/*
 * DBeaver - Universal Database Manager
 * Copyright (C) 2010-2022 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.cloudbeaver.server.events;

import io.cloudbeaver.model.session.BaseWebSession;
import io.cloudbeaver.model.session.WebSession;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

import java.util.Objects;

public class WSWebUtils {
    public static boolean isSessionIdEquals(@NotNull BaseWebSession webSession, @Nullable String sessionId) {
        if (sessionId == null) {
            return false;
        }
        if (Objects.equals(webSession.getSessionId(), sessionId)) {
            return true;
        }
        if (webSession instanceof WebSession) {
            return Objects.equals(webSession.getUserContext().getSmSessionId(), sessionId);
        }
        return false;
    }
}
