/*
 * DBeaver - Universal Database Manager
 * Copyright (C) 2010-2024 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.cloudbeaver.service;

import io.cloudbeaver.model.app.WebAppConfiguration;
import io.cloudbeaver.model.app.WebApplication;
import io.cloudbeaver.model.app.WebServerConfiguration;
import io.cloudbeaver.model.session.WebSession;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;

/**
 * Web service implementation
 */
public interface DBWServiceServerConfigurator extends DBWServiceBinding {

    void configureServer(
        @NotNull WebApplication application,
        @Nullable WebSession session,
        @NotNull WebServerConfiguration serverConfiguration,
        @NotNull WebAppConfiguration appConfig
    ) throws DBException;

    default void migrateConfigurationIfNeeded(@NotNull WebApplication application) throws DBException {

    }

    void reloadConfiguration(@NotNull WebAppConfiguration appConfig) throws DBException;

}
