/*
 * DBeaver - Universal Database Manager
 * Copyright (C) 2010-2024 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.cloudbeaver.registry;

import io.cloudbeaver.service.DBWServiceBinding;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;

import java.util.ArrayList;
import java.util.List;

/**
 * WebServiceDescriptor
 */
public class WebServiceDescriptor extends AbstractContextDescriptor {

    public static final String EXTENSION_ID = "io.cloudbeaver.service"; //$NON-NLS-1$

    private final String id;
    private final String label;
    private final String description;
    private final ObjectType implClass;

    private DBWServiceBinding instance;
    private final List<WebPermissionDescriptor> permissions = new ArrayList<>();

    public WebServiceDescriptor(IConfigurationElement config)
    {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.implClass = new ObjectType(config.getAttribute("class"));

        for (IConfigurationElement pc : config.getChildren("permission")) {
            permissions.add(new WebPermissionDescriptor(this, pc));
        }
    }

    public String getId() {
        return id;
    }

    public String getLabel() {
        return label;
    }

    public String getDescription() {
        return description;
    }

    public List<WebPermissionDescriptor> getPermissions() {
        return permissions;
    }

    public DBWServiceBinding getInstance()
        throws DBException
    {
        if (instance == null) {
            instance = implClass.createInstance(DBWServiceBinding.class);
        }
        return instance;
    }

}
