/*
 * DBeaver - Universal Database Manager
 * Copyright (C) 2010-2024 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.cloudbeaver.registry;

import org.eclipse.core.runtime.IConfigurationElement;

/**
 * Web connection info
 */
public class WebPermissionDescriptor {

    private final WebServiceDescriptor service;
    private final IConfigurationElement cfg;

    public WebPermissionDescriptor(WebServiceDescriptor service, IConfigurationElement cfg) {
        this.service = service;
        this.cfg = cfg;;
    }

    public WebServiceDescriptor getService() {
        return service;
    }

    public String getId() {
        return cfg.getAttribute("id");
    }

    public String getLabel() {
        return cfg.getAttribute("label");
    }

    public String getDescription() {
        return cfg.getAttribute("description");
    }

    public String getCategory() {
        return cfg.getAttribute("category");
    }

    public String getScope() {
        return cfg.getAttribute("scope");
    }

    @Override
    public String toString() {
        return getScope() + ":" + getId();
    }
}
