/*
 * DBeaver - Universal Database Manager
 * Copyright (C) 2010-2024 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.cloudbeaver.model.rm;

import io.cloudbeaver.model.app.WebApplication;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.rm.RMController;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class RMControllerInvocationHandler implements InvocationHandler {
    private final WebApplication webApplication;
    private final RMController rmController;

    public RMControllerInvocationHandler(RMController rmController, WebApplication webApplication) {
        this.webApplication = webApplication;
        this.rmController = rmController;
    }

    private void checkIsRmEnabled() throws DBException {
        if (!webApplication.getAppConfiguration().isResourceManagerEnabled()) {
            throw new DBException("Resource Manager disabled");
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            checkIsRmEnabled();
            return method.invoke(rmController, args);
        } catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}
