/*
 * DBeaver - Universal Database Manager
 * Copyright (C) 2010-2024 DBeaver Corp and others
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.cloudbeaver.auth.provisioning;

import io.cloudbeaver.model.session.WebSession;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.security.SMAuthProviderCustomConfiguration;
import org.jkiss.dbeaver.model.security.user.SMUserProvisioning;

import java.util.List;

public interface SMProvisioner {
    @NotNull
    List<SMUserProvisioning> listExternalUsers(
        @NotNull WebSession webSession,
        @NotNull SMAuthProviderCustomConfiguration customConfiguration,
        @NotNull SMProvisioningFilter filter
    ) throws DBException;

    default boolean isAuthRoleProvided(SMAuthProviderCustomConfiguration configuration) {
        return false;
    }
}
