/*
 * Copyright (c) 2021 Cyrille Rossant and contributors. All rights reserved.
 * Licensed under the MIT license. See LICENSE file in the project root for details.
 * SPDX-License-Identifier: MIT
 */

/*************************************************************************************************/
/*  String utils                                                                                 */
/*************************************************************************************************/

#ifndef DVZ_HEADER_STRING
#define DVZ_HEADER_STRING



/*************************************************************************************************/
/*  Includes                                                                                     */
/*************************************************************************************************/

#include "datoviz_math.h"



/*************************************************************************************************/
/*  Constants                                                                                    */
/*************************************************************************************************/



/*************************************************************************************************/
/*  Enums                                                                                        */
/*************************************************************************************************/



/*************************************************************************************************/
/*  Typedefs                                                                                     */
/*************************************************************************************************/



/*************************************************************************************************/
/*  Structs                                                                                      */
/*************************************************************************************************/



EXTERN_C_ON

/*************************************************************************************************/
/*  Functions                                                                                    */
/*************************************************************************************************/

// NOTE: the caller must FREE the output.
static inline uint32_t* _ascii_to_utf32(const char* string, uint32_t* out_length)
{
    ANN(string);

    // Convert ASCII to Unicode.
    uint32_t count = strnlen(string, 4096);
    uint32_t* codepoints = (uint32_t*)calloc(count, sizeof(uint32_t));
    for (uint32_t i = 0; i < count; i++)
    {
        codepoints[i] = (uint32_t)string[i];
    }

    if (out_length != NULL)
        *out_length = count;

    return codepoints;
}



EXTERN_C_OFF

#endif
