/*
 * Copyright (c) 2021 Cyrille Rossant and contributors. All rights reserved.
 * Licensed under the MIT license. See LICENSE file in the project root for details.
 * SPDX-License-Identifier: MIT
 */

/*************************************************************************************************/
/*  Random 64-bit integer                                                                        */
/*************************************************************************************************/

#ifndef DVZ_HEADER_PRNG
#define DVZ_HEADER_PRNG



/*************************************************************************************************/
/*  Includes                                                                                     */
/*************************************************************************************************/

#include "_macros.h"



/*************************************************************************************************/
/*  Typedefs                                                                                     */
/*************************************************************************************************/

typedef struct DvzPrng DvzPrng;



EXTERN_C_ON

/*************************************************************************************************/
/*  Functions                                                                                    */
/*************************************************************************************************/

DvzPrng* dvz_prng(void);



uint64_t dvz_prng_uuid(DvzPrng* prng);



void dvz_prng_destroy(DvzPrng* prng);



EXTERN_C_OFF

#endif
