/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.UUID;

public class Utilities {
    private static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] getBytes(short data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFF), (byte)((data & 0xFF00) >> 8)};
        return bytes;
    }

    public static byte[] getBytes(int data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFF), (byte)(data >> 8 & 0xFF), (byte)(data >> 16 & 0xFF), (byte)(data >> 24 & 0xFF)};
        return bytes;
    }

    public static byte[] getBytes(long data) {
        byte[] bytes = new byte[]{(byte)(data & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 56 & 0xFFL)};
        return bytes;
    }

    public static byte[] getBytes(float data) {
        int intBits = Float.floatToIntBits(data);
        return Utilities.getBytes(intBits);
    }

    public static byte[] getBytes(double data) {
        long intBits = Double.doubleToLongBits(data);
        return Utilities.getBytes(intBits);
    }

    public static byte[] getBytes(String data, String charsetName) {
        Charset charset = Charset.forName(charsetName);
        return data.getBytes(charset);
    }

    public static byte int2OneByte(int num) {
        return (byte)(num & 0xFF);
    }

    public static int oneByte2Int(byte byteNum) {
        return byteNum > 0 ? byteNum : 256 + byteNum;
    }

    public static short getShort(byte[] bytes, int index) {
        return (short)(0xFF & bytes[0 + index] | 0xFF00 & bytes[1 + index] << 8);
    }

    public static int getInt(byte[] bytes, int index) {
        return 0xFF & bytes[0 + index] | 0xFF00 & bytes[1 + index] << 8 | 0xFF0000 & bytes[2 + index] << 16 | 0xFF000000 & bytes[3 + index] << 24;
    }

    public static long getLong(byte[] bytes, int index) {
        return 0xFFL & (long)bytes[0 + index] | 0xFF00L & (long)bytes[1 + index] << 8 | 0xFF0000L & (long)bytes[2 + index] << 16 | 0xFF000000L & (long)bytes[3 + index] << 24 | 0xFF00000000L & (long)bytes[4 + index] << 32 | 0xFF0000000000L & (long)bytes[5 + index] << 40 | 0xFF000000000000L & (long)bytes[6 + index] << 48 | 0xFF00000000000000L & (long)bytes[7 + index] << 56;
    }

    public static float getFloat(byte[] bytes, int index) {
        return Float.intBitsToFloat(Utilities.getInt(bytes, index));
    }

    public static double getDouble(byte[] bytes, int index) {
        long l = Utilities.getLong(bytes, index);
        System.out.println(l);
        return Double.longBitsToDouble(l);
    }

    public static String getString(byte[] bytes, String charsetName) {
        return new String(bytes, Charset.forName(charsetName));
    }

    public static UUID Byte2UUID(byte[] data) {
        int i;
        if (data.length != 16) {
            throw new IllegalArgumentException("Invalid UUID byte[]");
        }
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    public static byte[] UUID2Byte(UUID uuid) {
        ByteArrayOutputStream ba = new ByteArrayOutputStream(16);
        DataOutputStream da = new DataOutputStream(ba);
        try {
            da.writeLong(uuid.getMostSignificantBits());
            da.writeLong(uuid.getLeastSignificantBits());
            ba.close();
            da.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] buffer = ba.toByteArray();
        byte temp = buffer[0];
        buffer[0] = buffer[3];
        buffer[3] = temp;
        temp = buffer[1];
        buffer[1] = buffer[2];
        buffer[2] = temp;
        temp = buffer[4];
        buffer[4] = buffer[5];
        buffer[5] = temp;
        temp = buffer[6];
        buffer[6] = buffer[7];
        buffer[7] = temp;
        return buffer;
    }

    public static byte[] string2Byte(String str) {
        byte[] byteArray;
        if (str == null) {
            return null;
        }
        try {
            byteArray = str.getBytes("unicode");
        }
        catch (Exception ex) {
            byteArray = str.getBytes();
        }
        if (byteArray.length >= 2) {
            if (byteArray[0] == -1 && byteArray[1] == -2) {
                byte[] newArray = new byte[byteArray.length - 2];
                System.arraycopy(byteArray, 2, newArray, 0, newArray.length);
                byteArray = newArray;
            } else if (byteArray[0] == -2 && byteArray[1] == -1) {
                for (int i = 0; i < byteArray.length; ++i) {
                    byte temp = byteArray[i];
                    byteArray[i] = byteArray[i + 1];
                    byteArray[i + 1] = temp;
                    ++i;
                }
                byte[] newArray = new byte[byteArray.length - 2];
                System.arraycopy(byteArray, 2, newArray, 0, newArray.length);
                byteArray = newArray;
            }
        }
        return byteArray;
    }

    public static String byte2String(byte[] byteArray) {
        String str;
        if (byteArray == null) {
            return null;
        }
        for (int i = 0; i < byteArray.length; ++i) {
            byte temp = byteArray[i];
            byteArray[i] = byteArray[i + 1];
            byteArray[i + 1] = temp;
            ++i;
        }
        try {
            str = new String(byteArray, "unicode");
        }
        catch (Exception ex) {
            str = new String(byteArray);
        }
        return str;
    }

    public static void bytesReverse(byte[] reverse) {
        if (reverse != null) {
            byte tmp = 0;
            for (int i = 0; i < reverse.length / 2; ++i) {
                tmp = reverse[i];
                reverse[i] = reverse[reverse.length - 1 - i];
                reverse[reverse.length - 1 - i] = tmp;
            }
        }
    }

    public static String bytes2HexString(byte[] bytes) {
        char[] buf = new char[bytes.length * 2];
        int index = 0;
        for (byte b : bytes) {
            buf[index++] = HEX_CHAR[b >>> 4 & 0xF];
            buf[index++] = HEX_CHAR[b & 0xF];
        }
        return new String(buf);
    }
}

