/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.Siemens;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.IMessage.S7Message;
import HslCommunication.Core.Net.NetworkBase.NetworkDeviceBase;
import HslCommunication.Core.Transfer.ReverseBytesTransform;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Core.Types.OperateResultExThree;
import HslCommunication.Core.Types.OperateResultExTwo;
import HslCommunication.Profinet.Siemens.SiemensPLCS;
import HslCommunication.Utilities;
import java.io.ByteArrayOutputStream;
import java.net.Socket;
import java.util.Arrays;

public class SiemensS7Net
extends NetworkDeviceBase<S7Message, ReverseBytesTransform> {
    private byte[] plcHead1 = new byte[]{3, 0, 0, 22, 17, -32, 0, 0, 0, 1, 0, -64, 1, 10, -63, 2, 1, 2, -62, 2, 1, 0};
    private byte[] plcHead2 = new byte[]{3, 0, 0, 25, 2, -16, -128, 50, 1, 0, 0, 4, 0, 0, 8, 0, 0, -16, 0, 0, 1, 0, 1, 1, -32};
    private byte[] plcOrderNumber = new byte[]{3, 0, 0, 33, 2, -16, -128, 50, 7, 0, 0, 0, 1, 0, 8, 0, 8, 0, 1, 18, 4, 17, 68, 1, 0, -1, 9, 0, 4, 0, 17, 0, 0};
    private SiemensPLCS CurrentPlc = SiemensPLCS.S1200;
    private byte[] plcHead1_200smart = new byte[]{3, 0, 0, 22, 17, -32, 0, 0, 0, 1, 0, -63, 2, 16, 0, -62, 2, 3, 0, -64, 1, 10};
    private byte[] plcHead2_200smart = new byte[]{3, 0, 0, 25, 2, -16, -128, 50, 1, 0, 0, -52, -63, 0, 8, 0, 0, -16, 0, 0, 1, 0, 1, 3, -64};

    public SiemensS7Net(SiemensPLCS siemens) {
        this.Initialization(siemens, "");
    }

    public SiemensS7Net(SiemensPLCS siemens, String ipAddress) {
        this.Initialization(siemens, ipAddress);
    }

    private void Initialization(SiemensPLCS siemens, String ipAddress) {
        this.WordLength = (short)2;
        this.setIpAddress(ipAddress);
        this.setPort(102);
        this.CurrentPlc = siemens;
        switch (siemens) {
            case S1200: {
                this.plcHead1[21] = 0;
                break;
            }
            case S300: {
                this.plcHead1[21] = 2;
                break;
            }
            case S1500: {
                this.plcHead1[21] = 0;
                break;
            }
            case S200Smart: {
                this.plcHead1 = this.plcHead1_200smart;
                this.plcHead2 = this.plcHead2_200smart;
                break;
            }
            default: {
                this.plcHead1[18] = 0;
            }
        }
    }

    @Override
    protected OperateResult InitializationOnConnect(Socket socket) {
        OperateResultExTwo<byte[], byte[]> read_first = this.ReadFromCoreServerBase(socket, this.plcHead1);
        if (!read_first.IsSuccess) {
            return read_first;
        }
        OperateResultExTwo<byte[], byte[]> read_second = this.ReadFromCoreServerBase(socket, this.plcHead2);
        if (!read_second.IsSuccess) {
            return read_second;
        }
        return OperateResult.CreateSuccessResult();
    }

    private int CalculateAddressStarted(String address) {
        if (address.indexOf(46) < 0) {
            return Integer.parseInt(address) * 8;
        }
        String[] temp = address.split(".");
        return Integer.parseInt(temp[0]) * 8 + Integer.parseInt(temp[1]);
    }

    private OperateResultExThree<Byte, Integer, Integer> AnalysisAddress(String address) {
        OperateResultExThree<Byte, Integer, Integer> result;
        block8: {
            result = new OperateResultExThree<Byte, Integer, Integer>();
            try {
                result.Content3 = 0;
                if (address.charAt(0) == 'I') {
                    result.Content1 = (byte)-127;
                    result.Content2 = this.CalculateAddressStarted(address.substring(1));
                    break block8;
                }
                if (address.charAt(0) == 'Q') {
                    result.Content1 = (byte)-126;
                    result.Content2 = this.CalculateAddressStarted(address.substring(1));
                    break block8;
                }
                if (address.charAt(0) == 'M') {
                    result.Content1 = (byte)-125;
                    result.Content2 = this.CalculateAddressStarted(address.substring(1));
                    break block8;
                }
                if (address.charAt(0) == 'D' || address.substring(0, 2) == "DB") {
                    result.Content1 = (byte)-124;
                    String[] adds = address.split("\\.");
                    result.Content3 = address.charAt(1) == 'B' ? Integer.valueOf(Integer.parseInt(adds[0].substring(2))) : Integer.valueOf(Integer.parseInt(adds[0].substring(1)));
                    result.Content2 = this.CalculateAddressStarted(address.substring(address.indexOf(46) + 1));
                    break block8;
                }
                if (address.charAt(0) == 'T') {
                    result.Content1 = 29;
                    result.Content2 = this.CalculateAddressStarted(address.substring(1));
                    break block8;
                }
                if (address.charAt(0) == 'C') {
                    result.Content1 = 28;
                    result.Content2 = this.CalculateAddressStarted(address.substring(1));
                    break block8;
                }
                result.Message = "\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b";
                result.Content1 = 0;
                result.Content2 = 0;
                result.Content3 = 0;
                return result;
            }
            catch (Exception ex) {
                result.Message = ex.getMessage();
                return result;
            }
        }
        result.IsSuccess = true;
        return result;
    }

    private OperateResultExOne<byte[]> BuildReadCommand(OperateResultExThree<Byte, Integer, Integer>[] address, short[] length) {
        if (address == null) {
            throw new RuntimeException("address\u4e3a\u7a7a");
        }
        if (length == null) {
            throw new RuntimeException("count\u4e3a\u7a7a");
        }
        if (address.length != length.length) {
            throw new RuntimeException("\u4e24\u4e2a\u53c2\u6570\u7684\u4e2a\u6570\u4e0d\u7edf\u4e00");
        }
        if (length.length > 19) {
            throw new RuntimeException("\u8bfb\u53d6\u7684\u6570\u7ec4\u6570\u91cf\u4e0d\u5141\u8bb8\u5927\u4e8e19");
        }
        OperateResultExOne<byte[]> result = new OperateResultExOne<byte[]>();
        int readCount = length.length;
        byte[] _PLCCommand = new byte[19 + readCount * 12];
        _PLCCommand[0] = 3;
        _PLCCommand[1] = 0;
        _PLCCommand[2] = (byte)(_PLCCommand.length / 256);
        _PLCCommand[3] = (byte)(_PLCCommand.length % 256);
        _PLCCommand[4] = 2;
        _PLCCommand[5] = -16;
        _PLCCommand[6] = -128;
        _PLCCommand[7] = 50;
        _PLCCommand[8] = 1;
        _PLCCommand[9] = 0;
        _PLCCommand[10] = 0;
        _PLCCommand[11] = 0;
        _PLCCommand[12] = 1;
        _PLCCommand[13] = (byte)((_PLCCommand.length - 17) / 256);
        _PLCCommand[14] = (byte)((_PLCCommand.length - 17) % 256);
        _PLCCommand[15] = 0;
        _PLCCommand[16] = 0;
        _PLCCommand[17] = 4;
        _PLCCommand[18] = (byte)readCount;
        for (int ii = 0; ii < readCount; ++ii) {
            _PLCCommand[19 + ii * 12] = 18;
            _PLCCommand[20 + ii * 12] = 10;
            _PLCCommand[21 + ii * 12] = 16;
            _PLCCommand[22 + ii * 12] = 2;
            _PLCCommand[23 + ii * 12] = (byte)(length[ii] / 256);
            _PLCCommand[24 + ii * 12] = (byte)(length[ii] % 256);
            _PLCCommand[25 + ii * 12] = (byte)((Integer)address[ii].Content3 / 256);
            _PLCCommand[26 + ii * 12] = (byte)((Integer)address[ii].Content3 % 256);
            _PLCCommand[27 + ii * 12] = (Byte)address[ii].Content1;
            _PLCCommand[28 + ii * 12] = (byte)((Integer)address[ii].Content2 / 256 / 256 % 256);
            _PLCCommand[29 + ii * 12] = (byte)((Integer)address[ii].Content2 / 256 % 256);
            _PLCCommand[30 + ii * 12] = (byte)((Integer)address[ii].Content2 % 256);
        }
        result.Content = _PLCCommand;
        result.IsSuccess = true;
        return result;
    }

    private OperateResultExOne<byte[]> BuildBitReadCommand(String address) {
        OperateResultExOne<byte[]> result = new OperateResultExOne<byte[]>();
        byte[] _PLCCommand = new byte[31];
        _PLCCommand[0] = 3;
        _PLCCommand[1] = 0;
        _PLCCommand[2] = (byte)(_PLCCommand.length / 256);
        _PLCCommand[3] = (byte)(_PLCCommand.length % 256);
        _PLCCommand[4] = 2;
        _PLCCommand[5] = -16;
        _PLCCommand[6] = -128;
        _PLCCommand[7] = 50;
        _PLCCommand[8] = 1;
        _PLCCommand[9] = 0;
        _PLCCommand[10] = 0;
        _PLCCommand[11] = 0;
        _PLCCommand[12] = 1;
        _PLCCommand[13] = (byte)((_PLCCommand.length - 17) / 256);
        _PLCCommand[14] = (byte)((_PLCCommand.length - 17) % 256);
        _PLCCommand[15] = 0;
        _PLCCommand[16] = 0;
        _PLCCommand[17] = 4;
        _PLCCommand[18] = 1;
        OperateResultExThree<Byte, Integer, Integer> analysis = this.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            result.CopyErrorFromOther(analysis);
            return result;
        }
        _PLCCommand[19] = 18;
        _PLCCommand[20] = 10;
        _PLCCommand[21] = 16;
        _PLCCommand[22] = 1;
        _PLCCommand[23] = 0;
        _PLCCommand[24] = 1;
        _PLCCommand[25] = (byte)((Integer)analysis.Content3 / 256);
        _PLCCommand[26] = (byte)((Integer)analysis.Content3 % 256);
        _PLCCommand[27] = (Byte)analysis.Content1;
        _PLCCommand[28] = (byte)((Integer)analysis.Content2 / 256 / 256 % 256);
        _PLCCommand[29] = (byte)((Integer)analysis.Content2 / 256 % 256);
        _PLCCommand[30] = (byte)((Integer)analysis.Content2 % 256);
        result.Content = _PLCCommand;
        result.IsSuccess = true;
        return result;
    }

    private OperateResultExOne<byte[]> BuildWriteByteCommand(String address, byte[] data) {
        if (data == null) {
            data = new byte[]{};
        }
        OperateResultExOne<byte[]> result = new OperateResultExOne<byte[]>();
        OperateResultExThree<Byte, Integer, Integer> analysis = this.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            result.CopyErrorFromOther(analysis);
            return result;
        }
        byte[] _PLCCommand = new byte[35 + data.length];
        _PLCCommand[0] = 3;
        _PLCCommand[1] = 0;
        _PLCCommand[2] = (byte)((35 + data.length) / 256);
        _PLCCommand[3] = (byte)((35 + data.length) % 256);
        _PLCCommand[4] = 2;
        _PLCCommand[5] = -16;
        _PLCCommand[6] = -128;
        _PLCCommand[7] = 50;
        _PLCCommand[8] = 1;
        _PLCCommand[9] = 0;
        _PLCCommand[10] = 0;
        _PLCCommand[11] = 0;
        _PLCCommand[12] = 1;
        _PLCCommand[13] = 0;
        _PLCCommand[14] = 14;
        _PLCCommand[15] = (byte)((4 + data.length) / 256);
        _PLCCommand[16] = (byte)((4 + data.length) % 256);
        _PLCCommand[17] = 5;
        _PLCCommand[18] = 1;
        _PLCCommand[19] = 18;
        _PLCCommand[20] = 10;
        _PLCCommand[21] = 16;
        _PLCCommand[22] = 2;
        _PLCCommand[23] = (byte)(data.length / 256);
        _PLCCommand[24] = (byte)(data.length % 256);
        _PLCCommand[25] = (byte)((Integer)analysis.Content3 / 256);
        _PLCCommand[26] = (byte)((Integer)analysis.Content3 % 256);
        _PLCCommand[27] = (Byte)analysis.Content1;
        _PLCCommand[28] = (byte)((Integer)analysis.Content2 / 256 / 256 % 256);
        _PLCCommand[29] = (byte)((Integer)analysis.Content2 / 256 % 256);
        _PLCCommand[30] = (byte)((Integer)analysis.Content2 % 256);
        _PLCCommand[31] = 0;
        _PLCCommand[32] = 4;
        _PLCCommand[33] = (byte)(data.length * 8 / 256);
        _PLCCommand[34] = (byte)(data.length * 8 % 256);
        System.arraycopy(data, 0, _PLCCommand, 35, data.length);
        result.Content = _PLCCommand;
        result.IsSuccess = true;
        return result;
    }

    private OperateResultExOne<byte[]> BuildWriteBitCommand(String address, boolean data) {
        OperateResultExOne<byte[]> result = new OperateResultExOne<byte[]>();
        OperateResultExThree<Byte, Integer, Integer> analysis = this.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            result.CopyErrorFromOther(analysis);
            return result;
        }
        byte[] buffer = new byte[]{data ? (byte)1 : 0};
        byte[] _PLCCommand = new byte[35 + buffer.length];
        _PLCCommand[0] = 3;
        _PLCCommand[1] = 0;
        _PLCCommand[2] = (byte)((35 + buffer.length) / 256);
        _PLCCommand[3] = (byte)((35 + buffer.length) % 256);
        _PLCCommand[4] = 2;
        _PLCCommand[5] = -16;
        _PLCCommand[6] = -128;
        _PLCCommand[7] = 50;
        _PLCCommand[8] = 1;
        _PLCCommand[9] = 0;
        _PLCCommand[10] = 0;
        _PLCCommand[11] = 0;
        _PLCCommand[12] = 1;
        _PLCCommand[13] = 0;
        _PLCCommand[14] = 14;
        _PLCCommand[15] = (byte)((4 + buffer.length) / 256);
        _PLCCommand[16] = (byte)((4 + buffer.length) % 256);
        _PLCCommand[17] = 5;
        _PLCCommand[18] = 1;
        _PLCCommand[19] = 18;
        _PLCCommand[20] = 10;
        _PLCCommand[21] = 16;
        _PLCCommand[22] = 1;
        _PLCCommand[23] = (byte)(buffer.length / 256);
        _PLCCommand[24] = (byte)(buffer.length % 256);
        _PLCCommand[25] = (byte)((Integer)analysis.Content3 / 256);
        _PLCCommand[26] = (byte)((Integer)analysis.Content3 % 256);
        _PLCCommand[27] = (Byte)analysis.Content1;
        _PLCCommand[28] = (byte)((Integer)analysis.Content2 / 256 / 256);
        _PLCCommand[29] = (byte)((Integer)analysis.Content2 / 256);
        _PLCCommand[30] = (byte)((Integer)analysis.Content2 % 256);
        _PLCCommand[31] = 0;
        _PLCCommand[32] = 3;
        _PLCCommand[33] = (byte)(buffer.length / 256);
        _PLCCommand[34] = (byte)(buffer.length % 256);
        System.arraycopy(buffer, 0, _PLCCommand, 35, buffer.length);
        result.Content = _PLCCommand;
        result.IsSuccess = true;
        return result;
    }

    public OperateResultExOne<String> ReadOrderNumber() {
        OperateResultExOne<String> result = new OperateResultExOne<String>();
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(this.plcOrderNumber);
        if (read.IsSuccess && ((byte[])read.Content).length > 100) {
            result.IsSuccess = true;
            result.Content = Utilities.getString(Arrays.copyOfRange((byte[])read.Content, 71, 20), "ASCII");
        }
        if (!result.IsSuccess) {
            result.CopyErrorFromOther(read);
        }
        return result;
    }

    @Override
    public OperateResultExOne<byte[]> Read(String address, short length) {
        OperateResultExThree<Byte, Integer, Integer> addressResult = this.AnalysisAddress(address);
        if (!addressResult.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(addressResult);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        short alreadyFinished = 0;
        while (alreadyFinished < length) {
            short readLength = (short)Math.min(length - alreadyFinished, 200);
            OperateResultExThree[] list = new OperateResultExThree[]{addressResult};
            OperateResultExOne<byte[]> read = this.Read(list, new short[]{readLength});
            if (read.IsSuccess) {
                try {
                    outputStream.write((byte[])read.Content);
                }
                catch (Exception exception) {}
            } else {
                return read;
            }
            alreadyFinished = (short)(alreadyFinished + readLength);
            OperateResultExThree<Byte, Integer, Integer> operateResultExThree = addressResult;
            Integer.valueOf((Integer)operateResultExThree.Content2 + readLength * 8);
            operateResultExThree.Content2 = operateResultExThree.Content2;
        }
        byte[] buffer = outputStream.toByteArray();
        try {
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return OperateResultExOne.CreateSuccessResult(buffer);
    }

    private OperateResultExOne<byte[]> ReadBitFromPLC(String address) {
        OperateResultExOne<byte[]> result = new OperateResultExOne<byte[]>();
        OperateResultExOne<byte[]> command = this.BuildBitReadCommand(address);
        if (!command.IsSuccess) {
            result.CopyErrorFromOther(command);
            return result;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (read.IsSuccess) {
            int receiveCount = 1;
            if (((byte[])read.Content).length >= 21 && ((byte[])read.Content)[20] == 1) {
                byte[] buffer = new byte[receiveCount];
                if (22 < ((byte[])read.Content).length && ((byte[])read.Content)[21] == -1 && ((byte[])read.Content)[22] == 3) {
                    buffer[0] = ((byte[])read.Content)[25];
                }
                result.Content = buffer;
                result.IsSuccess = true;
            } else {
                result.ErrorCode = read.ErrorCode;
                result.Message = "\u6570\u636e\u5757\u957f\u5ea6\u6821\u9a8c\u5931\u8d25";
            }
        } else {
            result.ErrorCode = read.ErrorCode;
            result.Message = read.Message;
        }
        return result;
    }

    public OperateResultExOne<byte[]> Read(String[] address, short[] length) {
        OperateResultExOne<byte[]> result = new OperateResultExOne<byte[]>();
        OperateResultExThree[] list = new OperateResultExThree[address.length];
        for (int i = 0; i < address.length; ++i) {
            OperateResultExThree<Byte, Integer, Integer> tmp = this.AnalysisAddress(address[i]);
            if (!tmp.IsSuccess) {
                result.CopyErrorFromOther(tmp);
                return result;
            }
            list[i] = tmp;
        }
        return this.Read(list, length);
    }

    private OperateResultExOne<byte[]> Read(OperateResultExThree<Byte, Integer, Integer>[] address, short[] length) {
        OperateResultExOne<byte[]> result = new OperateResultExOne<byte[]>();
        OperateResultExOne<byte[]> command = this.BuildReadCommand(address, length);
        if (!command.IsSuccess) {
            result.CopyErrorFromOther(command);
            return result;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (read.IsSuccess) {
            int receiveCount = 0;
            for (int i = 0; i < length.length; ++i) {
                receiveCount += length[i];
            }
            if (((byte[])read.Content).length >= 21 && ((byte[])read.Content)[20] == length.length) {
                byte[] buffer = new byte[receiveCount];
                int kk = 0;
                int ll = 0;
                for (int ii = 21; ii < ((byte[])read.Content).length; ++ii) {
                    if (ii + 1 >= ((byte[])read.Content).length || ((byte[])read.Content)[ii] != -1 || ((byte[])read.Content)[ii + 1] != 4) continue;
                    System.arraycopy(read.Content, ii + 4, buffer, ll, length[kk]);
                    ii += length[kk] + 3;
                    ll += length[kk];
                    ++kk;
                }
                result.Content = buffer;
                result.IsSuccess = true;
            } else {
                result.ErrorCode = read.ErrorCode;
                result.Message = "\u6570\u636e\u5757\u957f\u5ea6\u6821\u9a8c\u5931\u8d25";
            }
        } else {
            result.ErrorCode = read.ErrorCode;
            result.Message = read.Message;
        }
        return result;
    }

    public OperateResultExOne<Boolean> ReadBool(String address) {
        return this.GetBoolResultFromBytes(this.ReadBitFromPLC(address));
    }

    public OperateResultExOne<Byte> ReadByte(String address) {
        return this.GetByteResultFromBytes(this.Read(address, (short)1));
    }

    private OperateResult WriteBase(byte[] entireValue) {
        OperateResultExOne<byte[]> write = this.ReadFromCoreServer(entireValue);
        if (!write.IsSuccess) {
            return write;
        }
        if (((byte[])write.Content)[((byte[])write.Content).length - 1] != 255) {
            OperateResult result = new OperateResult();
            result.ErrorCode = ((byte[])write.Content)[((byte[])write.Content).length - 1];
            result.Message = "\u5199\u5165\u6570\u636e\u5f02\u5e38";
            return result;
        }
        return OperateResult.CreateSuccessResult();
    }

    @Override
    public OperateResult Write(String address, byte[] value) {
        OperateResultExOne<byte[]> command = this.BuildWriteByteCommand(address, value);
        if (!command.IsSuccess) {
            return command;
        }
        return this.WriteBase((byte[])command.Content);
    }

    public OperateResult Write(String address, boolean value) {
        OperateResultExOne<byte[]> command = this.BuildWriteBitCommand(address, value);
        if (!command.IsSuccess) {
            return command;
        }
        return this.WriteBase((byte[])command.Content);
    }

    public OperateResult Write(String address, String value, int length) {
        byte[] temp = ((ReverseBytesTransform)this.getByteTransform()).TransByte(value, "ASCII");
        temp = SoftBasic.ArrayExpandToLength(temp, length);
        return this.Write(address, temp);
    }

    public OperateResult WriteUnicodeString(String address, String value) {
        byte[] temp = Utilities.string2Byte(value);
        return this.Write(address, temp);
    }

    public OperateResult WriteUnicodeString(String address, String value, int length) {
        byte[] temp = Utilities.string2Byte(value);
        temp = SoftBasic.ArrayExpandToLength(temp, length * 2);
        return this.Write(address, temp);
    }

    public OperateResult Write(String address, boolean[] values) {
        return this.Write(address, SoftBasic.BoolArrayToByte(values));
    }

    public OperateResult Write(String address, byte value) {
        return this.Write(address, new byte[]{value});
    }

    @Override
    public String toString() {
        return "SiemensS7Net";
    }
}

