/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.Melsec;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.IMessage.MelsecQnA3EBinaryMessage;
import HslCommunication.Core.Net.NetworkBase.NetworkDeviceBase;
import HslCommunication.Core.Transfer.RegularByteTransform;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Core.Types.OperateResultExTwo;
import HslCommunication.Profinet.Melsec.MelsecMcDataType;
import HslCommunication.Utilities;

public class MelsecMcNet
extends NetworkDeviceBase<MelsecQnA3EBinaryMessage, RegularByteTransform> {
    private byte NetworkNumber = 0;
    private byte NetworkStationNumber = 0;

    public MelsecMcNet() {
        this.WordLength = 1;
    }

    public MelsecMcNet(String ipAddress, int port) {
        this.WordLength = 1;
        super.setIpAddress(ipAddress);
        super.setPort(port);
    }

    public byte getNetworkNumber() {
        return this.NetworkNumber;
    }

    public void setNetworkNumber(byte networkNumber) {
        this.NetworkNumber = networkNumber;
    }

    public byte getNetworkStationNumber() {
        return this.NetworkStationNumber;
    }

    public void setNetworkStationNumber(byte networkStationNumber) {
        this.NetworkStationNumber = networkStationNumber;
    }

    private OperateResultExTwo<MelsecMcDataType, Short> AnalysisAddress(String address) {
        OperateResultExTwo<MelsecMcDataType, Short> result = new OperateResultExTwo<MelsecMcDataType, Short>();
        try {
            switch (address.charAt(0)) {
                case 'M': 
                case 'm': {
                    result.Content1 = MelsecMcDataType.M;
                    result.Content2 = Short.parseShort(address.substring(1), MelsecMcDataType.M.getFromBase());
                    break;
                }
                case 'X': 
                case 'x': {
                    result.Content1 = MelsecMcDataType.X;
                    result.Content2 = Short.parseShort(address.substring(1), MelsecMcDataType.X.getFromBase());
                    break;
                }
                case 'Y': 
                case 'y': {
                    result.Content1 = MelsecMcDataType.Y;
                    result.Content2 = Short.parseShort(address.substring(1), MelsecMcDataType.Y.getFromBase());
                    break;
                }
                case 'D': 
                case 'd': {
                    result.Content1 = MelsecMcDataType.D;
                    result.Content2 = Short.parseShort(address.substring(1), MelsecMcDataType.D.getFromBase());
                    break;
                }
                case 'W': 
                case 'w': {
                    result.Content1 = MelsecMcDataType.W;
                    result.Content2 = Short.parseShort(address.substring(1), MelsecMcDataType.W.getFromBase());
                    break;
                }
                case 'L': 
                case 'l': {
                    result.Content1 = MelsecMcDataType.L;
                    result.Content2 = Short.parseShort(address.substring(1), MelsecMcDataType.L.getFromBase());
                    break;
                }
                case 'F': 
                case 'f': {
                    result.Content1 = MelsecMcDataType.F;
                    result.Content2 = Short.parseShort(address.substring(1), MelsecMcDataType.F.getFromBase());
                    break;
                }
                case 'V': 
                case 'v': {
                    result.Content1 = MelsecMcDataType.V;
                    result.Content2 = Short.parseShort(address.substring(1), MelsecMcDataType.V.getFromBase());
                    break;
                }
                case 'B': 
                case 'b': {
                    result.Content1 = MelsecMcDataType.B;
                    result.Content2 = Short.parseShort(address.substring(1), MelsecMcDataType.B.getFromBase());
                    break;
                }
                case 'R': 
                case 'r': {
                    result.Content1 = MelsecMcDataType.R;
                    result.Content2 = Short.parseShort(address.substring(1), MelsecMcDataType.R.getFromBase());
                    break;
                }
                case 'S': 
                case 's': {
                    result.Content1 = MelsecMcDataType.S;
                    result.Content2 = Short.parseShort(address.substring(1), MelsecMcDataType.S.getFromBase());
                    break;
                }
                case 'Z': 
                case 'z': {
                    result.Content1 = MelsecMcDataType.Z;
                    result.Content2 = Short.parseShort(address.substring(1), MelsecMcDataType.Z.getFromBase());
                    break;
                }
                case 'T': 
                case 't': {
                    result.Content1 = MelsecMcDataType.T;
                    result.Content2 = Short.parseShort(address.substring(1), MelsecMcDataType.T.getFromBase());
                    break;
                }
                case 'C': 
                case 'c': {
                    result.Content1 = MelsecMcDataType.C;
                    result.Content2 = Short.parseShort(address.substring(1), MelsecMcDataType.C.getFromBase());
                    break;
                }
                default: {
                    throw new Exception("\u8f93\u5165\u7684\u7c7b\u578b\u4e0d\u652f\u6301\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                }
            }
        }
        catch (Exception ex) {
            result.Message = "\u5730\u5740\u683c\u5f0f\u586b\u5199\u9519\u8bef\uff1a" + ex.getMessage();
            return result;
        }
        result.IsSuccess = true;
        return result;
    }

    private OperateResultExTwo<MelsecMcDataType, byte[]> BuildReadCommand(String address, short length) {
        OperateResultExTwo<MelsecMcDataType, byte[]> result = new OperateResultExTwo<MelsecMcDataType, byte[]>();
        OperateResultExTwo<MelsecMcDataType, Short> analysis = this.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            result.CopyErrorFromOther(analysis);
            return result;
        }
        byte[] _PLCCommand = new byte[]{80, 0, this.NetworkNumber, -1, -1, 3, this.NetworkStationNumber, 12, 0, 10, 0, 1, 4, ((MelsecMcDataType)analysis.Content1).getDataType(), 0, (byte)((Short)analysis.Content2 % 256), (byte)((Short)analysis.Content2 / 256), 0, ((MelsecMcDataType)analysis.Content1).getDataCode(), (byte)(length % 256), (byte)(length / 256)};
        result.Content1 = analysis.Content1;
        result.Content2 = _PLCCommand;
        result.IsSuccess = true;
        return result;
    }

    private OperateResultExTwo<MelsecMcDataType, byte[]> BuildWriteCommand(String address, byte[] value, int length) {
        OperateResultExTwo<MelsecMcDataType, byte[]> result = new OperateResultExTwo<MelsecMcDataType, byte[]>();
        OperateResultExTwo<MelsecMcDataType, Short> analysis = this.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            result.CopyErrorFromOther(analysis);
            return result;
        }
        byte[] _PLCCommand = new byte[21 + value.length];
        _PLCCommand[0] = 80;
        _PLCCommand[1] = 0;
        _PLCCommand[2] = this.NetworkNumber;
        _PLCCommand[3] = -1;
        _PLCCommand[4] = -1;
        _PLCCommand[5] = 3;
        _PLCCommand[6] = this.NetworkStationNumber;
        _PLCCommand[7] = (byte)((_PLCCommand.length - 9) % 256);
        _PLCCommand[8] = (byte)((_PLCCommand.length - 9) / 256);
        _PLCCommand[9] = 10;
        _PLCCommand[10] = 0;
        _PLCCommand[11] = 1;
        _PLCCommand[12] = 20;
        _PLCCommand[13] = ((MelsecMcDataType)analysis.Content1).getDataType();
        _PLCCommand[14] = 0;
        _PLCCommand[15] = (byte)((Short)analysis.Content2 % 256);
        _PLCCommand[16] = (byte)((Short)analysis.Content2 / 256);
        _PLCCommand[17] = 0;
        _PLCCommand[18] = ((MelsecMcDataType)analysis.Content1).getDataCode();
        if (((MelsecMcDataType)analysis.Content1).getDataType() == 1) {
            if (length > 0) {
                _PLCCommand[19] = (byte)(length % 256);
                _PLCCommand[20] = (byte)(length / 256);
            } else {
                _PLCCommand[19] = (byte)(value.length * 2 % 256);
                _PLCCommand[20] = (byte)(value.length * 2 / 256);
            }
        } else {
            _PLCCommand[19] = (byte)(value.length / 2 % 256);
            _PLCCommand[20] = (byte)(value.length / 2 / 256);
        }
        System.arraycopy(value, 0, _PLCCommand, 21, value.length);
        result.Content1 = analysis.Content1;
        result.Content2 = _PLCCommand;
        result.IsSuccess = true;
        return result;
    }

    @Override
    public OperateResultExOne<byte[]> Read(String address, short length) {
        OperateResultExOne<byte[]> result = new OperateResultExOne<byte[]>();
        OperateResultExTwo<MelsecMcDataType, byte[]> command = this.BuildReadCommand(address, length);
        if (!command.IsSuccess) {
            result.CopyErrorFromOther(command);
            return result;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content2);
        if (read.IsSuccess) {
            result.ErrorCode = Utilities.getShort((byte[])read.Content, 9);
            if (result.ErrorCode == 0) {
                if (((MelsecMcDataType)command.Content1).getDataType() == 1) {
                    result.Content = new byte[(((byte[])read.Content).length - 11) * 2];
                    for (int i = 11; i < ((byte[])read.Content).length; ++i) {
                        if ((((byte[])read.Content)[i] & 0x10) == 16) {
                            ((byte[])result.Content)[(i - 11) * 2 + 0] = 1;
                        }
                        if ((((byte[])read.Content)[i] & 1) != 1) continue;
                        ((byte[])result.Content)[(i - 11) * 2 + 1] = 1;
                    }
                } else {
                    result.Content = new byte[((byte[])read.Content).length - 11];
                    System.arraycopy(read.Content, 11, result.Content, 0, ((byte[])result.Content).length);
                }
                result.IsSuccess = true;
            } else {
                result.Message = "\u8bf7\u7ffb\u67e5\u4e09\u83f1\u901a\u8baf\u624b\u518c\u6765\u67e5\u770b\u5177\u4f53\u7684\u4fe1\u606f\u3002";
            }
        } else {
            result.ErrorCode = read.ErrorCode;
            result.Message = read.Message;
        }
        return result;
    }

    public OperateResultExOne<boolean[]> ReadBool(String address, short length) {
        OperateResultExOne<boolean[]> result = new OperateResultExOne<boolean[]>();
        OperateResultExTwo<MelsecMcDataType, Short> analysis = this.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            result.CopyErrorFromOther(analysis);
            return result;
        }
        if (((MelsecMcDataType)analysis.Content1).getDataType() == 0) {
            result.Message = "\u8bfb\u53d6\u4f4d\u53d8\u91cf\u6570\u7ec4\u53ea\u80fd\u9488\u5bf9\u4f4d\u8f6f\u5143\u4ef6\uff0c\u5982\u679c\u8bfb\u53d6\u5b57\u8f6f\u5143\u4ef6\uff0c\u8bf7\u8c03\u7528Read\u65b9\u6cd5";
            return result;
        }
        OperateResultExOne<byte[]> read = this.Read(address, length);
        if (!read.IsSuccess) {
            result.CopyErrorFromOther(read);
            return result;
        }
        result.Content = new boolean[((byte[])read.Content).length];
        for (int i = 0; i < ((byte[])read.Content).length; ++i) {
            ((boolean[])result.Content)[i] = ((byte[])read.Content)[i] == 1;
        }
        result.IsSuccess = true;
        return result;
    }

    public OperateResultExOne<Boolean> ReadBool(String address) {
        OperateResultExOne<boolean[]> read = this.ReadBool(address, (short)1);
        if (!read.IsSuccess) {
            OperateResultExOne<Boolean> resultExOne = new OperateResultExOne<Boolean>();
            resultExOne.CopyErrorFromOther(read);
            return resultExOne;
        }
        return OperateResultExOne.CreateSuccessResult(((boolean[])read.Content)[0]);
    }

    @Override
    public OperateResult Write(String address, byte[] value) {
        OperateResultExTwo<MelsecMcDataType, byte[]> command;
        OperateResultExOne result = new OperateResultExOne();
        OperateResultExTwo<MelsecMcDataType, Short> analysis = this.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            result.CopyErrorFromOther(analysis);
            return result;
        }
        if (((MelsecMcDataType)analysis.Content1).getDataType() == 1) {
            int length = value.length % 2 == 0 ? value.length / 2 : value.length / 2 + 1;
            byte[] buffer = new byte[length];
            for (int i = 0; i < length; ++i) {
                if (value[i * 2 + 0] != 0) {
                    int n = i;
                    buffer[n] = (byte)(buffer[n] + 16);
                }
                if (i * 2 + 1 >= value.length || value[i * 2 + 1] == 0) continue;
                int n = i;
                buffer[n] = (byte)(buffer[n] + 1);
            }
            command = this.BuildWriteCommand(address, buffer, value.length);
        } else {
            command = this.BuildWriteCommand(address, value, -1);
        }
        if (!command.IsSuccess) {
            result.CopyErrorFromOther(command);
            return result;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content2);
        if (read.IsSuccess) {
            result.ErrorCode = Utilities.getShort((byte[])read.Content, 9);
            if (result.ErrorCode == 0) {
                result.IsSuccess = true;
            }
        } else {
            result.ErrorCode = read.ErrorCode;
            result.Message = read.Message;
        }
        return result;
    }

    public OperateResult Write(String address, String value, int length) {
        byte[] temp = ((RegularByteTransform)super.getByteTransform()).TransByte(value, "US-ASCII");
        temp = SoftBasic.ArrayExpandToLength(temp, length);
        temp = SoftBasic.ArrayExpandToLengthEven(temp);
        return this.Write(address, temp);
    }

    public OperateResult WriteUnicodeString(String address, String value) {
        byte[] temp = ((RegularByteTransform)super.getByteTransform()).TransByte(value, "unicode");
        return this.Write(address, temp);
    }

    public OperateResult WriteUnicodeString(String address, String value, int length) {
        byte[] temp = ((RegularByteTransform)super.getByteTransform()).TransByte(value, "unicode");
        temp = SoftBasic.ArrayExpandToLength(temp, length * 2);
        return this.Write(address, temp);
    }

    public OperateResult Write(String address, boolean value) {
        return this.Write(address, new boolean[]{value});
    }

    public OperateResult Write(String address, boolean[] values) {
        byte[] buffer = new byte[values.length];
        for (int i = 0; i < values.length; ++i) {
            buffer[i] = values[i] ? (byte)1 : 0;
        }
        return this.Write(address, buffer);
    }

    @Override
    public String toString() {
        return "MelsecMcNet";
    }
}

