/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.ModBus;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.BasicFramework.SoftIncrementCount;
import HslCommunication.Core.IMessage.ModbusTcpMessage;
import HslCommunication.Core.Net.NetworkBase.NetworkDeviceBase;
import HslCommunication.Core.Transfer.ReverseWordTransform;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Core.Types.OperateResultExTwo;
import HslCommunication.Utilities;
import java.io.ByteArrayOutputStream;

public class ModbusTcpNet
extends NetworkDeviceBase<ModbusTcpMessage, ReverseWordTransform> {
    private byte station = 1;
    private SoftIncrementCount softIncrementCount = new SoftIncrementCount(65535L, 0L);
    private boolean isAddressStartWithZero = true;

    public ModbusTcpNet() {
        this.WordLength = 1;
    }

    public ModbusTcpNet(String ipAddress, int port, byte station) {
        this.setIpAddress(ipAddress);
        this.setPort(port);
        this.WordLength = 1;
        this.station = station;
    }

    public boolean getAddressStartWithZero() {
        return this.isAddressStartWithZero;
    }

    public void setAddressStartWithZero(boolean addressStartWithZero) {
        this.isAddressStartWithZero = addressStartWithZero;
    }

    public byte getStation() {
        return this.station;
    }

    public void setStation(byte station) {
        this.station = station;
    }

    public boolean isMultiWordReverse() {
        return ((ReverseWordTransform)this.getByteTransform()).IsMultiWordReverse;
    }

    public void setMultiWordReverse(boolean multiWordReverse) {
        ((ReverseWordTransform)this.getByteTransform()).IsMultiWordReverse = multiWordReverse;
    }

    public boolean isStringReverse() {
        return ((ReverseWordTransform)this.getByteTransform()).IsStringReverse;
    }

    public void setStringReverse(boolean stringReverse) {
        ((ReverseWordTransform)this.getByteTransform()).IsStringReverse = stringReverse;
    }

    private OperateResultExOne<Integer> AnalysisAddress(String address) {
        try {
            int add = Integer.parseInt(address);
            add = this.CheckAddressStartWithZero(add);
            return OperateResultExOne.CreateSuccessResult(add);
        }
        catch (Exception ex) {
            OperateResultExOne<Integer> resultExOne = new OperateResultExOne<Integer>();
            resultExOne.Message = ex.getMessage();
            return resultExOne;
        }
    }

    private OperateResultExTwo<Byte, Integer> AnalysisReadAddress(String address) {
        try {
            if (address.indexOf(88) < 0) {
                int add = Integer.parseInt(address);
                return OperateResultExTwo.CreateSuccessResult((byte)3, add);
            }
            String[] list = address.split("X");
            byte function = Byte.parseByte(list[0]);
            int add = Integer.parseInt(list[1]);
            return OperateResultExTwo.CreateSuccessResult(function, add);
        }
        catch (Exception ex) {
            OperateResultExTwo<Byte, Integer> resultExTwo = new OperateResultExTwo<Byte, Integer>();
            resultExTwo.Message = ex.getMessage();
            return resultExTwo;
        }
    }

    private int CheckAddressStartWithZero(int add) {
        if (this.isAddressStartWithZero) {
            if (add < 0) {
                throw new RuntimeException("\u5730\u5740\u503c\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
            }
        } else {
            if (add < 1) {
                throw new RuntimeException("\u5730\u5740\u503c\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1");
            }
            --add;
        }
        return add;
    }

    private OperateResultExOne<byte[]> BuildReadCommandBase(byte code, String address, short count) {
        OperateResultExOne<Integer> analysis = this.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        short messageId = (short)this.softIncrementCount.GetCurrentValue();
        byte[] buffer = new byte[]{(byte)(messageId / 256), (byte)(messageId % 256), 0, 0, 0, 6, this.station, code, (byte)((Integer)analysis.Content / 256), (byte)((Integer)analysis.Content % 256), (byte)(count / 256), (byte)(count % 256)};
        return OperateResultExOne.CreateSuccessResult(buffer);
    }

    private OperateResultExOne<byte[]> BuildReadCoilCommand(String address, short count) {
        return this.BuildReadCommandBase((byte)1, address, count);
    }

    private OperateResultExOne<byte[]> BuildReadDiscreteCommand(String address, short count) {
        return this.BuildReadCommandBase((byte)2, address, count);
    }

    private OperateResultExOne<byte[]> BuildReadRegisterCommand(String address, short count) {
        return this.BuildReadCommandBase((byte)3, address, count);
    }

    private OperateResultExOne<byte[]> BuildWriteOneCoilCommand(String address, boolean value) {
        OperateResultExOne<Integer> analysis = this.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        short messageId = (short)this.softIncrementCount.GetCurrentValue();
        byte[] buffer = new byte[]{(byte)(messageId / 256), (byte)(messageId % 256), 0, 0, 0, 6, this.station, 5, (byte)((Integer)analysis.Content / 256), (byte)((Integer)analysis.Content % 256), (byte)(value ? 255 : 0), 0};
        return OperateResultExOne.CreateSuccessResult(buffer);
    }

    private OperateResultExOne<byte[]> BuildWriteOneRegisterCommand(String address, byte[] data) {
        OperateResultExOne<Integer> analysis = this.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        short messageId = (short)this.softIncrementCount.GetCurrentValue();
        byte[] buffer = new byte[]{(byte)(messageId / 256), (byte)(messageId % 256), 0, 0, 0, 6, this.station, 6, (byte)((Integer)analysis.Content / 256), (byte)((Integer)analysis.Content % 256), data[1], data[0]};
        return OperateResultExOne.CreateSuccessResult(buffer);
    }

    private OperateResultExOne<byte[]> BuildWriteCoilCommand(String address, boolean[] values) {
        byte[] data = SoftBasic.BoolArrayToByte(values);
        OperateResultExOne<Integer> analysis = this.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        short messageId = (short)this.softIncrementCount.GetCurrentValue();
        byte[] buffer = new byte[13 + data.length];
        buffer[0] = (byte)(messageId / 256);
        buffer[1] = (byte)(messageId % 256);
        buffer[2] = 0;
        buffer[3] = 0;
        buffer[4] = (byte)((buffer.length - 6) / 256);
        buffer[5] = (byte)((buffer.length - 6) % 256);
        buffer[6] = this.station;
        buffer[7] = 15;
        buffer[8] = (byte)((Integer)analysis.Content / 256);
        buffer[9] = (byte)((Integer)analysis.Content % 256);
        buffer[10] = (byte)(values.length / 256);
        buffer[11] = (byte)(values.length % 256);
        buffer[12] = (byte)data.length;
        System.arraycopy(data, 0, buffer, 13, data.length);
        return OperateResultExOne.CreateSuccessResult(buffer);
    }

    private OperateResultExOne<byte[]> BuildWriteRegisterCommand(String address, byte[] data) {
        OperateResultExOne<Integer> analysis = this.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        short messageId = (short)this.softIncrementCount.GetCurrentValue();
        byte[] buffer = new byte[13 + data.length];
        buffer[0] = (byte)(messageId / 256);
        buffer[1] = (byte)(messageId % 256);
        buffer[2] = 0;
        buffer[3] = 0;
        buffer[4] = (byte)((buffer.length - 6) / 256);
        buffer[5] = (byte)((buffer.length - 6) % 256);
        buffer[6] = this.station;
        buffer[7] = 16;
        buffer[8] = (byte)((Integer)analysis.Content / 256);
        buffer[9] = (byte)((Integer)analysis.Content % 256);
        buffer[10] = (byte)(data.length / 2 / 256);
        buffer[11] = (byte)(data.length / 2 % 256);
        buffer[12] = (byte)data.length;
        System.arraycopy(data, 0, buffer, 13, data.length);
        return OperateResultExOne.CreateSuccessResult(buffer);
    }

    private String GetDescriptionByErrorCode(byte code) {
        switch (code) {
            case 1: {
                return "\u4e0d\u652f\u6301\u7684\u529f\u80fd\u7801";
            }
            case 2: {
                return "\u8bfb\u53d6\u7684\u6570\u636e\u8d8a\u754c";
            }
            case 3: {
                return "\u8bfb\u53d6\u957f\u5ea6\u8d85\u8fc7\u6700\u5927\u503c";
            }
            case 4: {
                return "\u8bfb\u5199\u5f02\u5e38";
            }
        }
        return "\u672a\u77e5\u9519\u8bef";
    }

    private OperateResultExOne<byte[]> CheckModbusTcpResponse(byte[] send) {
        OperateResultExOne<byte[]> result = this.ReadFromCoreServer(send);
        if (result.IsSuccess && send[7] + 128 == ((byte[])result.Content)[7]) {
            result.IsSuccess = false;
            result.Message = this.GetDescriptionByErrorCode(((byte[])result.Content)[8]);
            result.ErrorCode = ((byte[])result.Content)[8];
        }
        return result;
    }

    private OperateResultExOne<byte[]> ReadModBusBase(byte code, String address, short length) {
        OperateResultExOne<byte[]> command = this.BuildReadCommandBase(code, address, length);
        if (!command.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(command);
        }
        OperateResultExOne<byte[]> resultBytes = this.CheckModbusTcpResponse((byte[])command.Content);
        if (resultBytes.IsSuccess && ((byte[])resultBytes.Content).length >= 9) {
            byte[] buffer = new byte[((byte[])resultBytes.Content).length - 9];
            System.arraycopy(resultBytes.Content, 9, buffer, 0, buffer.length);
            resultBytes.Content = buffer;
        }
        return resultBytes;
    }

    public OperateResultExOne<Boolean> ReadCoil(String address) {
        OperateResultExOne<byte[]> read = this.ReadModBusBase((byte)1, address, (short)1);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return this.GetBoolResultFromBytes(read);
    }

    public OperateResultExOne<boolean[]> ReadCoil(String address, short length) {
        OperateResultExOne<byte[]> read = this.ReadModBusBase((byte)1, address, length);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(SoftBasic.ByteToBoolArray((byte[])read.Content, length));
    }

    public OperateResultExOne<Boolean> ReadDiscrete(String address) {
        OperateResultExOne<byte[]> read = this.ReadModBusBase((byte)2, address, (short)1);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return this.GetBoolResultFromBytes(read);
    }

    public OperateResultExOne<boolean[]> ReadDiscrete(String address, short length) {
        OperateResultExOne<byte[]> read = this.ReadModBusBase((byte)2, address, length);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(SoftBasic.ByteToBoolArray((byte[])read.Content, length));
    }

    @Override
    public OperateResultExOne<byte[]> Read(String address, short length) {
        short lengthTmp;
        OperateResultExTwo<Byte, Integer> analysis = this.AnalysisReadAddress(address);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (int alreadyFinished = 0; alreadyFinished < length; alreadyFinished += lengthTmp) {
            lengthTmp = (short)Math.min(length - alreadyFinished, 120);
            OperateResultExOne<byte[]> read = this.ReadModBusBase((Byte)analysis.Content1, String.valueOf((Integer)analysis.Content2 + alreadyFinished), lengthTmp);
            if (!read.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(read);
            }
            try {
                outputStream.write((byte[])read.Content);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        byte[] data = outputStream.toByteArray();
        try {
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return OperateResultExOne.CreateSuccessResult(data);
    }

    public OperateResult WriteOneRegister(String address, byte high, byte low) {
        OperateResultExOne<byte[]> command = this.BuildWriteOneRegisterCommand(address, new byte[]{high, low});
        if (!command.IsSuccess) {
            return command;
        }
        return this.CheckModbusTcpResponse((byte[])command.Content);
    }

    public OperateResult WriteOneRegister(String address, short value) {
        byte[] buffer = Utilities.getBytes(value);
        return this.WriteOneRegister(address, buffer[1], buffer[0]);
    }

    @Override
    public OperateResult Write(String address, byte[] value) {
        OperateResultExOne<byte[]> command = this.BuildWriteRegisterCommand(address, value);
        if (!command.IsSuccess) {
            return command;
        }
        return this.CheckModbusTcpResponse((byte[])command.Content);
    }

    public OperateResult WriteCoil(String address, boolean value) {
        OperateResultExOne<byte[]> command = this.BuildWriteOneCoilCommand(address, value);
        if (!command.IsSuccess) {
            return command;
        }
        return this.CheckModbusTcpResponse((byte[])command.Content);
    }

    public OperateResult WriteCoil(String address, boolean[] values) {
        OperateResultExOne<byte[]> command = this.BuildWriteCoilCommand(address, values);
        if (!command.IsSuccess) {
            return command;
        }
        return this.CheckModbusTcpResponse((byte[])command.Content);
    }

    public OperateResult Write(String address, String value, int length) {
        byte[] temp = ((ReverseWordTransform)this.getByteTransform()).TransByte(value, "ASCII");
        temp = SoftBasic.ArrayExpandToLength(temp, length);
        return this.Write(address, temp);
    }

    public OperateResult WriteUnicodeString(String address, String value) {
        byte[] temp = Utilities.string2Byte(value);
        return this.Write(address, temp);
    }

    public OperateResult WriteUnicodeString(String address, String value, int length) {
        byte[] temp = Utilities.string2Byte(value);
        temp = SoftBasic.ArrayExpandToLength(temp, length * 2);
        return this.Write(address, temp);
    }

    public OperateResult Write(String address, boolean[] values) {
        return this.Write(address, SoftBasic.BoolArrayToByte(values));
    }

    @Override
    public String toString() {
        return "ModbusTcpNet";
    }
}

