/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Enthernet.SimplifyNet;

import HslCommunication.Core.IMessage.HslMessage;
import HslCommunication.Core.Net.HslProtocol;
import HslCommunication.Core.Net.NetHandle;
import HslCommunication.Core.Net.NetworkBase.NetworkDoubleBase;
import HslCommunication.Core.Transfer.RegularByteTransform;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Utilities;

public class NetSimplifyClient
extends NetworkDoubleBase<HslMessage, RegularByteTransform> {
    public NetSimplifyClient(String ipAddress, int port) {
        this.setIpAddress(ipAddress);
        this.setPort(port);
    }

    public NetSimplifyClient() {
    }

    public OperateResultExOne<String> ReadFromServer(NetHandle customer, String send) {
        OperateResultExOne<String> result = new OperateResultExOne<String>();
        byte[] data = send.isEmpty() ? new byte[]{} : Utilities.string2Byte(send);
        OperateResultExOne<byte[]> temp = this.ReadFromServerBase(1001, customer.get_CodeValue(), data);
        result.IsSuccess = temp.IsSuccess;
        result.ErrorCode = temp.ErrorCode;
        result.Message = temp.Message;
        if (temp.IsSuccess) {
            result.Content = Utilities.byte2String((byte[])temp.Content);
        }
        temp = null;
        return result;
    }

    public OperateResultExOne<byte[]> ReadFromServer(NetHandle customer, byte[] send) {
        return this.ReadFromServerBase(1002, customer.get_CodeValue(), send);
    }

    private OperateResultExOne<byte[]> ReadFromServerBase(int headcode, int customer, byte[] send) {
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(HslProtocol.CommandBytes(headcode, customer, this.Token, send));
        if (!read.IsSuccess) {
            return read;
        }
        byte[] headBytes = new byte[32];
        byte[] contentBytes = new byte[((byte[])read.Content).length - 32];
        System.arraycopy(read.Content, 0, headBytes, 0, 32);
        if (contentBytes.length > 0) {
            System.arraycopy(read.Content, 32, contentBytes, 0, ((byte[])read.Content).length - 32);
        }
        contentBytes = HslProtocol.CommandAnalysis(headBytes, contentBytes);
        return OperateResultExOne.CreateSuccessResult(contentBytes);
    }

    @Override
    public String toString() {
        return "NetSimplifyClient";
    }
}

