/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Core.Transfer;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.Transfer.ByteTransformBase;
import HslCommunication.Utilities;

public class ReverseWordTransform
extends ByteTransformBase {
    public boolean IsMultiWordReverse = false;
    public boolean IsStringReverse = false;

    private byte[] ReverseBytesByWord(byte[] buffer, int index, int length, boolean isReverse) {
        byte b;
        int i;
        byte[] tmp = new byte[length];
        for (i = 0; i < length; ++i) {
            tmp[i] = buffer[index + i];
        }
        for (i = 0; i < length / 2; ++i) {
            b = tmp[i * 2 + 0];
            tmp[i * 2 + 0] = tmp[i * 2 + 1];
            tmp[i * 2 + 1] = b;
        }
        if (isReverse) {
            byte a;
            if (tmp.length == 4) {
                a = tmp[0];
                b = tmp[1];
                tmp[0] = tmp[2];
                tmp[1] = tmp[3];
                tmp[2] = a;
                tmp[3] = b;
            } else if (tmp.length == 8) {
                a = tmp[0];
                b = tmp[1];
                tmp[0] = tmp[6];
                tmp[1] = tmp[7];
                tmp[6] = a;
                tmp[7] = b;
                a = tmp[2];
                b = tmp[3];
                tmp[2] = tmp[4];
                tmp[3] = tmp[5];
                tmp[4] = a;
                tmp[5] = b;
            }
        }
        return tmp;
    }

    private byte[] ReverseBytesByWord(byte[] buffer, boolean isReverse) {
        return this.ReverseBytesByWord(buffer, 0, buffer.length, isReverse);
    }

    @Override
    public short TransInt16(byte[] buffer, int index) {
        return Utilities.getShort(this.ReverseBytesByWord(buffer, index, 2, false), 0);
    }

    @Override
    public int TransInt32(byte[] buffer, int index) {
        return Utilities.getInt(this.ReverseBytesByWord(buffer, index, 4, this.IsMultiWordReverse), 0);
    }

    @Override
    public long TransInt64(byte[] buffer, int index) {
        return Utilities.getLong(this.ReverseBytesByWord(buffer, index, 8, this.IsMultiWordReverse), 0);
    }

    @Override
    public float TransSingle(byte[] buffer, int index) {
        return Utilities.getFloat(this.ReverseBytesByWord(buffer, index, 4, this.IsMultiWordReverse), 0);
    }

    @Override
    public double TransDouble(byte[] buffer, int index) {
        return Utilities.getDouble(this.ReverseBytesByWord(buffer, index, 8, this.IsMultiWordReverse), 0);
    }

    @Override
    public String TransString(byte[] buffer, int index, int length, String encoding) {
        byte[] tmp = this.TransByte(buffer, index, length);
        if (this.IsStringReverse) {
            return Utilities.getString(this.ReverseBytesByWord(tmp, false), "ASCII");
        }
        return Utilities.getString(tmp, "ASCII");
    }

    @Override
    public byte[] TransByte(boolean[] values) {
        return SoftBasic.BoolArrayToByte(values);
    }

    @Override
    public byte[] TransByte(short[] values) {
        if (values == null) {
            return null;
        }
        byte[] buffer = new byte[values.length * 2];
        for (int i = 0; i < values.length; ++i) {
            byte[] tmp = Utilities.getBytes(values[i]);
            System.arraycopy(tmp, 0, buffer, 2 * i, tmp.length);
        }
        return this.ReverseBytesByWord(buffer, false);
    }

    @Override
    public byte[] TransByte(int[] values) {
        if (values == null) {
            return null;
        }
        byte[] buffer = new byte[values.length * 4];
        for (int i = 0; i < values.length; ++i) {
            byte[] tmp = Utilities.getBytes(values[i]);
            System.arraycopy(tmp, 0, buffer, 4 * i, tmp.length);
        }
        return this.ReverseBytesByWord(buffer, this.IsMultiWordReverse);
    }

    @Override
    public byte[] TransByte(long[] values) {
        if (values == null) {
            return null;
        }
        byte[] buffer = new byte[values.length * 8];
        for (int i = 0; i < values.length; ++i) {
            byte[] tmp = Utilities.getBytes(values[i]);
            System.arraycopy(tmp, 0, buffer, 8 * i, tmp.length);
        }
        return this.ReverseBytesByWord(buffer, this.IsMultiWordReverse);
    }

    @Override
    public byte[] TransByte(float[] values) {
        if (values == null) {
            return null;
        }
        byte[] buffer = new byte[values.length * 4];
        for (int i = 0; i < values.length; ++i) {
            byte[] tmp = Utilities.getBytes(values[i]);
            System.arraycopy(tmp, 0, buffer, 4 * i, tmp.length);
        }
        return this.ReverseBytesByWord(buffer, this.IsMultiWordReverse);
    }

    @Override
    public byte[] TransByte(double[] values) {
        if (values == null) {
            return null;
        }
        byte[] buffer = new byte[values.length * 8];
        for (int i = 0; i < values.length; ++i) {
            byte[] tmp = Utilities.getBytes(values[i]);
            System.arraycopy(tmp, 0, buffer, 8 * i, tmp.length);
        }
        return this.ReverseBytesByWord(buffer, this.IsMultiWordReverse);
    }

    @Override
    public byte[] TransByte(String value, String encoding) {
        if (value == null) {
            return null;
        }
        byte[] buffer = Utilities.getBytes(value, encoding);
        buffer = SoftBasic.ArrayExpandToLengthEven(buffer);
        if (this.IsStringReverse) {
            return this.ReverseBytesByWord(buffer, false);
        }
        return buffer;
    }
}

