/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Core.Transfer;

import HslCommunication.Core.Transfer.IByteTransform;
import HslCommunication.Utilities;

public class ByteTransformBase
implements IByteTransform {
    @Override
    public boolean TransBool(byte[] buffer, int index) {
        return buffer[index] != 0;
    }

    @Override
    public byte TransByte(byte[] buffer, int index) {
        return buffer[index];
    }

    @Override
    public byte[] TransByte(byte[] buffer, int index, int length) {
        byte[] tmp = new byte[length];
        System.arraycopy(buffer, index, tmp, 0, length);
        return tmp;
    }

    @Override
    public short TransInt16(byte[] buffer, int index) {
        return Utilities.getShort(buffer, index);
    }

    @Override
    public short[] TransInt16(byte[] buffer, int index, int length) {
        short[] tmp = new short[length];
        for (int i = 0; i < length; ++i) {
            tmp[i] = this.TransInt16(buffer, index + 2 * i);
        }
        return tmp;
    }

    @Override
    public int TransInt32(byte[] buffer, int index) {
        return Utilities.getInt(buffer, index);
    }

    @Override
    public int[] TransInt32(byte[] buffer, int index, int length) {
        int[] tmp = new int[length];
        for (int i = 0; i < length; ++i) {
            tmp[i] = this.TransInt32(buffer, index + 4 * i);
        }
        return tmp;
    }

    @Override
    public long TransInt64(byte[] buffer, int index) {
        return Utilities.getLong(buffer, index);
    }

    @Override
    public long[] TransInt64(byte[] buffer, int index, int length) {
        long[] tmp = new long[length];
        for (int i = 0; i < length; ++i) {
            tmp[i] = this.TransInt64(buffer, index + 8 * i);
        }
        return tmp;
    }

    @Override
    public float TransSingle(byte[] buffer, int index) {
        return Utilities.getFloat(buffer, index);
    }

    @Override
    public float[] TransSingle(byte[] buffer, int index, int length) {
        float[] tmp = new float[length];
        for (int i = 0; i < length; ++i) {
            tmp[i] = this.TransSingle(buffer, index + 4 * i);
        }
        return tmp;
    }

    @Override
    public double TransDouble(byte[] buffer, int index) {
        return Utilities.getDouble(buffer, index);
    }

    @Override
    public double[] TransDouble(byte[] buffer, int index, int length) {
        double[] tmp = new double[length];
        for (int i = 0; i < length; ++i) {
            tmp[i] = this.TransDouble(buffer, index + 4 * i);
        }
        return tmp;
    }

    @Override
    public String TransString(byte[] buffer, int index, int length, String encoding) {
        return Utilities.getString(this.TransByte(buffer, index, length), encoding);
    }

    @Override
    public byte[] TransByte(boolean value) {
        return this.TransByte(new boolean[]{value});
    }

    @Override
    public byte[] TransByte(boolean[] values) {
        if (values == null) {
            return null;
        }
        byte[] buffer = new byte[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (!values[i]) continue;
            buffer[i] = 1;
        }
        return buffer;
    }

    @Override
    public byte[] TransByte(byte value) {
        return new byte[]{value};
    }

    @Override
    public byte[] TransByte(short value) {
        return this.TransByte(new short[]{value});
    }

    @Override
    public byte[] TransByte(short[] values) {
        if (values == null) {
            return null;
        }
        byte[] buffer = new byte[values.length * 2];
        for (int i = 0; i < values.length; ++i) {
            System.arraycopy(Utilities.getBytes(values[i]), 0, buffer, 2 * i, 2);
        }
        return buffer;
    }

    @Override
    public byte[] TransByte(int value) {
        return this.TransByte(new int[]{value});
    }

    @Override
    public byte[] TransByte(int[] values) {
        if (values == null) {
            return null;
        }
        byte[] buffer = new byte[values.length * 4];
        for (int i = 0; i < values.length; ++i) {
            System.arraycopy(Utilities.getBytes(values[i]), 0, buffer, 4 * i, 4);
        }
        return buffer;
    }

    @Override
    public byte[] TransByte(long value) {
        return this.TransByte(new long[]{value});
    }

    @Override
    public byte[] TransByte(long[] values) {
        if (values == null) {
            return null;
        }
        byte[] buffer = new byte[values.length * 8];
        for (int i = 0; i < values.length; ++i) {
            System.arraycopy(Utilities.getBytes(values[i]), 0, buffer, 8 * i, 8);
        }
        return buffer;
    }

    @Override
    public byte[] TransByte(float value) {
        return this.TransByte(new float[]{value});
    }

    @Override
    public byte[] TransByte(float[] values) {
        if (values == null) {
            return null;
        }
        byte[] buffer = new byte[values.length * 4];
        for (int i = 0; i < values.length; ++i) {
            System.arraycopy(Utilities.getBytes(values[i]), 0, buffer, 4 * i, 4);
        }
        return buffer;
    }

    @Override
    public byte[] TransByte(double value) {
        return this.TransByte(new double[]{value});
    }

    @Override
    public byte[] TransByte(double[] values) {
        if (values == null) {
            return null;
        }
        byte[] buffer = new byte[values.length * 8];
        for (int i = 0; i < values.length; ++i) {
            System.arraycopy(Utilities.getBytes(values[i]), 0, buffer, 8 * i, 8);
        }
        return buffer;
    }

    @Override
    public byte[] TransByte(String value, String encoding) {
        return Utilities.getBytes(value, encoding);
    }
}

