/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Core.Net.NetworkBase;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.Net.HslProtocol;
import HslCommunication.Core.Net.NetworkBase.NetworkBase;
import HslCommunication.Core.Net.StateOne.AppSession;
import HslCommunication.Core.Types.ActionOperateExTwo;
import HslCommunication.Core.Types.HslTimeOut;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Core.Types.OperateResultExTwo;
import HslCommunication.Utilities;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;

public class NetworkXBase
extends NetworkBase {
    private Thread thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void SendBytesAsync(AppSession session, byte[] content) {
        if (content == null) {
            return;
        }
        try {
            session.getHybirdLockSend().lock();
            OutputStream outputStream = session.getWorkSocket().getOutputStream();
            outputStream.write(content);
        }
        catch (Exception ex) {
            if (!ex.getMessage().contains("\u8fdc\u7a0b\u4e3b\u673a\u5f3a\u8feb\u5173\u95ed\u4e86\u4e00\u4e2a\u73b0\u6709\u7684\u8fde\u63a5") && this.LogNet != null) {
                this.LogNet.WriteException(this.toString(), "\u540c\u6b65\u6570\u636e\u53d1\u9001\u5f02\u5e38\uff1a", ex);
            }
        }
        finally {
            session.getHybirdLockSend().unlock();
        }
    }

    protected void BeginReceiveBackground(final AppSession session) {
        this.thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    OperateResultExOne<byte[]> readHeadBytes = NetworkXBase.this.Receive(session.getWorkSocket(), 32);
                    if (!readHeadBytes.IsSuccess) {
                        NetworkXBase.this.SocketReceiveException(session);
                        return;
                    }
                    int length = Utilities.getInt((byte[])readHeadBytes.Content, 28);
                    OperateResultExOne<byte[]> readContent = NetworkXBase.this.Receive(session.getWorkSocket(), length);
                    if (!readContent.IsSuccess) {
                        NetworkXBase.this.SocketReceiveException(session);
                        return;
                    }
                    if (NetworkXBase.this.CheckRemoteToken((byte[])readHeadBytes.Content)) {
                        byte[] head = (byte[])readHeadBytes.Content;
                        byte[] content = HslProtocol.CommandAnalysis(head, (byte[])readContent.Content);
                        int protocol = Utilities.getInt(head, 0);
                        int customer = Utilities.getInt(head, 4);
                        NetworkXBase.this.DataProcessingCenter(session, protocol, customer, content);
                        continue;
                    }
                    if (NetworkXBase.this.LogNet != null) {
                        NetworkXBase.this.LogNet.WriteWarn(this.toString(), "\u63a5\u6536\u9a8c\u8bc1\u4ee4\u724c\u4e0d\u4e00\u81f4");
                    }
                    NetworkXBase.this.AppSessionRemoteClose(session);
                }
            }
        };
        this.thread.start();
    }

    protected void DataProcessingCenter(AppSession session, int protocol, int customer, byte[] content) {
    }

    protected boolean CheckRemoteToken(byte[] headBytes) {
        return SoftBasic.IsTwoBytesEquel(headBytes, 12, Utilities.UUID2Byte(this.Token), 0, 16);
    }

    protected void SocketReceiveException(AppSession session) {
    }

    protected void AppSessionRemoteClose(AppSession session) {
    }

    protected OperateResult SendBaseAndCheckReceive(Socket socket, int headcode, int customer, byte[] send) {
        send = HslProtocol.CommandBytes(headcode, customer, this.Token, send);
        OperateResult sendResult = this.Send(socket, send);
        if (!sendResult.IsSuccess) {
            return sendResult;
        }
        OperateResultExOne<Long> checkResult = this.ReceiveLong(socket);
        if (!checkResult.IsSuccess) {
            return checkResult;
        }
        if ((Long)checkResult.Content != (long)send.length) {
            this.CloseSocket(socket);
            return OperateResult.CreateFailedResult("\u547d\u4ee4\u957f\u5ea6\u68c0\u67e5\u5931\u8d25");
        }
        return checkResult;
    }

    protected OperateResult SendBytesAndCheckReceive(Socket socket, int customer, byte[] send) {
        return this.SendBaseAndCheckReceive(socket, 1002, customer, send);
    }

    protected OperateResult SendStringAndCheckReceive(Socket socket, int customer, String send) {
        byte[] data = send == null || send.isEmpty() ? null : Utilities.string2Byte(send);
        return this.SendBaseAndCheckReceive(socket, 1001, customer, data);
    }

    protected OperateResultExTwo<byte[], byte[]> ReceiveAndCheckBytes(Socket socket, int timeout) {
        HslTimeOut hslTimeOut = new HslTimeOut();
        hslTimeOut.DelayTime = timeout;
        hslTimeOut.IsSuccessful = false;
        hslTimeOut.StartTime = new Date();
        hslTimeOut.WorkSocket = socket;
        OperateResultExOne<byte[]> headResult = this.Receive(socket, 32);
        if (!headResult.IsSuccess) {
            hslTimeOut.IsSuccessful = true;
            return OperateResultExTwo.CreateFailedResult(headResult);
        }
        hslTimeOut.IsSuccessful = true;
        if (!this.CheckRemoteToken((byte[])headResult.Content)) {
            this.CloseSocket(socket);
            OperateResultExTwo<byte[], byte[]> resultExTwo = new OperateResultExTwo<byte[], byte[]>();
            resultExTwo.Message = "\u63a5\u6536\u9a8c\u8bc1\u4ee4\u724c\u4e0d\u4e00\u81f4";
            return resultExTwo;
        }
        int contentLength = Utilities.getInt((byte[])headResult.Content, 28);
        OperateResultExOne<byte[]> contentResult = this.Receive(socket, contentLength);
        if (!contentResult.IsSuccess) {
            OperateResultExTwo<byte[], byte[]> resultExTwo = new OperateResultExTwo<byte[], byte[]>();
            resultExTwo.CopyErrorFromOther(contentResult);
            return resultExTwo;
        }
        OperateResult checkResult = this.SendLong(socket, 32 + contentLength);
        if (!checkResult.IsSuccess) {
            OperateResultExTwo<byte[], byte[]> resultExTwo = new OperateResultExTwo<byte[], byte[]>();
            resultExTwo.CopyErrorFromOther(checkResult);
            return resultExTwo;
        }
        byte[] head = (byte[])headResult.Content;
        byte[] content = (byte[])contentResult.Content;
        content = HslProtocol.CommandAnalysis(head, content);
        return OperateResultExTwo.CreateSuccessResult(head, content);
    }

    protected OperateResultExTwo<Integer, String> ReceiveStringContentFromSocket(Socket socket) {
        OperateResultExTwo<byte[], byte[]> receive = this.ReceiveAndCheckBytes(socket, 10000);
        if (!receive.IsSuccess) {
            OperateResultExTwo<Integer, String> resultExTwo = new OperateResultExTwo<Integer, String>();
            resultExTwo.CopyErrorFromOther(receive);
            return resultExTwo;
        }
        if (Utilities.getInt((byte[])receive.Content1, 0) != 1001) {
            if (this.LogNet != null) {
                this.LogNet.WriteError(this.toString(), "\u547d\u4ee4\u5934\u6821\u9a8c\u5931\u8d25");
            }
            this.CloseSocket(socket);
            OperateResultExTwo<Integer, String> resultExTwo = new OperateResultExTwo<Integer, String>();
            resultExTwo.Message = "\u547d\u4ee4\u5934\u6821\u9a8c\u5931\u8d25";
            return resultExTwo;
        }
        if (receive.Content2 == null) {
            receive.Content2 = new byte[0];
        }
        return OperateResultExTwo.CreateSuccessResult(Utilities.getInt((byte[])receive.Content1, 4), Utilities.byte2String((byte[])receive.Content2));
    }

    protected OperateResultExTwo<Integer, byte[]> ReceiveBytesContentFromSocket(Socket socket) {
        OperateResultExTwo<byte[], byte[]> receive = this.ReceiveAndCheckBytes(socket, 10000);
        if (!receive.IsSuccess) {
            OperateResultExTwo<Integer, byte[]> resultExTwo = new OperateResultExTwo<Integer, byte[]>();
            resultExTwo.CopyErrorFromOther(receive);
            return resultExTwo;
        }
        if (Utilities.getInt((byte[])receive.Content1, 0) != 1002) {
            if (this.LogNet != null) {
                this.LogNet.WriteError(this.toString(), "\u547d\u4ee4\u5934\u6821\u9a8c\u5931\u8d25");
            }
            this.CloseSocket(socket);
            OperateResultExTwo<Integer, byte[]> resultExTwo = new OperateResultExTwo<Integer, byte[]>();
            resultExTwo.Message = "\u547d\u4ee4\u5934\u6821\u9a8c\u5931\u8d25";
            return resultExTwo;
        }
        return OperateResultExTwo.CreateSuccessResult(Utilities.getInt((byte[])receive.Content1, 4), receive.Content2);
    }

    protected boolean DeleteFileByName(String filename) {
        try {
            File file = new File(filename);
            if (!file.exists()) {
                return true;
            }
            file.delete();
            return true;
        }
        catch (Exception ex) {
            if (this.LogNet != null) {
                this.LogNet.WriteException(this.toString(), "delete file failed:" + filename, ex);
            }
            return false;
        }
    }

    protected String PreprocessFolderName(String folder) {
        if (folder.endsWith("\\")) {
            return folder.substring(0, folder.length() - 1);
        }
        return folder;
    }

    private OperateResultExOne<Long> ReceiveLong(Socket socket) {
        OperateResultExOne<byte[]> read = this.Receive(socket, 8);
        if (read.IsSuccess) {
            return OperateResultExOne.CreateSuccessResult(Utilities.getLong((byte[])read.Content, 0));
        }
        OperateResultExOne<Long> resultExOne = new OperateResultExOne<Long>();
        resultExOne.Message = read.Message;
        return resultExOne;
    }

    private OperateResult SendLong(Socket socket, long value) {
        return this.Send(socket, Utilities.getBytes(value));
    }

    protected OperateResult SendStream(Socket socket, InputStream stream, long receive, ActionOperateExTwo<Long, Long> report, boolean reportByPercent) {
        OperateResultExOne<Integer> read;
        byte[] buffer = new byte[102400];
        long percent = 0L;
        for (long SendTotal = 0L; SendTotal < receive; SendTotal += (long)((Integer)read.Content).intValue()) {
            read = this.ReadStream(stream, buffer);
            if (!read.IsSuccess) {
                OperateResult result = new OperateResult();
                result.Message = read.Message;
                return result;
            }
            byte[] newBuffer = new byte[((Integer)read.Content).intValue()];
            System.arraycopy(buffer, 0, newBuffer, 0, newBuffer.length);
            OperateResult write = this.SendBytesAndCheckReceive(socket, (Integer)read.Content, newBuffer);
            if (!write.IsSuccess) {
                OperateResult result = new OperateResult();
                result.Message = write.Message;
                return result;
            }
            if (!reportByPercent) continue;
            long percentCurrent = SendTotal * 100L / receive;
            if (percent == percentCurrent) continue;
            percent = percentCurrent;
            if (report == null) continue;
            report.Action(SendTotal, receive);
        }
        return OperateResult.CreateSuccessResult();
    }

    protected OperateResult WriteStream(Socket socket, OutputStream stream, long totalLength, ActionOperateExTwo<Long, Long> report, boolean reportByPercent) {
        OperateResultExTwo<Integer, byte[]> read;
        long percent = 0L;
        for (long count_receive = 0L; count_receive < totalLength; count_receive += (long)((Integer)read.Content1).intValue()) {
            read = this.ReceiveBytesContentFromSocket(socket);
            if (!read.IsSuccess) {
                OperateResult result = new OperateResult();
                result.Message = read.Message;
                return result;
            }
            OperateResult write = this.WriteStream(stream, (byte[])read.Content2);
            if (!write.IsSuccess) {
                OperateResult result = new OperateResult();
                result.Message = write.Message;
                return result;
            }
            if (!reportByPercent) continue;
            long percentCurrent = count_receive * 100L / totalLength;
            if (percent == percentCurrent) continue;
            percent = percentCurrent;
            if (report == null) continue;
            report.Action(count_receive, totalLength);
        }
        return OperateResult.CreateSuccessResult();
    }

    @Override
    public String toString() {
        return "NetworkXBase";
    }
}

