/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Core.Net.NetworkBase;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.IMessage.INetMessage;
import HslCommunication.Core.Net.NetworkBase.NetworkBase;
import HslCommunication.Core.Net.StateOne.AlienSession;
import HslCommunication.Core.Transfer.ByteTransformHelper;
import HslCommunication.Core.Transfer.IByteTransform;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Core.Types.OperateResultExTwo;
import java.lang.reflect.ParameterizedType;
import java.net.Socket;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class NetworkDoubleBase<TNetMessage extends INetMessage, TTransform extends IByteTransform>
extends NetworkBase {
    private TTransform byteTransform;
    private String ipAddress = "127.0.0.1";
    private int port = 10000;
    private int connectTimeOut = 10000;
    private int receiveTimeOut = 10000;
    private boolean isPersistentConn = false;
    private Lock queueLock = new ReentrantLock();
    private boolean IsSocketError = false;
    private boolean isUseSpecifiedSocket = false;
    private String connectionId = "";
    public AlienSession AlienSession = null;

    public NetworkDoubleBase() {
        this.byteTransform = this.getInstanceOfTTransform();
        this.connectionId = SoftBasic.GetUniqueStringByGuidAndRandom();
    }

    private TTransform getInstanceOfTTransform() {
        ParameterizedType superClass = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class type = (Class)superClass.getActualTypeArguments()[1];
        try {
            return (TTransform)((IByteTransform)type.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private TNetMessage getInstanceOfTNetMessage() {
        ParameterizedType superClass = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class type = (Class)superClass.getActualTypeArguments()[0];
        try {
            return (TNetMessage)((INetMessage)type.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TTransform getByteTransform() {
        return this.byteTransform;
    }

    public void setByteTransform(TTransform transform) {
        this.byteTransform = transform;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public void setConnectTimeOut(int connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }

    public int getReceiveTimeOut() {
        return this.receiveTimeOut;
    }

    public void setReceiveTimeOut(int receiveTimeOut) {
        this.receiveTimeOut = receiveTimeOut;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        if (!ipAddress.isEmpty()) {
            this.ipAddress = ipAddress;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public void SetPersistentConnection() {
        this.isPersistentConn = true;
    }

    public OperateResult ConnectServer() {
        this.isPersistentConn = true;
        OperateResult result = new OperateResult();
        this.CloseSocket(this.CoreSocket);
        OperateResultExOne<Socket> rSocket = this.CreateSocketAndInitialication();
        if (!rSocket.IsSuccess) {
            this.IsSocketError = true;
            rSocket.Content = null;
            result.Message = rSocket.Message;
        } else {
            this.CoreSocket = (Socket)rSocket.Content;
            result.IsSuccess = true;
            if (this.LogNet != null) {
                this.LogNet.WriteDebug(this.toString(), "\u542f\u52a8\u5f15\u64ce");
            }
        }
        return result;
    }

    public OperateResult ConnectServer(AlienSession session) {
        this.isPersistentConn = true;
        this.isUseSpecifiedSocket = true;
        if (session != null) {
            if (this.AlienSession != null) {
                this.CloseSocket(this.AlienSession.getSocket());
            }
            if (this.connectionId.isEmpty()) {
                this.connectionId = session.getDTU();
            }
            if (this.connectionId == session.getDTU()) {
                this.CoreSocket = session.getSocket();
                this.IsSocketError = false;
                this.AlienSession = session;
                return this.InitializationOnConnect(session.getSocket());
            }
            this.IsSocketError = true;
            return new OperateResult();
        }
        this.IsSocketError = true;
        return new OperateResult();
    }

    public OperateResult ConnectClose() {
        OperateResult result = new OperateResult();
        this.isPersistentConn = false;
        this.queueLock.lock();
        result = this.ExtraOnDisconnect(this.CoreSocket);
        if (this.CoreSocket != null) {
            this.CloseSocket(this.CoreSocket);
        }
        this.CoreSocket = null;
        this.queueLock.unlock();
        if (this.LogNet != null) {
            this.LogNet.WriteDebug(this.toString(), "\u5173\u95ed\u5f15\u64ce");
        }
        return result;
    }

    protected OperateResult InitializationOnConnect(Socket socket) {
        return OperateResult.CreateSuccessResult();
    }

    protected OperateResult ExtraOnDisconnect(Socket socket) {
        return OperateResult.CreateSuccessResult();
    }

    private OperateResultExOne<Socket> GetAvailableSocket() {
        if (this.isPersistentConn) {
            if (this.isUseSpecifiedSocket) {
                if (this.IsSocketError) {
                    OperateResultExOne<Socket> rSocket = new OperateResultExOne<Socket>();
                    rSocket.Message = "\u8fde\u63a5\u4e0d\u53ef\u7528";
                    return rSocket;
                }
                return OperateResultExOne.CreateSuccessResult(this.CoreSocket);
            }
            if (this.IsSocketError || this.CoreSocket == null) {
                OperateResult connect = this.ConnectServer();
                if (!connect.IsSuccess) {
                    this.IsSocketError = true;
                    OperateResultExOne<Socket> rSocket = new OperateResultExOne<Socket>();
                    rSocket.Message = connect.Message;
                    rSocket.ErrorCode = connect.ErrorCode;
                    return rSocket;
                }
                this.IsSocketError = false;
                return OperateResultExOne.CreateSuccessResult(this.CoreSocket);
            }
            return OperateResultExOne.CreateSuccessResult(this.CoreSocket);
        }
        return this.CreateSocketAndInitialication();
    }

    private OperateResultExOne<Socket> CreateSocketAndInitialication() {
        OperateResultExOne<Socket> result = this.CreateSocketAndConnect(this.ipAddress, this.port, this.connectTimeOut);
        if (result.IsSuccess) {
            OperateResult initi = this.InitializationOnConnect((Socket)result.Content);
            if (!initi.IsSuccess) {
                this.CloseSocket((Socket)result.Content);
                result.IsSuccess = initi.IsSuccess;
                result.CopyErrorFromOther(initi);
            }
        }
        return result;
    }

    public OperateResultExOne<byte[]> ReadFromCoreServer(Socket socket, byte[] send) {
        OperateResultExOne<byte[]> result = new OperateResultExOne<byte[]>();
        OperateResultExTwo<byte[], byte[]> read = this.ReadFromCoreServerBase(socket, send);
        if (read.IsSuccess) {
            result.IsSuccess = read.IsSuccess;
            result.Content = new byte[((byte[])read.Content1).length + ((byte[])read.Content2).length];
            if (((byte[])read.Content1).length > 0) {
                System.arraycopy(read.Content1, 0, result.Content, 0, ((byte[])read.Content1).length);
            }
            if (((byte[])read.Content2).length > 0) {
                System.arraycopy(read.Content2, 0, result.Content, ((byte[])read.Content1).length, ((byte[])read.Content2).length);
            }
        } else {
            result.CopyErrorFromOther(read);
        }
        return result;
    }

    public OperateResultExOne<byte[]> ReadFromCoreServer(byte[] send) {
        OperateResultExOne<byte[]> result = new OperateResultExOne<byte[]>();
        this.queueLock.lock();
        OperateResultExOne<Socket> resultSocket = this.GetAvailableSocket();
        if (!resultSocket.IsSuccess) {
            this.IsSocketError = true;
            if (this.AlienSession != null) {
                this.AlienSession.setIsStatusOk(false);
            }
            this.queueLock.unlock();
            result.CopyErrorFromOther(resultSocket);
            return result;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((Socket)resultSocket.Content, send);
        if (read.IsSuccess) {
            this.IsSocketError = false;
            result.IsSuccess = read.IsSuccess;
            result.Content = read.Content;
        } else {
            this.IsSocketError = true;
            if (this.AlienSession != null) {
                this.AlienSession.setIsStatusOk(false);
            }
            result.CopyErrorFromOther(read);
        }
        this.queueLock.unlock();
        if (!this.isPersistentConn) {
            this.CloseSocket((Socket)resultSocket.Content);
        }
        return result;
    }

    protected OperateResultExTwo<byte[], byte[]> ReadFromCoreServerBase(Socket socket, byte[] send) {
        OperateResultExTwo<byte[], byte[]> result = new OperateResultExTwo<byte[], byte[]>();
        TNetMessage netMsg = this.getInstanceOfTNetMessage();
        netMsg.setSendBytes(send);
        OperateResult resultSend = this.Send(socket, send);
        if (!resultSend.IsSuccess) {
            this.CloseSocket(socket);
            result.CopyErrorFromOther(resultSend);
            return result;
        }
        if (this.receiveTimeOut >= 0) {
            OperateResultExOne<TNetMessage> resultReceive = this.ReceiveMessage(socket, this.receiveTimeOut, netMsg);
            if (!resultReceive.IsSuccess) {
                this.CloseSocket(socket);
                result.CopyErrorFromOther(resultReceive);
                return result;
            }
            result.Content1 = ((INetMessage)resultReceive.Content).getHeadBytes();
            result.Content2 = ((INetMessage)resultReceive.Content).getContentBytes();
        }
        result.IsSuccess = true;
        return result;
    }

    @Override
    public String toString() {
        return "NetworkDoubleBase<TNetMessage>";
    }

    protected OperateResultExOne<Boolean> GetBoolResultFromBytes(OperateResultExOne<byte[]> result) {
        return ByteTransformHelper.GetBoolResultFromBytes(result, this.byteTransform);
    }

    protected OperateResultExOne<Byte> GetByteResultFromBytes(OperateResultExOne<byte[]> result) {
        return ByteTransformHelper.GetByteResultFromBytes(result, this.byteTransform);
    }

    protected OperateResultExOne<Short> GetInt16ResultFromBytes(OperateResultExOne<byte[]> result) {
        return ByteTransformHelper.GetInt16ResultFromBytes(result, this.byteTransform);
    }

    protected OperateResultExOne<Integer> GetInt32ResultFromBytes(OperateResultExOne<byte[]> result) {
        return ByteTransformHelper.GetInt32ResultFromBytes(result, this.byteTransform);
    }

    protected OperateResultExOne<Long> GetInt64ResultFromBytes(OperateResultExOne<byte[]> result) {
        return ByteTransformHelper.GetInt64ResultFromBytes(result, this.byteTransform);
    }

    protected OperateResultExOne<Float> GetSingleResultFromBytes(OperateResultExOne<byte[]> result) {
        return ByteTransformHelper.GetSingleResultFromBytes(result, this.byteTransform);
    }

    protected OperateResultExOne<Double> GetDoubleResultFromBytes(OperateResultExOne<byte[]> result) {
        return ByteTransformHelper.GetDoubleResultFromBytes(result, this.byteTransform);
    }

    protected OperateResultExOne<String> GetStringResultFromBytes(OperateResultExOne<byte[]> result) {
        return ByteTransformHelper.GetStringResultFromBytes(result, this.byteTransform);
    }
}

