/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Core.Net.NetworkBase;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.IMessage.INetMessage;
import HslCommunication.Core.Net.IReadWriteNet;
import HslCommunication.Core.Net.NetworkBase.NetworkDoubleBase;
import HslCommunication.Core.Transfer.IByteTransform;
import HslCommunication.Core.Types.IDataTransfer;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;

public class NetworkDeviceBase<TNetMessage extends INetMessage, TTransform extends IByteTransform>
extends NetworkDoubleBase<TNetMessage, TTransform>
implements IReadWriteNet {
    protected short WordLength = 1;

    @Override
    public OperateResultExOne<byte[]> Read(String address, short length) {
        return new OperateResultExOne<byte[]>();
    }

    public OperateResult Write(String address, byte[] value) {
        return new OperateResult();
    }

    @Override
    public <T extends IDataTransfer> OperateResultExOne<T> ReadCustomer(String address, Class<T> tClass) {
        IDataTransfer Content;
        OperateResultExOne result = new OperateResultExOne();
        try {
            Content = (IDataTransfer)tClass.newInstance();
        }
        catch (Exception ex) {
            Content = null;
        }
        OperateResultExOne<byte[]> read = this.Read(address, Content.getReadCount());
        if (read.IsSuccess) {
            Content.ParseSource((byte[])read.Content);
            result.Content = Content;
            result.IsSuccess = true;
        } else {
            result.ErrorCode = read.ErrorCode;
            result.Message = read.Message;
        }
        return result;
    }

    @Override
    public <T extends IDataTransfer> OperateResult WriteCustomer(String address, T data) {
        return this.Write(address, data.ToSource());
    }

    @Override
    public OperateResultExOne<Short> ReadInt16(String address) {
        return this.GetInt16ResultFromBytes(this.Read(address, this.WordLength));
    }

    @Override
    public OperateResultExOne<short[]> ReadInt16(String address, short length) {
        OperateResultExOne<byte[]> read = this.Read(address, (short)(length * this.WordLength));
        if (!read.IsSuccess) {
            OperateResultExOne<short[]> result = new OperateResultExOne<short[]>();
            result.CopyErrorFromOther(read);
            return result;
        }
        return OperateResultExOne.CreateSuccessResult(super.getByteTransform().TransInt16((byte[])read.Content, 0, length));
    }

    @Override
    public OperateResultExOne<Integer> ReadInt32(String address) {
        return this.GetInt32ResultFromBytes(this.Read(address, (short)(2 * this.WordLength)));
    }

    @Override
    public OperateResultExOne<int[]> ReadInt32(String address, short length) {
        OperateResultExOne<byte[]> read = this.Read(address, (short)(length * this.WordLength * 2));
        if (!read.IsSuccess) {
            OperateResultExOne<int[]> result = new OperateResultExOne<int[]>();
            result.CopyErrorFromOther(read);
            return result;
        }
        return OperateResultExOne.CreateSuccessResult(super.getByteTransform().TransInt32((byte[])read.Content, 0, length));
    }

    @Override
    public OperateResultExOne<Float> ReadFloat(String address) {
        return this.GetSingleResultFromBytes(this.Read(address, (short)(2 * this.WordLength)));
    }

    @Override
    public OperateResultExOne<float[]> ReadFloat(String address, short length) {
        OperateResultExOne<byte[]> read = this.Read(address, (short)(length * this.WordLength * 2));
        if (!read.IsSuccess) {
            OperateResultExOne<float[]> result = new OperateResultExOne<float[]>();
            result.CopyErrorFromOther(read);
            return result;
        }
        return OperateResultExOne.CreateSuccessResult(super.getByteTransform().TransSingle((byte[])read.Content, 0, length));
    }

    @Override
    public OperateResultExOne<Long> ReadInt64(String address) {
        return this.GetInt64ResultFromBytes(this.Read(address, (short)(4 * this.WordLength)));
    }

    @Override
    public OperateResultExOne<long[]> ReadInt64(String address, short length) {
        OperateResultExOne<byte[]> read = this.Read(address, (short)(length * this.WordLength * 4));
        if (!read.IsSuccess) {
            OperateResultExOne<long[]> result = new OperateResultExOne<long[]>();
            result.CopyErrorFromOther(read);
            return result;
        }
        return OperateResultExOne.CreateSuccessResult(super.getByteTransform().TransInt64((byte[])read.Content, 0, length));
    }

    @Override
    public OperateResultExOne<Double> ReadDouble(String address) {
        return this.GetDoubleResultFromBytes(this.Read(address, (short)(4 * this.WordLength)));
    }

    @Override
    public OperateResultExOne<double[]> ReadDouble(String address, short length) {
        OperateResultExOne<byte[]> read = this.Read(address, (short)(length * this.WordLength * 4));
        if (!read.IsSuccess) {
            OperateResultExOne<double[]> result = new OperateResultExOne<double[]>();
            result.CopyErrorFromOther(read);
            return result;
        }
        return OperateResultExOne.CreateSuccessResult(super.getByteTransform().TransDouble((byte[])read.Content, 0, length));
    }

    @Override
    public OperateResultExOne<String> ReadString(String address, short length) {
        return this.GetStringResultFromBytes(this.Read(address, length));
    }

    @Override
    public OperateResult Write(String address, short[] values) {
        return this.Write(address, super.getByteTransform().TransByte(values));
    }

    @Override
    public OperateResult Write(String address, short value) {
        return this.Write(address, new short[]{value});
    }

    @Override
    public OperateResult Write(String address, int[] values) {
        return this.Write(address, super.getByteTransform().TransByte(values));
    }

    @Override
    public OperateResult Write(String address, int value) {
        return this.Write(address, new int[]{value});
    }

    @Override
    public OperateResult Write(String address, float[] values) {
        return this.Write(address, super.getByteTransform().TransByte(values));
    }

    @Override
    public OperateResult Write(String address, float value) {
        return this.Write(address, new float[]{value});
    }

    @Override
    public OperateResult Write(String address, long[] values) {
        return this.Write(address, this.getByteTransform().TransByte(values));
    }

    @Override
    public OperateResult Write(String address, long value) {
        return this.Write(address, new long[]{value});
    }

    @Override
    public OperateResult Write(String address, double[] values) {
        return this.Write(address, this.getByteTransform().TransByte(values));
    }

    @Override
    public OperateResult Write(String address, double value) {
        return this.Write(address, new double[]{value});
    }

    @Override
    public OperateResult Write(String address, String value) {
        byte[] temp = this.getByteTransform().TransByte(value, "US-ASCII");
        if (this.WordLength == 1) {
            temp = SoftBasic.ArrayExpandToLengthEven(temp);
        }
        return this.Write(address, temp);
    }

    @Override
    public String toString() {
        return "NetworkDeviceBase<TNetMessage, TTransform>";
    }
}

