/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Core.Net.NetworkBase;

import HslCommunication.Core.IMessage.INetMessage;
import HslCommunication.Core.Types.HslTimeOut;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.LogNet.Core.ILogNet;
import HslCommunication.Utilities;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Date;
import java.util.UUID;

public abstract class NetworkBase {
    protected Socket CoreSocket = null;
    public ILogNet LogNet = null;
    public UUID Token = UUID.fromString("00000000-0000-0000-0000-000000000000");

    public static void ThreadPoolCheckConnect(HslTimeOut timeout, int millisecond) {
        while (!timeout.IsSuccessful) {
            if (new Date().getTime() - timeout.StartTime.getTime() <= (long)millisecond) continue;
            if (timeout.IsSuccessful) break;
            try {
                if (timeout.WorkSocket == null) break;
                timeout.WorkSocket.close();
            }
            catch (IOException iOException) {}
            break;
        }
    }

    protected OperateResultExOne<byte[]> Receive(Socket socket, int length) {
        OperateResultExOne<byte[]> resultExOne = new OperateResultExOne<byte[]>();
        if (length == 0) {
            resultExOne.IsSuccess = true;
            resultExOne.Content = new byte[0];
            return resultExOne;
        }
        byte[] bytes_receive = new byte[length];
        try {
            InputStream input = socket.getInputStream();
            for (int count_receive = 0; count_receive < length; count_receive += input.read(bytes_receive, count_receive, length - count_receive)) {
            }
        }
        catch (IOException ex) {
            this.CloseSocket(socket);
            resultExOne.Message = ex.getMessage();
            return resultExOne;
        }
        resultExOne.IsSuccess = true;
        resultExOne.Content = bytes_receive;
        return resultExOne;
    }

    protected <TNetMessage extends INetMessage> OperateResultExOne<TNetMessage> ReceiveMessage(Socket socket, int timeOut, TNetMessage netMsg) {
        OperateResultExOne resultExOne = new OperateResultExOne();
        HslTimeOut hslTimeOut = new HslTimeOut();
        hslTimeOut.DelayTime = timeOut;
        hslTimeOut.WorkSocket = socket;
        OperateResultExOne<byte[]> headResult = this.Receive(socket, netMsg.ProtocolHeadBytesLength());
        if (!headResult.IsSuccess) {
            hslTimeOut.IsSuccessful = true;
            resultExOne.CopyErrorFromOther(headResult);
            return resultExOne;
        }
        netMsg.setHeadBytes((byte[])headResult.Content);
        if (!netMsg.CheckHeadBytesLegal(Utilities.UUID2Byte(this.Token))) {
            hslTimeOut.IsSuccessful = true;
            this.CloseSocket(socket);
            if (this.LogNet != null) {
                this.LogNet.WriteError(this.toString(), "\u63a5\u6536\u9a8c\u8bc1\u4ee4\u724c\u4e0d\u4e00\u81f4");
            }
            resultExOne.Message = "\u63a5\u6536\u9a8c\u8bc1\u4ee4\u724c\u4e0d\u4e00\u81f4";
            return resultExOne;
        }
        int contentLength = netMsg.GetContentLengthByHeadBytes();
        if (contentLength == 0) {
            netMsg.setHeadBytes(new byte[0]);
        } else {
            OperateResultExOne<byte[]> contentResult = this.Receive(socket, contentLength);
            if (!contentResult.IsSuccess) {
                hslTimeOut.IsSuccessful = true;
                resultExOne.CopyErrorFromOther(contentResult);
                return resultExOne;
            }
            netMsg.setContentBytes((byte[])contentResult.Content);
        }
        if (netMsg.getContentBytes() == null) {
            netMsg.setContentBytes(new byte[0]);
        }
        hslTimeOut.IsSuccessful = true;
        resultExOne.Content = netMsg;
        resultExOne.IsSuccess = true;
        return resultExOne;
    }

    protected OperateResult Send(Socket socket, byte[] data) {
        OperateResult result = new OperateResult();
        if (data == null) {
            result.IsSuccess = true;
            return result;
        }
        try {
            DataOutputStream output = new DataOutputStream(socket.getOutputStream());
            output.write(data, 0, data.length);
        }
        catch (IOException ex) {
            result.Message = ex.getMessage();
            return result;
        }
        result.IsSuccess = true;
        return result;
    }

    protected OperateResultExOne<Socket> CreateSocketAndConnect(SocketAddress endPoint, int timeOut) {
        OperateResultExOne<Socket> operateResultExOne = new OperateResultExOne<Socket>();
        Socket socket = new Socket();
        try {
            socket.connect(endPoint, timeOut);
            operateResultExOne.Content = socket;
            operateResultExOne.IsSuccess = true;
        }
        catch (IOException ex) {
            operateResultExOne.Message = ex.getMessage();
            this.CloseSocket(socket);
        }
        return operateResultExOne;
    }

    protected OperateResultExOne<Socket> CreateSocketAndConnect(String ipAddress, int port, int timeOut) {
        InetSocketAddress endPoint = new InetSocketAddress(ipAddress, port);
        return this.CreateSocketAndConnect(endPoint, timeOut);
    }

    protected OperateResultExOne<Integer> ReadStream(InputStream stream, byte[] buffer) {
        OperateResultExOne<Integer> resultExOne = new OperateResultExOne<Integer>();
        try {
            int read_count;
            for (read_count = 0; read_count < buffer.length; read_count += stream.read(buffer, read_count, buffer.length - read_count)) {
            }
            resultExOne.Content = read_count;
            resultExOne.IsSuccess = true;
        }
        catch (IOException ex) {
            resultExOne.Message = ex.getMessage();
        }
        return resultExOne;
    }

    protected OperateResult WriteStream(OutputStream stream, byte[] buffer) {
        OperateResultExOne result = new OperateResultExOne();
        try {
            stream.write(buffer, 0, buffer.length);
            result.IsSuccess = true;
        }
        catch (IOException ex) {
            result.Message = ex.getMessage();
        }
        return result;
    }

    protected void CloseSocket(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "NetworkBase";
    }
}

