/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Core.Net;

import HslCommunication.BasicFramework.SoftZipped;
import HslCommunication.Core.Security.HslSecurity;
import HslCommunication.Utilities;
import java.util.UUID;

public class HslProtocol {
    public static final int HeadByteLength = 32;
    public static final int ProtocolBufferSize = 1024;
    public static final int ProtocolCheckSecends = 1;
    public static final int ProtocolClientQuit = 2;
    public static final int ProtocolClientRefuseLogin = 3;
    public static final int ProtocolClientAllowLogin = 4;
    public static final int ProtocolUserString = 1001;
    public static final int ProtocolUserBytes = 1002;
    public static final int ProtocolUserBitmap = 1003;
    public static final int ProtocolUserException = 1004;
    public static final int ProtocolFileDownload = 2001;
    public static final int ProtocolFileUpload = 2002;
    public static final int ProtocolFileDelete = 2003;
    public static final int ProtocolFileCheckRight = 2004;
    public static final int ProtocolFileCheckError = 2005;
    public static final int ProtocolFileSaveError = 2006;
    public static final int ProtocolFileDirectoryFiles = 2007;
    public static final int ProtocolFileDirectories = 2008;
    public static final int ProtocolProgressReport = 2009;
    public static final int ProtocolNoZipped = 3001;
    public static final int ProtocolZipped = 3002;

    public static byte[] CommandBytes(int command, int customer, UUID token, byte[] data) {
        byte[] _temp = null;
        int _zipped = 3001;
        int _sendLength = 0;
        if (data == null) {
            _temp = new byte[32];
        } else {
            if ((data = HslSecurity.ByteEncrypt(data)).length > 10240) {
                data = SoftZipped.CompressBytes(data);
                _zipped = 3002;
            }
            _temp = new byte[32 + data.length];
            _sendLength = data.length;
        }
        Utilities.getBytes(command);
        System.arraycopy(Utilities.getBytes(command), 0, _temp, 0, 4);
        System.arraycopy(Utilities.getBytes(customer), 0, _temp, 4, 4);
        System.arraycopy(Utilities.getBytes(_zipped), 0, _temp, 8, 4);
        System.arraycopy(Utilities.UUID2Byte(token), 0, _temp, 12, 16);
        System.arraycopy(Utilities.getBytes(_sendLength), 0, _temp, 28, 4);
        if (_sendLength > 0) {
            System.arraycopy(data, 0, _temp, 32, _sendLength);
        }
        return _temp;
    }

    public static byte[] CommandAnalysis(byte[] head, byte[] content) {
        if (content != null) {
            byte[] buffer = new byte[]{head[8], head[9], head[10], head[11]};
            int _zipped = Utilities.getInt(buffer, 0);
            if (_zipped == 3002) {
                content = SoftZipped.Decompress(content);
            }
            return HslSecurity.ByteDecrypt(content);
        }
        return null;
    }

    public static byte[] CommandBytes(int customer, UUID token, byte[] data) {
        return HslProtocol.CommandBytes(1002, customer, token, data);
    }

    public static byte[] CommandBytes(int customer, UUID token, String data) {
        if (data == null) {
            return HslProtocol.CommandBytes(1001, customer, token, null);
        }
        return HslProtocol.CommandBytes(1001, customer, token, Utilities.string2Byte(data));
    }
}

