/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Core.IMessage;

import HslCommunication.Core.IMessage.INetMessage;

public class S7Message
implements INetMessage {
    private byte[] HeadBytes = null;
    private byte[] ContentBytes = null;
    private byte[] SendBytes = null;

    @Override
    public int ProtocolHeadBytesLength() {
        return 4;
    }

    @Override
    public int GetContentLengthByHeadBytes() {
        if (this.HeadBytes == null) {
            return 0;
        }
        return (this.HeadBytes[2] & 0xFF) * 256 + (this.HeadBytes[3] & 0xFF) - 4;
    }

    @Override
    public boolean CheckHeadBytesLegal(byte[] token) {
        if (this.HeadBytes == null) {
            return false;
        }
        return this.HeadBytes[0] == 3 && this.HeadBytes[1] == 0;
    }

    @Override
    public int GetHeadBytesIdentity() {
        return 0;
    }

    @Override
    public byte[] getHeadBytes() {
        return this.HeadBytes;
    }

    @Override
    public byte[] getContentBytes() {
        return this.ContentBytes;
    }

    @Override
    public byte[] getSendBytes() {
        return this.SendBytes;
    }

    @Override
    public void setHeadBytes(byte[] headBytes) {
        this.HeadBytes = headBytes;
    }

    @Override
    public void setContentBytes(byte[] contentBytes) {
        this.ContentBytes = contentBytes;
    }

    @Override
    public void setSendBytes(byte[] sendBytes) {
        this.SendBytes = sendBytes;
    }
}

