/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.BasicFramework;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;

public class SoftBasic {
    private static List<Character> hexCharList = Arrays.asList(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'));

    public static String GetSizeDescription(long size) {
        if (size < 1000L) {
            return size + " B";
        }
        if (size < 1000000L) {
            float data = (float)size / 1024.0f;
            return String.format("%.2f", Float.valueOf(data)) + " Kb";
        }
        if (size < 1000000000L) {
            float data = (float)size / 1024.0f / 1024.0f;
            return String.format("%.2f", Float.valueOf(data)) + " Mb";
        }
        float data = (float)size / 1024.0f / 1024.0f / 1024.0f;
        return String.format("%.2f", Float.valueOf(data)) + " Gb";
    }

    public static boolean IsTwoBytesEquel(byte[] b1, int start1, byte[] b2, int start2, int length) {
        if (b1 == null || b2 == null) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (b1[i + start1] == b2[i + start2]) continue;
            return false;
        }
        return true;
    }

    public static byte[] ArrayExpandToLength(byte[] data, int length) {
        if (data == null) {
            return new byte[0];
        }
        byte[] buffer = new byte[length];
        System.arraycopy(data, 0, buffer, 0, Math.min(data.length, buffer.length));
        return buffer;
    }

    public static byte[] ArrayExpandToLengthEven(byte[] data) {
        if (data == null) {
            data = new byte[]{};
        }
        if (data.length % 2 == 1) {
            return SoftBasic.ArrayExpandToLength(data, data.length + 1);
        }
        return data;
    }

    public static <T> T[] ArrayExpandToLengthEven(Class<T> tClass, T[] data) {
        if (data == null) {
            data = new Object[]{};
        }
        if (data.length % 2 == 1) {
            return SoftBasic.ArrayExpandToLength(tClass, data, data.length + 1);
        }
        return data;
    }

    public static <T> T[] ArrayExpandToLength(Class<T> tClass, T[] data, int length) {
        if (data == null) {
            return (Object[])Array.newInstance(tClass, 0);
        }
        if (data.length == length) {
            return data;
        }
        Object[] buffer = (Object[])Array.newInstance(tClass, length);
        System.arraycopy(data, 0, buffer, 0, Math.min(data.length, buffer.length));
        return buffer;
    }

    public static String GetUniqueStringByGuidAndRandom() {
        Random random = new Random();
        return UUID.randomUUID().toString() + (random.nextInt(9000) + 1000);
    }

    public static String ByteToHexString(byte[] InBytes) {
        return SoftBasic.ByteToHexString(InBytes, '\u0000');
    }

    public static String ByteToHexString(byte[] InBytes, char segment) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (InBytes == null || InBytes.length <= 0) {
            return null;
        }
        for (int i = 0; i < InBytes.length; ++i) {
            int v = InBytes[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
            stringBuilder.append(segment);
        }
        return stringBuilder.toString();
    }

    public static byte[] BoolArrayToByte(boolean[] array) {
        if (array == null) {
            return null;
        }
        int length = array.length % 8 == 0 ? array.length / 8 : array.length / 8 + 1;
        byte[] buffer = new byte[length];
        for (int i = 0; i < array.length; ++i) {
            int index = i / 8;
            int offect = i % 8;
            int temp = 0;
            switch (offect) {
                case 0: {
                    temp = 1;
                    break;
                }
                case 1: {
                    temp = 2;
                    break;
                }
                case 2: {
                    temp = 4;
                    break;
                }
                case 3: {
                    temp = 8;
                    break;
                }
                case 4: {
                    temp = 16;
                    break;
                }
                case 5: {
                    temp = 32;
                    break;
                }
                case 6: {
                    temp = 64;
                    break;
                }
                case 7: {
                    temp = -128;
                    break;
                }
            }
            if (!array[i]) continue;
            int n = index;
            buffer[n] = (byte)(buffer[n] + temp);
        }
        return buffer;
    }

    public static boolean[] ByteToBoolArray(byte[] InBytes, int length) {
        if (InBytes == null) {
            return null;
        }
        if (length > InBytes.length * 8) {
            length = InBytes.length * 8;
        }
        boolean[] buffer = new boolean[length];
        for (int i = 0; i < length; ++i) {
            int index = i / 8;
            int offect = i % 8;
            int temp = 0;
            switch (offect) {
                case 0: {
                    temp = 1;
                    break;
                }
                case 1: {
                    temp = 2;
                    break;
                }
                case 2: {
                    temp = 4;
                    break;
                }
                case 3: {
                    temp = 8;
                    break;
                }
                case 4: {
                    temp = 16;
                    break;
                }
                case 5: {
                    temp = 32;
                    break;
                }
                case 6: {
                    temp = 64;
                    break;
                }
                case 7: {
                    temp = -128;
                    break;
                }
            }
            if ((InBytes[index] & temp) != temp) continue;
            buffer[i] = true;
        }
        return buffer;
    }

    public static String ByteToHexString(String InString) throws UnsupportedEncodingException {
        return SoftBasic.ByteToHexString(InString.getBytes("unicode"));
    }

    public static byte[] HexStringToBytes(String hex) {
        hex = hex.toUpperCase();
        ByteArrayOutputStream ms = new ByteArrayOutputStream();
        for (int i = 0; i < hex.length(); ++i) {
            if (i + 1 >= hex.length() || !hexCharList.contains(Character.valueOf(hex.charAt(i))) || !hexCharList.contains(Character.valueOf(hex.charAt(i + 1)))) continue;
            ms.write((byte)(hexCharList.indexOf(Character.valueOf(hex.charAt(i))) * 16 + hexCharList.indexOf(Character.valueOf(hex.charAt(i + 1)))));
            ++i;
        }
        byte[] result = ms.toByteArray();
        try {
            ms.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

