# Chinese Traditional (zh-HK) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                               | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | --------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 第 1987                                       | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 第 5                                          | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 第 1987                                       | 1986-12-28T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 第 5                                          | 0004-12-26T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 第 1                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 第 2                                          | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 第一季                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 第二季                                        | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 第一季度                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 第二季度                                      | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                             | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 第 1                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 第 2                                          | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 第一季                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 第二季                                        | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 第一季度                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 第二季度                                      | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 第 1                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 第 2                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 第 3                                          | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 第 4                                          | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 第 5                                          | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 第 6                                          | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 第 7                                          | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 第 8                                          | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 第 9                                          | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 第 10                                         | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 第 11                                         | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 第 12                                         | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | 1月                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2月                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3月                                           | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4月                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5月                                           | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6月                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7月                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8月                                           | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9月                                           | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10月                                          | Invalid Date             |
|                                 |              | 2019-11-10T12:13:14.015Z | 11月                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12月                                          | 2019-01-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | 一月                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 二月                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 三月                                          | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 四月                                          | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 五月                                          | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 六月                                          | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 七月                                          | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 八月                                          | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 九月                                          | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 十月                                          | Invalid Date             |
|                                 |              | 2019-11-10T12:13:14.015Z | 十一月                                        | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 十二月                                        | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | 一                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 二                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 三                                            | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 四                                            | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 五                                            | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 六                                            | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 七                                            | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 八                                            | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 九                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 十                                            | Invalid Date             |
|                                 |              | 2019-11-10T12:13:14.015Z | 十一                                          | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 十二                                          | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 第 1                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 第 2                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 第 3                                          | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 第 4                                          | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 第 5                                          | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 第 6                                          | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 第 7                                          | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 第 8                                          | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 第 9                                          | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 第 10                                         | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 第 11                                         | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 第 12                                         | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | 1月                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2月                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3月                                           | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4月                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5月                                           | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6月                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7月                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8月                                           | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9月                                           | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10月                                          | Invalid Date             |
|                                 |              | 2019-11-10T12:13:14.015Z | 11月                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12月                                          | 2019-01-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | 一月                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 二月                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 三月                                          | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 四月                                          | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 五月                                          | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 六月                                          | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 七月                                          | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 八月                                          | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 九月                                          | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 十月                                          | Invalid Date             |
|                                 |              | 2019-11-10T12:13:14.015Z | 十一月                                        | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 十二月                                        | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | 一                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 二                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 三                                            | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 四                                            | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 五                                            | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 六                                            | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 七                                            | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 八                                            | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 九                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 十                                            | Invalid Date             |
|                                 |              | 2019-11-10T12:13:14.015Z | 十一                                          | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 十二                                          | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 第 1                                          | 2018-12-30T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 第 49                                         | 2019-12-01T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 第 1                                          | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 第 48                                         | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1日                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11日                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28日                                          | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1日 二月                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11日 二月                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28日 二月                                     | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 第 42                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 第 365                                        | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | 週一                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 週五                                          | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | 週一                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 週五                                          | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | 週一                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 週五                                          | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | 星期一                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 星期五                                        | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | 一                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 五                                            | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | 一                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 五                                            | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 第 1                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 第 5                                          | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | 週一                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 週五                                          | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | 星期一                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 星期五                                        | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | 一                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 五                                            | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | 一                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 五                                            | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 第 2                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 第 6                                          | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | 週一                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 週五                                          | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | 星期一                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 星期五                                        | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | 一                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 五                                            | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | 一                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 五                                            | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 第 2                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 第 6                                          | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | 週一                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 週五                                          | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | 星期一                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 星期五                                        | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | 一                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 五                                            | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | 一                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 五                                            | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | 上                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 下                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 下                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 上                                            | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | 上                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 下                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 下                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 上                                            | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 晚上                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 夜晚                                          | Invalid Date             |
|                                 | BB           | 2019-02-11T11:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 晚上                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 夜晚                                          | Invalid Date             |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 晚上                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 夜晚                                          | Invalid Date             |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | 上午                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 下午                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | 晚上                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 夜晚                                          | Invalid Date             |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | 早                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | 午                                            | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | 晚                                            | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | 夜                                            | Invalid Date             |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11時                                          | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11時                                          | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11時                                          | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23時                                          | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11時                                          | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11時                                          | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11時                                          | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23時                                          | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1分                                           | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55分                                          | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1秒                                           | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55秒                                          | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 87-01-11                                      | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 87-02-11                                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 87-03-11                                      | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 87-04-11                                      | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 53-05-29                                      | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 87-06-11                                      | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 87-07-11                                      | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 87-08-11                                      | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 87-09-11                                      | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 87-10-11                                      | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 87-11-11                                      | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 87-12-11                                      | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 1987-01-11                                    | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987-02-11                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987-03-11                                    | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987-04-11                                    | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453-05-29                                    | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987-06-11                                    | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987-07-11                                    | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987-08-11                                    | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987-09-11                                    | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987-10-11                                    | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987-11-11                                    | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987-12-11                                    | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 1987年1月11日                                 | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987年2月11日                                 | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987年3月11日                                 | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987年4月11日                                 | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453年5月29日                                 | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987年6月11日                                 | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987年7月11日                                 | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987年8月11日                                 | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987年9月11日                                 | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987年10月11日                                | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987年11月11日                                | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987年12月11日                                | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | 1987年1月11日 星期日                          | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987年2月11日 星期三                          | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987年3月11日 星期三                          | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987年4月11日 星期六                          | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453年5月29日 星期日                          | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987年6月11日 星期四                          | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987年7月11日 星期六                          | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987年8月11日 星期二                          | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987年9月11日 星期五                          | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987年10月11日 星期日                         | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987年11月11日 星期三                         | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987年12月11日 星期五                         | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 下午 12:13                                    | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 下午 12:13                                    | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 下午 12:13                                    | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 下午 12:13                                    | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 下午 11:59                                    | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 下午 12:13                                    | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 下午 12:13                                    | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 下午 12:13                                    | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 下午 12:13                                    | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 下午 12:13                                    | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 下午 12:13                                    | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 下午 12:13                                    | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 下午 12:13:14                                 | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 下午 12:13:14                                 | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 下午 12:13:14                                 | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 下午 12:13:14                                 | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 下午 11:59:59                                 | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 下午 12:13:14                                 | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 下午 12:13:14                                 | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 下午 12:13:14                                 | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 下午 12:13:14                                 | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 下午 12:13:14                                 | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 下午 12:13:14                                 | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 下午 12:13:14                                 | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | GMT+0 下午 12:13:14                           | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | GMT+0 下午 12:13:14                           | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | GMT+0 下午 12:13:14                           | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | GMT+0 下午 12:13:14                           | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | GMT+0 下午 11:59:59                           | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | GMT+0 下午 12:13:14                           | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | GMT+0 下午 12:13:14                           | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | GMT+0 下午 12:13:14                           | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | GMT+0 下午 12:13:14                           | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | GMT+0 下午 12:13:14                           | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | GMT+0 下午 12:13:14                           | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | GMT+0 下午 12:13:14                           | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | GMT+00:00 下午 12:13:14                       | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | GMT+00:00 下午 12:13:14                       | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | GMT+00:00 下午 12:13:14                       | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | GMT+00:00 下午 12:13:14                       | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | GMT+00:00 下午 11:59:59                       | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | GMT+00:00 下午 12:13:14                       | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | GMT+00:00 下午 12:13:14                       | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | GMT+00:00 下午 12:13:14                       | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | GMT+00:00 下午 12:13:14                       | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | GMT+00:00 下午 12:13:14                       | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | GMT+00:00 下午 12:13:14                       | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | GMT+00:00 下午 12:13:14                       | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 87-01-11 下午 12:13                           | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 87-02-11 下午 12:13                           | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 87-03-11 下午 12:13                           | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 87-04-11 下午 12:13                           | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 53-05-29 下午 11:59                           | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 87-06-11 下午 12:13                           | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 87-07-11 下午 12:13                           | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 87-08-11 下午 12:13                           | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 87-09-11 下午 12:13                           | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 87-10-11 下午 12:13                           | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 87-11-11 下午 12:13                           | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 87-12-11 下午 12:13                           | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 1987-01-11 下午 12:13:14                      | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987-02-11 下午 12:13:14                      | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987-03-11 下午 12:13:14                      | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987-04-11 下午 12:13:14                      | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453-05-29 下午 11:59:59                      | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987-06-11 下午 12:13:14                      | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987-07-11 下午 12:13:14                      | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987-08-11 下午 12:13:14                      | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987-09-11 下午 12:13:14                      | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987-10-11 下午 12:13:14                      | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987-11-11 下午 12:13:14                      | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987-12-11 下午 12:13:14                      | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 1987年1月11日 GMT+0 下午 12:13:14             | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987年2月11日 GMT+0 下午 12:13:14             | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987年3月11日 GMT+0 下午 12:13:14             | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987年4月11日 GMT+0 下午 12:13:14             | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453年5月29日 GMT+0 下午 11:59:59             | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987年6月11日 GMT+0 下午 12:13:14             | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987年7月11日 GMT+0 下午 12:13:14             | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987年8月11日 GMT+0 下午 12:13:14             | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987年9月11日 GMT+0 下午 12:13:14             | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987年10月11日 GMT+0 下午 12:13:14            | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987年11月11日 GMT+0 下午 12:13:14            | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987年12月11日 GMT+0 下午 12:13:14            | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | 1987年1月11日 星期日 GMT+00:00 下午 12:13:14  | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987年2月11日 星期三 GMT+00:00 下午 12:13:14  | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987年3月11日 星期三 GMT+00:00 下午 12:13:14  | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987年4月11日 星期六 GMT+00:00 下午 12:13:14  | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453年5月29日 星期日 GMT+00:00 下午 11:59:59  | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987年6月11日 星期四 GMT+00:00 下午 12:13:14  | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987年7月11日 星期六 GMT+00:00 下午 12:13:14  | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987年8月11日 星期二 GMT+00:00 下午 12:13:14  | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987年9月11日 星期五 GMT+00:00 下午 12:13:14  | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987年10月11日 星期日 GMT+00:00 下午 12:13:14 | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987年11月11日 星期三 GMT+00:00 下午 12:13:14 | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987年12月11日 星期五 GMT+00:00 下午 12:13:14 | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result      | `includeSeconds: true` | `addSuffix: true` |
| ------------------------ | ----------- | ---------------------- | ----------------- |
| 2006-01-01T00:00:00.000Z | 大約 6 年   | 大約 6 年              | 大約 6 年內       |
| 2005-01-01T00:00:00.000Z | 大約 5 年   | 大約 5 年              | 大約 5 年內       |
| 2004-01-01T00:00:00.000Z | 大約 4 年   | 大約 4 年              | 大約 4 年內       |
| 2003-01-01T00:00:00.000Z | 大約 3 年   | 大約 3 年              | 大約 3 年內       |
| 2002-01-01T00:00:00.000Z | 大約 2 年   | 大約 2 年              | 大約 2 年內       |
| 2001-06-01T00:00:00.000Z | 超過 1 年   | 超過 1 年              | 超過 1 年內       |
| 2001-02-01T00:00:00.000Z | 大約 1 年   | 大約 1 年              | 大約 1 年內       |
| 2001-01-01T00:00:00.000Z | 大約 1 年   | 大約 1 年              | 大約 1 年內       |
| 2000-06-01T00:00:00.000Z | 5 個月      | 5 個月                 | 5 個月內          |
| 2000-03-01T00:00:00.000Z | 2 個月      | 2 個月                 | 2 個月內          |
| 2000-02-01T00:00:00.000Z | 大約 1 個月 | 大約 1 個月            | 大約 1 個月內     |
| 2000-01-15T00:00:00.000Z | 14 天       | 14 天                  | 14 天內           |
| 2000-01-02T00:00:00.000Z | 1 天        | 1 天                   | 1 天內            |
| 2000-01-01T06:00:00.000Z | 大約 6 小時 | 大約 6 小時            | 大約 6 小時內     |
| 2000-01-01T01:00:00.000Z | 大約 1 小時 | 大約 1 小時            | 大約 1 小時內     |
| 2000-01-01T00:45:00.000Z | 大約 1 小時 | 大約 1 小時            | 大約 1 小時內     |
| 2000-01-01T00:30:00.000Z | 30 分鐘     | 30 分鐘                | 30 分鐘內         |
| 2000-01-01T00:15:00.000Z | 15 分鐘     | 15 分鐘                | 15 分鐘內         |
| 2000-01-01T00:01:00.000Z | 1 分鐘      | 1 分鐘                 | 1 分鐘內          |
| 2000-01-01T00:00:25.000Z | 少於 1 分鐘 | 半分鐘                 | 少於 1 分鐘內     |
| 2000-01-01T00:00:15.000Z | 少於 1 分鐘 | 少於 20 秒             | 少於 1 分鐘內     |
| 2000-01-01T00:00:05.000Z | 少於 1 分鐘 | 少於 10 秒             | 少於 1 分鐘內     |
| 2000-01-01T00:00:00.000Z | 少於 1 分鐘 | 少於 5 秒              | 少於 1 分鐘前     |
| 1999-12-31T23:59:55.000Z | 少於 1 分鐘 | 少於 10 秒             | 少於 1 分鐘前     |
| 1999-12-31T23:59:45.000Z | 少於 1 分鐘 | 少於 20 秒             | 少於 1 分鐘前     |
| 1999-12-31T23:59:35.000Z | 少於 1 分鐘 | 半分鐘                 | 少於 1 分鐘前     |
| 1999-12-31T23:59:00.000Z | 1 分鐘      | 1 分鐘                 | 1 分鐘前          |
| 1999-12-31T23:45:00.000Z | 15 分鐘     | 15 分鐘                | 15 分鐘前         |
| 1999-12-31T23:30:00.000Z | 30 分鐘     | 30 分鐘                | 30 分鐘前         |
| 1999-12-31T23:15:00.000Z | 大約 1 小時 | 大約 1 小時            | 大約 1 小時前     |
| 1999-12-31T23:00:00.000Z | 大約 1 小時 | 大約 1 小時            | 大約 1 小時前     |
| 1999-12-31T18:00:00.000Z | 大約 6 小時 | 大約 6 小時            | 大約 6 小時前     |
| 1999-12-30T00:00:00.000Z | 2 天        | 2 天                   | 2 天前            |
| 1999-12-15T00:00:00.000Z | 17 天       | 17 天                  | 17 天前           |
| 1999-12-01T00:00:00.000Z | 大約 1 個月 | 大約 1 個月            | 大約 1 個月前     |
| 1999-11-01T00:00:00.000Z | 2 個月      | 2 個月                 | 2 個月前          |
| 1999-06-01T00:00:00.000Z | 7 個月      | 7 個月                 | 7 個月前          |
| 1999-01-01T00:00:00.000Z | 大約 1 年   | 大約 1 年              | 大約 1 年前       |
| 1998-12-01T00:00:00.000Z | 大約 1 年   | 大約 1 年              | 大約 1 年前       |
| 1998-06-01T00:00:00.000Z | 超過 1 年   | 超過 1 年              | 超過 1 年前       |
| 1998-01-01T00:00:00.000Z | 大約 2 年   | 大約 2 年              | 大約 2 年前       |
| 1997-01-01T00:00:00.000Z | 大約 3 年   | 大約 3 年              | 大約 3 年前       |
| 1996-01-01T00:00:00.000Z | 大約 4 年   | 大約 4 年              | 大約 4 年前       |
| 1995-01-01T00:00:00.000Z | 大約 5 年   | 大約 5 年              | 大約 5 年前       |
| 1994-01-01T00:00:00.000Z | 大約 6 年   | 大約 6 年              | 大約 6 年前       |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result  | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 年    | 6 年內            | 52608 小時                     |
| 2005-01-01T00:00:00.000Z | 5 年    | 5 年內            | 43848 小時                     |
| 2004-01-01T00:00:00.000Z | 4 年    | 4 年內            | 35064 小時                     |
| 2003-01-01T00:00:00.000Z | 3 年    | 3 年內            | 26304 小時                     |
| 2002-01-01T00:00:00.000Z | 2 年    | 2 年內            | 17544 小時                     |
| 2001-06-01T00:00:00.000Z | 1 年    | 1 年內            | 12408 小時                     |
| 2001-02-01T00:00:00.000Z | 1 年    | 1 年內            | 9528 小時                      |
| 2001-01-01T00:00:00.000Z | 1 年    | 1 年內            | 8784 小時                      |
| 2000-06-01T00:00:00.000Z | 5 個月  | 5 個月內          | 3648 小時                      |
| 2000-03-01T00:00:00.000Z | 2 個月  | 2 個月內          | 1440 小時                      |
| 2000-02-01T00:00:00.000Z | 1 個月  | 1 個月內          | 744 小時                       |
| 2000-01-15T00:00:00.000Z | 14 天   | 14 天內           | 336 小時                       |
| 2000-01-02T00:00:00.000Z | 1 天    | 1 天內            | 24 小時                        |
| 2000-01-01T06:00:00.000Z | 6 小時  | 6 小時內          | 6 小時                         |
| 2000-01-01T01:00:00.000Z | 1 小時  | 1 小時內          | 1 小時                         |
| 2000-01-01T00:45:00.000Z | 45 分鐘 | 45 分鐘內         | 1 小時                         |
| 2000-01-01T00:30:00.000Z | 30 分鐘 | 30 分鐘內         | 1 小時                         |
| 2000-01-01T00:15:00.000Z | 15 分鐘 | 15 分鐘內         | 0 小時                         |
| 2000-01-01T00:01:00.000Z | 1 分鐘  | 1 分鐘內          | 0 小時                         |
| 2000-01-01T00:00:25.000Z | 25 秒   | 25 秒內           | 0 小時                         |
| 2000-01-01T00:00:15.000Z | 15 秒   | 15 秒內           | 0 小時                         |
| 2000-01-01T00:00:05.000Z | 5 秒    | 5 秒內            | 0 小時                         |
| 2000-01-01T00:00:00.000Z | 0 秒    | 0 秒前            | 0 小時                         |
| 1999-12-31T23:59:55.000Z | 5 秒    | 5 秒前            | 0 小時                         |
| 1999-12-31T23:59:45.000Z | 15 秒   | 15 秒前           | 0 小時                         |
| 1999-12-31T23:59:35.000Z | 25 秒   | 25 秒前           | 0 小時                         |
| 1999-12-31T23:59:00.000Z | 1 分鐘  | 1 分鐘前          | 0 小時                         |
| 1999-12-31T23:45:00.000Z | 15 分鐘 | 15 分鐘前         | 0 小時                         |
| 1999-12-31T23:30:00.000Z | 30 分鐘 | 30 分鐘前         | 1 小時                         |
| 1999-12-31T23:15:00.000Z | 45 分鐘 | 45 分鐘前         | 1 小時                         |
| 1999-12-31T23:00:00.000Z | 1 小時  | 1 小時前          | 1 小時                         |
| 1999-12-31T18:00:00.000Z | 6 小時  | 6 小時前          | 6 小時                         |
| 1999-12-30T00:00:00.000Z | 2 天    | 2 天前            | 48 小時                        |
| 1999-12-15T00:00:00.000Z | 17 天   | 17 天前           | 408 小時                       |
| 1999-12-01T00:00:00.000Z | 1 個月  | 1 個月前          | 744 小時                       |
| 1999-11-01T00:00:00.000Z | 2 個月  | 2 個月前          | 1464 小時                      |
| 1999-06-01T00:00:00.000Z | 7 個月  | 7 個月前          | 5136 小時                      |
| 1999-01-01T00:00:00.000Z | 1 年    | 1 年前            | 8760 小時                      |
| 1998-12-01T00:00:00.000Z | 1 年    | 1 年前            | 9504 小時                      |
| 1998-06-01T00:00:00.000Z | 2 年    | 2 年前            | 13896 小時                     |
| 1998-01-01T00:00:00.000Z | 2 年    | 2 年前            | 17520 小時                     |
| 1997-01-01T00:00:00.000Z | 3 年    | 3 年前            | 26280 小時                     |
| 1996-01-01T00:00:00.000Z | 4 年    | 4 年前            | 35064 小時                     |
| 1995-01-01T00:00:00.000Z | 5 年    | 5 年前            | 43824 小時                     |
| 1994-01-01T00:00:00.000Z | 6 年    | 6 年前            | 52584 小時                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                |
| ------------------------ | --------------------- |
| 2000-01-10T00:00:00.000Z | 00-01-10              |
| 2000-01-05T00:00:00.000Z | 下個星期三 上午 12:00 |
| 2000-01-02T00:00:00.000Z | 明天 上午 12:00       |
| 2000-01-01T00:00:00.000Z | 今天 上午 12:00       |
| 1999-12-31T00:00:00.000Z | 昨天 上午 12:00       |
| 1999-12-27T00:00:00.000Z | 上個星期一 上午 12:00 |
| 1999-12-21T00:00:00.000Z | 99-12-21              |

## `formatDuration`

| Duration      | Result   |
| ------------- | -------- |
| {"years":0}   | 0 年     |
| {"years":1}   | 1 年     |
| {"years":2}   | 2 年     |
| {"months":0}  | 0 個月   |
| {"months":1}  | 1 個月   |
| {"months":2}  | 2 個月   |
| {"weeks":0}   | 0 個星期 |
| {"weeks":1}   | 1 個星期 |
| {"weeks":2}   | 2 個星期 |
| {"days":0}    | 0 天     |
| {"days":1}    | 1 天     |
| {"days":2}    | 2 天     |
| {"hours":0}   | 0 小時   |
| {"hours":1}   | 1 小時   |
| {"hours":2}   | 2 小時   |
| {"minutes":0} | 0 分鐘   |
| {"minutes":1} | 1 分鐘   |
| {"minutes":2} | 2 分鐘   |
| {"seconds":0} | 0 秒     |
| {"seconds":1} | 1 秒     |
| {"seconds":2} | 2 秒     |
