# Uighur (ug) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                     | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | --------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                                | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                   | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                                | 1986-12-28T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                   | 0004-12-26T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                   | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                   | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | بىرىنجى چارەك                                       | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | ئىككىنجى چارەك                                      | Invalid Date             |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                   | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                   | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                   | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | بىرىنجى چارەك                                       | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | ئىككىنجى چارەك                                      | Invalid Date             |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                                   | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                                   | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                   | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                                   | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                                   | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                                  | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                                  | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                                  | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | يانۋار                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | فېۋىرال                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | مارت                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | ئاپرىل                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | ماي                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ئىيۇن                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ئىيول                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ئاۋغۇست                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | سىنتەبىر                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ئۆكتەبىر                                            | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | نويابىر                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | دىكابىر                                             | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | يانۋار                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | فېۋىرال                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | مارت                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | ئاپرىل                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | ماي                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ئىيۇن                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ئىيول                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ئاۋغۇست                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | سىنتەبىر                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ئۆكتەبىر                                            | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | نويابىر                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | دىكابىر                                             | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | ي                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | ف                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | م                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | ا                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | م                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ى                                                   | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | ى                                                   | Invalid Date             |
|                                 |              | 2019-08-10T12:13:14.015Z | ا                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | س                                                   | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ۆ                                                   | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ن                                                   | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | د                                                   | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                                   | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                                   | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                   | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                                   | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                                   | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                                  | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                                  | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                                  | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | يانۋار                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | فېۋىرال                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | مارت                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | ئاپرىل                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | ماي                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ئىيۇن                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ئىيول                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ئاۋغۇست                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | سىنتەبىر                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ئۆكتەبىر                                            | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | نويابىر                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | دىكابىر                                             | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | يانۋار                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | فېۋىرال                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | مارت                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | ئاپرىل                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | ماي                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ئىيۇن                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ئىيول                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ئاۋغۇست                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | سىنتەبىر                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ئۆكتەبىر                                            | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | نويابىر                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | دىكابىر                                             | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | ي                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | ف                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | م                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | ا                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | م                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ى                                                   | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | ى                                                   | Invalid Date             |
|                                 |              | 2019-08-10T12:13:14.015Z | ا                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | س                                                   | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ۆ                                                   | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ن                                                   | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | د                                                   | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                                   | 2018-12-30T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 49                                                  | 2019-12-01T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                                   | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                                  | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                                  | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1 فېۋىرال                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11 فېۋىرال                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28 فېۋىرال                                          | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                                 | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | دۈشەنبە                                             | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | جۈمە                                                | Invalid Date             |
|                                 | EE           | 2019-02-11T12:13:14.015Z | دۈشەنبە                                             | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | جۈمە                                                | Invalid Date             |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | دۈشەنبە                                             | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | جۈمە                                                | Invalid Date             |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | دۈشەنبە                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جۈمە                                                | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | د                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                   | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | د                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                   | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                   | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | دۈشەنبە                                             | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | جۈمە                                                | Invalid Date             |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | دۈشەنبە                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جۈمە                                                | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | د                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                   | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | د                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                   | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 2                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6                                                   | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | دۈشەنبە                                             | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | جۈمە                                                | Invalid Date             |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | دۈشەنبە                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جۈمە                                                | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | د                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                   | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | د                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                   | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 2                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6                                                   | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | دۈشەنبە                                             | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | جۈمە                                                | Invalid Date             |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | دۈشەنبە                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جۈمە                                                | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | د                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                   | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | د                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                                   | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | چ                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ئە                                                  | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | ئەتىگەندە                                           | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | چۈشتىن كىيىن                                        | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | ئاخشامدا                                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | كىچىدە                                              | Invalid Date             |
|                                 | BB           | 2019-02-11T11:13:14.015Z | ئەتىگەندە                                           | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | چۈشتىن كىيىن                                        | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | ئاخشامدا                                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | كىچىدە                                              | Invalid Date             |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | ئەتىگەندە                                           | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | چۈشتىن كىيىن                                        | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | ئاخشامدا                                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | كىچىدە                                              | Invalid Date             |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | ئەتىگەندە                                           | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | چۈشتىن كىيىن                                        | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | ئاخشامدا                                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | كىچىدە                                              | Invalid Date             |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | ئەتىگەندە                                           | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | چۈشتىن كىيىن                                        | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | ئاخشامدا                                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | كىچىدە                                              | Invalid Date             |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                                  | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                  | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                                  | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                  | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                                  | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                  | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                                  | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                  | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                                   | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                                  | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                                   | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                                  | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 01/11/1987                                          | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 02/11/1987                                          | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 03/11/1987                                          | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 04/11/1987                                          | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 05/29/1453                                          | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 06/11/1987                                          | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 07/11/1987                                          | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 08/11/1987                                          | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 09/11/1987                                          | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 10/11/1987                                          | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987                                          | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12/11/1987                                          | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | يانۋار 11, 1987                                     | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | فېۋىرال 11, 1987                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | مارت 11, 1987                                       | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | ئاپرىل 11, 1987                                     | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | ماي 29, 1453                                        | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | ئىيۇن 11, 1987                                      | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | ئىيول 11, 1987                                      | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | ئاۋغۇست 11, 1987                                    | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | سىنتەبىر 11, 1987                                   | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | ئۆكتەبىر 11, 1987                                   | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | نويابىر 11, 1987                                    | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | دىكابىر 11, 1987                                    | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | يانۋار 11, 1987                                     | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | فېۋىرال 11, 1987                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | مارت 11, 1987                                       | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | ئاپرىل 11, 1987                                     | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | ماي 29, 1453                                        | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | ئىيۇن 11, 1987                                      | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | ئىيول 11, 1987                                      | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | ئاۋغۇست 11, 1987                                    | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | سىنتەبىر 11, 1987                                   | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | ئۆكتەبىر 11, 1987                                   | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | نويابىر 11, 1987                                    | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | دىكابىر 11, 1987                                    | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | يەكشەنبە, يانۋار 11, 1987                           | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | چارشەنبە, فېۋىرال 11, 1987                          | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | چارشەنبە, مارت 11, 1987                             | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | شەنبە, ئاپرىل 11, 1987                              | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | يەكشەنبە, ماي 29, 1453                              | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | پەيشەنبە, ئىيۇن 11, 1987                            | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | شەنبە, ئىيول 11, 1987                               | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | سەيشەنبە, ئاۋغۇست 11, 1987                          | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | جۈمە, سىنتەبىر 11, 1987                             | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | يەكشەنبە, ئۆكتەبىر 11, 1987                         | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | چارشەنبە, نويابىر 11, 1987                          | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | جۈمە, دىكابىر 11, 1987                              | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13 چ                                             | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13 چ                                             | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13 چ                                             | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13 چ                                             | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59 چ                                             | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13 چ                                             | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13 چ                                             | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13 چ                                             | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13 چ                                             | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13 چ                                             | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13 چ                                             | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13 چ                                             | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14 چ                                          | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 چ                                          | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 چ                                          | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 چ                                          | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 چ                                          | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 چ                                          | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 چ                                          | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 چ                                          | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 چ                                          | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 چ                                          | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 چ                                          | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 چ                                          | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 چ GMT+0                                    | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 چ GMT+0                                    | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 چ GMT+0                                    | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 چ GMT+0                                    | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 چ GMT+0                                    | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 چ GMT+0                                    | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 چ GMT+0                                    | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 چ GMT+0                                    | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 چ GMT+0                                    | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 چ GMT+0                                    | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 چ GMT+0                                    | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 چ GMT+0                                    | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 چ GMT+00:00                                | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 چ GMT+00:00                                | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 چ GMT+00:00                                | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 چ GMT+00:00                                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 چ GMT+00:00                                | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 چ GMT+00:00                                | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 چ GMT+00:00                                | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 چ GMT+00:00                                | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 چ GMT+00:00                                | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 چ GMT+00:00                                | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 چ GMT+00:00                                | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 چ GMT+00:00                                | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 01/11/1987, 12:13 چ                                 | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 02/11/1987, 12:13 چ                                 | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 03/11/1987, 12:13 چ                                 | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 04/11/1987, 12:13 چ                                 | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 05/29/1453, 11:59 چ                                 | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 06/11/1987, 12:13 چ                                 | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 07/11/1987, 12:13 چ                                 | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 08/11/1987, 12:13 چ                                 | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 09/11/1987, 12:13 چ                                 | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 10/11/1987, 12:13 چ                                 | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987, 12:13 چ                                 | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12/11/1987, 12:13 چ                                 | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | يانۋار 11, 1987, 12:13:14 چ                         | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | فېۋىرال 11, 1987, 12:13:14 چ                        | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | مارت 11, 1987, 12:13:14 چ                           | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | ئاپرىل 11, 1987, 12:13:14 چ                         | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | ماي 29, 1453, 11:59:59 چ                            | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | ئىيۇن 11, 1987, 12:13:14 چ                          | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | ئىيول 11, 1987, 12:13:14 چ                          | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | ئاۋغۇست 11, 1987, 12:13:14 چ                        | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | سىنتەبىر 11, 1987, 12:13:14 چ                       | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | ئۆكتەبىر 11, 1987, 12:13:14 چ                       | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | نويابىر 11, 1987, 12:13:14 چ                        | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | دىكابىر 11, 1987, 12:13:14 چ                        | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | يانۋار 11, 1987 دە 12:13:14 چ GMT+0                 | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | فېۋىرال 11, 1987 دە 12:13:14 چ GMT+0                | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | مارت 11, 1987 دە 12:13:14 چ GMT+0                   | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | ئاپرىل 11, 1987 دە 12:13:14 چ GMT+0                 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | ماي 29, 1453 دە 11:59:59 چ GMT+0                    | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | ئىيۇن 11, 1987 دە 12:13:14 چ GMT+0                  | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | ئىيول 11, 1987 دە 12:13:14 چ GMT+0                  | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | ئاۋغۇست 11, 1987 دە 12:13:14 چ GMT+0                | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | سىنتەبىر 11, 1987 دە 12:13:14 چ GMT+0               | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | ئۆكتەبىر 11, 1987 دە 12:13:14 چ GMT+0               | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | نويابىر 11, 1987 دە 12:13:14 چ GMT+0                | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | دىكابىر 11, 1987 دە 12:13:14 چ GMT+0                | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | يەكشەنبە, يانۋار 11, 1987 دە 12:13:14 چ GMT+00:00   | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | چارشەنبە, فېۋىرال 11, 1987 دە 12:13:14 چ GMT+00:00  | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | چارشەنبە, مارت 11, 1987 دە 12:13:14 چ GMT+00:00     | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | شەنبە, ئاپرىل 11, 1987 دە 12:13:14 چ GMT+00:00      | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | يەكشەنبە, ماي 29, 1453 دە 11:59:59 چ GMT+00:00      | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | پەيشەنبە, ئىيۇن 11, 1987 دە 12:13:14 چ GMT+00:00    | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | شەنبە, ئىيول 11, 1987 دە 12:13:14 چ GMT+00:00       | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | سەيشەنبە, ئاۋغۇست 11, 1987 دە 12:13:14 چ GMT+00:00  | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | جۈمە, سىنتەبىر 11, 1987 دە 12:13:14 چ GMT+00:00     | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | يەكشەنبە, ئۆكتەبىر 11, 1987 دە 12:13:14 چ GMT+00:00 | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | چارشەنبە, نويابىر 11, 1987 دە 12:13:14 چ GMT+00:00  | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | جۈمە, دىكابىر 11, 1987 دە 12:13:14 چ GMT+00:00      | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result             | `includeSeconds: true` | `addSuffix: true`        |
| ------------------------ | ------------------ | ---------------------- | ------------------------ |
| 2006-01-01T00:00:00.000Z | يىل 6 تەخمىنەن     | يىل 6 تەخمىنەن         | يىل 6 تەخمىنەن           |
| 2005-01-01T00:00:00.000Z | يىل 5 تەخمىنەن     | يىل 5 تەخمىنەن         | يىل 5 تەخمىنەن           |
| 2004-01-01T00:00:00.000Z | يىل 4 تەخمىنەن     | يىل 4 تەخمىنەن         | يىل 4 تەخمىنەن           |
| 2003-01-01T00:00:00.000Z | يىل 3 تەخمىنەن     | يىل 3 تەخمىنەن         | يىل 3 تەخمىنەن           |
| 2002-01-01T00:00:00.000Z | يىل 2 تەخمىنەن     | يىل 2 تەخمىنەن         | يىل 2 تەخمىنەن           |
| 2001-06-01T00:00:00.000Z | بىر يىلدىن ئارتۇق  | بىر يىلدىن ئارتۇق      | بىر يىلدىن ئارتۇق        |
| 2001-02-01T00:00:00.000Z | تەخمىنەن بىر يىل   | تەخمىنەن بىر يىل       | تەخمىنەن بىر يىل         |
| 2001-01-01T00:00:00.000Z | تەخمىنەن بىر يىل   | تەخمىنەن بىر يىل       | تەخمىنەن بىر يىل         |
| 2000-06-01T00:00:00.000Z | ئاي 5              | ئاي 5                  | ئاي 5                    |
| 2000-03-01T00:00:00.000Z | ئاي 2              | ئاي 2                  | ئاي 2                    |
| 2000-02-01T00:00:00.000Z | تەخمىنەن بىر ئاي   | تەخمىنەن بىر ئاي       | تەخمىنەن بىر ئاي         |
| 2000-01-15T00:00:00.000Z | كۈن 14             | كۈن 14                 | كۈن 14                   |
| 2000-01-02T00:00:00.000Z | بىر كۈن            | بىر كۈن                | بىر كۈن                  |
| 2000-01-01T06:00:00.000Z | سائەت 6 تەخمىنەن   | سائەت 6 تەخمىنەن       | سائەت 6 تەخمىنەن         |
| 2000-01-01T01:00:00.000Z | تەخمىنەن بىر سائەت | تەخمىنەن بىر سائەت     | تەخمىنەن بىر سائەت       |
| 2000-01-01T00:45:00.000Z | تەخمىنەن بىر سائەت | تەخمىنەن بىر سائەت     | تەخمىنەن بىر سائەت       |
| 2000-01-01T00:30:00.000Z | مىنۇت 30           | مىنۇت 30               | مىنۇت 30                 |
| 2000-01-01T00:15:00.000Z | مىنۇت 15           | مىنۇت 15               | مىنۇت 15                 |
| 2000-01-01T00:01:00.000Z | بىر مىنۇت          | بىر مىنۇت              | بىر مىنۇت                |
| 2000-01-01T00:00:25.000Z | بىر مىنۇت ئىچىدە   | يىرىم مىنۇت            | بىر مىنۇت ئىچىدە         |
| 2000-01-01T00:00:15.000Z | بىر مىنۇت ئىچىدە   | سىكۇنت ئىچىدە 20       | بىر مىنۇت ئىچىدە         |
| 2000-01-01T00:00:05.000Z | بىر مىنۇت ئىچىدە   | سىكۇنت ئىچىدە 10       | بىر مىنۇت ئىچىدە         |
| 2000-01-01T00:00:00.000Z | بىر مىنۇت ئىچىدە   | سىكۇنت ئىچىدە 5        | بىر مىنۇت ئىچىدە بولدى   |
| 1999-12-31T23:59:55.000Z | بىر مىنۇت ئىچىدە   | سىكۇنت ئىچىدە 10       | بىر مىنۇت ئىچىدە بولدى   |
| 1999-12-31T23:59:45.000Z | بىر مىنۇت ئىچىدە   | سىكۇنت ئىچىدە 20       | بىر مىنۇت ئىچىدە بولدى   |
| 1999-12-31T23:59:35.000Z | بىر مىنۇت ئىچىدە   | يىرىم مىنۇت            | بىر مىنۇت ئىچىدە بولدى   |
| 1999-12-31T23:59:00.000Z | بىر مىنۇت          | بىر مىنۇت              | بىر مىنۇت بولدى          |
| 1999-12-31T23:45:00.000Z | مىنۇت 15           | مىنۇت 15               | مىنۇت 15 بولدى           |
| 1999-12-31T23:30:00.000Z | مىنۇت 30           | مىنۇت 30               | مىنۇت 30 بولدى           |
| 1999-12-31T23:15:00.000Z | تەخمىنەن بىر سائەت | تەخمىنەن بىر سائەت     | تەخمىنەن بىر سائەت بولدى |
| 1999-12-31T23:00:00.000Z | تەخمىنەن بىر سائەت | تەخمىنەن بىر سائەت     | تەخمىنەن بىر سائەت بولدى |
| 1999-12-31T18:00:00.000Z | سائەت 6 تەخمىنەن   | سائەت 6 تەخمىنەن       | سائەت 6 تەخمىنەن بولدى   |
| 1999-12-30T00:00:00.000Z | كۈن 2              | كۈن 2                  | كۈن 2 بولدى              |
| 1999-12-15T00:00:00.000Z | كۈن 17             | كۈن 17                 | كۈن 17 بولدى             |
| 1999-12-01T00:00:00.000Z | تەخمىنەن بىر ئاي   | تەخمىنەن بىر ئاي       | تەخمىنەن بىر ئاي بولدى   |
| 1999-11-01T00:00:00.000Z | ئاي 2              | ئاي 2                  | ئاي 2 بولدى              |
| 1999-06-01T00:00:00.000Z | ئاي 7              | ئاي 7                  | ئاي 7 بولدى              |
| 1999-01-01T00:00:00.000Z | تەخمىنەن بىر يىل   | تەخمىنەن بىر يىل       | تەخمىنەن بىر يىل بولدى   |
| 1998-12-01T00:00:00.000Z | تەخمىنەن بىر يىل   | تەخمىنەن بىر يىل       | تەخمىنەن بىر يىل بولدى   |
| 1998-06-01T00:00:00.000Z | بىر يىلدىن ئارتۇق  | بىر يىلدىن ئارتۇق      | بىر يىلدىن ئارتۇق بولدى  |
| 1998-01-01T00:00:00.000Z | يىل 2 تەخمىنەن     | يىل 2 تەخمىنەن         | يىل 2 تەخمىنەن بولدى     |
| 1997-01-01T00:00:00.000Z | يىل 3 تەخمىنەن     | يىل 3 تەخمىنەن         | يىل 3 تەخمىنەن بولدى     |
| 1996-01-01T00:00:00.000Z | يىل 4 تەخمىنەن     | يىل 4 تەخمىنەن         | يىل 4 تەخمىنەن بولدى     |
| 1995-01-01T00:00:00.000Z | يىل 5 تەخمىنەن     | يىل 5 تەخمىنەن         | يىل 5 تەخمىنەن بولدى     |
| 1994-01-01T00:00:00.000Z | يىل 6 تەخمىنەن     | يىل 6 تەخمىنەن         | يىل 6 تەخمىنەن بولدى     |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result    | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | --------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | يىل 6     | يىل 6             | سائەت 52608                    |
| 2005-01-01T00:00:00.000Z | يىل 5     | يىل 5             | سائەت 43848                    |
| 2004-01-01T00:00:00.000Z | يىل 4     | يىل 4             | سائەت 35064                    |
| 2003-01-01T00:00:00.000Z | يىل 3     | يىل 3             | سائەت 26304                    |
| 2002-01-01T00:00:00.000Z | يىل 2     | يىل 2             | سائەت 17544                    |
| 2001-06-01T00:00:00.000Z | بىر يىل   | بىر يىل           | سائەت 12408                    |
| 2001-02-01T00:00:00.000Z | بىر يىل   | بىر يىل           | سائەت 9528                     |
| 2001-01-01T00:00:00.000Z | بىر يىل   | بىر يىل           | سائەت 8784                     |
| 2000-06-01T00:00:00.000Z | ئاي 5     | ئاي 5             | سائەت 3648                     |
| 2000-03-01T00:00:00.000Z | ئاي 2     | ئاي 2             | سائەت 1440                     |
| 2000-02-01T00:00:00.000Z | بىر ئاي   | بىر ئاي           | سائەت 744                      |
| 2000-01-15T00:00:00.000Z | كۈن 14    | كۈن 14            | سائەت 336                      |
| 2000-01-02T00:00:00.000Z | بىر كۈن   | بىر كۈن           | سائەت 24                       |
| 2000-01-01T06:00:00.000Z | سائەت 6   | سائەت 6           | سائەت 6                        |
| 2000-01-01T01:00:00.000Z | بىر سائەت | بىر سائەت         | بىر سائەت                      |
| 2000-01-01T00:45:00.000Z | مىنۇت 45  | مىنۇت 45          | بىر سائەت                      |
| 2000-01-01T00:30:00.000Z | مىنۇت 30  | مىنۇت 30          | بىر سائەت                      |
| 2000-01-01T00:15:00.000Z | مىنۇت 15  | مىنۇت 15          | سائەت 0                        |
| 2000-01-01T00:01:00.000Z | بىر مىنۇت | بىر مىنۇت         | سائەت 0                        |
| 2000-01-01T00:00:25.000Z | سىكۇنت 25 | سىكۇنت 25         | سائەت 0                        |
| 2000-01-01T00:00:15.000Z | سىكۇنت 15 | سىكۇنت 15         | سائەت 0                        |
| 2000-01-01T00:00:05.000Z | سىكۇنت 5  | سىكۇنت 5          | سائەت 0                        |
| 2000-01-01T00:00:00.000Z | سىكۇنت 0  | سىكۇنت 0 بولدى    | سائەت 0                        |
| 1999-12-31T23:59:55.000Z | سىكۇنت 5  | سىكۇنت 5 بولدى    | سائەت 0                        |
| 1999-12-31T23:59:45.000Z | سىكۇنت 15 | سىكۇنت 15 بولدى   | سائەت 0                        |
| 1999-12-31T23:59:35.000Z | سىكۇنت 25 | سىكۇنت 25 بولدى   | سائەت 0                        |
| 1999-12-31T23:59:00.000Z | بىر مىنۇت | بىر مىنۇت بولدى   | سائەت 0                        |
| 1999-12-31T23:45:00.000Z | مىنۇت 15  | مىنۇت 15 بولدى    | سائەت 0                        |
| 1999-12-31T23:30:00.000Z | مىنۇت 30  | مىنۇت 30 بولدى    | بىر سائەت                      |
| 1999-12-31T23:15:00.000Z | مىنۇت 45  | مىنۇت 45 بولدى    | بىر سائەت                      |
| 1999-12-31T23:00:00.000Z | بىر سائەت | بىر سائەت بولدى   | بىر سائەت                      |
| 1999-12-31T18:00:00.000Z | سائەت 6   | سائەت 6 بولدى     | سائەت 6                        |
| 1999-12-30T00:00:00.000Z | كۈن 2     | كۈن 2 بولدى       | سائەت 48                       |
| 1999-12-15T00:00:00.000Z | كۈن 17    | كۈن 17 بولدى      | سائەت 408                      |
| 1999-12-01T00:00:00.000Z | بىر ئاي   | بىر ئاي بولدى     | سائەت 744                      |
| 1999-11-01T00:00:00.000Z | ئاي 2     | ئاي 2 بولدى       | سائەت 1464                     |
| 1999-06-01T00:00:00.000Z | ئاي 7     | ئاي 7 بولدى       | سائەت 5136                     |
| 1999-01-01T00:00:00.000Z | بىر يىل   | بىر يىل بولدى     | سائەت 8760                     |
| 1998-12-01T00:00:00.000Z | بىر يىل   | بىر يىل بولدى     | سائەت 9504                     |
| 1998-06-01T00:00:00.000Z | يىل 2     | يىل 2 بولدى       | سائەت 13896                    |
| 1998-01-01T00:00:00.000Z | يىل 2     | يىل 2 بولدى       | سائەت 17520                    |
| 1997-01-01T00:00:00.000Z | يىل 3     | يىل 3 بولدى       | سائەت 26280                    |
| 1996-01-01T00:00:00.000Z | يىل 4     | يىل 4 بولدى       | سائەت 35064                    |
| 1995-01-01T00:00:00.000Z | يىل 5     | يىل 5 بولدى       | سائەت 43824                    |
| 1994-01-01T00:00:00.000Z | يىل 6     | يىل 6 بولدى       | سائەت 52584                    |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                      |
| ------------------------ | --------------------------- |
| 2000-01-10T00:00:00.000Z | 01/10/2000                  |
| 2000-01-05T00:00:00.000Z | چارشەنبە دە 12:00 ئە        |
| 2000-01-02T00:00:00.000Z | ئەتە دە 12:00 ئە            |
| 2000-01-01T00:00:00.000Z | بۈگۈن دە 12:00 ئە           |
| 1999-12-31T00:00:00.000Z | تۈنۈگۈن دە 12:00 ئە         |
| 1999-12-27T00:00:00.000Z | ئ‍ۆتكەن دۈشەنبە دە 12:00 ئە |
| 1999-12-21T00:00:00.000Z | 12/21/1999                  |

## `formatDuration`

| Duration      | Result     |
| ------------- | ---------- |
| {"years":0}   | يىل 0      |
| {"years":1}   | بىر يىل    |
| {"years":2}   | يىل 2      |
| {"months":0}  | ئاي 0      |
| {"months":1}  | بىر ئاي    |
| {"months":2}  | ئاي 2      |
| {"weeks":0}   | ھەپتە 0    |
| {"weeks":1}   | بىرھەپتە   |
| {"weeks":2}   | ھەپتە 2    |
| {"days":0}    | كۈن 0      |
| {"days":1}    | بىر كۈن    |
| {"days":2}    | كۈن 2      |
| {"hours":0}   | سائەت 0    |
| {"hours":1}   | بىر سائەت  |
| {"hours":2}   | سائەت 2    |
| {"minutes":0} | مىنۇت 0    |
| {"minutes":1} | بىر مىنۇت  |
| {"minutes":2} | مىنۇت 2    |
| {"seconds":0} | سىكۇنت 0   |
| {"seconds":1} | بىر سىكۇنت |
| {"seconds":2} | سىكۇنت 2   |
