# Thai (th) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                            | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ---------------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                                       | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                          | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                                       | 1986-12-28T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                                          | 0004-12-26T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                          | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | Q1                                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                         | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | ไตรมาสแรก                                                  | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | ไตรมาสที่สอง                                               | Invalid Date             |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                          | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                          | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | Q1                                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                         | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | ไตรมาสแรก                                                  | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | ไตรมาสที่สอง                                               | Invalid Date             |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1                                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                                          | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                                          | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                                          | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                                          | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                          | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                                          | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                                          | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                                         | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                                         | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                                         | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | ม.ค.                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | ก.พ.                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | มี.ค.                                                      | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | เม.ย.                                                      | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | พ.ค.                                                       | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | มิ.ย.                                                      | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ก.ค.                                                       | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ส.ค.                                                       | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | ก.ย.                                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ต.ค.                                                       | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | พ.ย.                                                       | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ธ.ค.                                                       | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | มกราคม                                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | กุมภาพันธ์                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | มีนาคม                                                     | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | เมษายน                                                     | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | พฤษภาคม                                                    | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | มิถุนายน                                                   | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | กรกฎาคม                                                    | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | สิงหาคม                                                    | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | กันยายน                                                    | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ตุลาคม                                                     | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | พฤศจิกายน                                                  | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ธันวาคม                                                    | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | ม.ค.                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | ก.พ.                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | มี.ค.                                                      | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | เม.ย.                                                      | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | พ.ค.                                                       | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | มิ.ย.                                                      | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ก.ค.                                                       | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ส.ค.                                                       | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | ก.ย.                                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ต.ค.                                                       | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | พ.ย.                                                       | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ธ.ค.                                                       | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1                                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                                          | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                                          | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                                          | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                                          | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                                          | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                                          | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                                          | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                                         | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                                         | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                                         | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | ม.ค.                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | ก.พ.                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | มี.ค.                                                      | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | เม.ย.                                                      | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | พ.ค.                                                       | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | มิ.ย.                                                      | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ก.ค.                                                       | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ส.ค.                                                       | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | ก.ย.                                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ต.ค.                                                       | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | พ.ย.                                                       | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ธ.ค.                                                       | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | มกราคม                                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | กุมภาพันธ์                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | มีนาคม                                                     | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | เมษายน                                                     | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | พฤษภาคม                                                    | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | มิถุนายน                                                   | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | กรกฎาคม                                                    | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | สิงหาคม                                                    | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | กันยายน                                                    | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ตุลาคม                                                     | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | พฤศจิกายน                                                  | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ธันวาคม                                                    | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | ม.ค.                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | ก.พ.                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | มี.ค.                                                      | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | เม.ย.                                                      | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | พ.ค.                                                       | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | มิ.ย.                                                      | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ก.ค.                                                       | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ส.ค.                                                       | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | ก.ย.                                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ต.ค.                                                       | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | พ.ย.                                                       | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ธ.ค.                                                       | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                                          | 2018-12-30T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 49                                                         | 2019-12-01T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                                          | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                                         | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1                                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                                         | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1 กุมภาพันธ์                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11 กุมภาพันธ์                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28 กุมภาพันธ์                                              | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                                        | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | จ.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศ.                                                         | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | จ.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศ.                                                         | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | จ.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศ.                                                         | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | จันทร์                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศุกร์                                                      | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | จ.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศ.                                                         | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | จ.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศ.                                                         | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                                          | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | จ.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศ.                                                         | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | จันทร์                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศุกร์                                                      | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | จ.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศ.                                                         | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | จ.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศ.                                                         | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 2                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6                                                          | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | จ.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศ.                                                         | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | จันทร์                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศุกร์                                                      | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | จ.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศ.                                                         | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | จ.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศ.                                                         | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 2                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6                                                          | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | จ.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศ.                                                         | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | จันทร์                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศุกร์                                                      | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | จ.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศ.                                                         | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | จ.                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ศ.                                                         | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | หลังเที่ยง                                                 | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ก่อนเที่ยง                                                 | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | ตอนเช้า                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ตอนกลางวัน                                                 | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | ตอนเย็น                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ตอนกลางคืน                                                 | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | ตอนเช้า                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ตอนกลางวัน                                                 | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | ตอนเย็น                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ตอนกลางคืน                                                 | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | ตอนเช้า                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ตอนกลางวัน                                                 | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | ตอนเย็น                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ตอนกลางคืน                                                 | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | ตอนเช้า                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ตอนกลางวัน                                                 | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | ตอนเย็น                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ตอนกลางคืน                                                 | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | ตอนเช้า                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ตอนกลางวัน                                                 | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | ตอนเย็น                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ตอนกลางคืน                                                 | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                                         | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                         | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                                         | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                         | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                                         | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                                         | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                                         | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                                         | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                                          | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                                         | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                                          | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                                         | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11/01/1987                                                 | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987                                                 | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987                                                 | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987                                                 | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                                 | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987                                                 | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987                                                 | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987                                                 | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987                                                 | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987                                                 | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987                                                 | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987                                                 | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11 ม.ค. 1987                                               | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 ก.พ. 1987                                               | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 มี.ค. 1987                                              | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 เม.ย. 1987                                              | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 พ.ค. 1453                                               | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 มิ.ย. 1987                                              | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 ก.ค. 1987                                               | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 ส.ค. 1987                                               | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 ก.ย. 1987                                               | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 ต.ค. 1987                                               | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 พ.ย. 1987                                               | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ธ.ค. 1987                                               | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11 มกราคม 1987                                             | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 กุมภาพันธ์ 1987                                         | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 มีนาคม 1987                                             | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 เมษายน 1987                                             | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 พฤษภาคม 1453                                            | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 มิถุนายน 1987                                           | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 กรกฎาคม 1987                                            | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 สิงหาคม 1987                                            | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 กันยายน 1987                                            | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 ตุลาคม 1987                                             | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 พฤศจิกายน 1987                                          | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ธันวาคม 1987                                            | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | วันอาทิตย์ที่ 11 มกราคม 1987                               | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | วันพุธที่ 11 กุมภาพันธ์ 1987                               | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | วันพุธที่ 11 มีนาคม 1987                                   | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | วันเสาร์ที่ 11 เมษายน 1987                                 | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | วันอาทิตย์ที่ 29 พฤษภาคม 1453                              | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | วันพฤหัสบดีที่ 11 มิถุนายน 1987                            | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | วันเสาร์ที่ 11 กรกฎาคม 1987                                | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | วันอังคารที่ 11 สิงหาคม 1987                               | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | วันศุกร์ที่ 11 กันยายน 1987                                | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | วันอาทิตย์ที่ 11 ตุลาคม 1987                               | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | วันพุธที่ 11 พฤศจิกายน 1987                                | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | วันศุกร์ที่ 11 ธันวาคม 1987                                | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13 น.                                                   | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13 น.                                                   | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13 น.                                                   | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13 น.                                                   | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59 น.                                                   | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13 น.                                                   | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13 น.                                                   | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13 น.                                                   | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13 น.                                                   | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13 น.                                                   | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13 น.                                                   | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13 น.                                                   | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14 น.                                                | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 น.                                                | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 น.                                                | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 น.                                                | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 น.                                                | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 น.                                                | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 น.                                                | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 น.                                                | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 น.                                                | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 น.                                                | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 น.                                                | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 น.                                                | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 น. GMT+0                                          | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 น. GMT+0                                          | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 น. GMT+0                                          | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 น. GMT+0                                          | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 น. GMT+0                                          | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 น. GMT+0                                          | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 น. GMT+0                                          | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 น. GMT+0                                          | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 น. GMT+0                                          | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 น. GMT+0                                          | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 น. GMT+0                                          | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 น. GMT+0                                          | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 น. GMT+00:00                                      | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 น. GMT+00:00                                      | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 น. GMT+00:00                                      | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 น. GMT+00:00                                      | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 น. GMT+00:00                                      | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 น. GMT+00:00                                      | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 น. GMT+00:00                                      | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 น. GMT+00:00                                      | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 น. GMT+00:00                                      | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 น. GMT+00:00                                      | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 น. GMT+00:00                                      | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 น. GMT+00:00                                      | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11/01/1987, 12:13 น.                                       | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987, 12:13 น.                                       | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987, 12:13 น.                                       | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987, 12:13 น.                                       | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453, 23:59 น.                                       | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987, 12:13 น.                                       | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987, 12:13 น.                                       | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987, 12:13 น.                                       | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987, 12:13 น.                                       | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987, 12:13 น.                                       | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987, 12:13 น.                                       | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987, 12:13 น.                                       | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11 ม.ค. 1987, 12:13:14 น.                                  | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 ก.พ. 1987, 12:13:14 น.                                  | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 มี.ค. 1987, 12:13:14 น.                                 | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 เม.ย. 1987, 12:13:14 น.                                 | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 พ.ค. 1453, 23:59:59 น.                                  | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 มิ.ย. 1987, 12:13:14 น.                                 | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 ก.ค. 1987, 12:13:14 น.                                  | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 ส.ค. 1987, 12:13:14 น.                                  | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 ก.ย. 1987, 12:13:14 น.                                  | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 ต.ค. 1987, 12:13:14 น.                                  | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 พ.ย. 1987, 12:13:14 น.                                  | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ธ.ค. 1987, 12:13:14 น.                                  | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11 มกราคม 1987 เวลา 12:13:14 น. GMT+0                      | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 กุมภาพันธ์ 1987 เวลา 12:13:14 น. GMT+0                  | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 มีนาคม 1987 เวลา 12:13:14 น. GMT+0                      | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 เมษายน 1987 เวลา 12:13:14 น. GMT+0                      | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 พฤษภาคม 1453 เวลา 23:59:59 น. GMT+0                     | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 มิถุนายน 1987 เวลา 12:13:14 น. GMT+0                    | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 กรกฎาคม 1987 เวลา 12:13:14 น. GMT+0                     | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 สิงหาคม 1987 เวลา 12:13:14 น. GMT+0                     | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 กันยายน 1987 เวลา 12:13:14 น. GMT+0                     | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 ตุลาคม 1987 เวลา 12:13:14 น. GMT+0                      | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 พฤศจิกายน 1987 เวลา 12:13:14 น. GMT+0                   | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ธันวาคม 1987 เวลา 12:13:14 น. GMT+0                     | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | วันอาทิตย์ที่ 11 มกราคม 1987 เวลา 12:13:14 น. GMT+00:00    | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | วันพุธที่ 11 กุมภาพันธ์ 1987 เวลา 12:13:14 น. GMT+00:00    | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | วันพุธที่ 11 มีนาคม 1987 เวลา 12:13:14 น. GMT+00:00        | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | วันเสาร์ที่ 11 เมษายน 1987 เวลา 12:13:14 น. GMT+00:00      | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | วันอาทิตย์ที่ 29 พฤษภาคม 1453 เวลา 23:59:59 น. GMT+00:00   | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | วันพฤหัสบดีที่ 11 มิถุนายน 1987 เวลา 12:13:14 น. GMT+00:00 | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | วันเสาร์ที่ 11 กรกฎาคม 1987 เวลา 12:13:14 น. GMT+00:00     | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | วันอังคารที่ 11 สิงหาคม 1987 เวลา 12:13:14 น. GMT+00:00    | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | วันศุกร์ที่ 11 กันยายน 1987 เวลา 12:13:14 น. GMT+00:00     | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | วันอาทิตย์ที่ 11 ตุลาคม 1987 เวลา 12:13:14 น. GMT+00:00    | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | วันพุธที่ 11 พฤศจิกายน 1987 เวลา 12:13:14 น. GMT+00:00     | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | วันศุกร์ที่ 11 ธันวาคม 1987 เวลา 12:13:14 น. GMT+00:00     | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result           | `includeSeconds: true` | `addSuffix: true`         |
| ------------------------ | ---------------- | ---------------------- | ------------------------- |
| 2006-01-01T00:00:00.000Z | ประมาณ 6 ปี      | ประมาณ 6 ปี            | ใน ประมาณ 6 ปี            |
| 2005-01-01T00:00:00.000Z | ประมาณ 5 ปี      | ประมาณ 5 ปี            | ใน ประมาณ 5 ปี            |
| 2004-01-01T00:00:00.000Z | ประมาณ 4 ปี      | ประมาณ 4 ปี            | ใน ประมาณ 4 ปี            |
| 2003-01-01T00:00:00.000Z | ประมาณ 3 ปี      | ประมาณ 3 ปี            | ใน ประมาณ 3 ปี            |
| 2002-01-01T00:00:00.000Z | ประมาณ 2 ปี      | ประมาณ 2 ปี            | ใน ประมาณ 2 ปี            |
| 2001-06-01T00:00:00.000Z | มากกว่า 1 ปี     | มากกว่า 1 ปี           | ใน มากกว่า 1 ปี           |
| 2001-02-01T00:00:00.000Z | ประมาณ 1 ปี      | ประมาณ 1 ปี            | ใน ประมาณ 1 ปี            |
| 2001-01-01T00:00:00.000Z | ประมาณ 1 ปี      | ประมาณ 1 ปี            | ใน ประมาณ 1 ปี            |
| 2000-06-01T00:00:00.000Z | 5 เดือน          | 5 เดือน                | ใน 5 เดือน                |
| 2000-03-01T00:00:00.000Z | 2 เดือน          | 2 เดือน                | ใน 2 เดือน                |
| 2000-02-01T00:00:00.000Z | ประมาณ 1 เดือน   | ประมาณ 1 เดือน         | ใน ประมาณ 1 เดือน         |
| 2000-01-15T00:00:00.000Z | 14 วัน           | 14 วัน                 | ใน 14 วัน                 |
| 2000-01-02T00:00:00.000Z | 1 วัน            | 1 วัน                  | ใน 1 วัน                  |
| 2000-01-01T06:00:00.000Z | ประมาณ 6 ชั่วโมง | ประมาณ 6 ชั่วโมง       | ใน ประมาณ 6 ชั่วโมง       |
| 2000-01-01T01:00:00.000Z | ประมาณ 1 ชั่วโมง | ประมาณ 1 ชั่วโมง       | ใน ประมาณ 1 ชั่วโมง       |
| 2000-01-01T00:45:00.000Z | ประมาณ 1 ชั่วโมง | ประมาณ 1 ชั่วโมง       | ใน ประมาณ 1 ชั่วโมง       |
| 2000-01-01T00:30:00.000Z | 30 นาที          | 30 นาที                | ใน 30 นาที                |
| 2000-01-01T00:15:00.000Z | 15 นาที          | 15 นาที                | ใน 15 นาที                |
| 2000-01-01T00:01:00.000Z | 1 นาที           | 1 นาที                 | ใน 1 นาที                 |
| 2000-01-01T00:00:25.000Z | น้อยกว่า 1 นาที  | ครึ่งนาที              | ใน น้อยกว่า 1 นาที        |
| 2000-01-01T00:00:15.000Z | น้อยกว่า 1 นาที  | น้อยกว่า 20 วินาที     | ใน น้อยกว่า 1 นาที        |
| 2000-01-01T00:00:05.000Z | น้อยกว่า 1 นาที  | น้อยกว่า 10 วินาที     | ใน น้อยกว่า 1 นาที        |
| 2000-01-01T00:00:00.000Z | น้อยกว่า 1 นาที  | น้อยกว่า 5 วินาที      | น้อยกว่า 1 นาทีที่ผ่านมา  |
| 1999-12-31T23:59:55.000Z | น้อยกว่า 1 นาที  | น้อยกว่า 10 วินาที     | น้อยกว่า 1 นาทีที่ผ่านมา  |
| 1999-12-31T23:59:45.000Z | น้อยกว่า 1 นาที  | น้อยกว่า 20 วินาที     | น้อยกว่า 1 นาทีที่ผ่านมา  |
| 1999-12-31T23:59:35.000Z | น้อยกว่า 1 นาที  | ครึ่งนาที              | น้อยกว่า 1 นาทีที่ผ่านมา  |
| 1999-12-31T23:59:00.000Z | 1 นาที           | 1 นาที                 | 1 นาทีที่ผ่านมา           |
| 1999-12-31T23:45:00.000Z | 15 นาที          | 15 นาที                | 15 นาทีที่ผ่านมา          |
| 1999-12-31T23:30:00.000Z | 30 นาที          | 30 นาที                | 30 นาทีที่ผ่านมา          |
| 1999-12-31T23:15:00.000Z | ประมาณ 1 ชั่วโมง | ประมาณ 1 ชั่วโมง       | ประมาณ 1 ชั่วโมงที่ผ่านมา |
| 1999-12-31T23:00:00.000Z | ประมาณ 1 ชั่วโมง | ประมาณ 1 ชั่วโมง       | ประมาณ 1 ชั่วโมงที่ผ่านมา |
| 1999-12-31T18:00:00.000Z | ประมาณ 6 ชั่วโมง | ประมาณ 6 ชั่วโมง       | ประมาณ 6 ชั่วโมงที่ผ่านมา |
| 1999-12-30T00:00:00.000Z | 2 วัน            | 2 วัน                  | 2 วันที่ผ่านมา            |
| 1999-12-15T00:00:00.000Z | 17 วัน           | 17 วัน                 | 17 วันที่ผ่านมา           |
| 1999-12-01T00:00:00.000Z | ประมาณ 1 เดือน   | ประมาณ 1 เดือน         | ประมาณ 1 เดือนที่ผ่านมา   |
| 1999-11-01T00:00:00.000Z | 2 เดือน          | 2 เดือน                | 2 เดือนที่ผ่านมา          |
| 1999-06-01T00:00:00.000Z | 7 เดือน          | 7 เดือน                | 7 เดือนที่ผ่านมา          |
| 1999-01-01T00:00:00.000Z | ประมาณ 1 ปี      | ประมาณ 1 ปี            | ประมาณ 1 ปีที่ผ่านมา      |
| 1998-12-01T00:00:00.000Z | ประมาณ 1 ปี      | ประมาณ 1 ปี            | ประมาณ 1 ปีที่ผ่านมา      |
| 1998-06-01T00:00:00.000Z | มากกว่า 1 ปี     | มากกว่า 1 ปี           | มากกว่า 1 ปีที่ผ่านมา     |
| 1998-01-01T00:00:00.000Z | ประมาณ 2 ปี      | ประมาณ 2 ปี            | ประมาณ 2 ปีที่ผ่านมา      |
| 1997-01-01T00:00:00.000Z | ประมาณ 3 ปี      | ประมาณ 3 ปี            | ประมาณ 3 ปีที่ผ่านมา      |
| 1996-01-01T00:00:00.000Z | ประมาณ 4 ปี      | ประมาณ 4 ปี            | ประมาณ 4 ปีที่ผ่านมา      |
| 1995-01-01T00:00:00.000Z | ประมาณ 5 ปี      | ประมาณ 5 ปี            | ประมาณ 5 ปีที่ผ่านมา      |
| 1994-01-01T00:00:00.000Z | ประมาณ 6 ปี      | ประมาณ 6 ปี            | ประมาณ 6 ปีที่ผ่านมา      |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result    | `addSuffix: true`  | With forced unit (i.e. `hour`) |
| ------------------------ | --------- | ------------------ | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 ปี      | ใน 6 ปี            | 52608 ชั่วโมง                  |
| 2005-01-01T00:00:00.000Z | 5 ปี      | ใน 5 ปี            | 43848 ชั่วโมง                  |
| 2004-01-01T00:00:00.000Z | 4 ปี      | ใน 4 ปี            | 35064 ชั่วโมง                  |
| 2003-01-01T00:00:00.000Z | 3 ปี      | ใน 3 ปี            | 26304 ชั่วโมง                  |
| 2002-01-01T00:00:00.000Z | 2 ปี      | ใน 2 ปี            | 17544 ชั่วโมง                  |
| 2001-06-01T00:00:00.000Z | 1 ปี      | ใน 1 ปี            | 12408 ชั่วโมง                  |
| 2001-02-01T00:00:00.000Z | 1 ปี      | ใน 1 ปี            | 9528 ชั่วโมง                   |
| 2001-01-01T00:00:00.000Z | 1 ปี      | ใน 1 ปี            | 8784 ชั่วโมง                   |
| 2000-06-01T00:00:00.000Z | 5 เดือน   | ใน 5 เดือน         | 3648 ชั่วโมง                   |
| 2000-03-01T00:00:00.000Z | 2 เดือน   | ใน 2 เดือน         | 1440 ชั่วโมง                   |
| 2000-02-01T00:00:00.000Z | 1 เดือน   | ใน 1 เดือน         | 744 ชั่วโมง                    |
| 2000-01-15T00:00:00.000Z | 14 วัน    | ใน 14 วัน          | 336 ชั่วโมง                    |
| 2000-01-02T00:00:00.000Z | 1 วัน     | ใน 1 วัน           | 24 ชั่วโมง                     |
| 2000-01-01T06:00:00.000Z | 6 ชั่วโมง | ใน 6 ชั่วโมง       | 6 ชั่วโมง                      |
| 2000-01-01T01:00:00.000Z | 1 ชั่วโมง | ใน 1 ชั่วโมง       | 1 ชั่วโมง                      |
| 2000-01-01T00:45:00.000Z | 45 นาที   | ใน 45 นาที         | 1 ชั่วโมง                      |
| 2000-01-01T00:30:00.000Z | 30 นาที   | ใน 30 นาที         | 1 ชั่วโมง                      |
| 2000-01-01T00:15:00.000Z | 15 นาที   | ใน 15 นาที         | 0 ชั่วโมง                      |
| 2000-01-01T00:01:00.000Z | 1 นาที    | ใน 1 นาที          | 0 ชั่วโมง                      |
| 2000-01-01T00:00:25.000Z | 25 วินาที | ใน 25 วินาที       | 0 ชั่วโมง                      |
| 2000-01-01T00:00:15.000Z | 15 วินาที | ใน 15 วินาที       | 0 ชั่วโมง                      |
| 2000-01-01T00:00:05.000Z | 5 วินาที  | ใน 5 วินาที        | 0 ชั่วโมง                      |
| 2000-01-01T00:00:00.000Z | 0 วินาที  | 0 วินาทีที่ผ่านมา  | 0 ชั่วโมง                      |
| 1999-12-31T23:59:55.000Z | 5 วินาที  | 5 วินาทีที่ผ่านมา  | 0 ชั่วโมง                      |
| 1999-12-31T23:59:45.000Z | 15 วินาที | 15 วินาทีที่ผ่านมา | 0 ชั่วโมง                      |
| 1999-12-31T23:59:35.000Z | 25 วินาที | 25 วินาทีที่ผ่านมา | 0 ชั่วโมง                      |
| 1999-12-31T23:59:00.000Z | 1 นาที    | 1 นาทีที่ผ่านมา    | 0 ชั่วโมง                      |
| 1999-12-31T23:45:00.000Z | 15 นาที   | 15 นาทีที่ผ่านมา   | 0 ชั่วโมง                      |
| 1999-12-31T23:30:00.000Z | 30 นาที   | 30 นาทีที่ผ่านมา   | 1 ชั่วโมง                      |
| 1999-12-31T23:15:00.000Z | 45 นาที   | 45 นาทีที่ผ่านมา   | 1 ชั่วโมง                      |
| 1999-12-31T23:00:00.000Z | 1 ชั่วโมง | 1 ชั่วโมงที่ผ่านมา | 1 ชั่วโมง                      |
| 1999-12-31T18:00:00.000Z | 6 ชั่วโมง | 6 ชั่วโมงที่ผ่านมา | 6 ชั่วโมง                      |
| 1999-12-30T00:00:00.000Z | 2 วัน     | 2 วันที่ผ่านมา     | 48 ชั่วโมง                     |
| 1999-12-15T00:00:00.000Z | 17 วัน    | 17 วันที่ผ่านมา    | 408 ชั่วโมง                    |
| 1999-12-01T00:00:00.000Z | 1 เดือน   | 1 เดือนที่ผ่านมา   | 744 ชั่วโมง                    |
| 1999-11-01T00:00:00.000Z | 2 เดือน   | 2 เดือนที่ผ่านมา   | 1464 ชั่วโมง                   |
| 1999-06-01T00:00:00.000Z | 7 เดือน   | 7 เดือนที่ผ่านมา   | 5136 ชั่วโมง                   |
| 1999-01-01T00:00:00.000Z | 1 ปี      | 1 ปีที่ผ่านมา      | 8760 ชั่วโมง                   |
| 1998-12-01T00:00:00.000Z | 1 ปี      | 1 ปีที่ผ่านมา      | 9504 ชั่วโมง                   |
| 1998-06-01T00:00:00.000Z | 2 ปี      | 2 ปีที่ผ่านมา      | 13896 ชั่วโมง                  |
| 1998-01-01T00:00:00.000Z | 2 ปี      | 2 ปีที่ผ่านมา      | 17520 ชั่วโมง                  |
| 1997-01-01T00:00:00.000Z | 3 ปี      | 3 ปีที่ผ่านมา      | 26280 ชั่วโมง                  |
| 1996-01-01T00:00:00.000Z | 4 ปี      | 4 ปีที่ผ่านมา      | 35064 ชั่วโมง                  |
| 1995-01-01T00:00:00.000Z | 5 ปี      | 5 ปีที่ผ่านมา      | 43824 ชั่วโมง                  |
| 1994-01-01T00:00:00.000Z | 6 ปี      | 6 ปีที่ผ่านมา      | 52584 ชั่วโมง                  |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                    |
| ------------------------ | ------------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000                |
| 2000-01-05T00:00:00.000Z | พุธ เวลา 0:00 น.          |
| 2000-01-02T00:00:00.000Z | พรุ่งนี้เวลา 0:00 น.      |
| 2000-01-01T00:00:00.000Z | วันนี้เวลา 0:00 น.        |
| 1999-12-31T00:00:00.000Z | เมื่อวานนี้เวลา 0:00 น.   |
| 1999-12-27T00:00:00.000Z | จันทร์ที่แล้วเวลา 0:00 น. |
| 1999-12-21T00:00:00.000Z | 21/12/1999                |

## `formatDuration`

| Duration      | Result    |
| ------------- | --------- |
| {"years":0}   | 0 ปี      |
| {"years":1}   | 1 ปี      |
| {"years":2}   | 2 ปี      |
| {"months":0}  | 0 เดือน   |
| {"months":1}  | 1 เดือน   |
| {"months":2}  | 2 เดือน   |
| {"weeks":0}   | 0 สัปดาห์ |
| {"weeks":1}   | 1 สัปดาห์ |
| {"weeks":2}   | 2 สัปดาห์ |
| {"days":0}    | 0 วัน     |
| {"days":1}    | 1 วัน     |
| {"days":2}    | 2 วัน     |
| {"hours":0}   | 0 ชั่วโมง |
| {"hours":1}   | 1 ชั่วโมง |
| {"hours":2}   | 2 ชั่วโมง |
| {"minutes":0} | 0 นาที    |
| {"minutes":1} | 1 นาที    |
| {"minutes":2} | 2 นาที    |
| {"seconds":0} | 0 วินาที  |
| {"seconds":1} | 1 วินาที  |
| {"seconds":2} | 2 วินาที  |
