# Swedish (sv) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                     | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | --------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987:e                                              | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5:e                                                 | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987:e                                              | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4:e                                                 | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1:a                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2:a                                                 | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | Q1                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                  | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1:a kvartalet                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2:a kvartalet                                       | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                   | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1:a                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2:a                                                 | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | Q1                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                  | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1:a kvartalet                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2:a kvartalet                                       | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1:a                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2:a                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3:e                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4:e                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5:e                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6:e                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7:e                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8:e                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9:e                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10:e                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11:e                                                | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12:e                                                | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | jan.                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | feb.                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | mars                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | apr.                                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | maj                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | juni                                                | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juli                                                | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | aug.                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | sep.                                                | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | okt.                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | nov.                                                | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | dec.                                                | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | januari                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | februari                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | mars                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | april                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | maj                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | juni                                                | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juli                                                | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | augusti                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | september                                           | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | oktober                                             | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | november                                            | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | december                                            | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | J                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | F                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | M                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | A                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | J                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | A                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | S                                                   | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | O                                                   | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | N                                                   | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | D                                                   | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1:a                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2:a                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3:e                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4:e                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5:e                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6:e                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7:e                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8:e                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9:e                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10:e                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11:e                                                | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12:e                                                | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | jan.                                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | feb.                                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | mars                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | apr.                                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | maj                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | juni                                                | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juli                                                | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | aug.                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | sep.                                                | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | okt.                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | nov.                                                | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | dec.                                                | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | januari                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | februari                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | mars                                                | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | april                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | maj                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | juni                                                | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juli                                                | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | augusti                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | september                                           | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | oktober                                             | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | november                                            | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | december                                            | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | J                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | F                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | M                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | A                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                                   | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | J                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | A                                                   | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | S                                                   | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | O                                                   | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | N                                                   | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | D                                                   | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1:a                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48:e                                                | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1:a                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48:e                                                | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1:a                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11:e                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28:e                                                | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1:a februari                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11:e februari                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28:e februari                                       | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42:a                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365:e                                               | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | mån                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | mån                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | mån                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | måndag                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fredag                                              | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | M                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | F                                                   | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | må                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fr                                                  | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1:a                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5:e                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | mån                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | måndag                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fredag                                              | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | M                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | F                                                   | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | må                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fr                                                  | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1:a                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5:e                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | mån                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | måndag                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fredag                                              | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | M                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | F                                                   | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | må                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fr                                                  | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1:a                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5:e                                                 | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | mån                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fre                                                 | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | måndag                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fredag                                              | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | M                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | F                                                   | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | må                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fr                                                  | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | em                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | fm                                                  | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | på morg.                                            | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | på efterm.                                          | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | på kvällen                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | på natten                                           | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | på morg.                                            | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | på efterm.                                          | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | på kvällen                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | på natten                                           | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | på morg.                                            | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | på efterm.                                          | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | på kvällen                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | på natten                                           | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | på morgonen                                         | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | på eftermiddagen                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | på kvällen                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | på natten                                           | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | på morg.                                            | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | på efterm.                                          | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | på kvällen                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | på natten                                           | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11:e                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11:e                                                | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11:e                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23:e                                                | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11:e                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11:e                                                | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11:e                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23:e                                                | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1:a                                                 | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55:e                                                | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1:a                                                 | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55:e                                                | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 1987-01-11                                          | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987-02-11                                          | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987-03-11                                          | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987-04-11                                          | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453-05-29                                          | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987-06-11                                          | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987-07-11                                          | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987-08-11                                          | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987-09-11                                          | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987-10-11                                          | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987-11-11                                          | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987-12-11                                          | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11 jan. 1987                                        | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 feb. 1987                                        | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 mars 1987                                        | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 apr. 1987                                        | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 maj 1453                                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 juni 1987                                        | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 juli 1987                                        | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 aug. 1987                                        | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 sep. 1987                                        | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 okt. 1987                                        | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 nov. 1987                                        | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 dec. 1987                                        | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11 januari 1987                                     | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 februari 1987                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 mars 1987                                        | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 april 1987                                       | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 maj 1453                                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 juni 1987                                        | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 juli 1987                                        | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 augusti 1987                                     | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 september 1987                                   | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 oktober 1987                                     | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 november 1987                                    | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 december 1987                                    | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | söndag 11 januari 1987                              | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | onsdag 11 februari 1987                             | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | onsdag 11 mars 1987                                 | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | lördag 11 april 1987                                | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | söndag 29 maj 1453                                  | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | torsdag 11 juni 1987                                | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | lördag 11 juli 1987                                 | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | tisdag 11 augusti 1987                              | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | fredag 11 september 1987                            | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | söndag 11 oktober 1987                              | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | onsdag 11 november 1987                             | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | fredag 11 december 1987                             | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                               | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                               | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                               | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                               | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                               | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                               | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                               | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                               | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                               | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                               | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                               | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                               | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                            | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                            | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                            | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                            | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                            | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                            | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                            | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                            | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                            | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                            | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                            | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                            | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                      | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | kl. 23:59:59 GMT+00:00                              | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                              | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 1987-01-11 12:13                                    | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987-02-11 12:13                                    | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987-03-11 12:13                                    | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987-04-11 12:13                                    | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453-05-29 23:59                                    | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987-06-11 12:13                                    | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987-07-11 12:13                                    | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987-08-11 12:13                                    | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987-09-11 12:13                                    | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987-10-11 12:13                                    | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987-11-11 12:13                                    | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987-12-11 12:13                                    | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11 jan. 1987 12:13:14                               | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 feb. 1987 12:13:14                               | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 mars 1987 12:13:14                               | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 apr. 1987 12:13:14                               | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 maj 1453 23:59:59                                | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 juni 1987 12:13:14                               | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 juli 1987 12:13:14                               | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 aug. 1987 12:13:14                               | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 sep. 1987 12:13:14                               | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 okt. 1987 12:13:14                               | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 nov. 1987 12:13:14                               | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 dec. 1987 12:13:14                               | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11 januari 1987 kl. 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 februari 1987 kl. 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 mars 1987 kl. 12:13:14 GMT+0                     | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 april 1987 kl. 12:13:14 GMT+0                    | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 maj 1453 kl. 23:59:59 GMT+0                      | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 juni 1987 kl. 12:13:14 GMT+0                     | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 juli 1987 kl. 12:13:14 GMT+0                     | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 augusti 1987 kl. 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 september 1987 kl. 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 oktober 1987 kl. 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 november 1987 kl. 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 december 1987 kl. 12:13:14 GMT+0                 | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | söndag 11 januari 1987 kl. kl. 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | onsdag 11 februari 1987 kl. kl. 12:13:14 GMT+00:00  | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | onsdag 11 mars 1987 kl. kl. 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | lördag 11 april 1987 kl. kl. 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | söndag 29 maj 1453 kl. kl. 23:59:59 GMT+00:00       | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | torsdag 11 juni 1987 kl. kl. 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | lördag 11 juli 1987 kl. kl. 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | tisdag 11 augusti 1987 kl. kl. 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | fredag 11 september 1987 kl. kl. 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | söndag 11 oktober 1987 kl. kl. 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | onsdag 11 november 1987 kl. kl. 12:13:14 GMT+00:00  | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | fredag 11 december 1987 kl. kl. 12:13:14 GMT+00:00  | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result             | `includeSeconds: true` | `addSuffix: true`        |
| ------------------------ | ------------------ | ---------------------- | ------------------------ |
| 2006-01-01T00:00:00.000Z | ungefär sex år     | ungefär sex år         | om ungefär sex år        |
| 2005-01-01T00:00:00.000Z | ungefär fem år     | ungefär fem år         | om ungefär fem år        |
| 2004-01-01T00:00:00.000Z | ungefär fyra år    | ungefär fyra år        | om ungefär fyra år       |
| 2003-01-01T00:00:00.000Z | ungefär tre år     | ungefär tre år         | om ungefär tre år        |
| 2002-01-01T00:00:00.000Z | ungefär två år     | ungefär två år         | om ungefär två år        |
| 2001-06-01T00:00:00.000Z | över ett år        | över ett år            | om över ett år           |
| 2001-02-01T00:00:00.000Z | ungefär ett år     | ungefär ett år         | om ungefär ett år        |
| 2001-01-01T00:00:00.000Z | ungefär ett år     | ungefär ett år         | om ungefär ett år        |
| 2000-06-01T00:00:00.000Z | fem månader        | fem månader            | om fem månader           |
| 2000-03-01T00:00:00.000Z | två månader        | två månader            | om två månader           |
| 2000-02-01T00:00:00.000Z | ungefär en månad   | ungefär en månad       | om ungefär en månad      |
| 2000-01-15T00:00:00.000Z | 14 dagar           | 14 dagar               | om 14 dagar              |
| 2000-01-02T00:00:00.000Z | en dag             | en dag                 | om en dag                |
| 2000-01-01T06:00:00.000Z | ungefär sex timmar | ungefär sex timmar     | om ungefär sex timmar    |
| 2000-01-01T01:00:00.000Z | ungefär en timme   | ungefär en timme       | om ungefär en timme      |
| 2000-01-01T00:45:00.000Z | ungefär en timme   | ungefär en timme       | om ungefär en timme      |
| 2000-01-01T00:30:00.000Z | 30 minuter         | 30 minuter             | om 30 minuter            |
| 2000-01-01T00:15:00.000Z | 15 minuter         | 15 minuter             | om 15 minuter            |
| 2000-01-01T00:01:00.000Z | en minut           | en minut               | om en minut              |
| 2000-01-01T00:00:25.000Z | mindre än en minut | en halv minut          | om mindre än en minut    |
| 2000-01-01T00:00:15.000Z | mindre än en minut | mindre än 20 sekunder  | om mindre än en minut    |
| 2000-01-01T00:00:05.000Z | mindre än en minut | mindre än tio sekunder | om mindre än en minut    |
| 2000-01-01T00:00:00.000Z | mindre än en minut | mindre än fem sekunder | mindre än en minut sedan |
| 1999-12-31T23:59:55.000Z | mindre än en minut | mindre än tio sekunder | mindre än en minut sedan |
| 1999-12-31T23:59:45.000Z | mindre än en minut | mindre än 20 sekunder  | mindre än en minut sedan |
| 1999-12-31T23:59:35.000Z | mindre än en minut | en halv minut          | mindre än en minut sedan |
| 1999-12-31T23:59:00.000Z | en minut           | en minut               | en minut sedan           |
| 1999-12-31T23:45:00.000Z | 15 minuter         | 15 minuter             | 15 minuter sedan         |
| 1999-12-31T23:30:00.000Z | 30 minuter         | 30 minuter             | 30 minuter sedan         |
| 1999-12-31T23:15:00.000Z | ungefär en timme   | ungefär en timme       | ungefär en timme sedan   |
| 1999-12-31T23:00:00.000Z | ungefär en timme   | ungefär en timme       | ungefär en timme sedan   |
| 1999-12-31T18:00:00.000Z | ungefär sex timmar | ungefär sex timmar     | ungefär sex timmar sedan |
| 1999-12-30T00:00:00.000Z | två dagar          | två dagar              | två dagar sedan          |
| 1999-12-15T00:00:00.000Z | 17 dagar           | 17 dagar               | 17 dagar sedan           |
| 1999-12-01T00:00:00.000Z | ungefär en månad   | ungefär en månad       | ungefär en månad sedan   |
| 1999-11-01T00:00:00.000Z | två månader        | två månader            | två månader sedan        |
| 1999-06-01T00:00:00.000Z | sju månader        | sju månader            | sju månader sedan        |
| 1999-01-01T00:00:00.000Z | ungefär ett år     | ungefär ett år         | ungefär ett år sedan     |
| 1998-12-01T00:00:00.000Z | ungefär ett år     | ungefär ett år         | ungefär ett år sedan     |
| 1998-06-01T00:00:00.000Z | över ett år        | över ett år            | över ett år sedan        |
| 1998-01-01T00:00:00.000Z | ungefär två år     | ungefär två år         | ungefär två år sedan     |
| 1997-01-01T00:00:00.000Z | ungefär tre år     | ungefär tre år         | ungefär tre år sedan     |
| 1996-01-01T00:00:00.000Z | ungefär fyra år    | ungefär fyra år        | ungefär fyra år sedan    |
| 1995-01-01T00:00:00.000Z | ungefär fem år     | ungefär fem år         | ungefär fem år sedan     |
| 1994-01-01T00:00:00.000Z | ungefär sex år     | ungefär sex år         | ungefär sex år sedan     |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result        | `addSuffix: true`   | With forced unit (i.e. `hour`) |
| ------------------------ | ------------- | ------------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | sex år        | om sex år           | 52608 timmar                   |
| 2005-01-01T00:00:00.000Z | fem år        | om fem år           | 43848 timmar                   |
| 2004-01-01T00:00:00.000Z | fyra år       | om fyra år          | 35064 timmar                   |
| 2003-01-01T00:00:00.000Z | tre år        | om tre år           | 26304 timmar                   |
| 2002-01-01T00:00:00.000Z | två år        | om två år           | 17544 timmar                   |
| 2001-06-01T00:00:00.000Z | ett år        | om ett år           | 12408 timmar                   |
| 2001-02-01T00:00:00.000Z | ett år        | om ett år           | 9528 timmar                    |
| 2001-01-01T00:00:00.000Z | ett år        | om ett år           | 8784 timmar                    |
| 2000-06-01T00:00:00.000Z | fem månader   | om fem månader      | 3648 timmar                    |
| 2000-03-01T00:00:00.000Z | två månader   | om två månader      | 1440 timmar                    |
| 2000-02-01T00:00:00.000Z | en månad      | om en månad         | 744 timmar                     |
| 2000-01-15T00:00:00.000Z | 14 dagar      | om 14 dagar         | 336 timmar                     |
| 2000-01-02T00:00:00.000Z | en dag        | om en dag           | 24 timmar                      |
| 2000-01-01T06:00:00.000Z | sex timmar    | om sex timmar       | sex timmar                     |
| 2000-01-01T01:00:00.000Z | en timme      | om en timme         | en timme                       |
| 2000-01-01T00:45:00.000Z | 45 minuter    | om 45 minuter       | en timme                       |
| 2000-01-01T00:30:00.000Z | 30 minuter    | om 30 minuter       | en timme                       |
| 2000-01-01T00:15:00.000Z | 15 minuter    | om 15 minuter       | noll timmar                    |
| 2000-01-01T00:01:00.000Z | en minut      | om en minut         | noll timmar                    |
| 2000-01-01T00:00:25.000Z | 25 sekunder   | om 25 sekunder      | noll timmar                    |
| 2000-01-01T00:00:15.000Z | 15 sekunder   | om 15 sekunder      | noll timmar                    |
| 2000-01-01T00:00:05.000Z | fem sekunder  | om fem sekunder     | noll timmar                    |
| 2000-01-01T00:00:00.000Z | noll sekunder | noll sekunder sedan | noll timmar                    |
| 1999-12-31T23:59:55.000Z | fem sekunder  | fem sekunder sedan  | noll timmar                    |
| 1999-12-31T23:59:45.000Z | 15 sekunder   | 15 sekunder sedan   | noll timmar                    |
| 1999-12-31T23:59:35.000Z | 25 sekunder   | 25 sekunder sedan   | noll timmar                    |
| 1999-12-31T23:59:00.000Z | en minut      | en minut sedan      | noll timmar                    |
| 1999-12-31T23:45:00.000Z | 15 minuter    | 15 minuter sedan    | noll timmar                    |
| 1999-12-31T23:30:00.000Z | 30 minuter    | 30 minuter sedan    | en timme                       |
| 1999-12-31T23:15:00.000Z | 45 minuter    | 45 minuter sedan    | en timme                       |
| 1999-12-31T23:00:00.000Z | en timme      | en timme sedan      | en timme                       |
| 1999-12-31T18:00:00.000Z | sex timmar    | sex timmar sedan    | sex timmar                     |
| 1999-12-30T00:00:00.000Z | två dagar     | två dagar sedan     | 48 timmar                      |
| 1999-12-15T00:00:00.000Z | 17 dagar      | 17 dagar sedan      | 408 timmar                     |
| 1999-12-01T00:00:00.000Z | en månad      | en månad sedan      | 744 timmar                     |
| 1999-11-01T00:00:00.000Z | två månader   | två månader sedan   | 1464 timmar                    |
| 1999-06-01T00:00:00.000Z | sju månader   | sju månader sedan   | 5136 timmar                    |
| 1999-01-01T00:00:00.000Z | ett år        | ett år sedan        | 8760 timmar                    |
| 1998-12-01T00:00:00.000Z | ett år        | ett år sedan        | 9504 timmar                    |
| 1998-06-01T00:00:00.000Z | två år        | två år sedan        | 13896 timmar                   |
| 1998-01-01T00:00:00.000Z | två år        | två år sedan        | 17520 timmar                   |
| 1997-01-01T00:00:00.000Z | tre år        | tre år sedan        | 26280 timmar                   |
| 1996-01-01T00:00:00.000Z | fyra år       | fyra år sedan       | 35064 timmar                   |
| 1995-01-01T00:00:00.000Z | fem år        | fem år sedan        | 43824 timmar                   |
| 1994-01-01T00:00:00.000Z | sex år        | sex år sedan        | 52584 timmar                   |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result              |
| ------------------------ | ------------------- |
| 2000-01-10T00:00:00.000Z | 2000-01-10          |
| 2000-01-05T00:00:00.000Z | onsdag kl. 00:00    |
| 2000-01-02T00:00:00.000Z | imorgon kl. 00:00   |
| 2000-01-01T00:00:00.000Z | idag kl. 00:00      |
| 1999-12-31T00:00:00.000Z | igår kl. 00:00      |
| 1999-12-27T00:00:00.000Z | i måndags kl. 00:00 |
| 1999-12-21T00:00:00.000Z | 1999-12-21          |

## `formatDuration`

| Duration      | Result        |
| ------------- | ------------- |
| {"years":0}   | noll år       |
| {"years":1}   | ett år        |
| {"years":2}   | två år        |
| {"months":0}  | noll månader  |
| {"months":1}  | en månad      |
| {"months":2}  | två månader   |
| {"weeks":0}   | noll veckor   |
| {"weeks":1}   | en vecka      |
| {"weeks":2}   | två veckor    |
| {"days":0}    | noll dagar    |
| {"days":1}    | en dag        |
| {"days":2}    | två dagar     |
| {"hours":0}   | noll timmar   |
| {"hours":1}   | en timme      |
| {"hours":2}   | två timmar    |
| {"minutes":0} | noll minuter  |
| {"minutes":1} | en minut      |
| {"minutes":2} | två minuter   |
| {"seconds":0} | noll sekunder |
| {"seconds":1} | en sekund     |
| {"seconds":2} | två sekunder  |
