# Northern Sámi (se) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                                    | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------------------------------ | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987.                                                              | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5.                                                                 | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987.                                                              | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4.                                                                 | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1.                                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                                                 | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | Q1                                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                                 | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1. kvartála                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. kvartála                                                        | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                                  | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1.                                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                                                 | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | Q1                                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                                                 | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1. kvartála                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. kvartála                                                        | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1.                                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2.                                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3.                                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4.                                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5.                                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6.                                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8.                                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9.                                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10.                                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11.                                                                | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12.                                                                | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | ođđa                                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | guov                                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | njuk                                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | cuo                                                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | mies                                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | geas                                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | suoi                                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | borg                                                               | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | čakč                                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | golg                                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | skáb                                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | juov                                                               | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | ođđajagemánnu                                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | guovvamánnu                                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | njukčamánnu                                                        | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | cuoŋománnu                                                         | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | miessemánnu                                                        | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | geassemánnu                                                        | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | suoidnemánnu                                                       | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | borgemánnu                                                         | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | čakčamánnu                                                         | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | golggotmánnu                                                       | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | skábmamánnu                                                        | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | juovlamánnu                                                        | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | O                                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | G                                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | N                                                                  | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | C                                                                  | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                                                  | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | G                                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | S                                                                  | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | B                                                                  | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Č                                                                  | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | G                                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | S                                                                  | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | J                                                                  | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1.                                                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2.                                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3.                                                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4.                                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5.                                                                 | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6.                                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                                                 | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8.                                                                 | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9.                                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10.                                                                | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11.                                                                | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12.                                                                | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | ođđa                                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | guov                                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | njuk                                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | cuo                                                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | mies                                                               | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | geas                                                               | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | suoi                                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | borg                                                               | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | čakč                                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | golg                                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | skáb                                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | juov                                                               | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | ođđajagemánnu                                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | guovvamánnu                                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | njukčamánnu                                                        | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | cuoŋománnu                                                         | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | miessemánnu                                                        | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | geassemánnu                                                        | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | suoidnemánnu                                                       | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | borgemánnu                                                         | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | čakčamánnu                                                         | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | golggotmánnu                                                       | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | skábmamánnu                                                        | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | juovlamánnu                                                        | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | O                                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | G                                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | N                                                                  | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | C                                                                  | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                                                  | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | G                                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | S                                                                  | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | B                                                                  | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Č                                                                  | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | G                                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | S                                                                  | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | J                                                                  | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1.                                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                                                | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1.                                                                 | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                                                | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1.                                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11.                                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28.                                                                | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1. guovvamánnu                                                     | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11. guovvamánnu                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28. guovvamánnu                                                    | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42.                                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365.                                                               | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | vuos                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | bear                                                               | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | vuos                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | bear                                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | vuos                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | bear                                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | vuossárga                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | bearjadat                                                          | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | V                                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | B                                                                  | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | vuos                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | bear                                                               | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1.                                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | vuos                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | bear                                                               | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | vuossárga                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | bearjadat                                                          | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | V                                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | B                                                                  | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | vuos                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | bear                                                               | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1.                                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | vuos                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | bear                                                               | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | vuossárga                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | bearjadat                                                          | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | V                                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | B                                                                  | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | vuos                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | bear                                                               | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1.                                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                                 | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | vuos                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | bear                                                               | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | vuossárga                                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | bearjadat                                                          | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | V                                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | B                                                                  | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | vuos                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | bear                                                               | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | a.m.                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                               | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | a.m.                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                               | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | a.m.                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                               | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | a.m.                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                               | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | a                                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                                  | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | a.m.                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                               | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | a.m.                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                               | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | a.m.                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                               | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | a.m.                                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                               | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | a                                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                                  | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | iđđes                                                              | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | maŋŋel gaskabea.                                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | eahkes                                                             | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ihkku                                                              | Invalid Date             |
|                                 | BB           | 2019-02-11T11:13:14.015Z | iđđes                                                              | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | maŋŋel gaskabea.                                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | eahkes                                                             | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ihkku                                                              | Invalid Date             |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | iđđes                                                              | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | maŋŋel gaskabea.                                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | eahkes                                                             | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ihkku                                                              | Invalid Date             |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | iđđes                                                              | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | maŋŋel gaskabeaivvi                                                | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | eahkes                                                             | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ihkku                                                              | Invalid Date             |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | iđđes                                                              | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | maŋŋel gaska.                                                      | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | eahkes                                                             | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ihkku                                                              | Invalid Date             |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11.                                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                                                | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11.                                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                                                | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11.                                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                                                | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11.                                                                | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                                                | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1.                                                                 | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55.                                                                | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1.                                                                 | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55.                                                                | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11.01.1987                                                         | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11.02.1987                                                         | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11.03.1987                                                         | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11.04.1987                                                         | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453                                                         | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11.06.1987                                                         | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11.07.1987                                                         | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11.08.1987                                                         | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11.09.1987                                                         | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11.10.1987                                                         | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11.11.1987                                                         | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11.12.1987                                                         | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | ođđa 11. b. 1987                                                   | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | guov 11. b. 1987                                                   | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | njuk 11. b. 1987                                                   | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | cuo 11. b. 1987                                                    | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | mies 29. b. 1453                                                   | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | geas 11. b. 1987                                                   | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | suoi 11. b. 1987                                                   | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | borg 11. b. 1987                                                   | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | čakč 11. b. 1987                                                   | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | golg 11. b. 1987                                                   | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | skáb 11. b. 1987                                                   | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | juov 11. b. 1987                                                   | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | ođđajagemánnu 11. b. 1987                                          | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | guovvamánnu 11. b. 1987                                            | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | njukčamánnu 11. b. 1987                                            | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | cuoŋománnu 11. b. 1987                                             | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | miessemánnu 29. b. 1453                                            | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | geassemánnu 11. b. 1987                                            | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | suoidnemánnu 11. b. 1987                                           | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | borgemánnu 11. b. 1987                                             | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | čakčamánnu 11. b. 1987                                             | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | golggotmánnu 11. b. 1987                                           | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | skábmamánnu 11. b. 1987                                            | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | juovlamánnu 11. b. 1987                                            | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | sotnabeaivi ođđajagemánnu 11. b. 1987                              | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | gaskavahkku guovvamánnu 11. b. 1987                                | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | gaskavahkku njukčamánnu 11. b. 1987                                | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | lávvardat cuoŋománnu 11. b. 1987                                   | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | sotnabeaivi miessemánnu 29. b. 1453                                | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | duorastat geassemánnu 11. b. 1987                                  | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | lávvardat suoidnemánnu 11. b. 1987                                 | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | maŋŋebárga borgemánnu 11. b. 1987                                  | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | bearjadat čakčamánnu 11. b. 1987                                   | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | sotnabeaivi golggotmánnu 11. b. 1987                               | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | gaskavahkku skábmamánnu 11. b. 1987                                | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | bearjadat juovlamánnu 11. b. 1987                                  | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                                              | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                                              | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                                              | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                                              | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                                              | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                                              | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                                              | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                                              | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                                              | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                                              | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                                              | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                                              | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                                           | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                                           | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                                           | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                                           | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                                           | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                                           | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                                           | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                                           | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                                           | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                                           | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                                           | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                                           | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                                                     | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                                     | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                                                     | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                                                     | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                                     | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                                                     | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                                                     | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                                                     | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                                                     | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                                                     | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                                                     | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                                                     | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | dii. 12:13:14 GMT+00:00                                            | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | dii. 12:13:14 GMT+00:00                                            | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | dii. 12:13:14 GMT+00:00                                            | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | dii. 12:13:14 GMT+00:00                                            | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | dii. 23:59:59 GMT+00:00                                            | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | dii. 12:13:14 GMT+00:00                                            | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | dii. 12:13:14 GMT+00:00                                            | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | dii. 12:13:14 GMT+00:00                                            | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | dii. 12:13:14 GMT+00:00                                            | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | dii. 12:13:14 GMT+00:00                                            | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | dii. 12:13:14 GMT+00:00                                            | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | dii. 12:13:14 GMT+00:00                                            | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11.01.1987 12:13                                                   | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11.02.1987 12:13                                                   | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11.03.1987 12:13                                                   | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11.04.1987 12:13                                                   | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453 23:59                                                   | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11.06.1987 12:13                                                   | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11.07.1987 12:13                                                   | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11.08.1987 12:13                                                   | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11.09.1987 12:13                                                   | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11.10.1987 12:13                                                   | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11.11.1987 12:13                                                   | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11.12.1987 12:13                                                   | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | ođđa 11. b. 1987 12:13:14                                          | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | guov 11. b. 1987 12:13:14                                          | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | njuk 11. b. 1987 12:13:14                                          | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | cuo 11. b. 1987 12:13:14                                           | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | mies 29. b. 1453 23:59:59                                          | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | geas 11. b. 1987 12:13:14                                          | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | suoi 11. b. 1987 12:13:14                                          | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | borg 11. b. 1987 12:13:14                                          | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | čakč 11. b. 1987 12:13:14                                          | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | golg 11. b. 1987 12:13:14                                          | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | skáb 11. b. 1987 12:13:14                                          | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | juov 11. b. 1987 12:13:14                                          | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | ođđajagemánnu 11. b. 1987 dii. 12:13:14 GMT+0                      | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | guovvamánnu 11. b. 1987 dii. 12:13:14 GMT+0                        | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | njukčamánnu 11. b. 1987 dii. 12:13:14 GMT+0                        | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | cuoŋománnu 11. b. 1987 dii. 12:13:14 GMT+0                         | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | miessemánnu 29. b. 1453 dii. 23:59:59 GMT+0                        | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | geassemánnu 11. b. 1987 dii. 12:13:14 GMT+0                        | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | suoidnemánnu 11. b. 1987 dii. 12:13:14 GMT+0                       | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | borgemánnu 11. b. 1987 dii. 12:13:14 GMT+0                         | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | čakčamánnu 11. b. 1987 dii. 12:13:14 GMT+0                         | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | golggotmánnu 11. b. 1987 dii. 12:13:14 GMT+0                       | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | skábmamánnu 11. b. 1987 dii. 12:13:14 GMT+0                        | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | juovlamánnu 11. b. 1987 dii. 12:13:14 GMT+0                        | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | sotnabeaivi ođđajagemánnu 11. b. 1987 dii. dii. 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | gaskavahkku guovvamánnu 11. b. 1987 dii. dii. 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | gaskavahkku njukčamánnu 11. b. 1987 dii. dii. 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | lávvardat cuoŋománnu 11. b. 1987 dii. dii. 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | sotnabeaivi miessemánnu 29. b. 1453 dii. dii. 23:59:59 GMT+00:00   | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | duorastat geassemánnu 11. b. 1987 dii. dii. 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | lávvardat suoidnemánnu 11. b. 1987 dii. dii. 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | maŋŋebárga borgemánnu 11. b. 1987 dii. dii. 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | bearjadat čakčamánnu 11. b. 1987 dii. dii. 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | sotnabeaivi golggotmánnu 11. b. 1987 dii. dii. 12:13:14 GMT+00:00  | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | gaskavahkku skábmamánnu 11. b. 1987 dii. dii. 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | bearjadat juovlamánnu 11. b. 1987 dii. dii. 12:13:14 GMT+00:00     | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result                  | `includeSeconds: true` | `addSuffix: true`               |
| ------------------------ | ----------------------- | ---------------------- | ------------------------------- |
| 2006-01-01T00:00:00.000Z | sullii 6 jagi           | sullii 6 jagi          | geahčen sullii 6 jagi           |
| 2005-01-01T00:00:00.000Z | sullii 5 jagi           | sullii 5 jagi          | geahčen sullii 5 jagi           |
| 2004-01-01T00:00:00.000Z | sullii 4 jagi           | sullii 4 jagi          | geahčen sullii 4 jagi           |
| 2003-01-01T00:00:00.000Z | sullii 3 jagi           | sullii 3 jagi          | geahčen sullii 3 jagi           |
| 2002-01-01T00:00:00.000Z | sullii 2 jagi           | sullii 2 jagi          | geahčen sullii 2 jagi           |
| 2001-06-01T00:00:00.000Z | guhkit go jagi          | guhkit go jagi         | geahčen guhkit go jagi          |
| 2001-02-01T00:00:00.000Z | sullii ovtta jagi       | sullii ovtta jagi      | geahčen sullii ovtta jagi       |
| 2001-01-01T00:00:00.000Z | sullii ovtta jagi       | sullii ovtta jagi      | geahčen sullii ovtta jagi       |
| 2000-06-01T00:00:00.000Z | 5 mánu                  | 5 mánu                 | geahčen 5 mánu                  |
| 2000-03-01T00:00:00.000Z | 2 mánu                  | 2 mánu                 | geahčen 2 mánu                  |
| 2000-02-01T00:00:00.000Z | sullii ovtta mánu       | sullii ovtta mánu      | geahčen sullii ovtta mánu       |
| 2000-01-15T00:00:00.000Z | 14 beaivvi              | 14 beaivvi             | geahčen 14 beaivvi              |
| 2000-01-02T00:00:00.000Z | beaivvi                 | beaivvi                | geahčen beaivvi                 |
| 2000-01-01T06:00:00.000Z | sullii 6 diimmu         | sullii 6 diimmu        | geahčen sullii 6 diimmu         |
| 2000-01-01T01:00:00.000Z | sullii ovtta diimmu     | sullii ovtta diimmu    | geahčen sullii ovtta diimmu     |
| 2000-01-01T00:45:00.000Z | sullii ovtta diimmu     | sullii ovtta diimmu    | geahčen sullii ovtta diimmu     |
| 2000-01-01T00:30:00.000Z | 30 minuhta              | 30 minuhta             | geahčen 30 minuhta              |
| 2000-01-01T00:15:00.000Z | 15 minuhta              | 15 minuhta             | geahčen 15 minuhta              |
| 2000-01-01T00:01:00.000Z | minuhta                 | minuhta                | geahčen minuhta                 |
| 2000-01-01T00:00:25.000Z | unnit go bealle minuhta | bealle minuhta         | geahčen unnit go bealle minuhta |
| 2000-01-01T00:00:15.000Z | unnit go bealle minuhta | unnit go 20 sekundda   | geahčen unnit go bealle minuhta |
| 2000-01-01T00:00:05.000Z | unnit go bealle minuhta | unnit go 10 sekundda   | geahčen unnit go bealle minuhta |
| 2000-01-01T00:00:00.000Z | unnit go bealle minuhta | unnit go 5 sekundda    | unnit go bealle minuhta áigi    |
| 1999-12-31T23:59:55.000Z | unnit go bealle minuhta | unnit go 10 sekundda   | unnit go bealle minuhta áigi    |
| 1999-12-31T23:59:45.000Z | unnit go bealle minuhta | unnit go 20 sekundda   | unnit go bealle minuhta áigi    |
| 1999-12-31T23:59:35.000Z | unnit go bealle minuhta | bealle minuhta         | unnit go bealle minuhta áigi    |
| 1999-12-31T23:59:00.000Z | minuhta                 | minuhta                | minuhta áigi                    |
| 1999-12-31T23:45:00.000Z | 15 minuhta              | 15 minuhta             | 15 minuhta áigi                 |
| 1999-12-31T23:30:00.000Z | 30 minuhta              | 30 minuhta             | 30 minuhta áigi                 |
| 1999-12-31T23:15:00.000Z | sullii ovtta diimmu     | sullii ovtta diimmu    | sullii ovtta diimmu áigi        |
| 1999-12-31T23:00:00.000Z | sullii ovtta diimmu     | sullii ovtta diimmu    | sullii ovtta diimmu áigi        |
| 1999-12-31T18:00:00.000Z | sullii 6 diimmu         | sullii 6 diimmu        | sullii 6 diimmu áigi            |
| 1999-12-30T00:00:00.000Z | 2 beaivvi               | 2 beaivvi              | 2 beaivvi áigi                  |
| 1999-12-15T00:00:00.000Z | 17 beaivvi              | 17 beaivvi             | 17 beaivvi áigi                 |
| 1999-12-01T00:00:00.000Z | sullii ovtta mánu       | sullii ovtta mánu      | sullii ovtta mánu áigi          |
| 1999-11-01T00:00:00.000Z | 2 mánu                  | 2 mánu                 | 2 mánu áigi                     |
| 1999-06-01T00:00:00.000Z | 7 mánu                  | 7 mánu                 | 7 mánu áigi                     |
| 1999-01-01T00:00:00.000Z | sullii ovtta jagi       | sullii ovtta jagi      | sullii ovtta jagi áigi          |
| 1998-12-01T00:00:00.000Z | sullii ovtta jagi       | sullii ovtta jagi      | sullii ovtta jagi áigi          |
| 1998-06-01T00:00:00.000Z | guhkit go jagi          | guhkit go jagi         | guhkit go jagi áigi             |
| 1998-01-01T00:00:00.000Z | sullii 2 jagi           | sullii 2 jagi          | sullii 2 jagi áigi              |
| 1997-01-01T00:00:00.000Z | sullii 3 jagi           | sullii 3 jagi          | sullii 3 jagi áigi              |
| 1996-01-01T00:00:00.000Z | sullii 4 jagi           | sullii 4 jagi          | sullii 4 jagi áigi              |
| 1995-01-01T00:00:00.000Z | sullii 5 jagi           | sullii 5 jagi          | sullii 5 jagi áigi              |
| 1994-01-01T00:00:00.000Z | sullii 6 jagi           | sullii 6 jagi          | sullii 6 jagi áigi              |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result      | `addSuffix: true`   | With forced unit (i.e. `hour`) |
| ------------------------ | ----------- | ------------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 jagi      | geahčen 6 jagi      | 52608 diimmu                   |
| 2005-01-01T00:00:00.000Z | 5 jagi      | geahčen 5 jagi      | 43848 diimmu                   |
| 2004-01-01T00:00:00.000Z | 4 jagi      | geahčen 4 jagi      | 35064 diimmu                   |
| 2003-01-01T00:00:00.000Z | 3 jagi      | geahčen 3 jagi      | 26304 diimmu                   |
| 2002-01-01T00:00:00.000Z | 2 jagi      | geahčen 2 jagi      | 17544 diimmu                   |
| 2001-06-01T00:00:00.000Z | jagi        | geahčen jagi        | 12408 diimmu                   |
| 2001-02-01T00:00:00.000Z | jagi        | geahčen jagi        | 9528 diimmu                    |
| 2001-01-01T00:00:00.000Z | jagi        | geahčen jagi        | 8784 diimmu                    |
| 2000-06-01T00:00:00.000Z | 5 mánu      | geahčen 5 mánu      | 3648 diimmu                    |
| 2000-03-01T00:00:00.000Z | 2 mánu      | geahčen 2 mánu      | 1440 diimmu                    |
| 2000-02-01T00:00:00.000Z | mánu        | geahčen mánu        | 744 diimmu                     |
| 2000-01-15T00:00:00.000Z | 14 beaivvi  | geahčen 14 beaivvi  | 336 diimmu                     |
| 2000-01-02T00:00:00.000Z | beaivvi     | geahčen beaivvi     | 24 diimmu                      |
| 2000-01-01T06:00:00.000Z | 6 diimmu    | geahčen 6 diimmu    | 6 diimmu                       |
| 2000-01-01T01:00:00.000Z | diimmu      | geahčen diimmu      | diimmu                         |
| 2000-01-01T00:45:00.000Z | 45 minuhta  | geahčen 45 minuhta  | diimmu                         |
| 2000-01-01T00:30:00.000Z | 30 minuhta  | geahčen 30 minuhta  | diimmu                         |
| 2000-01-01T00:15:00.000Z | 15 minuhta  | geahčen 15 minuhta  | 0 diimmu                       |
| 2000-01-01T00:01:00.000Z | minuhta     | geahčen minuhta     | 0 diimmu                       |
| 2000-01-01T00:00:25.000Z | 25 sekundda | geahčen 25 sekundda | 0 diimmu                       |
| 2000-01-01T00:00:15.000Z | 15 sekundda | geahčen 15 sekundda | 0 diimmu                       |
| 2000-01-01T00:00:05.000Z | 5 sekundda  | geahčen 5 sekundda  | 0 diimmu                       |
| 2000-01-01T00:00:00.000Z | 0 sekundda  | 0 sekundda áigi     | 0 diimmu                       |
| 1999-12-31T23:59:55.000Z | 5 sekundda  | 5 sekundda áigi     | 0 diimmu                       |
| 1999-12-31T23:59:45.000Z | 15 sekundda | 15 sekundda áigi    | 0 diimmu                       |
| 1999-12-31T23:59:35.000Z | 25 sekundda | 25 sekundda áigi    | 0 diimmu                       |
| 1999-12-31T23:59:00.000Z | minuhta     | minuhta áigi        | 0 diimmu                       |
| 1999-12-31T23:45:00.000Z | 15 minuhta  | 15 minuhta áigi     | 0 diimmu                       |
| 1999-12-31T23:30:00.000Z | 30 minuhta  | 30 minuhta áigi     | diimmu                         |
| 1999-12-31T23:15:00.000Z | 45 minuhta  | 45 minuhta áigi     | diimmu                         |
| 1999-12-31T23:00:00.000Z | diimmu      | diimmu áigi         | diimmu                         |
| 1999-12-31T18:00:00.000Z | 6 diimmu    | 6 diimmu áigi       | 6 diimmu                       |
| 1999-12-30T00:00:00.000Z | 2 beaivvi   | 2 beaivvi áigi      | 48 diimmu                      |
| 1999-12-15T00:00:00.000Z | 17 beaivvi  | 17 beaivvi áigi     | 408 diimmu                     |
| 1999-12-01T00:00:00.000Z | mánu        | mánu áigi           | 744 diimmu                     |
| 1999-11-01T00:00:00.000Z | 2 mánu      | 2 mánu áigi         | 1464 diimmu                    |
| 1999-06-01T00:00:00.000Z | 7 mánu      | 7 mánu áigi         | 5136 diimmu                    |
| 1999-01-01T00:00:00.000Z | jagi        | jagi áigi           | 8760 diimmu                    |
| 1998-12-01T00:00:00.000Z | jagi        | jagi áigi           | 9504 diimmu                    |
| 1998-06-01T00:00:00.000Z | 2 jagi      | 2 jagi áigi         | 13896 diimmu                   |
| 1998-01-01T00:00:00.000Z | 2 jagi      | 2 jagi áigi         | 17520 diimmu                   |
| 1997-01-01T00:00:00.000Z | 3 jagi      | 3 jagi áigi         | 26280 diimmu                   |
| 1996-01-01T00:00:00.000Z | 4 jagi      | 4 jagi áigi         | 35064 diimmu                   |
| 1995-01-01T00:00:00.000Z | 5 jagi      | 5 jagi áigi         | 43824 diimmu                   |
| 1994-01-01T00:00:00.000Z | 6 jagi      | 6 jagi áigi         | 52584 diimmu                   |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                      |
| ------------------------ | --------------------------- |
| 2000-01-10T00:00:00.000Z | 10.01.2000                  |
| 2000-01-05T00:00:00.000Z | gaskavahkku dii. 00:00      |
| 2000-01-02T00:00:00.000Z | ihtin dii. 00:00            |
| 2000-01-01T00:00:00.000Z | odne dii. 00:00             |
| 1999-12-31T00:00:00.000Z | ikte dii. 00:00             |
| 1999-12-27T00:00:00.000Z | ovddit vuossárga dii. 00:00 |
| 1999-12-21T00:00:00.000Z | 21.12.1999                  |

## `formatDuration`

| Duration      | Result     |
| ------------- | ---------- |
| {"years":0}   | 0 jagi     |
| {"years":1}   | jagi       |
| {"years":2}   | 2 jagi     |
| {"months":0}  | 0 mánu     |
| {"months":1}  | mánu       |
| {"months":2}  | 2 mánu     |
| {"weeks":0}   | 0 vahku    |
| {"weeks":1}   | vahku      |
| {"weeks":2}   | 2 vahku    |
| {"days":0}    | 0 beaivvi  |
| {"days":1}    | beaivvi    |
| {"days":2}    | 2 beaivvi  |
| {"hours":0}   | 0 diimmu   |
| {"hours":1}   | diimmu     |
| {"hours":2}   | 2 diimmu   |
| {"minutes":0} | 0 minuhta  |
| {"minutes":1} | minuhta    |
| {"minutes":2} | 2 minuhta  |
| {"seconds":0} | 0 sekundda |
| {"seconds":1} | sekundda   |
| {"seconds":2} | 2 sekundda |
