# Maltese (mt) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                 | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ----------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987º                                           | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5º                                              | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987º                                           | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4º                                              | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1º                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2º                                              | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | K1                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | K2                                              | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1. kwart                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. kwart                                        | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                               | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1º                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2º                                              | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | K1                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | K2                                              | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1. kwart                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. kwart                                        | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1º                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2º                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3º                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4º                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5º                                              | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6º                                              | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7º                                              | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8º                                              | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9º                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10º                                             | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11º                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12º                                             | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | Jan                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Fra                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Mar                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | Apr                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Mej                                             | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Ġun                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Lul                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Aww                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Set                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Ott                                             | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Nov                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Diċ                                             | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | Jannar                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Frar                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Marzu                                           | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | April                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Mejju                                           | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Ġunju                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Lulju                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Awwissu                                         | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Settembru                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Ottubru                                         | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Novembru                                        | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Diċembru                                        | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | J                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | F                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | M                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | A                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Ġ                                               | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | L                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | A                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | S                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | O                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | N                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | D                                               | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1º                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2º                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3º                                              | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4º                                              | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5º                                              | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6º                                              | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7º                                              | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8º                                              | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9º                                              | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10º                                             | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11º                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12º                                             | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | Jan                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Fra                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Mar                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | Apr                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Mej                                             | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Ġun                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Lul                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Aww                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Set                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Ott                                             | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Nov                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Diċ                                             | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | Jannar                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | Frar                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | Marzu                                           | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | April                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | Mejju                                           | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Ġunju                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Lulju                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | Awwissu                                         | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | Settembru                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | Ottubru                                         | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | Novembru                                        | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | Diċembru                                        | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | J                                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | F                                               | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | M                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | A                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                               | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | Ġ                                               | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | L                                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | A                                               | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | S                                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | O                                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | N                                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | D                                               | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1º                                              | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48º                                             | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1º                                              | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48º                                             | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1º                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11º                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28º                                             | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1º Frar                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11º Frar                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28º Frar                                        | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42º                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365º                                            | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | Tne                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ġim                                             | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | Tne                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ġim                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | Tne                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ġim                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | It-Tnejn                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Il-Ġimgħa                                       | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | T                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ġ                                               | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | Tn                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ġi                                              | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1º                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5º                                              | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | Tne                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ġim                                             | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | It-Tnejn                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Il-Ġimgħa                                       | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | T                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ġ                                               | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | Tn                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ġi                                              | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1º                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5º                                              | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | Tne                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ġim                                             | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | It-Tnejn                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Il-Ġimgħa                                       | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | T                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ġ                                               | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | Tn                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ġi                                              | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1º                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5º                                              | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | Tne                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ġim                                             | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | It-Tnejn                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Il-Ġimgħa                                       | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | T                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ġ                                               | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | Tn                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Ġi                                              | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | am                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                              | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | a.m.                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                            | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | a                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                               | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                              | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | am                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                              | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | a.m.                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                            | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | a                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                               | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                               | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | filgħodu                                        | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | wara nofsinhar                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | filgħaxija                                      | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | billejl                                         | Invalid Date             |
|                                 | BB           | 2019-02-11T11:13:14.015Z | filgħodu                                        | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | wara nofsinhar                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | filgħaxija                                      | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | billejl                                         | Invalid Date             |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | filgħodu                                        | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | wara nofsinhar                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | filgħaxija                                      | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | billejl                                         | Invalid Date             |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | filgħodu                                        | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | wara nofsinhar                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | filgħaxija                                      | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | billejl                                         | Invalid Date             |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | filgħodu                                        | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | wara nofsinhar                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | filgħaxija                                      | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | billejl                                         | Invalid Date             |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11º                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11º                                             | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11º                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23º                                             | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11º                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11º                                             | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11º                                             | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23º                                             | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1º                                              | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55º                                             | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1º                                              | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55º                                             | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11/01/1987                                      | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987                                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987                                      | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987                                      | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                      | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987                                      | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987                                      | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987                                      | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987                                      | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987                                      | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987                                      | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987                                      | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11 Jan 1987                                     | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 Fra 1987                                     | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 Mar 1987                                     | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 Apr 1987                                     | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Mej 1453                                     | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 Ġun 1987                                     | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 Lul 1987                                     | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 Aww 1987                                     | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 Set 1987                                     | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 Ott 1987                                     | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 Nov 1987                                     | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 Diċ 1987                                     | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11 Jannar 1987                                  | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 Frar 1987                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 Marzu 1987                                   | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 April 1987                                   | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Mejju 1453                                   | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 Ġunju 1987                                   | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 Lulju 1987                                   | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 Awwissu 1987                                 | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 Settembru 1987                               | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 Ottubru 1987                                 | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 Novembru 1987                                | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 Diċembru 1987                                | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | Il-Ħadd, 11 Jannar 1987                         | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | L-Erbgħa, 11 Frar 1987                          | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | L-Erbgħa, 11 Marzu 1987                         | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | Is-Sibt, 11 April 1987                          | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | Il-Ħadd, 29 Mejju 1453                          | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | Il-Ħamis, 11 Ġunju 1987                         | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | Is-Sibt, 11 Lulju 1987                          | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | It-Tlieta, 11 Awwissu 1987                      | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | Il-Ġimgħa, 11 Settembru 1987                    | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | Il-Ħadd, 11 Ottubru 1987                        | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | L-Erbgħa, 11 Novembru 1987                      | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | Il-Ġimgħa, 11 Diċembru 1987                     | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                           | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                           | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                           | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                           | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                           | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                           | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                           | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                           | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                           | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                           | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                           | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                           | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                        | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                        | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                        | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                        | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                        | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                        | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                        | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                        | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                        | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                        | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                        | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                        | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                  | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                                  | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                              | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+00:00                              | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11/01/1987 12:13                                | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987 12:13                                | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987 12:13                                | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987 12:13                                | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453 23:59                                | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987 12:13                                | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987 12:13                                | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987 12:13                                | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987 12:13                                | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987 12:13                                | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987 12:13                                | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987 12:13                                | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11 Jan 1987 12:13:14                            | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 Fra 1987 12:13:14                            | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 Mar 1987 12:13:14                            | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 Apr 1987 12:13:14                            | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Mej 1453 23:59:59                            | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 Ġun 1987 12:13:14                            | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 Lul 1987 12:13:14                            | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 Aww 1987 12:13:14                            | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 Set 1987 12:13:14                            | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 Ott 1987 12:13:14                            | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 Nov 1987 12:13:14                            | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 Diċ 1987 12:13:14                            | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11 Jannar 1987 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 Frar 1987 12:13:14 GMT+0                     | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 Marzu 1987 12:13:14 GMT+0                    | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 April 1987 12:13:14 GMT+0                    | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Mejju 1453 23:59:59 GMT+0                    | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 Ġunju 1987 12:13:14 GMT+0                    | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 Lulju 1987 12:13:14 GMT+0                    | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 Awwissu 1987 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 Settembru 1987 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 Ottubru 1987 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 Novembru 1987 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 Diċembru 1987 12:13:14 GMT+0                 | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | Il-Ħadd, 11 Jannar 1987 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | L-Erbgħa, 11 Frar 1987 12:13:14 GMT+00:00       | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | L-Erbgħa, 11 Marzu 1987 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | Is-Sibt, 11 April 1987 12:13:14 GMT+00:00       | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | Il-Ħadd, 29 Mejju 1453 23:59:59 GMT+00:00       | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | Il-Ħamis, 11 Ġunju 1987 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | Is-Sibt, 11 Lulju 1987 12:13:14 GMT+00:00       | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | It-Tlieta, 11 Awwissu 1987 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | Il-Ġimgħa, 11 Settembru 1987 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | Il-Ħadd, 11 Ottubru 1987 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | L-Erbgħa, 11 Novembru 1987 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | Il-Ġimgħa, 11 Diċembru 1987 12:13:14 GMT+00:00  | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result            | `includeSeconds: true` | `addSuffix: true`     |
| ------------------------ | ----------------- | ---------------------- | --------------------- |
| 2006-01-01T00:00:00.000Z | madwar 6 snin     | madwar 6 snin          | f'madwar 6 snin       |
| 2005-01-01T00:00:00.000Z | madwar 5 snin     | madwar 5 snin          | f'madwar 5 snin       |
| 2004-01-01T00:00:00.000Z | madwar 4 snin     | madwar 4 snin          | f'madwar 4 snin       |
| 2003-01-01T00:00:00.000Z | madwar 3 snin     | madwar 3 snin          | f'madwar 3 snin       |
| 2002-01-01T00:00:00.000Z | madwar sentejn    | madwar sentejn         | f'madwar sentejn      |
| 2001-06-01T00:00:00.000Z | aktar minn sena   | aktar minn sena        | f'aktar minn sena     |
| 2001-02-01T00:00:00.000Z | madwar sena       | madwar sena            | f'madwar sena         |
| 2001-01-01T00:00:00.000Z | madwar sena       | madwar sena            | f'madwar sena         |
| 2000-06-01T00:00:00.000Z | 5 xhur            | 5 xhur                 | f'5 xhur              |
| 2000-03-01T00:00:00.000Z | 2 xhur            | 2 xhur                 | f'2 xhur              |
| 2000-02-01T00:00:00.000Z | madwar xahar      | madwar xahar           | f'madwar xahar        |
| 2000-01-15T00:00:00.000Z | 14 ġranet         | 14 ġranet              | f'14 ġranet           |
| 2000-01-02T00:00:00.000Z | ġurnata           | ġurnata                | f'ġurnata             |
| 2000-01-01T06:00:00.000Z | madwar 6 siegħat  | madwar 6 siegħat       | f'madwar 6 siegħat    |
| 2000-01-01T01:00:00.000Z | madwar siegħa     | madwar siegħa          | f'madwar siegħa       |
| 2000-01-01T00:45:00.000Z | madwar siegħa     | madwar siegħa          | f'madwar siegħa       |
| 2000-01-01T00:30:00.000Z | 30 minuti         | 30 minuti              | f'30 minuti           |
| 2000-01-01T00:15:00.000Z | 15 minuti         | 15 minuti              | f'15 minuti           |
| 2000-01-01T00:01:00.000Z | minuta            | minuta                 | f'minuta              |
| 2000-01-01T00:00:25.000Z | inqas minn minuta | nofs minuta            | f'inqas minn minuta   |
| 2000-01-01T00:00:15.000Z | inqas minn minuta | inqas minn 20 sekondi  | f'inqas minn minuta   |
| 2000-01-01T00:00:05.000Z | inqas minn minuta | inqas minn 10 sekondi  | f'inqas minn minuta   |
| 2000-01-01T00:00:00.000Z | inqas minn minuta | inqas minn 5 sekondi   | inqas minn minuta ilu |
| 1999-12-31T23:59:55.000Z | inqas minn minuta | inqas minn 10 sekondi  | inqas minn minuta ilu |
| 1999-12-31T23:59:45.000Z | inqas minn minuta | inqas minn 20 sekondi  | inqas minn minuta ilu |
| 1999-12-31T23:59:35.000Z | inqas minn minuta | nofs minuta            | inqas minn minuta ilu |
| 1999-12-31T23:59:00.000Z | minuta            | minuta                 | minuta ilu            |
| 1999-12-31T23:45:00.000Z | 15 minuti         | 15 minuti              | 15 minuti ilu         |
| 1999-12-31T23:30:00.000Z | 30 minuti         | 30 minuti              | 30 minuti ilu         |
| 1999-12-31T23:15:00.000Z | madwar siegħa     | madwar siegħa          | madwar siegħa ilu     |
| 1999-12-31T23:00:00.000Z | madwar siegħa     | madwar siegħa          | madwar siegħa ilu     |
| 1999-12-31T18:00:00.000Z | madwar 6 siegħat  | madwar 6 siegħat       | madwar 6 siegħat ilu  |
| 1999-12-30T00:00:00.000Z | 2 ġranet          | 2 ġranet               | 2 ġranet ilu          |
| 1999-12-15T00:00:00.000Z | 17 ġranet         | 17 ġranet              | 17 ġranet ilu         |
| 1999-12-01T00:00:00.000Z | madwar xahar      | madwar xahar           | madwar xahar ilu      |
| 1999-11-01T00:00:00.000Z | 2 xhur            | 2 xhur                 | 2 xhur ilu            |
| 1999-06-01T00:00:00.000Z | 7 xhur            | 7 xhur                 | 7 xhur ilu            |
| 1999-01-01T00:00:00.000Z | madwar sena       | madwar sena            | madwar sena ilu       |
| 1998-12-01T00:00:00.000Z | madwar sena       | madwar sena            | madwar sena ilu       |
| 1998-06-01T00:00:00.000Z | aktar minn sena   | aktar minn sena        | aktar minn sena ilu   |
| 1998-01-01T00:00:00.000Z | madwar sentejn    | madwar sentejn         | madwar sentejn ilu    |
| 1997-01-01T00:00:00.000Z | madwar 3 snin     | madwar 3 snin          | madwar 3 snin ilu     |
| 1996-01-01T00:00:00.000Z | madwar 4 snin     | madwar 4 snin          | madwar 4 snin ilu     |
| 1995-01-01T00:00:00.000Z | madwar 5 snin     | madwar 5 snin          | madwar 5 snin ilu     |
| 1994-01-01T00:00:00.000Z | madwar 6 snin     | madwar 6 snin          | madwar 6 snin ilu     |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result     | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ---------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 snin     | f'6 snin          | 52608 siegħat                  |
| 2005-01-01T00:00:00.000Z | 5 snin     | f'5 snin          | 43848 siegħat                  |
| 2004-01-01T00:00:00.000Z | 4 snin     | f'4 snin          | 35064 siegħat                  |
| 2003-01-01T00:00:00.000Z | 3 snin     | f'3 snin          | 26304 siegħat                  |
| 2002-01-01T00:00:00.000Z | sentejn    | f'sentejn         | 17544 siegħat                  |
| 2001-06-01T00:00:00.000Z | sena       | f'sena            | 12408 siegħat                  |
| 2001-02-01T00:00:00.000Z | sena       | f'sena            | 9528 siegħat                   |
| 2001-01-01T00:00:00.000Z | sena       | f'sena            | 8784 siegħat                   |
| 2000-06-01T00:00:00.000Z | 5 xhur     | f'5 xhur          | 3648 siegħat                   |
| 2000-03-01T00:00:00.000Z | 2 xhur     | f'2 xhur          | 1440 siegħat                   |
| 2000-02-01T00:00:00.000Z | xahar      | f'xahar           | 744 siegħat                    |
| 2000-01-15T00:00:00.000Z | 14 ġranet  | f'14 ġranet       | 336 siegħat                    |
| 2000-01-02T00:00:00.000Z | ġurnata    | f'ġurnata         | 24 siegħat                     |
| 2000-01-01T06:00:00.000Z | 6 siegħat  | f'6 siegħat       | 6 siegħat                      |
| 2000-01-01T01:00:00.000Z | siegħa     | f'siegħa          | siegħa                         |
| 2000-01-01T00:45:00.000Z | 45 minuti  | f'45 minuti       | siegħa                         |
| 2000-01-01T00:30:00.000Z | 30 minuti  | f'30 minuti       | siegħa                         |
| 2000-01-01T00:15:00.000Z | 15 minuti  | f'15 minuti       | 0 siegħat                      |
| 2000-01-01T00:01:00.000Z | minuta     | f'minuta          | 0 siegħat                      |
| 2000-01-01T00:00:25.000Z | 25 sekondi | f'25 sekondi      | 0 siegħat                      |
| 2000-01-01T00:00:15.000Z | 15 sekondi | f'15 sekondi      | 0 siegħat                      |
| 2000-01-01T00:00:05.000Z | 5 sekondi  | f'5 sekondi       | 0 siegħat                      |
| 2000-01-01T00:00:00.000Z | 0 sekondi  | 0 sekondi ilu     | 0 siegħat                      |
| 1999-12-31T23:59:55.000Z | 5 sekondi  | 5 sekondi ilu     | 0 siegħat                      |
| 1999-12-31T23:59:45.000Z | 15 sekondi | 15 sekondi ilu    | 0 siegħat                      |
| 1999-12-31T23:59:35.000Z | 25 sekondi | 25 sekondi ilu    | 0 siegħat                      |
| 1999-12-31T23:59:00.000Z | minuta     | minuta ilu        | 0 siegħat                      |
| 1999-12-31T23:45:00.000Z | 15 minuti  | 15 minuti ilu     | 0 siegħat                      |
| 1999-12-31T23:30:00.000Z | 30 minuti  | 30 minuti ilu     | siegħa                         |
| 1999-12-31T23:15:00.000Z | 45 minuti  | 45 minuti ilu     | siegħa                         |
| 1999-12-31T23:00:00.000Z | siegħa     | siegħa ilu        | siegħa                         |
| 1999-12-31T18:00:00.000Z | 6 siegħat  | 6 siegħat ilu     | 6 siegħat                      |
| 1999-12-30T00:00:00.000Z | 2 ġranet   | 2 ġranet ilu      | 48 siegħat                     |
| 1999-12-15T00:00:00.000Z | 17 ġranet  | 17 ġranet ilu     | 408 siegħat                    |
| 1999-12-01T00:00:00.000Z | xahar      | xahar ilu         | 744 siegħat                    |
| 1999-11-01T00:00:00.000Z | 2 xhur     | 2 xhur ilu        | 1464 siegħat                   |
| 1999-06-01T00:00:00.000Z | 7 xhur     | 7 xhur ilu        | 5136 siegħat                   |
| 1999-01-01T00:00:00.000Z | sena       | sena ilu          | 8760 siegħat                   |
| 1998-12-01T00:00:00.000Z | sena       | sena ilu          | 9504 siegħat                   |
| 1998-06-01T00:00:00.000Z | sentejn    | sentejn ilu       | 13896 siegħat                  |
| 1998-01-01T00:00:00.000Z | sentejn    | sentejn ilu       | 17520 siegħat                  |
| 1997-01-01T00:00:00.000Z | 3 snin     | 3 snin ilu        | 26280 siegħat                  |
| 1996-01-01T00:00:00.000Z | 4 snin     | 4 snin ilu        | 35064 siegħat                  |
| 1995-01-01T00:00:00.000Z | 5 snin     | 5 snin ilu        | 43824 siegħat                  |
| 1994-01-01T00:00:00.000Z | 6 snin     | 6 snin ilu        | 52584 siegħat                  |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                       |
| ------------------------ | ---------------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000                   |
| 2000-01-05T00:00:00.000Z | L-Erbgħa fil-00:00           |
| 2000-01-02T00:00:00.000Z | Għada fil-00:00              |
| 2000-01-01T00:00:00.000Z | Illum fil-00:00              |
| 1999-12-31T00:00:00.000Z | Il-bieraħ fil-00:00          |
| 1999-12-27T00:00:00.000Z | It-Tnejn li għadda fil-00:00 |
| 1999-12-21T00:00:00.000Z | 21/12/1999                   |

## `formatDuration`

| Duration      | Result    |
| ------------- | --------- |
| {"years":0}   | 0 snin    |
| {"years":1}   | sena      |
| {"years":2}   | sentejn   |
| {"months":0}  | 0 xhur    |
| {"months":1}  | xahar     |
| {"months":2}  | 2 xhur    |
| {"weeks":0}   | 0 ġimgħat |
| {"weeks":1}   | ġimgħa    |
| {"weeks":2}   | 2 ġimgħat |
| {"days":0}    | 0 ġranet  |
| {"days":1}    | ġurnata   |
| {"days":2}    | 2 ġranet  |
| {"hours":0}   | 0 siegħat |
| {"hours":1}   | siegħa    |
| {"hours":2}   | 2 siegħat |
| {"minutes":0} | 0 minuti  |
| {"minutes":1} | minuta    |
| {"minutes":2} | 2 minuti  |
| {"seconds":0} | 0 sekondi |
| {"seconds":1} | sekonda   |
| {"seconds":2} | 2 sekondi |
