# Lithuanian (lt) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                          | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | -------------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987-oji                                                 | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-oji                                                    | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987-oji                                                 | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4-oji                                                    | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1-oji                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-oji                                                    | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | I k.                                                     | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | II k.                                                    | Invalid Date             |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | I ketvirtis                                              | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | II ketvirtis                                             | Invalid Date             |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                        | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1-oji                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-oji                                                    | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | I ketv.                                                  | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | II ketv.                                                 | Invalid Date             |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | I ketvirtis                                              | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | II ketvirtis                                             | Invalid Date             |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1-oji                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2-oji                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3-oji                                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4-oji                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5-oji                                                    | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6-oji                                                    | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-oji                                                    | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8-oji                                                    | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9-oji                                                    | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10-oji                                                   | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11-oji                                                   | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12-oji                                                   | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | saus.                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | vas.                                                     | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | kov.                                                     | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | bal.                                                     | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | geg.                                                     | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | birž.                                                    | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | liep.                                                    | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | rugp.                                                    | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | rugs.                                                    | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | spal.                                                    | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | lapkr.                                                   | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | gruod.                                                   | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | sausio                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | vasario                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | kovo                                                     | Invalid Date             |
|                                 |              | 2019-04-10T12:13:14.015Z | balandžio                                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | gegužės                                                  | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | birželio                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | liepos                                                   | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | rugpjūčio                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | rugsėjo                                                  | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | spalio                                                   | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | lapkričio                                                | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | gruodžio                                                 | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | S                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | V                                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | K                                                        | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | B                                                        | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | G                                                        | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | B                                                        | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | L                                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | R                                                        | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | R                                                        | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | S                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | L                                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | G                                                        | 2019-05-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1-oji                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2-oji                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3-oji                                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4-oji                                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5-oji                                                    | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6-oji                                                    | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-oji                                                    | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8-oji                                                    | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9-oji                                                    | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10-oji                                                   | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11-oji                                                   | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12-oji                                                   | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | saus.                                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | vas.                                                     | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | kov.                                                     | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | bal.                                                     | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | geg.                                                     | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | birž.                                                    | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | liep.                                                    | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | rugp.                                                    | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | rugs.                                                    | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | spal.                                                    | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | lapkr.                                                   | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | gruod.                                                   | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | sausis                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | vasaris                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | kovas                                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | balandis                                                 | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | gegužė                                                   | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | birželis                                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | liepa                                                    | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | rugpjūtis                                                | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | rugsėjis                                                 | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | spalis                                                   | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | lapkritis                                                | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | gruodis                                                  | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | S                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | V                                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | K                                                        | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | B                                                        | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | G                                                        | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | B                                                        | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | L                                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | R                                                        | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | R                                                        | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | S                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | L                                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | G                                                        | 2019-05-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1-oji                                                    | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-oji                                                   | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1-oji                                                    | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-oji                                                   | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1-oji                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11-oji                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28-oji                                                   | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1-oji vasario                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11-oji vasario                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28-oji vasario                                           | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42-oji                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365-oji                                                  | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | pr                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pn                                                       | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | pr                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pn                                                       | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | pr                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pn                                                       | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | pirmadienį                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | penktadienį                                              | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | P                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                                        | 2019-02-11T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | Pr                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pn                                                       | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1-oji                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-oji                                                    | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | pr                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pn                                                       | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | pirmadienį                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | penktadienį                                              | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | P                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                                        | 2019-02-11T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | Pr                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pn                                                       | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1-oji                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-oji                                                    | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | pr                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pn                                                       | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | pirmadienį                                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | penktadienį                                              | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | P                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                                        | 2019-02-11T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | Pr                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pn                                                       | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1-oji                                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-oji                                                    | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | pr                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pn                                                       | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | pirmadienis                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | penktadienis                                             | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | P                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                                        | 2019-02-11T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | Pr                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Pn                                                       | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | priešpiet                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popiet                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | popiet                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | priešpiet                                                | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | priešpiet                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popiet                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | popiet                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | priešpiet                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | priešpiet                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popiet                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | popiet                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | priešpiet                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | priešpiet                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popiet                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | popiet                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | priešpiet                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | pr. p.                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pop.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pop.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | pr. p.                                                   | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | priešpiet                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popiet                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | popiet                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | priešpiet                                                | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | priešpiet                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popiet                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | popiet                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | priešpiet                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | priešpiet                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popiet                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | popiet                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | priešpiet                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | priešpiet                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popiet                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | popiet                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | priešpiet                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | pr. p.                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pop.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pop.                                                     | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | pr. p.                                                   | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | rytas                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popietė                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | vakaras                                                  | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | naktis                                                   | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | rytas                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popietė                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | vakaras                                                  | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | naktis                                                   | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | rytas                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popietė                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | vakaras                                                  | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | naktis                                                   | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | rytas                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popietė                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | vakaras                                                  | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | naktis                                                   | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | rytas                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | popietė                                                  | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | vakaras                                                  | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | naktis                                                   | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11-oji                                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-oji                                                   | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11-oji                                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-oji                                                   | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11-oji                                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-oji                                                   | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11-oji                                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-oji                                                   | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1-oji                                                    | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55-oji                                                   | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1-oji                                                    | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55-oji                                                   | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 1987-01-11                                               | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987-02-11                                               | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987-03-11                                               | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987-04-11                                               | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453-05-29                                               | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987-06-11                                               | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987-07-11                                               | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987-08-11                                               | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987-09-11                                               | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987-10-11                                               | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987-11-11                                               | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987-12-11                                               | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 1987-01-11                                               | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987-02-11                                               | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987-03-11                                               | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987-04-11                                               | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453-05-29                                               | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987-06-11                                               | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987-07-11                                               | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987-08-11                                               | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987-09-11                                               | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987-10-11                                               | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987-11-11                                               | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987-12-11                                               | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 1987 m. sausio 11 d.                                     | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987 m. vasario 11 d.                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987 m. kovo 11 d.                                       | Invalid Date             |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987 m. balandžio 11 d.                                  | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453 m. gegužės 29 d.                                    | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987 m. birželio 11 d.                                   | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987 m. liepos 11 d.                                     | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987 m. rugpjūčio 11 d.                                  | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987 m. rugsėjo 11 d.                                    | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987 m. spalio 11 d.                                     | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987 m. lapkričio 11 d.                                  | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987 m. gruodžio 11 d.                                   | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | 1987 m. sausio 11 d., sekmadienį                         | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987 m. vasario 11 d., trečiadienį                       | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987 m. kovo 11 d., trečiadienį                          | Invalid Date             |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987 m. balandžio 11 d., šeštadienį                      | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453 m. gegužės 29 d., sekmadienį                        | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987 m. birželio 11 d., ketvirtadienį                    | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987 m. liepos 11 d., šeštadienį                         | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987 m. rugpjūčio 11 d., antradienį                      | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987 m. rugsėjo 11 d., penktadienį                       | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987 m. spalio 11 d., sekmadienį                         | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987 m. lapkričio 11 d., trečiadienį                     | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987 m. gruodžio 11 d., penktadienį                      | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                                    | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                                    | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                                    | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                                    | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                                    | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                                    | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                                    | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                                    | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                                    | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                                    | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                                    | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                                    | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                                 | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                                 | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                                 | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                                 | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                                 | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                                 | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                                 | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                                 | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                                 | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                                 | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                                 | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                                 | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                                           | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                           | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                                           | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                                           | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                           | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                                           | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                                           | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                                           | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                                           | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                                           | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                                           | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                                           | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+00:00                                       | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                       | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+00:00                                       | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+00:00                                       | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                       | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+00:00                                       | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+00:00                                       | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+00:00                                       | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+00:00                                       | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+00:00                                       | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+00:00                                       | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+00:00                                       | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 1987-01-11 12:13                                         | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987-02-11 12:13                                         | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987-03-11 12:13                                         | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987-04-11 12:13                                         | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453-05-29 23:59                                         | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987-06-11 12:13                                         | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987-07-11 12:13                                         | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987-08-11 12:13                                         | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987-09-11 12:13                                         | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987-10-11 12:13                                         | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987-11-11 12:13                                         | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987-12-11 12:13                                         | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 1987-01-11 12:13:14                                      | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987-02-11 12:13:14                                      | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987-03-11 12:13:14                                      | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987-04-11 12:13:14                                      | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453-05-29 23:59:59                                      | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987-06-11 12:13:14                                      | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987-07-11 12:13:14                                      | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987-08-11 12:13:14                                      | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987-09-11 12:13:14                                      | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987-10-11 12:13:14                                      | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987-11-11 12:13:14                                      | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987-12-11 12:13:14                                      | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 1987 m. sausio 11 d. 12:13:14 GMT+0                      | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987 m. vasario 11 d. 12:13:14 GMT+0                     | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987 m. kovo 11 d. 12:13:14 GMT+0                        | Invalid Date             |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987 m. balandžio 11 d. 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453 m. gegužės 29 d. 23:59:59 GMT+0                     | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987 m. birželio 11 d. 12:13:14 GMT+0                    | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987 m. liepos 11 d. 12:13:14 GMT+0                      | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987 m. rugpjūčio 11 d. 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987 m. rugsėjo 11 d. 12:13:14 GMT+0                     | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987 m. spalio 11 d. 12:13:14 GMT+0                      | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987 m. lapkričio 11 d. 12:13:14 GMT+0                   | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987 m. gruodžio 11 d. 12:13:14 GMT+0                    | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | 1987 m. sausio 11 d., sekmadienį 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 1987 m. vasario 11 d., trečiadienį 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 1987 m. kovo 11 d., trečiadienį 12:13:14 GMT+00:00       | Invalid Date             |
|                                 |              | 1987-04-11T12:13:14.015Z | 1987 m. balandžio 11 d., šeštadienį 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 1453 m. gegužės 29 d., sekmadienį 23:59:59 GMT+00:00     | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 1987 m. birželio 11 d., ketvirtadienį 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 1987 m. liepos 11 d., šeštadienį 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 1987 m. rugpjūčio 11 d., antradienį 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 1987 m. rugsėjo 11 d., penktadienį 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 1987 m. spalio 11 d., sekmadienį 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 1987 m. lapkričio 11 d., trečiadienį 12:13:14 GMT+00:00  | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 1987 m. gruodžio 11 d., penktadienį 12:13:14 GMT+00:00   | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result            | `includeSeconds: true`  | `addSuffix: true`       |
| ------------------------ | ----------------- | ----------------------- | ----------------------- |
| 2006-01-01T00:00:00.000Z | apie 6 metai      | apie 6 metai            | po apie 6 metų          |
| 2005-01-01T00:00:00.000Z | apie 5 metai      | apie 5 metai            | po apie 5 metų          |
| 2004-01-01T00:00:00.000Z | apie 4 metai      | apie 4 metai            | po apie 4 metų          |
| 2003-01-01T00:00:00.000Z | apie 3 metai      | apie 3 metai            | po apie 3 metų          |
| 2002-01-01T00:00:00.000Z | apie 2 metai      | apie 2 metai            | po apie 2 metų          |
| 2001-06-01T00:00:00.000Z | daugiau nei metai | daugiau nei metai       | po daugiau nei metų     |
| 2001-02-01T00:00:00.000Z | apie metai        | apie metai              | po apie metų            |
| 2001-01-01T00:00:00.000Z | apie metai        | apie metai              | po apie metų            |
| 2000-06-01T00:00:00.000Z | 5 mėnesiai        | 5 mėnesiai              | po 5 mėnesių            |
| 2000-03-01T00:00:00.000Z | 2 mėnesiai        | 2 mėnesiai              | po 2 mėnesių            |
| 2000-02-01T00:00:00.000Z | apie mėnuo        | apie mėnuo              | po apie mėnesio         |
| 2000-01-15T00:00:00.000Z | 14 dienų          | 14 dienų                | po 14 dienų             |
| 2000-01-02T00:00:00.000Z | diena             | diena                   | po dienos               |
| 2000-01-01T06:00:00.000Z | apie 6 valandos   | apie 6 valandos         | po apie 6 valandų       |
| 2000-01-01T01:00:00.000Z | apie valanda      | apie valanda            | po apie valandos        |
| 2000-01-01T00:45:00.000Z | apie valanda      | apie valanda            | po apie valandos        |
| 2000-01-01T00:30:00.000Z | 30 minučių        | 30 minučių              | po 30 minučių           |
| 2000-01-01T00:15:00.000Z | 15 minučių        | 15 minučių              | po 15 minučių           |
| 2000-01-01T00:01:00.000Z | minutė            | minutė                  | po minutės              |
| 2000-01-01T00:00:25.000Z | mažiau nei minutė | pusė minutės            | po mažiau nei minutės   |
| 2000-01-01T00:00:15.000Z | mažiau nei minutė | mažiau nei 20 sekundžių | po mažiau nei minutės   |
| 2000-01-01T00:00:05.000Z | mažiau nei minutė | mažiau nei 10 sekundžių | po mažiau nei minutės   |
| 2000-01-01T00:00:00.000Z | mažiau nei minutė | mažiau nei 5 sekundė    | prieš mažiau nei minutę |
| 1999-12-31T23:59:55.000Z | mažiau nei minutė | mažiau nei 10 sekundžių | prieš mažiau nei minutę |
| 1999-12-31T23:59:45.000Z | mažiau nei minutė | mažiau nei 20 sekundžių | prieš mažiau nei minutę |
| 1999-12-31T23:59:35.000Z | mažiau nei minutė | pusė minutės            | prieš mažiau nei minutę |
| 1999-12-31T23:59:00.000Z | minutė            | minutė                  | prieš minutę            |
| 1999-12-31T23:45:00.000Z | 15 minučių        | 15 minučių              | prieš 15 minučių        |
| 1999-12-31T23:30:00.000Z | 30 minučių        | 30 minučių              | prieš 30 minučių        |
| 1999-12-31T23:15:00.000Z | apie valanda      | apie valanda            | prieš apie valandą      |
| 1999-12-31T23:00:00.000Z | apie valanda      | apie valanda            | prieš apie valandą      |
| 1999-12-31T18:00:00.000Z | apie 6 valandos   | apie 6 valandos         | prieš apie 6 valandas   |
| 1999-12-30T00:00:00.000Z | 2 dienos          | 2 dienos                | prieš 2 dienas          |
| 1999-12-15T00:00:00.000Z | 17 dienų          | 17 dienų                | prieš 17 dienų          |
| 1999-12-01T00:00:00.000Z | apie mėnuo        | apie mėnuo              | prieš apie mėnesį       |
| 1999-11-01T00:00:00.000Z | 2 mėnesiai        | 2 mėnesiai              | prieš 2 mėnesius        |
| 1999-06-01T00:00:00.000Z | 7 mėnesiai        | 7 mėnesiai              | prieš 7 mėnesius        |
| 1999-01-01T00:00:00.000Z | apie metai        | apie metai              | prieš apie metus        |
| 1998-12-01T00:00:00.000Z | apie metai        | apie metai              | prieš apie metus        |
| 1998-06-01T00:00:00.000Z | daugiau nei metai | daugiau nei metai       | prieš daugiau nei metus |
| 1998-01-01T00:00:00.000Z | apie 2 metai      | apie 2 metai            | prieš apie 2 metus      |
| 1997-01-01T00:00:00.000Z | apie 3 metai      | apie 3 metai            | prieš apie 3 metus      |
| 1996-01-01T00:00:00.000Z | apie 4 metai      | apie 4 metai            | prieš apie 4 metus      |
| 1995-01-01T00:00:00.000Z | apie 5 metai      | apie 5 metai            | prieš apie 5 metus      |
| 1994-01-01T00:00:00.000Z | apie 6 metai      | apie 6 metai            | prieš apie 6 metus      |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result       | `addSuffix: true`  | With forced unit (i.e. `hour`) |
| ------------------------ | ------------ | ------------------ | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 metai      | po 6 metų          | 52608 valandos                 |
| 2005-01-01T00:00:00.000Z | 5 metai      | po 5 metų          | 43848 valandos                 |
| 2004-01-01T00:00:00.000Z | 4 metai      | po 4 metų          | 35064 valandos                 |
| 2003-01-01T00:00:00.000Z | 3 metai      | po 3 metų          | 26304 valandos                 |
| 2002-01-01T00:00:00.000Z | 2 metai      | po 2 metų          | 17544 valandos                 |
| 2001-06-01T00:00:00.000Z | metai        | po metų            | 12408 valandos                 |
| 2001-02-01T00:00:00.000Z | metai        | po metų            | 9528 valandos                  |
| 2001-01-01T00:00:00.000Z | metai        | po metų            | 8784 valandos                  |
| 2000-06-01T00:00:00.000Z | 5 mėnesiai   | po 5 mėnesių       | 3648 valandos                  |
| 2000-03-01T00:00:00.000Z | 2 mėnesiai   | po 2 mėnesių       | 1440 valandų                   |
| 2000-02-01T00:00:00.000Z | mėnuo        | po mėnesio         | 744 valandos                   |
| 2000-01-15T00:00:00.000Z | 14 dienų     | po 14 dienų        | 336 valandos                   |
| 2000-01-02T00:00:00.000Z | diena        | po dienos          | 24 valandos                    |
| 2000-01-01T06:00:00.000Z | 6 valandos   | po 6 valandų       | 6 valandos                     |
| 2000-01-01T01:00:00.000Z | valanda      | po valandos        | valanda                        |
| 2000-01-01T00:45:00.000Z | 45 minutės   | po 45 minučių      | valanda                        |
| 2000-01-01T00:30:00.000Z | 30 minučių   | po 30 minučių      | valanda                        |
| 2000-01-01T00:15:00.000Z | 15 minučių   | po 15 minučių      | 0 valandų                      |
| 2000-01-01T00:01:00.000Z | minutė       | po minutės         | 0 valandų                      |
| 2000-01-01T00:00:25.000Z | 25 sekundė   | po 25 sekundžių    | 0 valandų                      |
| 2000-01-01T00:00:15.000Z | 15 sekundžių | po 15 sekundžių    | 0 valandų                      |
| 2000-01-01T00:00:05.000Z | 5 sekundė    | po 5 sekundžių     | 0 valandų                      |
| 2000-01-01T00:00:00.000Z | 0 sekundžių  | prieš 0 sekundžių  | 0 valandų                      |
| 1999-12-31T23:59:55.000Z | 5 sekundė    | prieš 5 sekundes   | 0 valandų                      |
| 1999-12-31T23:59:45.000Z | 15 sekundžių | prieš 15 sekundžių | 0 valandų                      |
| 1999-12-31T23:59:35.000Z | 25 sekundė   | prieš 25 sekundes  | 0 valandų                      |
| 1999-12-31T23:59:00.000Z | minutė       | prieš minutę       | 0 valandų                      |
| 1999-12-31T23:45:00.000Z | 15 minučių   | prieš 15 minučių   | 0 valandų                      |
| 1999-12-31T23:30:00.000Z | 30 minučių   | prieš 30 minučių   | valanda                        |
| 1999-12-31T23:15:00.000Z | 45 minutės   | prieš 45 minutes   | valanda                        |
| 1999-12-31T23:00:00.000Z | valanda      | prieš valandą      | valanda                        |
| 1999-12-31T18:00:00.000Z | 6 valandos   | prieš 6 valandas   | 6 valandos                     |
| 1999-12-30T00:00:00.000Z | 2 dienos     | prieš 2 dienas     | 48 valandos                    |
| 1999-12-15T00:00:00.000Z | 17 dienų     | prieš 17 dienų     | 408 valandos                   |
| 1999-12-01T00:00:00.000Z | mėnuo        | prieš mėnesį       | 744 valandos                   |
| 1999-11-01T00:00:00.000Z | 2 mėnesiai   | prieš 2 mėnesius   | 1464 valandos                  |
| 1999-06-01T00:00:00.000Z | 7 mėnesiai   | prieš 7 mėnesius   | 5136 valandos                  |
| 1999-01-01T00:00:00.000Z | metai        | prieš metus        | 8760 valandų                   |
| 1998-12-01T00:00:00.000Z | metai        | prieš metus        | 9504 valandos                  |
| 1998-06-01T00:00:00.000Z | 2 metai      | prieš 2 metus      | 13896 valandos                 |
| 1998-01-01T00:00:00.000Z | 2 metai      | prieš 2 metus      | 17520 valandų                  |
| 1997-01-01T00:00:00.000Z | 3 metai      | prieš 3 metus      | 26280 valandų                  |
| 1996-01-01T00:00:00.000Z | 4 metai      | prieš 4 metus      | 35064 valandos                 |
| 1995-01-01T00:00:00.000Z | 5 metai      | prieš 5 metus      | 43824 valandos                 |
| 1994-01-01T00:00:00.000Z | 6 metai      | prieš 6 metus      | 52584 valandos                 |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                    |
| ------------------------ | ------------------------- |
| 2000-01-10T00:00:00.000Z | 2000-01-10                |
| 2000-01-05T00:00:00.000Z | trečiadienį 00:00         |
| 2000-01-02T00:00:00.000Z | Rytoj 00:00               |
| 2000-01-01T00:00:00.000Z | Šiandien 00:00            |
| 1999-12-31T00:00:00.000Z | Vakar 00:00               |
| 1999-12-27T00:00:00.000Z | Praėjusį pirmadienį 00:00 |
| 1999-12-21T00:00:00.000Z | 1999-12-21                |

## `formatDuration`

| Duration      | Result          |
| ------------- | --------------- |
| {"years":0}   | 0 metų          |
| {"years":1}   | metai           |
| {"years":2}   | 2 metai         |
| {"months":0}  | 0 mėnesių       |
| {"months":1}  | mėnuo           |
| {"months":2}  | 2 mėnesiai      |
| {"weeks":0}   | 0 savaičių      |
| {"weeks":1}   | savaitė         |
| {"weeks":2}   | 2 savaitės      |
| {"days":0}    | 0 dienų         |
| {"days":1}    | diena           |
| {"days":2}    | 2 dienos        |
| {"hours":0}   | 0 valandų       |
| {"hours":1}   | valanda         |
| {"hours":2}   | 2 valandos      |
| {"minutes":0} | 0 minučių       |
| {"minutes":1} | minutė          |
| {"minutes":2} | 2 minutės       |
| {"seconds":0} | 0 sekundžių     |
| {"seconds":1} | kelios sekundės |
| {"seconds":2} | 2 sekundė       |
