# Khmer (km) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                               | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | --------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                          | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                             | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                          | 1986-12-28T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                             | 0004-12-26T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                             | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | Q1                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                            | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | ត្រីមាសទី 1                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ត្រីមាសទី 2                                   | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                             | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                             | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | Q1                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | Q2                                            | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | ត្រីមាសទី 1                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ត្រីមាសទី 2                                   | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                             | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                            | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                            | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                            | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | មករា                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | កុម្ភៈ                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | មីនា                                          | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | មេសា                                          | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | ឧសភា                                          | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | មិថុនា                                        | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | កក្កដា                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | សីហា                                          | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | កញ្ញា                                         | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | តុលា                                          | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | វិច្ឆិកា                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ធ្នូ                                          | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | មករា                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | កុម្ភៈ                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | មីនា                                          | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | មេសា                                          | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | ឧសភា                                          | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | មិថុនា                                        | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | កក្កដា                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | សីហា                                          | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | កញ្ញា                                         | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | តុលា                                          | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | វិច្ឆិកា                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ធ្នូ                                          | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | ម.ក                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | ក.ម                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | មិ                                            | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | ម.ស                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | ឧ.ស                                           | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ម.ថ                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ក.ដ                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | សី                                            | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | កញ                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | តុ                                            | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | វិ                                            | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ធ                                             | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                             | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                            | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                            | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                            | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | មករា                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | កុម្ភៈ                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | មីនា                                          | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | មេសា                                          | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | ឧសភា                                          | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | មិថុនា                                        | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | កក្កដា                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | សីហា                                          | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | កញ្ញា                                         | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | តុលា                                          | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | វិច្ឆិកា                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ធ្នូ                                          | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | មករា                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | កុម្ភៈ                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | មីនា                                          | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | មេសា                                          | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | ឧសភា                                          | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | មិថុនា                                        | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | កក្កដា                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | សីហា                                          | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | កញ្ញា                                         | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | តុលា                                          | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | វិច្ឆិកា                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ធ្នូ                                          | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | ម.ក                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | ក.ម                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | មិ                                            | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | ម.ស                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | ឧ.ស                                           | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ម.ថ                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ក.ដ                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | សី                                            | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | កញ                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | តុ                                            | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | វិ                                            | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ធ                                             | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                             | 2018-12-30T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 49                                            | 2019-12-01T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                             | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                            | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                            | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1 កុម្ភៈ                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11 កុម្ភៈ                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28 កុម្ភៈ                                     | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                           | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | ច                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុ                                            | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | ច                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុ                                            | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | ច                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុ                                            | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | ចន្ទ                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុក្រ                                         | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | ច                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុ                                            | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | ច                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុ                                            | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                             | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | ច                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុ                                            | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | ចន្ទ                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុក្រ                                         | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | ច                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុ                                            | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | ច                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុ                                            | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 2                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6                                             | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | ច                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុ                                            | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | ចន្ទ                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុក្រ                                         | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | ច                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុ                                            | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | ច                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុ                                            | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 2                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6                                             | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | ច                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុ                                            | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | ចន្ទ                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុក្រ                                         | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | ច                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុ                                            | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | ច                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | សុ                                            | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ល្ងាច                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ព្រឹក                                         | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | ពេលព្រឹក                                      | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ពេលរសៀល                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ពេលល្ងាច                                      | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ពេលយប់                                        | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | ពេលព្រឹក                                      | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ពេលរសៀល                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ពេលល្ងាច                                      | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ពេលយប់                                        | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | ពេលព្រឹក                                      | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ពេលរសៀល                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ពេលល្ងាច                                      | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ពេលយប់                                        | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | ពេលព្រឹក                                      | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ពេលរសៀល                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ពេលល្ងាច                                      | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ពេលយប់                                        | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | ពេលព្រឹក                                      | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ពេលរសៀល                                       | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ពេលល្ងាច                                      | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ពេលយប់                                        | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                            | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                            | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                            | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                            | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                             | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                            | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                             | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                            | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11/01/1987                                    | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987                                    | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987                                    | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                    | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987                                    | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987                                    | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987                                    | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987                                    | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987                                    | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987                                    | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987                                    | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11 មករា 1987                                  | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 កុម្ភៈ 1987                                | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 មីនា 1987                                  | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 មេសា 1987                                  | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 ឧសភា 1453                                  | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 មិថុនា 1987                                | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 កក្កដា 1987                                | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 សីហា 1987                                  | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 កញ្ញា 1987                                 | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 តុលា 1987                                  | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 វិច្ឆិកា 1987                              | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ធ្នូ 1987                                  | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11 មករា 1987                                  | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 កុម្ភៈ 1987                                | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 មីនា 1987                                  | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 មេសា 1987                                  | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 ឧសភា 1453                                  | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 មិថុនា 1987                                | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 កក្កដា 1987                                | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 សីហា 1987                                  | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 កញ្ញា 1987                                 | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 តុលា 1987                                  | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 វិច្ឆិកា 1987                              | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ធ្នូ 1987                                  | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | អាទិត្យ 11 មករា 1987                          | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | ពុធ 11 កុម្ភៈ 1987                            | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | ពុធ 11 មីនា 1987                              | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | សៅរ៍ 11 មេសា 1987                             | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | អាទិត្យ 29 ឧសភា 1453                          | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | ព្រហស្បតិ៍ 11 មិថុនា 1987                     | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | សៅរ៍ 11 កក្កដា 1987                           | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | អង្គារ 11 សីហា 1987                           | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | សុក្រ 11 កញ្ញា 1987                           | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | អាទិត្យ 11 តុលា 1987                          | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | ពុធ 11 វិច្ឆិកា 1987                          | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | សុក្រ 11 ធ្នូ 1987                            | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13 ល្ងាច                                   | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13 ល្ងាច                                   | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13 ល្ងាច                                   | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13 ល្ងាច                                   | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59 ល្ងាច                                   | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13 ល្ងាច                                   | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13 ល្ងាច                                   | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13 ល្ងាច                                   | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13 ល្ងាច                                   | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13 ល្ងាច                                   | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13 ល្ងាច                                   | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13 ល្ងាច                                   | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 ល្ងាច                                | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 ល្ងាច                                | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-12-11T12:13:14.000Z |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 ល្ងាច                                | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 ល្ងាច                                | 1987-12-11T12:13:14.000Z |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11/01/1987, 12:13 ល្ងាច                       | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987, 12:13 ល្ងាច                       | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987, 12:13 ល្ងាច                       | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987, 12:13 ល្ងាច                       | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453, 11:59 ល្ងាច                       | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987, 12:13 ល្ងាច                       | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987, 12:13 ល្ងាច                       | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987, 12:13 ល្ងាច                       | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987, 12:13 ល្ងាច                       | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987, 12:13 ល្ងាច                       | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987, 12:13 ល្ងាច                       | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987, 12:13 ល្ងាច                       | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11 មករា 1987, 12:13:14 ល្ងាច                  | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 កុម្ភៈ 1987, 12:13:14 ល្ងាច                | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 មីនា 1987, 12:13:14 ល្ងាច                  | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 មេសា 1987, 12:13:14 ល្ងាច                  | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 ឧសភា 1453, 11:59:59 ល្ងាច                  | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 មិថុនា 1987, 12:13:14 ល្ងាច                | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 កក្កដា 1987, 12:13:14 ល្ងាច                | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 សីហា 1987, 12:13:14 ល្ងាច                  | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 កញ្ញា 1987, 12:13:14 ល្ងាច                 | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 តុលា 1987, 12:13:14 ល្ងាច                  | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 វិច្ឆិកា 1987, 12:13:14 ល្ងាច              | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ធ្នូ 1987, 12:13:14 ល្ងាច                  | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11 មករា 1987 ម៉ោង 12:13:14 ល្ងាច              | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 កុម្ភៈ 1987 ម៉ោង 12:13:14 ល្ងាច            | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 មីនា 1987 ម៉ោង 12:13:14 ល្ងាច              | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 មេសា 1987 ម៉ោង 12:13:14 ល្ងាច              | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 ឧសភា 1453 ម៉ោង 11:59:59 ល្ងាច              | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 មិថុនា 1987 ម៉ោង 12:13:14 ល្ងាច            | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 កក្កដា 1987 ម៉ោង 12:13:14 ល្ងាច            | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 សីហា 1987 ម៉ោង 12:13:14 ល្ងាច              | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 កញ្ញា 1987 ម៉ោង 12:13:14 ល្ងាច             | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 តុលា 1987 ម៉ោង 12:13:14 ល្ងាច              | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 វិច្ឆិកា 1987 ម៉ោង 12:13:14 ល្ងាច          | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ធ្នូ 1987 ម៉ោង 12:13:14 ល្ងាច              | 1987-12-11T12:13:14.000Z |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | អាទិត្យ 11 មករា 1987 ម៉ោង 12:13:14 ល្ងាច      | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | ពុធ 11 កុម្ភៈ 1987 ម៉ោង 12:13:14 ល្ងាច        | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | ពុធ 11 មីនា 1987 ម៉ោង 12:13:14 ល្ងាច          | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | សៅរ៍ 11 មេសា 1987 ម៉ោង 12:13:14 ល្ងាច         | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | អាទិត្យ 29 ឧសភា 1453 ម៉ោង 11:59:59 ល្ងាច      | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | ព្រហស្បតិ៍ 11 មិថុនា 1987 ម៉ោង 12:13:14 ល្ងាច | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | សៅរ៍ 11 កក្កដា 1987 ម៉ោង 12:13:14 ល្ងាច       | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | អង្គារ 11 សីហា 1987 ម៉ោង 12:13:14 ល្ងាច       | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | សុក្រ 11 កញ្ញា 1987 ម៉ោង 12:13:14 ល្ងាច       | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | អាទិត្យ 11 តុលា 1987 ម៉ោង 12:13:14 ល្ងាច      | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | ពុធ 11 វិច្ឆិកា 1987 ម៉ោង 12:13:14 ល្ងាច      | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | សុក្រ 11 ធ្នូ 1987 ម៉ោង 12:13:14 ល្ងាច        | 1987-12-11T12:13:14.000Z |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result         | `includeSeconds: true` | `addSuffix: true`          |
| ------------------------ | -------------- | ---------------------- | -------------------------- |
| 2006-01-01T00:00:00.000Z | ប្រហែល 6 ឆ្នាំ | ប្រហែល 6 ឆ្នាំ         | ក្នុងរយៈពេល ប្រហែល 6 ឆ្នាំ |
| 2005-01-01T00:00:00.000Z | ប្រហែល 5 ឆ្នាំ | ប្រហែល 5 ឆ្នាំ         | ក្នុងរយៈពេល ប្រហែល 5 ឆ្នាំ |
| 2004-01-01T00:00:00.000Z | ប្រហែល 4 ឆ្នាំ | ប្រហែល 4 ឆ្នាំ         | ក្នុងរយៈពេល ប្រហែល 4 ឆ្នាំ |
| 2003-01-01T00:00:00.000Z | ប្រហែល 3 ឆ្នាំ | ប្រហែល 3 ឆ្នាំ         | ក្នុងរយៈពេល ប្រហែល 3 ឆ្នាំ |
| 2002-01-01T00:00:00.000Z | ប្រហែល 2 ឆ្នាំ | ប្រហែល 2 ឆ្នាំ         | ក្នុងរយៈពេល ប្រហែល 2 ឆ្នាំ |
| 2001-06-01T00:00:00.000Z | ជាង 1 ឆ្នាំ    | ជាង 1 ឆ្នាំ            | ក្នុងរយៈពេល ជាង 1 ឆ្នាំ    |
| 2001-02-01T00:00:00.000Z | ប្រហែល 1 ឆ្នាំ | ប្រហែល 1 ឆ្នាំ         | ក្នុងរយៈពេល ប្រហែល 1 ឆ្នាំ |
| 2001-01-01T00:00:00.000Z | ប្រហែល 1 ឆ្នាំ | ប្រហែល 1 ឆ្នាំ         | ក្នុងរយៈពេល ប្រហែល 1 ឆ្នាំ |
| 2000-06-01T00:00:00.000Z | 5 ខែ           | 5 ខែ                   | ក្នុងរយៈពេល 5 ខែ           |
| 2000-03-01T00:00:00.000Z | 2 ខែ           | 2 ខែ                   | ក្នុងរយៈពេល 2 ខែ           |
| 2000-02-01T00:00:00.000Z | ប្រហែល 1 ខែ    | ប្រហែល 1 ខែ            | ក្នុងរយៈពេល ប្រហែល 1 ខែ    |
| 2000-01-15T00:00:00.000Z | 14 ថ្ងៃ        | 14 ថ្ងៃ                | ក្នុងរយៈពេល 14 ថ្ងៃ        |
| 2000-01-02T00:00:00.000Z | 1 ថ្ងៃ         | 1 ថ្ងៃ                 | ក្នុងរយៈពេល 1 ថ្ងៃ         |
| 2000-01-01T06:00:00.000Z | ប្រហែល 6 ម៉ោង  | ប្រហែល 6 ម៉ោង          | ក្នុងរយៈពេល ប្រហែល 6 ម៉ោង  |
| 2000-01-01T01:00:00.000Z | ប្រហែល 1 ម៉ោង  | ប្រហែល 1 ម៉ោង          | ក្នុងរយៈពេល ប្រហែល 1 ម៉ោង  |
| 2000-01-01T00:45:00.000Z | ប្រហែល 1 ម៉ោង  | ប្រហែល 1 ម៉ោង          | ក្នុងរយៈពេល ប្រហែល 1 ម៉ោង  |
| 2000-01-01T00:30:00.000Z | 30 នាទី        | 30 នាទី                | ក្នុងរយៈពេល 30 នាទី        |
| 2000-01-01T00:15:00.000Z | 15 នាទី        | 15 នាទី                | ក្នុងរយៈពេល 15 នាទី        |
| 2000-01-01T00:01:00.000Z | 1 នាទី         | 1 នាទី                 | ក្នុងរយៈពេល 1 នាទី         |
| 2000-01-01T00:00:25.000Z | តិចជាង 1 នាទី  | កន្លះនាទី              | ក្នុងរយៈពេល តិចជាង 1 នាទី  |
| 2000-01-01T00:00:15.000Z | តិចជាង 1 នាទី  | តិចជាង 20 វិនាទី       | ក្នុងរយៈពេល តិចជាង 1 នាទី  |
| 2000-01-01T00:00:05.000Z | តិចជាង 1 នាទី  | តិចជាង 10 វិនាទី       | ក្នុងរយៈពេល តិចជាង 1 នាទី  |
| 2000-01-01T00:00:00.000Z | តិចជាង 1 នាទី  | តិចជាង 5 វិនាទី        | តិចជាង 1 នាទីមុន           |
| 1999-12-31T23:59:55.000Z | តិចជាង 1 នាទី  | តិចជាង 10 វិនាទី       | តិចជាង 1 នាទីមុន           |
| 1999-12-31T23:59:45.000Z | តិចជាង 1 នាទី  | តិចជាង 20 វិនាទី       | តិចជាង 1 នាទីមុន           |
| 1999-12-31T23:59:35.000Z | តិចជាង 1 នាទី  | កន្លះនាទី              | តិចជាង 1 នាទីមុន           |
| 1999-12-31T23:59:00.000Z | 1 នាទី         | 1 នាទី                 | 1 នាទីមុន                  |
| 1999-12-31T23:45:00.000Z | 15 នាទី        | 15 នាទី                | 15 នាទីមុន                 |
| 1999-12-31T23:30:00.000Z | 30 នាទី        | 30 នាទី                | 30 នាទីមុន                 |
| 1999-12-31T23:15:00.000Z | ប្រហែល 1 ម៉ោង  | ប្រហែល 1 ម៉ោង          | ប្រហែល 1 ម៉ោងមុន           |
| 1999-12-31T23:00:00.000Z | ប្រហែល 1 ម៉ោង  | ប្រហែល 1 ម៉ោង          | ប្រហែល 1 ម៉ោងមុន           |
| 1999-12-31T18:00:00.000Z | ប្រហែល 6 ម៉ោង  | ប្រហែល 6 ម៉ោង          | ប្រហែល 6 ម៉ោងមុន           |
| 1999-12-30T00:00:00.000Z | 2 ថ្ងៃ         | 2 ថ្ងៃ                 | 2 ថ្ងៃមុន                  |
| 1999-12-15T00:00:00.000Z | 17 ថ្ងៃ        | 17 ថ្ងៃ                | 17 ថ្ងៃមុន                 |
| 1999-12-01T00:00:00.000Z | ប្រហែល 1 ខែ    | ប្រហែល 1 ខែ            | ប្រហែល 1 ខែមុន             |
| 1999-11-01T00:00:00.000Z | 2 ខែ           | 2 ខែ                   | 2 ខែមុន                    |
| 1999-06-01T00:00:00.000Z | 7 ខែ           | 7 ខែ                   | 7 ខែមុន                    |
| 1999-01-01T00:00:00.000Z | ប្រហែល 1 ឆ្នាំ | ប្រហែល 1 ឆ្នាំ         | ប្រហែល 1 ឆ្នាំមុន          |
| 1998-12-01T00:00:00.000Z | ប្រហែល 1 ឆ្នាំ | ប្រហែល 1 ឆ្នាំ         | ប្រហែល 1 ឆ្នាំមុន          |
| 1998-06-01T00:00:00.000Z | ជាង 1 ឆ្នាំ    | ជាង 1 ឆ្នាំ            | ជាង 1 ឆ្នាំមុន             |
| 1998-01-01T00:00:00.000Z | ប្រហែល 2 ឆ្នាំ | ប្រហែល 2 ឆ្នាំ         | ប្រហែល 2 ឆ្នាំមុន          |
| 1997-01-01T00:00:00.000Z | ប្រហែល 3 ឆ្នាំ | ប្រហែល 3 ឆ្នាំ         | ប្រហែល 3 ឆ្នាំមុន          |
| 1996-01-01T00:00:00.000Z | ប្រហែល 4 ឆ្នាំ | ប្រហែល 4 ឆ្នាំ         | ប្រហែល 4 ឆ្នាំមុន          |
| 1995-01-01T00:00:00.000Z | ប្រហែល 5 ឆ្នាំ | ប្រហែល 5 ឆ្នាំ         | ប្រហែល 5 ឆ្នាំមុន          |
| 1994-01-01T00:00:00.000Z | ប្រហែល 6 ឆ្នាំ | ប្រហែល 6 ឆ្នាំ         | ប្រហែល 6 ឆ្នាំមុន          |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result    | `addSuffix: true`     | With forced unit (i.e. `hour`) |
| ------------------------ | --------- | --------------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 ឆ្នាំ   | ក្នុងរយៈពេល 6 ឆ្នាំ   | 52608 ម៉ោង                     |
| 2005-01-01T00:00:00.000Z | 5 ឆ្នាំ   | ក្នុងរយៈពេល 5 ឆ្នាំ   | 43848 ម៉ោង                     |
| 2004-01-01T00:00:00.000Z | 4 ឆ្នាំ   | ក្នុងរយៈពេល 4 ឆ្នាំ   | 35064 ម៉ោង                     |
| 2003-01-01T00:00:00.000Z | 3 ឆ្នាំ   | ក្នុងរយៈពេល 3 ឆ្នាំ   | 26304 ម៉ោង                     |
| 2002-01-01T00:00:00.000Z | 2 ឆ្នាំ   | ក្នុងរយៈពេល 2 ឆ្នាំ   | 17544 ម៉ោង                     |
| 2001-06-01T00:00:00.000Z | 1 ឆ្នាំ   | ក្នុងរយៈពេល 1 ឆ្នាំ   | 12408 ម៉ោង                     |
| 2001-02-01T00:00:00.000Z | 1 ឆ្នាំ   | ក្នុងរយៈពេល 1 ឆ្នាំ   | 9528 ម៉ោង                      |
| 2001-01-01T00:00:00.000Z | 1 ឆ្នាំ   | ក្នុងរយៈពេល 1 ឆ្នាំ   | 8784 ម៉ោង                      |
| 2000-06-01T00:00:00.000Z | 5 ខែ      | ក្នុងរយៈពេល 5 ខែ      | 3648 ម៉ោង                      |
| 2000-03-01T00:00:00.000Z | 2 ខែ      | ក្នុងរយៈពេល 2 ខែ      | 1440 ម៉ោង                      |
| 2000-02-01T00:00:00.000Z | 1 ខែ      | ក្នុងរយៈពេល 1 ខែ      | 744 ម៉ោង                       |
| 2000-01-15T00:00:00.000Z | 14 ថ្ងៃ   | ក្នុងរយៈពេល 14 ថ្ងៃ   | 336 ម៉ោង                       |
| 2000-01-02T00:00:00.000Z | 1 ថ្ងៃ    | ក្នុងរយៈពេល 1 ថ្ងៃ    | 24 ម៉ោង                        |
| 2000-01-01T06:00:00.000Z | 6 ម៉ោង    | ក្នុងរយៈពេល 6 ម៉ោង    | 6 ម៉ោង                         |
| 2000-01-01T01:00:00.000Z | 1 ម៉ោង    | ក្នុងរយៈពេល 1 ម៉ោង    | 1 ម៉ោង                         |
| 2000-01-01T00:45:00.000Z | 45 នាទី   | ក្នុងរយៈពេល 45 នាទី   | 1 ម៉ោង                         |
| 2000-01-01T00:30:00.000Z | 30 នាទី   | ក្នុងរយៈពេល 30 នាទី   | 1 ម៉ោង                         |
| 2000-01-01T00:15:00.000Z | 15 នាទី   | ក្នុងរយៈពេល 15 នាទី   | 0 ម៉ោង                         |
| 2000-01-01T00:01:00.000Z | 1 នាទី    | ក្នុងរយៈពេល 1 នាទី    | 0 ម៉ោង                         |
| 2000-01-01T00:00:25.000Z | 25 វិនាទី | ក្នុងរយៈពេល 25 វិនាទី | 0 ម៉ោង                         |
| 2000-01-01T00:00:15.000Z | 15 វិនាទី | ក្នុងរយៈពេល 15 វិនាទី | 0 ម៉ោង                         |
| 2000-01-01T00:00:05.000Z | 5 វិនាទី  | ក្នុងរយៈពេល 5 វិនាទី  | 0 ម៉ោង                         |
| 2000-01-01T00:00:00.000Z | 0 វិនាទី  | 0 វិនាទីមុន           | 0 ម៉ោង                         |
| 1999-12-31T23:59:55.000Z | 5 វិនាទី  | 5 វិនាទីមុន           | 0 ម៉ោង                         |
| 1999-12-31T23:59:45.000Z | 15 វិនាទី | 15 វិនាទីមុន          | 0 ម៉ោង                         |
| 1999-12-31T23:59:35.000Z | 25 វិនាទី | 25 វិនាទីមុន          | 0 ម៉ោង                         |
| 1999-12-31T23:59:00.000Z | 1 នាទី    | 1 នាទីមុន             | 0 ម៉ោង                         |
| 1999-12-31T23:45:00.000Z | 15 នាទី   | 15 នាទីមុន            | 0 ម៉ោង                         |
| 1999-12-31T23:30:00.000Z | 30 នាទី   | 30 នាទីមុន            | 1 ម៉ោង                         |
| 1999-12-31T23:15:00.000Z | 45 នាទី   | 45 នាទីមុន            | 1 ម៉ោង                         |
| 1999-12-31T23:00:00.000Z | 1 ម៉ោង    | 1 ម៉ោងមុន             | 1 ម៉ោង                         |
| 1999-12-31T18:00:00.000Z | 6 ម៉ោង    | 6 ម៉ោងមុន             | 6 ម៉ោង                         |
| 1999-12-30T00:00:00.000Z | 2 ថ្ងៃ    | 2 ថ្ងៃមុន             | 48 ម៉ោង                        |
| 1999-12-15T00:00:00.000Z | 17 ថ្ងៃ   | 17 ថ្ងៃមុន            | 408 ម៉ោង                       |
| 1999-12-01T00:00:00.000Z | 1 ខែ      | 1 ខែមុន               | 744 ម៉ោង                       |
| 1999-11-01T00:00:00.000Z | 2 ខែ      | 2 ខែមុន               | 1464 ម៉ោង                      |
| 1999-06-01T00:00:00.000Z | 7 ខែ      | 7 ខែមុន               | 5136 ម៉ោង                      |
| 1999-01-01T00:00:00.000Z | 1 ឆ្នាំ   | 1 ឆ្នាំមុន            | 8760 ម៉ោង                      |
| 1998-12-01T00:00:00.000Z | 1 ឆ្នាំ   | 1 ឆ្នាំមុន            | 9504 ម៉ោង                      |
| 1998-06-01T00:00:00.000Z | 2 ឆ្នាំ   | 2 ឆ្នាំមុន            | 13896 ម៉ោង                     |
| 1998-01-01T00:00:00.000Z | 2 ឆ្នាំ   | 2 ឆ្នាំមុន            | 17520 ម៉ោង                     |
| 1997-01-01T00:00:00.000Z | 3 ឆ្នាំ   | 3 ឆ្នាំមុន            | 26280 ម៉ោង                     |
| 1996-01-01T00:00:00.000Z | 4 ឆ្នាំ   | 4 ឆ្នាំមុន            | 35064 ម៉ោង                     |
| 1995-01-01T00:00:00.000Z | 5 ឆ្នាំ   | 5 ឆ្នាំមុន            | 43824 ម៉ោង                     |
| 1994-01-01T00:00:00.000Z | 6 ឆ្នាំ   | 6 ឆ្នាំមុន            | 52584 ម៉ោង                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                                 |
| ------------------------ | -------------------------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000                             |
| 2000-01-05T00:00:00.000Z | ថ្ងៃពុធស​ប្តា​ហ៍​ក្រោយម៉ោង 12:00 ព្រឹក |
| 2000-01-02T00:00:00.000Z | ថ្ងៃស្អែកម៉ោង 12:00 ព្រឹក              |
| 2000-01-01T00:00:00.000Z | ថ្ងៃនេះម៉ោង 12:00 ព្រឹក                |
| 1999-12-31T00:00:00.000Z | ម្សិលមិញនៅម៉ោង 12:00 ព្រឹក             |
| 1999-12-27T00:00:00.000Z | ថ្ងៃចន្ទស​ប្តា​ហ៍​មុនម៉ោង 12:00 ព្រឹក  |
| 1999-12-21T00:00:00.000Z | 21/12/1999                             |

## `formatDuration`

| Duration      | Result    |
| ------------- | --------- |
| {"years":0}   | 0 ឆ្នាំ   |
| {"years":1}   | 1 ឆ្នាំ   |
| {"years":2}   | 2 ឆ្នាំ   |
| {"months":0}  | 0 ខែ      |
| {"months":1}  | 1 ខែ      |
| {"months":2}  | 2 ខែ      |
| {"weeks":0}   | 0 សប្តាហ៍ |
| {"weeks":1}   | 1 សប្តាហ៍ |
| {"weeks":2}   | 2 សប្តាហ៍ |
| {"days":0}    | 0 ថ្ងៃ    |
| {"days":1}    | 1 ថ្ងៃ    |
| {"days":2}    | 2 ថ្ងៃ    |
| {"hours":0}   | 0 ម៉ោង    |
| {"hours":1}   | 1 ម៉ោង    |
| {"hours":2}   | 2 ម៉ោង    |
| {"minutes":0} | 0 នាទី    |
| {"minutes":1} | 1 នាទី    |
| {"minutes":2} | 2 នាទី    |
| {"seconds":0} | 0 វិនាទី  |
| {"seconds":1} | 1 វិនាទី  |
| {"seconds":2} | 2 វិនាទី  |
