# Georgian (ka) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                           | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | --------------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987-ე                                                    | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-ე                                                       | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987-ე                                                    | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-ე                                                       | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1-ლი                                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ე                                                       | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1-ლი კვ                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ე კვ                                                    | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1-ლი კვარტალი                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ე კვარტალი                                              | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                         | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1-ლი                                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ე                                                       | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1-ლი კვ                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ე კვ                                                    | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1-ლი კვარტალი                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ე კვარტალი                                              | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1-ლი                                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2-ე                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3-ე                                                       | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4-ე                                                       | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5-ე                                                       | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6-ე                                                       | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-ე                                                       | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8-ე                                                       | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9-ე                                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10-ე                                                      | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11-ე                                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12-ე                                                      | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | იან                                                       | Invalid Date             |
|                                 |              | 2019-02-11T12:13:14.015Z | თებ                                                       | Invalid Date             |
|                                 |              | 2019-03-11T12:13:14.015Z | მარ                                                       | Invalid Date             |
|                                 |              | 2019-04-10T12:13:14.015Z | აპრ                                                       | Invalid Date             |
|                                 |              | 2019-05-10T12:13:14.015Z | მაი                                                       | Invalid Date             |
|                                 |              | 2019-06-10T12:13:14.015Z | ივნ                                                       | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | ივლ                                                       | Invalid Date             |
|                                 |              | 2019-08-10T12:13:14.015Z | აგვ                                                       | Invalid Date             |
|                                 |              | 2019-09-10T12:13:14.015Z | სექ                                                       | Invalid Date             |
|                                 |              | 2019-10-10T12:13:14.015Z | ოქტ                                                       | Invalid Date             |
|                                 |              | 2019-11-10T12:13:14.015Z | ნოე                                                       | Invalid Date             |
|                                 |              | 2019-12-10T12:13:14.015Z | დეკ                                                       | Invalid Date             |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | იანვარი                                                   | Invalid Date             |
|                                 |              | 2019-02-11T12:13:14.015Z | თებერვალი                                                 | Invalid Date             |
|                                 |              | 2019-03-11T12:13:14.015Z | მარტი                                                     | Invalid Date             |
|                                 |              | 2019-04-10T12:13:14.015Z | აპრილი                                                    | Invalid Date             |
|                                 |              | 2019-05-10T12:13:14.015Z | მაისი                                                     | Invalid Date             |
|                                 |              | 2019-06-10T12:13:14.015Z | ივნისი                                                    | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | ივლისი                                                    | Invalid Date             |
|                                 |              | 2019-08-10T12:13:14.015Z | აგვისტო                                                   | Invalid Date             |
|                                 |              | 2019-09-10T12:13:14.015Z | სექტემბერი                                                | Invalid Date             |
|                                 |              | 2019-10-10T12:13:14.015Z | ოქტომბერი                                                 | Invalid Date             |
|                                 |              | 2019-11-10T12:13:14.015Z | ნოემბერი                                                  | Invalid Date             |
|                                 |              | 2019-12-10T12:13:14.015Z | დეკემბერი                                                 | Invalid Date             |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | ია                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | თე                                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | მა                                                        | Invalid Date             |
|                                 |              | 2019-04-10T12:13:14.015Z | აპ                                                        | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | მს                                                        | Invalid Date             |
|                                 |              | 2019-06-10T12:13:14.015Z | ვნ                                                        | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ვლ                                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | აგ                                                        | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | სე                                                        | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ოქ                                                        | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ნო                                                        | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | დე                                                        | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1-ლი                                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2-ე                                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3-ე                                                       | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4-ე                                                       | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5-ე                                                       | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6-ე                                                       | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-ე                                                       | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8-ე                                                       | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9-ე                                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10-ე                                                      | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11-ე                                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12-ე                                                      | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | იან                                                       | Invalid Date             |
|                                 |              | 2019-02-11T12:13:14.015Z | თებ                                                       | Invalid Date             |
|                                 |              | 2019-03-11T12:13:14.015Z | მარ                                                       | Invalid Date             |
|                                 |              | 2019-04-10T12:13:14.015Z | აპრ                                                       | Invalid Date             |
|                                 |              | 2019-05-10T12:13:14.015Z | მაი                                                       | Invalid Date             |
|                                 |              | 2019-06-10T12:13:14.015Z | ივნ                                                       | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | ივლ                                                       | Invalid Date             |
|                                 |              | 2019-08-10T12:13:14.015Z | აგვ                                                       | Invalid Date             |
|                                 |              | 2019-09-10T12:13:14.015Z | სექ                                                       | Invalid Date             |
|                                 |              | 2019-10-10T12:13:14.015Z | ოქტ                                                       | Invalid Date             |
|                                 |              | 2019-11-10T12:13:14.015Z | ნოე                                                       | Invalid Date             |
|                                 |              | 2019-12-10T12:13:14.015Z | დეკ                                                       | Invalid Date             |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | იანვარი                                                   | Invalid Date             |
|                                 |              | 2019-02-11T12:13:14.015Z | თებერვალი                                                 | Invalid Date             |
|                                 |              | 2019-03-11T12:13:14.015Z | მარტი                                                     | Invalid Date             |
|                                 |              | 2019-04-10T12:13:14.015Z | აპრილი                                                    | Invalid Date             |
|                                 |              | 2019-05-10T12:13:14.015Z | მაისი                                                     | Invalid Date             |
|                                 |              | 2019-06-10T12:13:14.015Z | ივნისი                                                    | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | ივლისი                                                    | Invalid Date             |
|                                 |              | 2019-08-10T12:13:14.015Z | აგვისტო                                                   | Invalid Date             |
|                                 |              | 2019-09-10T12:13:14.015Z | სექტემბერი                                                | Invalid Date             |
|                                 |              | 2019-10-10T12:13:14.015Z | ოქტომბერი                                                 | Invalid Date             |
|                                 |              | 2019-11-10T12:13:14.015Z | ნოემბერი                                                  | Invalid Date             |
|                                 |              | 2019-12-10T12:13:14.015Z | დეკემბერი                                                 | Invalid Date             |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | ია                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | თე                                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | მა                                                        | Invalid Date             |
|                                 |              | 2019-04-10T12:13:14.015Z | აპ                                                        | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | მს                                                        | Invalid Date             |
|                                 |              | 2019-06-10T12:13:14.015Z | ვნ                                                        | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ვლ                                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | აგ                                                        | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | სე                                                        | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ოქ                                                        | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ნო                                                        | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | დე                                                        | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1-ლი                                                      | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-ე                                                      | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1-ლი                                                      | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-ე                                                      | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1-ლი                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11-ე                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28-ე                                                      | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1-ლი თებერვალი                                            | Invalid Date             |
|                                 |              | 2019-02-11T12:13:14.015Z | 11-ე თებერვალი                                            | Invalid Date             |
|                                 |              | 2019-02-28T12:13:14.015Z | 28-ე თებერვალი                                            | Invalid Date             |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42-ე                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365-ე                                                     | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | ორშ                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პარ                                                       | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | ორშ                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პარ                                                       | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | ორშ                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პარ                                                       | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | ორშაბათი                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პარასკევი                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | ორ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პა                                                        | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | ორშ                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პარ                                                       | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1-ლი                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-ე                                                       | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | ორშ                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პარ                                                       | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | ორშაბათი                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პარასკევი                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | ორ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პა                                                        | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | ორშ                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პარ                                                       | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1-ლი                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-ე                                                       | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | ორშ                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პარ                                                       | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | ორშაბათი                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პარასკევი                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | ორ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პა                                                        | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | ორშ                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პარ                                                       | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1-ლი                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-ე                                                       | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | ორშ                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პარ                                                       | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | ორშაბათი                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პარასკევი                                                 | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | ორ                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პა                                                        | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | ორშ                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | პარ                                                       | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                        | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                        | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | am                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                        | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | a.m.                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                      | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | a                                                         | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                         | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                         | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                         | Invalid Date             |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                        | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                        | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | am                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                                        | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | a.m.                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                      | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | a                                                         | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                         | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                         | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                         | Invalid Date             |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | დილით                                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | ნაშუადღევს                                                | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | საღამოს                                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ღამით                                                     | Invalid Date             |
|                                 | BB           | 2019-02-11T11:13:14.015Z | დილით                                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | ნაშუადღევს                                                | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | საღამოს                                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ღამით                                                     | Invalid Date             |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | დილით                                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | ნაშუადღევს                                                | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | საღამოს                                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ღამით                                                     | Invalid Date             |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | დილით                                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | ნაშუადღევს                                                | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | საღამოს                                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ღამით                                                     | Invalid Date             |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | დილით                                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | ნაშუადღევს                                                | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | საღამოს                                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ღამით                                                     | Invalid Date             |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11-ე                                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-ე                                                      | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11-ე                                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-ე                                                      | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11-ე                                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-ე                                                      | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11-ე                                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-ე                                                      | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1-ლი                                                      | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55-ე                                                      | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1-ლი                                                      | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55-ე                                                      | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11/01/1987                                                | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987                                                | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987                                                | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987                                                | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                                | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987                                                | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987                                                | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987                                                | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987                                                | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987                                                | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987                                                | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987                                                | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11, იან, 1987                                             | Invalid Date             |
|                                 |              | 1987-02-11T12:13:14.015Z | 11, თებ, 1987                                             | Invalid Date             |
|                                 |              | 1987-03-11T12:13:14.015Z | 11, მარ, 1987                                             | Invalid Date             |
|                                 |              | 1987-04-11T12:13:14.015Z | 11, აპრ, 1987                                             | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29, მაი, 1453                                             | Invalid Date             |
|                                 |              | 1987-06-11T12:13:14.015Z | 11, ივნ, 1987                                             | Invalid Date             |
|                                 |              | 1987-07-11T12:13:14.015Z | 11, ივლ, 1987                                             | Invalid Date             |
|                                 |              | 1987-08-11T12:13:14.015Z | 11, აგვ, 1987                                             | Invalid Date             |
|                                 |              | 1987-09-11T12:13:14.015Z | 11, სექ, 1987                                             | Invalid Date             |
|                                 |              | 1987-10-11T12:13:14.015Z | 11, ოქტ, 1987                                             | Invalid Date             |
|                                 |              | 1987-11-11T12:13:14.015Z | 11, ნოე, 1987                                             | Invalid Date             |
|                                 |              | 1987-12-11T12:13:14.015Z | 11, დეკ, 1987                                             | Invalid Date             |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11-ე, იანვარი, 1987                                       | Invalid Date             |
|                                 |              | 1987-02-11T12:13:14.015Z | 11-ე, თებერვალი, 1987                                     | Invalid Date             |
|                                 |              | 1987-03-11T12:13:14.015Z | 11-ე, მარტი, 1987                                         | Invalid Date             |
|                                 |              | 1987-04-11T12:13:14.015Z | 11-ე, აპრილი, 1987                                        | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29-ე, მაისი, 1453                                         | Invalid Date             |
|                                 |              | 1987-06-11T12:13:14.015Z | 11-ე, ივნისი, 1987                                        | Invalid Date             |
|                                 |              | 1987-07-11T12:13:14.015Z | 11-ე, ივლისი, 1987                                        | Invalid Date             |
|                                 |              | 1987-08-11T12:13:14.015Z | 11-ე, აგვისტო, 1987                                       | Invalid Date             |
|                                 |              | 1987-09-11T12:13:14.015Z | 11-ე, სექტემბერი, 1987                                    | Invalid Date             |
|                                 |              | 1987-10-11T12:13:14.015Z | 11-ე, ოქტომბერი, 1987                                     | Invalid Date             |
|                                 |              | 1987-11-11T12:13:14.015Z | 11-ე, ნოემბერი, 1987                                      | Invalid Date             |
|                                 |              | 1987-12-11T12:13:14.015Z | 11-ე, დეკემბერი, 1987                                     | Invalid Date             |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | კვირა, 11-ე იანვარი, 1987                                 | Invalid Date             |
|                                 |              | 1987-02-11T12:13:14.015Z | ოთხშაბათი, 11-ე თებერვალი, 1987                           | Invalid Date             |
|                                 |              | 1987-03-11T12:13:14.015Z | ოთხშაბათი, 11-ე მარტი, 1987                               | Invalid Date             |
|                                 |              | 1987-04-11T12:13:14.015Z | შაბათი, 11-ე აპრილი, 1987                                 | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | კვირა, 29-ე მაისი, 1453                                   | Invalid Date             |
|                                 |              | 1987-06-11T12:13:14.015Z | ხუთშაბათი, 11-ე ივნისი, 1987                              | Invalid Date             |
|                                 |              | 1987-07-11T12:13:14.015Z | შაბათი, 11-ე ივლისი, 1987                                 | Invalid Date             |
|                                 |              | 1987-08-11T12:13:14.015Z | სამშაბათი, 11-ე აგვისტო, 1987                             | Invalid Date             |
|                                 |              | 1987-09-11T12:13:14.015Z | პარასკევი, 11-ე სექტემბერი, 1987                          | Invalid Date             |
|                                 |              | 1987-10-11T12:13:14.015Z | კვირა, 11-ე ოქტომბერი, 1987                               | Invalid Date             |
|                                 |              | 1987-11-11T12:13:14.015Z | ოთხშაბათი, 11-ე ნოემბერი, 1987                            | Invalid Date             |
|                                 |              | 1987-12-11T12:13:14.015Z | პარასკევი, 11-ე დეკემბერი, 1987                           | Invalid Date             |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13 PM                                                  | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13 PM                                                  | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13 PM                                                  | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13 PM                                                  | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59 PM                                                  | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13 PM                                                  | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13 PM                                                  | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13 PM                                                  | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13 PM                                                  | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13 PM                                                  | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13 PM                                                  | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13 PM                                                  | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14 PM                                               | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 PM                                               | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 PM                                               | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 PM                                               | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 PM                                               | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 PM                                               | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 PM                                               | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 PM                                               | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 PM                                               | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 PM                                               | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 PM                                               | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 PM                                               | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 PM GMT+0                                         | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 PM GMT+0                                         | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 PM GMT+0                                         | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 PM GMT+0                                         | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 PM GMT+0                                         | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 PM GMT+0                                         | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 PM GMT+0                                         | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 PM GMT+0                                         | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 PM GMT+0                                         | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 PM GMT+0                                         | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 PM GMT+0                                         | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 PM GMT+0                                         | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 PM GMT+00:00                                     | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 PM GMT+00:00                                     | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 PM GMT+00:00                                     | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 PM GMT+00:00                                     | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 11:59:59 PM GMT+00:00                                     | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 PM GMT+00:00                                     | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 PM GMT+00:00                                     | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 PM GMT+00:00                                     | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 PM GMT+00:00                                     | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 PM GMT+00:00                                     | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 PM GMT+00:00                                     | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 PM GMT+00:00                                     | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11/01/1987, 12:13 PM                                      | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987, 12:13 PM                                      | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987, 12:13 PM                                      | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987, 12:13 PM                                      | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453, 11:59 PM                                      | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987, 12:13 PM                                      | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987, 12:13 PM                                      | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987, 12:13 PM                                      | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987, 12:13 PM                                      | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987, 12:13 PM                                      | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987, 12:13 PM                                      | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987, 12:13 PM                                      | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11, იან, 1987, 12:13:14 PM                                | Invalid Date             |
|                                 |              | 1987-02-11T12:13:14.015Z | 11, თებ, 1987, 12:13:14 PM                                | Invalid Date             |
|                                 |              | 1987-03-11T12:13:14.015Z | 11, მარ, 1987, 12:13:14 PM                                | Invalid Date             |
|                                 |              | 1987-04-11T12:13:14.015Z | 11, აპრ, 1987, 12:13:14 PM                                | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29, მაი, 1453, 11:59:59 PM                                | Invalid Date             |
|                                 |              | 1987-06-11T12:13:14.015Z | 11, ივნ, 1987, 12:13:14 PM                                | Invalid Date             |
|                                 |              | 1987-07-11T12:13:14.015Z | 11, ივლ, 1987, 12:13:14 PM                                | Invalid Date             |
|                                 |              | 1987-08-11T12:13:14.015Z | 11, აგვ, 1987, 12:13:14 PM                                | Invalid Date             |
|                                 |              | 1987-09-11T12:13:14.015Z | 11, სექ, 1987, 12:13:14 PM                                | Invalid Date             |
|                                 |              | 1987-10-11T12:13:14.015Z | 11, ოქტ, 1987, 12:13:14 PM                                | Invalid Date             |
|                                 |              | 1987-11-11T12:13:14.015Z | 11, ნოე, 1987, 12:13:14 PM                                | Invalid Date             |
|                                 |              | 1987-12-11T12:13:14.015Z | 11, დეკ, 1987, 12:13:14 PM                                | Invalid Date             |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11-ე, იანვარი, 1987 12:13:14 PM GMT+0-ზე                  | Invalid Date             |
|                                 |              | 1987-02-11T12:13:14.015Z | 11-ე, თებერვალი, 1987 12:13:14 PM GMT+0-ზე                | Invalid Date             |
|                                 |              | 1987-03-11T12:13:14.015Z | 11-ე, მარტი, 1987 12:13:14 PM GMT+0-ზე                    | Invalid Date             |
|                                 |              | 1987-04-11T12:13:14.015Z | 11-ე, აპრილი, 1987 12:13:14 PM GMT+0-ზე                   | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29-ე, მაისი, 1453 11:59:59 PM GMT+0-ზე                    | Invalid Date             |
|                                 |              | 1987-06-11T12:13:14.015Z | 11-ე, ივნისი, 1987 12:13:14 PM GMT+0-ზე                   | Invalid Date             |
|                                 |              | 1987-07-11T12:13:14.015Z | 11-ე, ივლისი, 1987 12:13:14 PM GMT+0-ზე                   | Invalid Date             |
|                                 |              | 1987-08-11T12:13:14.015Z | 11-ე, აგვისტო, 1987 12:13:14 PM GMT+0-ზე                  | Invalid Date             |
|                                 |              | 1987-09-11T12:13:14.015Z | 11-ე, სექტემბერი, 1987 12:13:14 PM GMT+0-ზე               | Invalid Date             |
|                                 |              | 1987-10-11T12:13:14.015Z | 11-ე, ოქტომბერი, 1987 12:13:14 PM GMT+0-ზე                | Invalid Date             |
|                                 |              | 1987-11-11T12:13:14.015Z | 11-ე, ნოემბერი, 1987 12:13:14 PM GMT+0-ზე                 | Invalid Date             |
|                                 |              | 1987-12-11T12:13:14.015Z | 11-ე, დეკემბერი, 1987 12:13:14 PM GMT+0-ზე                | Invalid Date             |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | კვირა, 11-ე იანვარი, 1987 12:13:14 PM GMT+00:00-ზე        | Invalid Date             |
|                                 |              | 1987-02-11T12:13:14.015Z | ოთხშაბათი, 11-ე თებერვალი, 1987 12:13:14 PM GMT+00:00-ზე  | Invalid Date             |
|                                 |              | 1987-03-11T12:13:14.015Z | ოთხშაბათი, 11-ე მარტი, 1987 12:13:14 PM GMT+00:00-ზე      | Invalid Date             |
|                                 |              | 1987-04-11T12:13:14.015Z | შაბათი, 11-ე აპრილი, 1987 12:13:14 PM GMT+00:00-ზე        | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | კვირა, 29-ე მაისი, 1453 11:59:59 PM GMT+00:00-ზე          | Invalid Date             |
|                                 |              | 1987-06-11T12:13:14.015Z | ხუთშაბათი, 11-ე ივნისი, 1987 12:13:14 PM GMT+00:00-ზე     | Invalid Date             |
|                                 |              | 1987-07-11T12:13:14.015Z | შაბათი, 11-ე ივლისი, 1987 12:13:14 PM GMT+00:00-ზე        | Invalid Date             |
|                                 |              | 1987-08-11T12:13:14.015Z | სამშაბათი, 11-ე აგვისტო, 1987 12:13:14 PM GMT+00:00-ზე    | Invalid Date             |
|                                 |              | 1987-09-11T12:13:14.015Z | პარასკევი, 11-ე სექტემბერი, 1987 12:13:14 PM GMT+00:00-ზე | Invalid Date             |
|                                 |              | 1987-10-11T12:13:14.015Z | კვირა, 11-ე ოქტომბერი, 1987 12:13:14 PM GMT+00:00-ზე      | Invalid Date             |
|                                 |              | 1987-11-11T12:13:14.015Z | ოთხშაბათი, 11-ე ნოემბერი, 1987 12:13:14 PM GMT+00:00-ზე   | Invalid Date             |
|                                 |              | 1987-12-11T12:13:14.015Z | პარასკევი, 11-ე დეკემბერი, 1987 12:13:14 PM GMT+00:00-ზე  | Invalid Date             |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result             | `includeSeconds: true` | `addSuffix: true`        |
| ------------------------ | ------------------ | ---------------------- | ------------------------ |
| 2006-01-01T00:00:00.000Z | დაახლოებით 6 წელი  | დაახლოებით 6 წელი      | დაახლოებით 6 წელში       |
| 2005-01-01T00:00:00.000Z | დაახლოებით 5 წელი  | დაახლოებით 5 წელი      | დაახლოებით 5 წელში       |
| 2004-01-01T00:00:00.000Z | დაახლოებით 4 წელი  | დაახლოებით 4 წელი      | დაახლოებით 4 წელში       |
| 2003-01-01T00:00:00.000Z | დაახლოებით 3 წელი  | დაახლოებით 3 წელი      | დაახლოებით 3 წელში       |
| 2002-01-01T00:00:00.000Z | დაახლოებით 2 წელი  | დაახლოებით 2 წელი      | დაახლოებით 2 წელში       |
| 2001-06-01T00:00:00.000Z | 1 წელზე მეტი       | 1 წელზე მეტი           | 1 წელზე მეტი ხნის შემდეგ |
| 2001-02-01T00:00:00.000Z | დაახლოებით 1 წელი  | დაახლოებით 1 წელი      | დაახლოებით 1 წელში       |
| 2001-01-01T00:00:00.000Z | დაახლოებით 1 წელი  | დაახლოებით 1 წელი      | დაახლოებით 1 წელში       |
| 2000-06-01T00:00:00.000Z | 5 თვე              | 5 თვე                  | 5 თვეში                  |
| 2000-03-01T00:00:00.000Z | 2 თვე              | 2 თვე                  | 2 თვეში                  |
| 2000-02-01T00:00:00.000Z | დაახლოებით 1 თვე   | დაახლოებით 1 თვე       | დაახლოებით 1 თვეში       |
| 2000-01-15T00:00:00.000Z | 14 დღე             | 14 დღე                 | 14 დღეში                 |
| 2000-01-02T00:00:00.000Z | 1 დღე              | 1 დღე                  | 1 დღეში                  |
| 2000-01-01T06:00:00.000Z | დაახლოებით 6 საათი | დაახლოებით 6 საათი     | დაახლოებით 6 საათში      |
| 2000-01-01T01:00:00.000Z | დაახლოებით 1 საათი | დაახლოებით 1 საათი     | დაახლოებით 1 საათში      |
| 2000-01-01T00:45:00.000Z | დაახლოებით 1 საათი | დაახლოებით 1 საათი     | დაახლოებით 1 საათში      |
| 2000-01-01T00:30:00.000Z | 30 წუთი            | 30 წუთი                | 30 წუთში                 |
| 2000-01-01T00:15:00.000Z | 15 წუთი            | 15 წუთი                | 15 წუთში                 |
| 2000-01-01T00:01:00.000Z | 1 წუთი             | 1 წუთი                 | 1 წუთში                  |
| 2000-01-01T00:00:25.000Z | 1 წუთზე ნაკლები    | ნახევარი წუთი          | 1 წუთზე ნაკლებში         |
| 2000-01-01T00:00:15.000Z | 1 წუთზე ნაკლები    | 20 წამზე ნაკლები       | 1 წუთზე ნაკლებში         |
| 2000-01-01T00:00:05.000Z | 1 წუთზე ნაკლები    | 10 წამზე ნაკლები       | 1 წუთზე ნაკლებში         |
| 2000-01-01T00:00:00.000Z | 1 წუთზე ნაკლები    | 5 წამზე ნაკლები        | 1 წუთზე ნაკლები ხნის წინ |
| 1999-12-31T23:59:55.000Z | 1 წუთზე ნაკლები    | 10 წამზე ნაკლები       | 1 წუთზე ნაკლები ხნის წინ |
| 1999-12-31T23:59:45.000Z | 1 წუთზე ნაკლები    | 20 წამზე ნაკლები       | 1 წუთზე ნაკლები ხნის წინ |
| 1999-12-31T23:59:35.000Z | 1 წუთზე ნაკლები    | ნახევარი წუთი          | 1 წუთზე ნაკლები ხნის წინ |
| 1999-12-31T23:59:00.000Z | 1 წუთი             | 1 წუთი                 | 1 წუთის წინ              |
| 1999-12-31T23:45:00.000Z | 15 წუთი            | 15 წუთი                | 15 წუთის წინ             |
| 1999-12-31T23:30:00.000Z | 30 წუთი            | 30 წუთი                | 30 წუთის წინ             |
| 1999-12-31T23:15:00.000Z | დაახლოებით 1 საათი | დაახლოებით 1 საათი     | დაახლოებით 1 საათის წინ  |
| 1999-12-31T23:00:00.000Z | დაახლოებით 1 საათი | დაახლოებით 1 საათი     | დაახლოებით 1 საათის წინ  |
| 1999-12-31T18:00:00.000Z | დაახლოებით 6 საათი | დაახლოებით 6 საათი     | დაახლოებით 6 საათის წინ  |
| 1999-12-30T00:00:00.000Z | 2 დღე              | 2 დღე                  | 2 დღის წინ               |
| 1999-12-15T00:00:00.000Z | 17 დღე             | 17 დღე                 | 17 დღის წინ              |
| 1999-12-01T00:00:00.000Z | დაახლოებით 1 თვე   | დაახლოებით 1 თვე       | დაახლოებით 1 თვის წინ    |
| 1999-11-01T00:00:00.000Z | 2 თვე              | 2 თვე                  | 2 თვის წინ               |
| 1999-06-01T00:00:00.000Z | 7 თვე              | 7 თვე                  | 7 თვის წინ               |
| 1999-01-01T00:00:00.000Z | დაახლოებით 1 წელი  | დაახლოებით 1 წელი      | დაახლოებით 1 წლის წინ    |
| 1998-12-01T00:00:00.000Z | დაახლოებით 1 წელი  | დაახლოებით 1 წელი      | დაახლოებით 1 წლის წინ    |
| 1998-06-01T00:00:00.000Z | 1 წელზე მეტი       | 1 წელზე მეტი           | 1 წელზე მეტი ხნის წინ    |
| 1998-01-01T00:00:00.000Z | დაახლოებით 2 წელი  | დაახლოებით 2 წელი      | დაახლოებით 2 წლის წინ    |
| 1997-01-01T00:00:00.000Z | დაახლოებით 3 წელი  | დაახლოებით 3 წელი      | დაახლოებით 3 წლის წინ    |
| 1996-01-01T00:00:00.000Z | დაახლოებით 4 წელი  | დაახლოებით 4 წელი      | დაახლოებით 4 წლის წინ    |
| 1995-01-01T00:00:00.000Z | დაახლოებით 5 წელი  | დაახლოებით 5 წელი      | დაახლოებით 5 წლის წინ    |
| 1994-01-01T00:00:00.000Z | დაახლოებით 6 წელი  | დაახლოებით 6 წელი      | დაახლოებით 6 წლის წინ    |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result  | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 წელი  | 6 წელში           | 52608 საათი                    |
| 2005-01-01T00:00:00.000Z | 5 წელი  | 5 წელში           | 43848 საათი                    |
| 2004-01-01T00:00:00.000Z | 4 წელი  | 4 წელში           | 35064 საათი                    |
| 2003-01-01T00:00:00.000Z | 3 წელი  | 3 წელში           | 26304 საათი                    |
| 2002-01-01T00:00:00.000Z | 2 წელი  | 2 წელში           | 17544 საათი                    |
| 2001-06-01T00:00:00.000Z | 1 წელი  | 1 წელში           | 12408 საათი                    |
| 2001-02-01T00:00:00.000Z | 1 წელი  | 1 წელში           | 9528 საათი                     |
| 2001-01-01T00:00:00.000Z | 1 წელი  | 1 წელში           | 8784 საათი                     |
| 2000-06-01T00:00:00.000Z | 5 თვე   | 5 თვეში           | 3648 საათი                     |
| 2000-03-01T00:00:00.000Z | 2 თვე   | 2 თვეში           | 1440 საათი                     |
| 2000-02-01T00:00:00.000Z | 1 თვე   | 1 თვეში           | 744 საათი                      |
| 2000-01-15T00:00:00.000Z | 14 დღე  | 14 დღეში          | 336 საათი                      |
| 2000-01-02T00:00:00.000Z | 1 დღე   | 1 დღეში           | 24 საათი                       |
| 2000-01-01T06:00:00.000Z | 6 საათი | 6 საათში          | 6 საათი                        |
| 2000-01-01T01:00:00.000Z | 1 საათი | 1 საათში          | 1 საათი                        |
| 2000-01-01T00:45:00.000Z | 45 წუთი | 45 წუთში          | 1 საათი                        |
| 2000-01-01T00:30:00.000Z | 30 წუთი | 30 წუთში          | 1 საათი                        |
| 2000-01-01T00:15:00.000Z | 15 წუთი | 15 წუთში          | 0 საათი                        |
| 2000-01-01T00:01:00.000Z | 1 წუთი  | 1 წუთში           | 0 საათი                        |
| 2000-01-01T00:00:25.000Z | 25 წამი | 25 წამში          | 0 საათი                        |
| 2000-01-01T00:00:15.000Z | 15 წამი | 15 წამში          | 0 საათი                        |
| 2000-01-01T00:00:05.000Z | 5 წამი  | 5 წამში           | 0 საათი                        |
| 2000-01-01T00:00:00.000Z | 0 წამი  | 0 წამის წინ       | 0 საათი                        |
| 1999-12-31T23:59:55.000Z | 5 წამი  | 5 წამის წინ       | 0 საათი                        |
| 1999-12-31T23:59:45.000Z | 15 წამი | 15 წამის წინ      | 0 საათი                        |
| 1999-12-31T23:59:35.000Z | 25 წამი | 25 წამის წინ      | 0 საათი                        |
| 1999-12-31T23:59:00.000Z | 1 წუთი  | 1 წუთის წინ       | 0 საათი                        |
| 1999-12-31T23:45:00.000Z | 15 წუთი | 15 წუთის წინ      | 0 საათი                        |
| 1999-12-31T23:30:00.000Z | 30 წუთი | 30 წუთის წინ      | 1 საათი                        |
| 1999-12-31T23:15:00.000Z | 45 წუთი | 45 წუთის წინ      | 1 საათი                        |
| 1999-12-31T23:00:00.000Z | 1 საათი | 1 საათის წინ      | 1 საათი                        |
| 1999-12-31T18:00:00.000Z | 6 საათი | 6 საათის წინ      | 6 საათი                        |
| 1999-12-30T00:00:00.000Z | 2 დღე   | 2 დღის წინ        | 48 საათი                       |
| 1999-12-15T00:00:00.000Z | 17 დღე  | 17 დღის წინ       | 408 საათი                      |
| 1999-12-01T00:00:00.000Z | 1 თვე   | 1 თვის წინ        | 744 საათი                      |
| 1999-11-01T00:00:00.000Z | 2 თვე   | 2 თვის წინ        | 1464 საათი                     |
| 1999-06-01T00:00:00.000Z | 7 თვე   | 7 თვის წინ        | 5136 საათი                     |
| 1999-01-01T00:00:00.000Z | 1 წელი  | 1 წლის წინ        | 8760 საათი                     |
| 1998-12-01T00:00:00.000Z | 1 წელი  | 1 წლის წინ        | 9504 საათი                     |
| 1998-06-01T00:00:00.000Z | 2 წელი  | 2 წლის წინ        | 13896 საათი                    |
| 1998-01-01T00:00:00.000Z | 2 წელი  | 2 წლის წინ        | 17520 საათი                    |
| 1997-01-01T00:00:00.000Z | 3 წელი  | 3 წლის წინ        | 26280 საათი                    |
| 1996-01-01T00:00:00.000Z | 4 წელი  | 4 წლის წინ        | 35064 საათი                    |
| 1995-01-01T00:00:00.000Z | 5 წელი  | 5 წლის წინ        | 43824 საათი                    |
| 1994-01-01T00:00:00.000Z | 6 წელი  | 6 წლის წინ        | 52584 საათი                    |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                        |
| ------------------------ | ----------------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000                    |
| 2000-01-05T00:00:00.000Z | შემდეგი ოთხშაბათი 12:00 AM-ზე |
| 2000-01-02T00:00:00.000Z | ხვალ 12:00 AM-ზე              |
| 2000-01-01T00:00:00.000Z | დღეს 12:00 AM-ზე              |
| 1999-12-31T00:00:00.000Z | გუშინ 12:00 AM-ზე             |
| 1999-12-27T00:00:00.000Z | წინა ორშაბათი 12:00 AM-ზე     |
| 1999-12-21T00:00:00.000Z | 21/12/1999                    |

## `formatDuration`

| Duration      | Result  |
| ------------- | ------- |
| {"years":0}   | 0 წელი  |
| {"years":1}   | 1 წელი  |
| {"years":2}   | 2 წელი  |
| {"months":0}  | 0 თვე   |
| {"months":1}  | 1 თვე   |
| {"months":2}  | 2 თვე   |
| {"weeks":0}   | 0 კვირა |
| {"weeks":1}   | 1 კვირა |
| {"weeks":2}   | 2 კვირა |
| {"days":0}    | 0 დღე   |
| {"days":1}    | 1 დღე   |
| {"days":2}    | 2 დღე   |
| {"hours":0}   | 0 საათი |
| {"hours":1}   | 1 საათი |
| {"hours":2}   | 2 საათი |
| {"minutes":0} | 0 წუთი  |
| {"minutes":1} | 1 წუთი  |
| {"minutes":2} | 2 წუთი  |
| {"seconds":0} | 0 წამი  |
| {"seconds":1} | 1 წამი  |
| {"seconds":2} | 2 წამი  |
