# Italian (it) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                               | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | --------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                          | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                             | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                          | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4                                             | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                             | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | T1                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | T2                                            | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1º trimestre                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2º trimestre                                  | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                             | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                             | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | T1                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | T2                                            | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1º trimestre                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2º trimestre                                  | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                             | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                            | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                            | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                            | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | gen                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | feb                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | mar                                           | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | apr                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | mag                                           | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | giu                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | lug                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ago                                           | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | set                                           | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ott                                           | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | nov                                           | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | dic                                           | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | gennaio                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | febbraio                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | marzo                                         | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | aprile                                        | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | maggio                                        | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | giugno                                        | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | luglio                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | agosto                                        | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | settembre                                     | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ottobre                                       | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | novembre                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | dicembre                                      | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | G                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | F                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | M                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | A                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | G                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | L                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | A                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | S                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | O                                             | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | N                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | D                                             | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                             | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                             | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                             | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                            | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                            | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                            | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | gen                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | feb                                           | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | mar                                           | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | apr                                           | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | mag                                           | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | giu                                           | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | lug                                           | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | ago                                           | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | set                                           | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ott                                           | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | nov                                           | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | dic                                           | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | gennaio                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | febbraio                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | marzo                                         | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | aprile                                        | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | maggio                                        | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | giugno                                        | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | luglio                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | agosto                                        | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | settembre                                     | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | ottobre                                       | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | novembre                                      | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | dicembre                                      | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | G                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | F                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | M                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | A                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | M                                             | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | G                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | L                                             | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | A                                             | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | S                                             | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | O                                             | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | N                                             | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | D                                             | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                             | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                            | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                             | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                            | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                            | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1 febbraio                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11 febbraio                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28 febbraio                                   | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                           | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | lun                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                           | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | lun                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                           | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | lun                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                           | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | lunedì                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | venerdì                                       | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | L                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | lun                                           | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                           | Invalid Date             |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                             | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | lun                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                           | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | lunedì                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | venerdì                                       | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | L                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                             | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | lun                                           | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                           | Invalid Date             |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                             | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | lun                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                           | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | lunedì                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | venerdì                                       | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | L                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                             | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | lun                                           | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                           | Invalid Date             |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                             | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | lun                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                           | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | lunedì                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | venerdì                                       | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | L                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                             | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | lun                                           | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                           | Invalid Date             |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | am                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                            | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | m.                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.                                            | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | p.                                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | m.                                            | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | am                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                            | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | m.                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.                                            | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | p.                                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | m.                                            | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | di mattina                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | del pomeriggio                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | di sera                                       | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | di notte                                      | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | di mattina                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | del pomeriggio                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | di sera                                       | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | di notte                                      | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | di mattina                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | del pomeriggio                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | di sera                                       | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | di notte                                      | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | di mattina                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | del pomeriggio                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | di sera                                       | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | di notte                                      | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | di mattina                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | del pomeriggio                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | di sera                                       | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | di notte                                      | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                            | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                            | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                            | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                            | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                             | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                            | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                             | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                            | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11/01/1987                                    | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987                                    | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987                                    | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                    | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987                                    | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987                                    | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987                                    | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987                                    | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987                                    | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987                                    | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987                                    | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11 gen 1987                                   | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 feb 1987                                   | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 mar 1987                                   | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 apr 1987                                   | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mag 1453                                   | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 giu 1987                                   | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 lug 1987                                   | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 ago 1987                                   | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 set 1987                                   | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 ott 1987                                   | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 nov 1987                                   | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 dic 1987                                   | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11 gennaio 1987                               | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 febbraio 1987                              | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 marzo 1987                                 | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 aprile 1987                                | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 maggio 1453                                | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 giugno 1987                                | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 luglio 1987                                | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 agosto 1987                                | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 settembre 1987                             | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 ottobre 1987                               | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 novembre 1987                              | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 dicembre 1987                              | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | domenica 11 gennaio 1987                      | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | mercoledì 11 febbraio 1987                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | mercoledì 11 marzo 1987                       | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | sabato 11 aprile 1987                         | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | domenica 29 maggio 1453                       | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | giovedì 11 giugno 1987                        | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | sabato 11 luglio 1987                         | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | martedì 11 agosto 1987                        | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | venerdì 11 settembre 1987                     | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | domenica 11 ottobre 1987                      | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | mercoledì 11 novembre 1987                    | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | venerdì 11 dicembre 1987                      | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                         | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                         | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                         | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                         | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                         | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                         | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                         | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                         | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                         | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                         | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                         | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                         | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                      | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                      | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                      | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                      | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                      | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                      | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                      | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                      | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                      | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                      | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                      | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                      | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                            | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11/01/1987 12:13                              | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987 12:13                              | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987 12:13                              | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987 12:13                              | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453 23:59                              | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987 12:13                              | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987 12:13                              | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987 12:13                              | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987 12:13                              | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987 12:13                              | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987 12:13                              | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987 12:13                              | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11 gen 1987 12:13:14                          | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 feb 1987 12:13:14                          | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 mar 1987 12:13:14                          | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 apr 1987 12:13:14                          | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mag 1453 23:59:59                          | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 giu 1987 12:13:14                          | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 lug 1987 12:13:14                          | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 ago 1987 12:13:14                          | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 set 1987 12:13:14                          | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 ott 1987 12:13:14                          | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 nov 1987 12:13:14                          | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 dic 1987 12:13:14                          | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11 gennaio 1987 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 febbraio 1987 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 marzo 1987 12:13:14 GMT+0                  | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 aprile 1987 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 maggio 1453 23:59:59 GMT+0                 | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 giugno 1987 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 luglio 1987 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 agosto 1987 12:13:14 GMT+0                 | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 settembre 1987 12:13:14 GMT+0              | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 ottobre 1987 12:13:14 GMT+0                | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 novembre 1987 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 dicembre 1987 12:13:14 GMT+0               | Errored                  |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | domenica 11 gennaio 1987 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-02-11T12:13:14.015Z | mercoledì 11 febbraio 1987 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-03-11T12:13:14.015Z | mercoledì 11 marzo 1987 12:13:14 GMT+00:00    | Errored                  |
|                                 |              | 1987-04-11T12:13:14.015Z | sabato 11 aprile 1987 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | domenica 29 maggio 1453 23:59:59 GMT+00:00    | Errored                  |
|                                 |              | 1987-06-11T12:13:14.015Z | giovedì 11 giugno 1987 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-07-11T12:13:14.015Z | sabato 11 luglio 1987 12:13:14 GMT+00:00      | Errored                  |
|                                 |              | 1987-08-11T12:13:14.015Z | martedì 11 agosto 1987 12:13:14 GMT+00:00     | Errored                  |
|                                 |              | 1987-09-11T12:13:14.015Z | venerdì 11 settembre 1987 12:13:14 GMT+00:00  | Errored                  |
|                                 |              | 1987-10-11T12:13:14.015Z | domenica 11 ottobre 1987 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1987-11-11T12:13:14.015Z | mercoledì 11 novembre 1987 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1987-12-11T12:13:14.015Z | venerdì 11 dicembre 1987 12:13:14 GMT+00:00   | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result            | `includeSeconds: true` | `addSuffix: true`     |
| ------------------------ | ----------------- | ---------------------- | --------------------- |
| 2006-01-01T00:00:00.000Z | circa 6 anni      | circa 6 anni           | tra circa 6 anni      |
| 2005-01-01T00:00:00.000Z | circa 5 anni      | circa 5 anni           | tra circa 5 anni      |
| 2004-01-01T00:00:00.000Z | circa 4 anni      | circa 4 anni           | tra circa 4 anni      |
| 2003-01-01T00:00:00.000Z | circa 3 anni      | circa 3 anni           | tra circa 3 anni      |
| 2002-01-01T00:00:00.000Z | circa 2 anni      | circa 2 anni           | tra circa 2 anni      |
| 2001-06-01T00:00:00.000Z | più di un anno    | più di un anno         | tra più di un anno    |
| 2001-02-01T00:00:00.000Z | circa un anno     | circa un anno          | tra circa un anno     |
| 2001-01-01T00:00:00.000Z | circa un anno     | circa un anno          | tra circa un anno     |
| 2000-06-01T00:00:00.000Z | 5 mesi            | 5 mesi                 | tra 5 mesi            |
| 2000-03-01T00:00:00.000Z | 2 mesi            | 2 mesi                 | tra 2 mesi            |
| 2000-02-01T00:00:00.000Z | circa un mese     | circa un mese          | tra circa un mese     |
| 2000-01-15T00:00:00.000Z | 14 giorni         | 14 giorni              | tra 14 giorni         |
| 2000-01-02T00:00:00.000Z | un giorno         | un giorno              | tra un giorno         |
| 2000-01-01T06:00:00.000Z | circa 6 ore       | circa 6 ore            | tra circa 6 ore       |
| 2000-01-01T01:00:00.000Z | circa un'ora      | circa un'ora           | tra circa un'ora      |
| 2000-01-01T00:45:00.000Z | circa un'ora      | circa un'ora           | tra circa un'ora      |
| 2000-01-01T00:30:00.000Z | 30 minuti         | 30 minuti              | tra 30 minuti         |
| 2000-01-01T00:15:00.000Z | 15 minuti         | 15 minuti              | tra 15 minuti         |
| 2000-01-01T00:01:00.000Z | un minuto         | un minuto              | tra un minuto         |
| 2000-01-01T00:00:25.000Z | meno di un minuto | alcuni secondi         | tra meno di un minuto |
| 2000-01-01T00:00:15.000Z | meno di un minuto | meno di 20 secondi     | tra meno di un minuto |
| 2000-01-01T00:00:05.000Z | meno di un minuto | meno di 10 secondi     | tra meno di un minuto |
| 2000-01-01T00:00:00.000Z | meno di un minuto | meno di 5 secondi      | meno di un minuto fa  |
| 1999-12-31T23:59:55.000Z | meno di un minuto | meno di 10 secondi     | meno di un minuto fa  |
| 1999-12-31T23:59:45.000Z | meno di un minuto | meno di 20 secondi     | meno di un minuto fa  |
| 1999-12-31T23:59:35.000Z | meno di un minuto | alcuni secondi         | meno di un minuto fa  |
| 1999-12-31T23:59:00.000Z | un minuto         | un minuto              | un minuto fa          |
| 1999-12-31T23:45:00.000Z | 15 minuti         | 15 minuti              | 15 minuti fa          |
| 1999-12-31T23:30:00.000Z | 30 minuti         | 30 minuti              | 30 minuti fa          |
| 1999-12-31T23:15:00.000Z | circa un'ora      | circa un'ora           | circa un'ora fa       |
| 1999-12-31T23:00:00.000Z | circa un'ora      | circa un'ora           | circa un'ora fa       |
| 1999-12-31T18:00:00.000Z | circa 6 ore       | circa 6 ore            | circa 6 ore fa        |
| 1999-12-30T00:00:00.000Z | 2 giorni          | 2 giorni               | 2 giorni fa           |
| 1999-12-15T00:00:00.000Z | 17 giorni         | 17 giorni              | 17 giorni fa          |
| 1999-12-01T00:00:00.000Z | circa un mese     | circa un mese          | circa un mese fa      |
| 1999-11-01T00:00:00.000Z | 2 mesi            | 2 mesi                 | 2 mesi fa             |
| 1999-06-01T00:00:00.000Z | 7 mesi            | 7 mesi                 | 7 mesi fa             |
| 1999-01-01T00:00:00.000Z | circa un anno     | circa un anno          | circa un anno fa      |
| 1998-12-01T00:00:00.000Z | circa un anno     | circa un anno          | circa un anno fa      |
| 1998-06-01T00:00:00.000Z | più di un anno    | più di un anno         | più di un anno fa     |
| 1998-01-01T00:00:00.000Z | circa 2 anni      | circa 2 anni           | circa 2 anni fa       |
| 1997-01-01T00:00:00.000Z | circa 3 anni      | circa 3 anni           | circa 3 anni fa       |
| 1996-01-01T00:00:00.000Z | circa 4 anni      | circa 4 anni           | circa 4 anni fa       |
| 1995-01-01T00:00:00.000Z | circa 5 anni      | circa 5 anni           | circa 5 anni fa       |
| 1994-01-01T00:00:00.000Z | circa 6 anni      | circa 6 anni           | circa 6 anni fa       |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result     | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ---------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 anni     | tra 6 anni        | 52608 ore                      |
| 2005-01-01T00:00:00.000Z | 5 anni     | tra 5 anni        | 43848 ore                      |
| 2004-01-01T00:00:00.000Z | 4 anni     | tra 4 anni        | 35064 ore                      |
| 2003-01-01T00:00:00.000Z | 3 anni     | tra 3 anni        | 26304 ore                      |
| 2002-01-01T00:00:00.000Z | 2 anni     | tra 2 anni        | 17544 ore                      |
| 2001-06-01T00:00:00.000Z | un anno    | tra un anno       | 12408 ore                      |
| 2001-02-01T00:00:00.000Z | un anno    | tra un anno       | 9528 ore                       |
| 2001-01-01T00:00:00.000Z | un anno    | tra un anno       | 8784 ore                       |
| 2000-06-01T00:00:00.000Z | 5 mesi     | tra 5 mesi        | 3648 ore                       |
| 2000-03-01T00:00:00.000Z | 2 mesi     | tra 2 mesi        | 1440 ore                       |
| 2000-02-01T00:00:00.000Z | un mese    | tra un mese       | 744 ore                        |
| 2000-01-15T00:00:00.000Z | 14 giorni  | tra 14 giorni     | 336 ore                        |
| 2000-01-02T00:00:00.000Z | un giorno  | tra un giorno     | 24 ore                         |
| 2000-01-01T06:00:00.000Z | 6 ore      | tra 6 ore         | 6 ore                          |
| 2000-01-01T01:00:00.000Z | un'ora     | tra un'ora        | un'ora                         |
| 2000-01-01T00:45:00.000Z | 45 minuti  | tra 45 minuti     | un'ora                         |
| 2000-01-01T00:30:00.000Z | 30 minuti  | tra 30 minuti     | un'ora                         |
| 2000-01-01T00:15:00.000Z | 15 minuti  | tra 15 minuti     | 0 ore                          |
| 2000-01-01T00:01:00.000Z | un minuto  | tra un minuto     | 0 ore                          |
| 2000-01-01T00:00:25.000Z | 25 secondi | tra 25 secondi    | 0 ore                          |
| 2000-01-01T00:00:15.000Z | 15 secondi | tra 15 secondi    | 0 ore                          |
| 2000-01-01T00:00:05.000Z | 5 secondi  | tra 5 secondi     | 0 ore                          |
| 2000-01-01T00:00:00.000Z | 0 secondi  | 0 secondi fa      | 0 ore                          |
| 1999-12-31T23:59:55.000Z | 5 secondi  | 5 secondi fa      | 0 ore                          |
| 1999-12-31T23:59:45.000Z | 15 secondi | 15 secondi fa     | 0 ore                          |
| 1999-12-31T23:59:35.000Z | 25 secondi | 25 secondi fa     | 0 ore                          |
| 1999-12-31T23:59:00.000Z | un minuto  | un minuto fa      | 0 ore                          |
| 1999-12-31T23:45:00.000Z | 15 minuti  | 15 minuti fa      | 0 ore                          |
| 1999-12-31T23:30:00.000Z | 30 minuti  | 30 minuti fa      | un'ora                         |
| 1999-12-31T23:15:00.000Z | 45 minuti  | 45 minuti fa      | un'ora                         |
| 1999-12-31T23:00:00.000Z | un'ora     | un'ora fa         | un'ora                         |
| 1999-12-31T18:00:00.000Z | 6 ore      | 6 ore fa          | 6 ore                          |
| 1999-12-30T00:00:00.000Z | 2 giorni   | 2 giorni fa       | 48 ore                         |
| 1999-12-15T00:00:00.000Z | 17 giorni  | 17 giorni fa      | 408 ore                        |
| 1999-12-01T00:00:00.000Z | un mese    | un mese fa        | 744 ore                        |
| 1999-11-01T00:00:00.000Z | 2 mesi     | 2 mesi fa         | 1464 ore                       |
| 1999-06-01T00:00:00.000Z | 7 mesi     | 7 mesi fa         | 5136 ore                       |
| 1999-01-01T00:00:00.000Z | un anno    | un anno fa        | 8760 ore                       |
| 1998-12-01T00:00:00.000Z | un anno    | un anno fa        | 9504 ore                       |
| 1998-06-01T00:00:00.000Z | 2 anni     | 2 anni fa         | 13896 ore                      |
| 1998-01-01T00:00:00.000Z | 2 anni     | 2 anni fa         | 17520 ore                      |
| 1997-01-01T00:00:00.000Z | 3 anni     | 3 anni fa         | 26280 ore                      |
| 1996-01-01T00:00:00.000Z | 4 anni     | 4 anni fa         | 35064 ore                      |
| 1995-01-01T00:00:00.000Z | 5 anni     | 5 anni fa         | 43824 ore                      |
| 1994-01-01T00:00:00.000Z | 6 anni     | 6 anni fa         | 52584 ore                      |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                        |
| ------------------------ | ----------------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000                    |
| 2000-01-05T00:00:00.000Z | mercoledì prossimo alle 00:00 |
| 2000-01-02T00:00:00.000Z | domani alle 00:00             |
| 2000-01-01T00:00:00.000Z | oggi alle 00:00               |
| 1999-12-31T00:00:00.000Z | ieri alle 00:00               |
| 1999-12-27T00:00:00.000Z | lunedì alle 00:00             |
| 1999-12-21T00:00:00.000Z | 21/12/1999                    |

## `formatDuration`

| Duration      | Result        |
| ------------- | ------------- |
| {"years":0}   | 0 anni        |
| {"years":1}   | un anno       |
| {"years":2}   | 2 anni        |
| {"months":0}  | 0 mesi        |
| {"months":1}  | un mese       |
| {"months":2}  | 2 mesi        |
| {"weeks":0}   | 0 settimane   |
| {"weeks":1}   | una settimana |
| {"weeks":2}   | 2 settimane   |
| {"days":0}    | 0 giorni      |
| {"days":1}    | un giorno     |
| {"days":2}    | 2 giorni      |
| {"hours":0}   | 0 ore         |
| {"hours":1}   | un'ora        |
| {"hours":2}   | 2 ore         |
| {"minutes":0} | 0 minuti      |
| {"minutes":1} | un minuto     |
| {"minutes":2} | 2 minuti      |
| {"seconds":0} | 0 secondi     |
| {"seconds":1} | un secondo    |
| {"seconds":2} | 2 secondi     |
