# Modern Standard Arabic (ar) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                              | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | -------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                         | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                            | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                         | 1986-12-27T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                            | 0005-01-01T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                            | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | ر1                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ر2                                           | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | الربع الأول                                  | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | الربع الثاني                                 | Invalid Date             |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                            | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                            | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | ر1                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ر2                                           | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | الربع الأول                                  | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | الربع الثاني                                 | Invalid Date             |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                            | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                            | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                            | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                            | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                            | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                            | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                           | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                           | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                           | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | يناير                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | فبراير                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | مارس                                         | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | أبريل                                        | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | مايو                                         | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | يونيو                                        | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | يوليو                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | أغسطس                                        | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | سبتمبر                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | أكتوبر                                       | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | نوفمبر                                       | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ديسمبر                                       | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | يناير                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | فبراير                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | مارس                                         | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | أبريل                                        | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | مايو                                         | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | يونيو                                        | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | يوليو                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | أغسطس                                        | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | سبتمبر                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | أكتوبر                                       | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | نوفمبر                                       | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ديسمبر                                       | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | ي                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | ف                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | م                                            | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | أ                                            | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | م                                            | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ي                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ي                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | أ                                            | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | س                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | أ                                            | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ن                                            | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | د                                            | 2019-12-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                            | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                            | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                            | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                            | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                            | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                            | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                           | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                           | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                           | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | يناير                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | فبراير                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | مارس                                         | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | أبريل                                        | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | مايو                                         | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | يونيو                                        | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | يوليو                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | أغسطس                                        | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | سبتمبر                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | أكتوبر                                       | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | نوفمبر                                       | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ديسمبر                                       | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | يناير                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | فبراير                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | مارس                                         | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | أبريل                                        | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | مايو                                         | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | يونيو                                        | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | يوليو                                        | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | أغسطس                                        | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | سبتمبر                                       | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | أكتوبر                                       | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | نوفمبر                                       | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ديسمبر                                       | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | ي                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | ف                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | م                                            | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | أ                                            | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | م                                            | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ي                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ي                                            | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | أ                                            | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | س                                            | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | أ                                            | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ن                                            | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | د                                            | 2019-12-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                            | 2018-12-29T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 49                                           | 2019-11-30T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                            | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                           | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                           | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1 فبراير                                     | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11 فبراير                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28 فبراير                                    | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                          | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | اثنين                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                         | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | اثنين                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                         | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | اثنين                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                         | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | الاثنين                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | الجمعة                                       | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | ن                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                            | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | اثنين                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                         | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                            | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | اثنين                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                         | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | الاثنين                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | الجمعة                                       | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | ن                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                            | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | اثنين                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                         | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 3                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 7                                            | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | اثنين                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                         | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | الاثنين                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | الجمعة                                       | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | ن                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                            | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | اثنين                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                         | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 3                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 7                                            | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | اثنين                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                         | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | الاثنين                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | الجمعة                                       | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | ن                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                            | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | اثنين                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                         | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | م                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                            | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | في الصباح                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | بعد الظهر                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | في المساء                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                                     | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | في الصباح                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | بعد الظهر                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | في المساء                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                                     | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | في الصباح                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | بعد الظهر                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | في المساء                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                                     | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | في الصباح                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | بعد الظهر                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | في المساء                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                                     | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | في الصباح                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | بعد الظهر                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | في المساء                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                                     | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                           | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                           | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                           | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                           | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                           | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                           | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                           | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                           | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                            | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                           | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                            | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                           | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11/01/1987                                   | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987                                   | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987                                   | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987                                   | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                   | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987                                   | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987                                   | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987                                   | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987                                   | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987                                   | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987                                   | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987                                   | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11 يناير 1987                                | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 فبراير 1987                               | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 مارس 1987                                 | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 أبريل 1987                                | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 مايو 1453                                 | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 يونيو 1987                                | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 يوليو 1987                                | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 أغسطس 1987                                | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 سبتمبر 1987                               | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 أكتوبر 1987                               | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 نوفمبر 1987                               | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ديسمبر 1987                               | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11 يناير 1987                                | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 فبراير 1987                               | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 مارس 1987                                 | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 أبريل 1987                                | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 مايو 1453                                 | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 يونيو 1987                                | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 يوليو 1987                                | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 أغسطس 1987                                | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 سبتمبر 1987                               | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 أكتوبر 1987                               | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 نوفمبر 1987                               | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ديسمبر 1987                               | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | الأحد، 11 يناير 1987                         | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | الأربعاء، 11 فبراير 1987                     | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | الأربعاء، 11 مارس 1987                       | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | السبت، 11 أبريل 1987                         | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | الأحد، 29 مايو 1453                          | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | الخميس، 11 يونيو 1987                        | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | السبت، 11 يوليو 1987                         | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | الثلاثاء، 11 أغسطس 1987                      | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | الجمعة، 11 سبتمبر 1987                       | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | الأحد، 11 أكتوبر 1987                        | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | الأربعاء، 11 نوفمبر 1987                     | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | الجمعة، 11 ديسمبر 1987                       | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                        | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                        | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                        | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                        | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                        | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                        | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                        | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                        | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                        | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                        | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                        | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                        | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                                     | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                     | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                     | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                     | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                     | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                     | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                     | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                     | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                     | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                     | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                     | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                     | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14                                     | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                     | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                     | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                     | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                     | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                     | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                     | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                     | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                     | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                     | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                     | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                     | 1987-12-11T12:13:14.000Z |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14                                     | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                                     | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                                     | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                                     | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                     | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                                     | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                                     | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                                     | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                                     | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                                     | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                                     | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                                     | 1987-12-11T12:13:14.000Z |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11/01/1987, 12:13                            | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987, 12:13                            | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987, 12:13                            | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987, 12:13                            | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453, 23:59                            | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987, 12:13                            | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987, 12:13                            | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987, 12:13                            | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987, 12:13                            | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987, 12:13                            | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987, 12:13                            | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987, 12:13                            | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11 يناير 1987, 12:13:14                      | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 فبراير 1987, 12:13:14                     | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 مارس 1987, 12:13:14                       | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 أبريل 1987, 12:13:14                      | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 مايو 1453, 23:59:59                       | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 يونيو 1987, 12:13:14                      | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 يوليو 1987, 12:13:14                      | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 أغسطس 1987, 12:13:14                      | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 سبتمبر 1987, 12:13:14                     | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 أكتوبر 1987, 12:13:14                     | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 نوفمبر 1987, 12:13:14                     | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ديسمبر 1987, 12:13:14                     | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11 يناير 1987 عند الساعة 12:13:14            | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 فبراير 1987 عند الساعة 12:13:14           | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 مارس 1987 عند الساعة 12:13:14             | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 أبريل 1987 عند الساعة 12:13:14            | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 مايو 1453 عند الساعة 23:59:59             | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 يونيو 1987 عند الساعة 12:13:14            | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 يوليو 1987 عند الساعة 12:13:14            | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 أغسطس 1987 عند الساعة 12:13:14            | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 سبتمبر 1987 عند الساعة 12:13:14           | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 أكتوبر 1987 عند الساعة 12:13:14           | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 نوفمبر 1987 عند الساعة 12:13:14           | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ديسمبر 1987 عند الساعة 12:13:14           | 1987-12-11T12:13:14.000Z |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | الأحد، 11 يناير 1987 عند الساعة 12:13:14     | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | الأربعاء، 11 فبراير 1987 عند الساعة 12:13:14 | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | الأربعاء، 11 مارس 1987 عند الساعة 12:13:14   | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | السبت، 11 أبريل 1987 عند الساعة 12:13:14     | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | الأحد، 29 مايو 1453 عند الساعة 23:59:59      | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | الخميس، 11 يونيو 1987 عند الساعة 12:13:14    | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | السبت، 11 يوليو 1987 عند الساعة 12:13:14     | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | الثلاثاء، 11 أغسطس 1987 عند الساعة 12:13:14  | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | الجمعة، 11 سبتمبر 1987 عند الساعة 12:13:14   | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | الأحد، 11 أكتوبر 1987 عند الساعة 12:13:14    | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | الأربعاء، 11 نوفمبر 1987 عند الساعة 12:13:14 | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | الجمعة، 11 ديسمبر 1987 عند الساعة 12:13:14   | 1987-12-11T12:13:14.000Z |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result             | `includeSeconds: true` | `addSuffix: true`       |
| ------------------------ | ------------------ | ---------------------- | ----------------------- |
| 2006-01-01T00:00:00.000Z | 6 سنوات تقريباً    | 6 سنوات تقريباً        | خلال 6 سنوات تقريباً    |
| 2005-01-01T00:00:00.000Z | 5 سنوات تقريباً    | 5 سنوات تقريباً        | خلال 5 سنوات تقريباً    |
| 2004-01-01T00:00:00.000Z | 4 سنوات تقريباً    | 4 سنوات تقريباً        | خلال 4 سنوات تقريباً    |
| 2003-01-01T00:00:00.000Z | 3 سنوات تقريباً    | 3 سنوات تقريباً        | خلال 3 سنوات تقريباً    |
| 2002-01-01T00:00:00.000Z | سنتين تقريبا       | سنتين تقريبا           | خلال سنتين تقريبا       |
| 2001-06-01T00:00:00.000Z | أكثر من سنة        | أكثر من سنة            | خلال أكثر من سنة        |
| 2001-02-01T00:00:00.000Z | سنة واحدة تقريباً  | سنة واحدة تقريباً      | خلال سنة واحدة تقريباً  |
| 2001-01-01T00:00:00.000Z | سنة واحدة تقريباً  | سنة واحدة تقريباً      | خلال سنة واحدة تقريباً  |
| 2000-06-01T00:00:00.000Z | 5 أشهر             | 5 أشهر                 | خلال 5 أشهر             |
| 2000-03-01T00:00:00.000Z | شهران              | شهران                  | خلال شهران              |
| 2000-02-01T00:00:00.000Z | شهر واحد تقريباً   | شهر واحد تقريباً       | خلال شهر واحد تقريباً   |
| 2000-01-15T00:00:00.000Z | 14 يوم             | 14 يوم                 | خلال 14 يوم             |
| 2000-01-02T00:00:00.000Z | يوم واحد           | يوم واحد               | خلال يوم واحد           |
| 2000-01-01T06:00:00.000Z | 6 ساعات تقريباً    | 6 ساعات تقريباً        | خلال 6 ساعات تقريباً    |
| 2000-01-01T01:00:00.000Z | ساعة واحدة تقريباً | ساعة واحدة تقريباً     | خلال ساعة واحدة تقريباً |
| 2000-01-01T00:45:00.000Z | ساعة واحدة تقريباً | ساعة واحدة تقريباً     | خلال ساعة واحدة تقريباً |
| 2000-01-01T00:30:00.000Z | 30 دقيقة           | 30 دقيقة               | خلال 30 دقيقة           |
| 2000-01-01T00:15:00.000Z | 15 دقيقة           | 15 دقيقة               | خلال 15 دقيقة           |
| 2000-01-01T00:01:00.000Z | دقيقة واحدة        | دقيقة واحدة            | خلال دقيقة واحدة        |
| 2000-01-01T00:00:25.000Z | أقل من دقيقة       | نصف دقيقة              | خلال أقل من دقيقة       |
| 2000-01-01T00:00:15.000Z | أقل من دقيقة       | أقل من 20 ثانية        | خلال أقل من دقيقة       |
| 2000-01-01T00:00:05.000Z | أقل من دقيقة       | أقل من 10 ثواني        | خلال أقل من دقيقة       |
| 2000-01-01T00:00:00.000Z | أقل من دقيقة       | أقل من 5 ثواني         | منذ أقل من دقيقة        |
| 1999-12-31T23:59:55.000Z | أقل من دقيقة       | أقل من 10 ثواني        | منذ أقل من دقيقة        |
| 1999-12-31T23:59:45.000Z | أقل من دقيقة       | أقل من 20 ثانية        | منذ أقل من دقيقة        |
| 1999-12-31T23:59:35.000Z | أقل من دقيقة       | نصف دقيقة              | منذ أقل من دقيقة        |
| 1999-12-31T23:59:00.000Z | دقيقة واحدة        | دقيقة واحدة            | منذ دقيقة واحدة         |
| 1999-12-31T23:45:00.000Z | 15 دقيقة           | 15 دقيقة               | منذ 15 دقيقة            |
| 1999-12-31T23:30:00.000Z | 30 دقيقة           | 30 دقيقة               | منذ 30 دقيقة            |
| 1999-12-31T23:15:00.000Z | ساعة واحدة تقريباً | ساعة واحدة تقريباً     | منذ ساعة واحدة تقريباً  |
| 1999-12-31T23:00:00.000Z | ساعة واحدة تقريباً | ساعة واحدة تقريباً     | منذ ساعة واحدة تقريباً  |
| 1999-12-31T18:00:00.000Z | 6 ساعات تقريباً    | 6 ساعات تقريباً        | منذ 6 ساعات تقريباً     |
| 1999-12-30T00:00:00.000Z | يومان              | يومان                  | منذ يومان               |
| 1999-12-15T00:00:00.000Z | 17 يوم             | 17 يوم                 | منذ 17 يوم              |
| 1999-12-01T00:00:00.000Z | شهر واحد تقريباً   | شهر واحد تقريباً       | منذ شهر واحد تقريباً    |
| 1999-11-01T00:00:00.000Z | شهران              | شهران                  | منذ شهران               |
| 1999-06-01T00:00:00.000Z | 7 أشهر             | 7 أشهر                 | منذ 7 أشهر              |
| 1999-01-01T00:00:00.000Z | سنة واحدة تقريباً  | سنة واحدة تقريباً      | منذ سنة واحدة تقريباً   |
| 1998-12-01T00:00:00.000Z | سنة واحدة تقريباً  | سنة واحدة تقريباً      | منذ سنة واحدة تقريباً   |
| 1998-06-01T00:00:00.000Z | أكثر من سنة        | أكثر من سنة            | منذ أكثر من سنة         |
| 1998-01-01T00:00:00.000Z | سنتين تقريبا       | سنتين تقريبا           | منذ سنتين تقريبا        |
| 1997-01-01T00:00:00.000Z | 3 سنوات تقريباً    | 3 سنوات تقريباً        | منذ 3 سنوات تقريباً     |
| 1996-01-01T00:00:00.000Z | 4 سنوات تقريباً    | 4 سنوات تقريباً        | منذ 4 سنوات تقريباً     |
| 1995-01-01T00:00:00.000Z | 5 سنوات تقريباً    | 5 سنوات تقريباً        | منذ 5 سنوات تقريباً     |
| 1994-01-01T00:00:00.000Z | 6 سنوات تقريباً    | 6 سنوات تقريباً        | منذ 6 سنوات تقريباً     |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result      | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ----------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 سنوات     | خلال 6 سنوات      | 52608 ساعة                     |
| 2005-01-01T00:00:00.000Z | 5 سنوات     | خلال 5 سنوات      | 43848 ساعة                     |
| 2004-01-01T00:00:00.000Z | 4 سنوات     | خلال 4 سنوات      | 35064 ساعة                     |
| 2003-01-01T00:00:00.000Z | 3 سنوات     | خلال 3 سنوات      | 26304 ساعة                     |
| 2002-01-01T00:00:00.000Z | سنتان       | خلال سنتان        | 17544 ساعة                     |
| 2001-06-01T00:00:00.000Z | سنة واحد    | خلال سنة واحد     | 12408 ساعة                     |
| 2001-02-01T00:00:00.000Z | سنة واحد    | خلال سنة واحد     | 9528 ساعة                      |
| 2001-01-01T00:00:00.000Z | سنة واحد    | خلال سنة واحد     | 8784 ساعة                      |
| 2000-06-01T00:00:00.000Z | 5 أشهر      | خلال 5 أشهر       | 3648 ساعة                      |
| 2000-03-01T00:00:00.000Z | شهران       | خلال شهران        | 1440 ساعة                      |
| 2000-02-01T00:00:00.000Z | شهر واحد    | خلال شهر واحد     | 744 ساعة                       |
| 2000-01-15T00:00:00.000Z | 14 يوم      | خلال 14 يوم       | 336 ساعة                       |
| 2000-01-02T00:00:00.000Z | يوم واحد    | خلال يوم واحد     | 24 ساعة                        |
| 2000-01-01T06:00:00.000Z | 6 ساعات     | خلال 6 ساعات      | 6 ساعات                        |
| 2000-01-01T01:00:00.000Z | ساعة واحدة  | خلال ساعة واحدة   | ساعة واحدة                     |
| 2000-01-01T00:45:00.000Z | 45 دقيقة    | خلال 45 دقيقة     | ساعة واحدة                     |
| 2000-01-01T00:30:00.000Z | 30 دقيقة    | خلال 30 دقيقة     | ساعة واحدة                     |
| 2000-01-01T00:15:00.000Z | 15 دقيقة    | خلال 15 دقيقة     | 0 ساعات                        |
| 2000-01-01T00:01:00.000Z | دقيقة واحدة | خلال دقيقة واحدة  | 0 ساعات                        |
| 2000-01-01T00:00:25.000Z | 25 ثانية    | خلال 25 ثانية     | 0 ساعات                        |
| 2000-01-01T00:00:15.000Z | 15 ثانية    | خلال 15 ثانية     | 0 ساعات                        |
| 2000-01-01T00:00:05.000Z | 5 ثواني     | خلال 5 ثواني      | 0 ساعات                        |
| 2000-01-01T00:00:00.000Z | 0 ثواني     | منذ 0 ثواني       | 0 ساعات                        |
| 1999-12-31T23:59:55.000Z | 5 ثواني     | منذ 5 ثواني       | 0 ساعات                        |
| 1999-12-31T23:59:45.000Z | 15 ثانية    | منذ 15 ثانية      | 0 ساعات                        |
| 1999-12-31T23:59:35.000Z | 25 ثانية    | منذ 25 ثانية      | 0 ساعات                        |
| 1999-12-31T23:59:00.000Z | دقيقة واحدة | منذ دقيقة واحدة   | 0 ساعات                        |
| 1999-12-31T23:45:00.000Z | 15 دقيقة    | منذ 15 دقيقة      | 0 ساعات                        |
| 1999-12-31T23:30:00.000Z | 30 دقيقة    | منذ 30 دقيقة      | ساعة واحدة                     |
| 1999-12-31T23:15:00.000Z | 45 دقيقة    | منذ 45 دقيقة      | ساعة واحدة                     |
| 1999-12-31T23:00:00.000Z | ساعة واحدة  | منذ ساعة واحدة    | ساعة واحدة                     |
| 1999-12-31T18:00:00.000Z | 6 ساعات     | منذ 6 ساعات       | 6 ساعات                        |
| 1999-12-30T00:00:00.000Z | يومان       | منذ يومان         | 48 ساعة                        |
| 1999-12-15T00:00:00.000Z | 17 يوم      | منذ 17 يوم        | 408 ساعة                       |
| 1999-12-01T00:00:00.000Z | شهر واحد    | منذ شهر واحد      | 744 ساعة                       |
| 1999-11-01T00:00:00.000Z | شهران       | منذ شهران         | 1464 ساعة                      |
| 1999-06-01T00:00:00.000Z | 7 أشهر      | منذ 7 أشهر        | 5136 ساعة                      |
| 1999-01-01T00:00:00.000Z | سنة واحد    | منذ سنة واحد      | 8760 ساعة                      |
| 1998-12-01T00:00:00.000Z | سنة واحد    | منذ سنة واحد      | 9504 ساعة                      |
| 1998-06-01T00:00:00.000Z | سنتان       | منذ سنتان         | 13896 ساعة                     |
| 1998-01-01T00:00:00.000Z | سنتان       | منذ سنتان         | 17520 ساعة                     |
| 1997-01-01T00:00:00.000Z | 3 سنوات     | منذ 3 سنوات       | 26280 ساعة                     |
| 1996-01-01T00:00:00.000Z | 4 سنوات     | منذ 4 سنوات       | 35064 ساعة                     |
| 1995-01-01T00:00:00.000Z | 5 سنوات     | منذ 5 سنوات       | 43824 ساعة                     |
| 1994-01-01T00:00:00.000Z | 6 سنوات     | منذ 6 سنوات       | 52584 ساعة                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                           |
| ------------------------ | -------------------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000                       |
| 2000-01-05T00:00:00.000Z | الأربعاء القادم عند الساعة 00:00 |
| 2000-01-02T00:00:00.000Z | غدا عند الساعة 00:00             |
| 2000-01-01T00:00:00.000Z | اليوم عند الساعة 00:00           |
| 1999-12-31T00:00:00.000Z | الأمس عند الساعة 00:00           |
| 1999-12-27T00:00:00.000Z | الاثنين الماضي عند الساعة 00:00  |
| 1999-12-21T00:00:00.000Z | 21/12/1999                       |

## `formatDuration`

| Duration      | Result      |
| ------------- | ----------- |
| {"years":0}   | 0 سنوات     |
| {"years":1}   | سنة واحد    |
| {"years":2}   | سنتان       |
| {"months":0}  | 0 أشهر      |
| {"months":1}  | شهر واحد    |
| {"months":2}  | شهران       |
| {"weeks":0}   | 0 أسابيع    |
| {"weeks":1}   | أسبوع واحد  |
| {"weeks":2}   | أسبوعان     |
| {"days":0}    | 0 أيام      |
| {"days":1}    | يوم واحد    |
| {"days":2}    | يومان       |
| {"hours":0}   | 0 ساعات     |
| {"hours":1}   | ساعة واحدة  |
| {"hours":2}   | ساعتان      |
| {"minutes":0} | 0 دقائق     |
| {"minutes":1} | دقيقة واحدة |
| {"minutes":2} | دقيقتان     |
| {"seconds":0} | 0 ثواني     |
| {"seconds":1} | ثانية واحدة |
| {"seconds":2} | ثانيتان     |
