# Arabic (ar-TN) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                      | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------ | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                 | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                    | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                 | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                    | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                    | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | ر1                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ر2                                   | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | الربع الأول                          | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | الربع الثاني                         | Invalid Date             |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                    | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                    | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | ر1                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | ر2                                   | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | الربع الأول                          | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | الربع الثاني                         | Invalid Date             |
| Month (formatting)              | Mo           | 2019-01-11T12:13:14.015Z | 1                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                    | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                    | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                    | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                    | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                    | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                   | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                   | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                   | 2019-12-01T00:00:00.000Z |
|                                 | MMM          | 2019-01-11T12:13:14.015Z | جانفي                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | فيفري                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | مارس                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | أفريل                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | ماي                                  | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | جوان                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | جويلية                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | أوت                                  | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | سبتمبر                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | أكتوبر                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | نوفمبر                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ديسمبر                               | 2019-12-01T00:00:00.000Z |
|                                 | MMMM         | 2019-01-11T12:13:14.015Z | جانفي                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | فيفري                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | مارس                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | أفريل                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | ماي                                  | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | جوان                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | جويلية                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | أوت                                  | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | سبتمبر                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | أكتوبر                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | نوفمبر                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ديسمبر                               | 2019-12-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-01-11T12:13:14.015Z | د                                    | 2019-12-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | ن                                    | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | أ                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | س                                    | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | أ                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ج                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ج                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | م                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | أ                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | م                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ف                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ج                                    | 2019-01-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-01-11T12:13:14.015Z | 1                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 2                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | 3                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | 4                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | 5                                    | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | 6                                    | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                    | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | 8                                    | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | 9                                    | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | 10                                   | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | 11                                   | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | 12                                   | 2019-12-01T00:00:00.000Z |
|                                 | LLL          | 2019-01-11T12:13:14.015Z | جانفي                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | فيفري                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | مارس                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | أفريل                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | ماي                                  | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | جوان                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | جويلية                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | أوت                                  | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | سبتمبر                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | أكتوبر                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | نوفمبر                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ديسمبر                               | 2019-12-01T00:00:00.000Z |
|                                 | LLLL         | 2019-01-11T12:13:14.015Z | جانفي                                | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | فيفري                                | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | مارس                                 | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | أفريل                                | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | ماي                                  | 2019-05-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | جوان                                 | 2019-06-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | جويلية                               | 2019-07-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | أوت                                  | 2019-08-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | سبتمبر                               | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | أكتوبر                               | 2019-10-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | نوفمبر                               | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ديسمبر                               | 2019-12-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-01-11T12:13:14.015Z | د                                    | 2019-12-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | ن                                    | 2019-11-01T00:00:00.000Z |
|                                 |              | 2019-03-11T12:13:14.015Z | أ                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-04-10T12:13:14.015Z | س                                    | 2019-09-01T00:00:00.000Z |
|                                 |              | 2019-05-10T12:13:14.015Z | أ                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-06-10T12:13:14.015Z | ج                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | ج                                    | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-08-10T12:13:14.015Z | م                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-09-10T12:13:14.015Z | أ                                    | 2019-04-01T00:00:00.000Z |
|                                 |              | 2019-10-10T12:13:14.015Z | م                                    | 2019-03-01T00:00:00.000Z |
|                                 |              | 2019-11-10T12:13:14.015Z | ف                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-12-10T12:13:14.015Z | ج                                    | 2019-01-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                    | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                   | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                    | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                   | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-01T12:13:14.015Z | 1                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                   | 2019-02-28T00:00:00.000Z |
|                                 | do MMMM      | 2019-02-01T12:13:14.015Z | 1 فيفري                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-02-11T12:13:14.015Z | 11 فيفري                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28 فيفري                             | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                  | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | اثنين                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                 | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | اثنين                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | اثنين                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | الاثنين                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | الجمعة                               | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | ن                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                    | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | اثنين                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                 | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                    | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | اثنين                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                 | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | الاثنين                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | الجمعة                               | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | ن                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                    | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | اثنين                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                 | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                    | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | اثنين                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                 | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | الاثنين                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | الجمعة                               | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | ن                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                    | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | اثنين                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                 | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                    | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | اثنين                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                 | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | الاثنين                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | الجمعة                               | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | ن                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ج                                    | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | اثنين                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | جمعة                                 | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ع                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ص                                    | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | في الصباح                            | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | بعد القايلة                          | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | في العشية                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                             | Invalid Date             |
|                                 | BB           | 2019-02-11T11:13:14.015Z | في الصباح                            | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | بعد القايلة                          | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | في العشية                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                             | Invalid Date             |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | في الصباح                            | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | بعد القايلة                          | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | في العشية                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                             | Invalid Date             |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | في الصباح                            | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | بعد القايلة                          | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | في العشية                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                             | Invalid Date             |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | في الصباح                            | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | بعد القايلة                          | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | في العشية                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | في الليل                             | Invalid Date             |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                   | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                   | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                   | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                   | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                   | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                    | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                   | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                    | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                   | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-01-11T12:13:14.015Z | 11/01/1987                           | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987                           | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987                           | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987                           | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                           | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987                           | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987                           | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987                           | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987                           | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987                           | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987                           | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987                           | 1987-12-11T00:00:00.000Z |
|                                 | PP           | 1987-01-11T12:13:14.015Z | 11 جانفي 1987                        | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 فيفري 1987                        | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 مارس 1987                         | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 أفريل 1987                        | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 ماي 1453                          | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 جوان 1987                         | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 جويلية 1987                       | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 أوت 1987                          | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 سبتمبر 1987                       | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 أكتوبر 1987                       | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 نوفمبر 1987                       | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ديسمبر 1987                       | 1987-12-11T00:00:00.000Z |
|                                 | PPP          | 1987-01-11T12:13:14.015Z | 11 جانفي 1987                        | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 فيفري 1987                        | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 مارس 1987                         | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 أفريل 1987                        | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 ماي 1453                          | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 جوان 1987                         | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 جويلية 1987                       | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 أوت 1987                          | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 سبتمبر 1987                       | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 أكتوبر 1987                       | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 نوفمبر 1987                       | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ديسمبر 1987                       | 1987-12-11T00:00:00.000Z |
|                                 | PPPP         | 1987-01-11T12:13:14.015Z | الأحد، 11 جانفي 1987                 | 1987-01-11T00:00:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | الأربعاء، 11 فيفري 1987              | 1987-02-11T00:00:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | الأربعاء، 11 مارس 1987               | 1987-03-11T00:00:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | السبت، 11 أفريل 1987                 | 1987-04-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | الأحد، 29 ماي 1453                   | 1453-05-29T00:00:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | الخميس، 11 جوان 1987                 | 1987-06-11T00:00:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | السبت، 11 جويلية 1987                | 1987-07-11T00:00:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | الثلاثاء، 11 أوت 1987                | 1987-08-11T00:00:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | الجمعة، 11 سبتمبر 1987               | 1987-09-11T00:00:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | الأحد، 11 أكتوبر 1987                | 1987-10-11T00:00:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | الأربعاء، 11 نوفمبر 1987             | 1987-11-11T00:00:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | الجمعة، 11 ديسمبر 1987               | 1987-12-11T00:00:00.000Z |
| Long localized time             | p            | 1987-01-11T12:13:14.015Z | 12:13                                | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13                                | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13                                | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13                                | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13                                | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13                                | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13                                | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13                                | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13                                | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13                                | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13                                | 1987-12-11T12:13:00.000Z |
|                                 | pp           | 1987-01-11T12:13:14.015Z | 12:13:14                             | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                             | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                             | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                             | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                             | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                             | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                             | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                             | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                             | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                             | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                             | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                             | 1987-12-11T12:13:14.000Z |
|                                 | ppp          | 1987-01-11T12:13:14.015Z | 12:13:14                             | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                             | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                             | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                             | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                             | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                             | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                             | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                             | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                             | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                             | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                             | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                             | 1987-12-11T12:13:14.000Z |
|                                 | pppp         | 1987-01-11T12:13:14.015Z | 12:13:14                             | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 12:13:14                             | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 12:13:14                             | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 12:13:14                             | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                             | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 12:13:14                             | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 12:13:14                             | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 12:13:14                             | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 12:13:14                             | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 12:13:14                             | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 12:13:14                             | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 12:13:14                             | 1987-12-11T12:13:14.000Z |
| Combination of date and time    | Pp           | 1987-01-11T12:13:14.015Z | 11/01/1987, 12:13                    | 1987-01-11T12:13:00.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11/02/1987, 12:13                    | 1987-02-11T12:13:00.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11/03/1987, 12:13                    | 1987-03-11T12:13:00.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11/04/1987, 12:13                    | 1987-04-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453, 23:59                    | 1453-05-29T23:59:00.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11/06/1987, 12:13                    | 1987-06-11T12:13:00.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11/07/1987, 12:13                    | 1987-07-11T12:13:00.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11/08/1987, 12:13                    | 1987-08-11T12:13:00.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11/09/1987, 12:13                    | 1987-09-11T12:13:00.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11/10/1987, 12:13                    | 1987-10-11T12:13:00.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11/11/1987, 12:13                    | 1987-11-11T12:13:00.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11/12/1987, 12:13                    | 1987-12-11T12:13:00.000Z |
|                                 | PPpp         | 1987-01-11T12:13:14.015Z | 11 جانفي 1987, 12:13:14              | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 فيفري 1987, 12:13:14              | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 مارس 1987, 12:13:14               | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 أفريل 1987, 12:13:14              | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 ماي 1453, 23:59:59                | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 جوان 1987, 12:13:14               | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 جويلية 1987, 12:13:14             | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 أوت 1987, 12:13:14                | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 سبتمبر 1987, 12:13:14             | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 أكتوبر 1987, 12:13:14             | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 نوفمبر 1987, 12:13:14             | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ديسمبر 1987, 12:13:14             | 1987-12-11T12:13:14.000Z |
|                                 | PPPppp       | 1987-01-11T12:13:14.015Z | 11 جانفي 1987 مع 12:13:14            | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | 11 فيفري 1987 مع 12:13:14            | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | 11 مارس 1987 مع 12:13:14             | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | 11 أفريل 1987 مع 12:13:14            | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 ماي 1453 مع 23:59:59              | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | 11 جوان 1987 مع 12:13:14             | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | 11 جويلية 1987 مع 12:13:14           | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | 11 أوت 1987 مع 12:13:14              | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | 11 سبتمبر 1987 مع 12:13:14           | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | 11 أكتوبر 1987 مع 12:13:14           | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | 11 نوفمبر 1987 مع 12:13:14           | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | 11 ديسمبر 1987 مع 12:13:14           | 1987-12-11T12:13:14.000Z |
|                                 | PPPPpppp     | 1987-01-11T12:13:14.015Z | الأحد، 11 جانفي 1987 مع 12:13:14     | 1987-01-11T12:13:14.000Z |
|                                 |              | 1987-02-11T12:13:14.015Z | الأربعاء، 11 فيفري 1987 مع 12:13:14  | 1987-02-11T12:13:14.000Z |
|                                 |              | 1987-03-11T12:13:14.015Z | الأربعاء، 11 مارس 1987 مع 12:13:14   | 1987-03-11T12:13:14.000Z |
|                                 |              | 1987-04-11T12:13:14.015Z | السبت، 11 أفريل 1987 مع 12:13:14     | 1987-04-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | الأحد، 29 ماي 1453 مع 23:59:59       | 1453-05-29T23:59:59.000Z |
|                                 |              | 1987-06-11T12:13:14.015Z | الخميس، 11 جوان 1987 مع 12:13:14     | 1987-06-11T12:13:14.000Z |
|                                 |              | 1987-07-11T12:13:14.015Z | السبت، 11 جويلية 1987 مع 12:13:14    | 1987-07-11T12:13:14.000Z |
|                                 |              | 1987-08-11T12:13:14.015Z | الثلاثاء، 11 أوت 1987 مع 12:13:14    | 1987-08-11T12:13:14.000Z |
|                                 |              | 1987-09-11T12:13:14.015Z | الجمعة، 11 سبتمبر 1987 مع 12:13:14   | 1987-09-11T12:13:14.000Z |
|                                 |              | 1987-10-11T12:13:14.015Z | الأحد، 11 أكتوبر 1987 مع 12:13:14    | 1987-10-11T12:13:14.000Z |
|                                 |              | 1987-11-11T12:13:14.015Z | الأربعاء، 11 نوفمبر 1987 مع 12:13:14 | 1987-11-11T12:13:14.000Z |
|                                 |              | 1987-12-11T12:13:14.015Z | الجمعة، 11 ديسمبر 1987 مع 12:13:14   | 1987-12-11T12:13:14.000Z |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result        | `includeSeconds: true` | `addSuffix: true`  |
| ------------------------ | ------------- | ---------------------- | ------------------ |
| 2006-01-01T00:00:00.000Z | 6 أعوام تقريب | 6 أعوام تقريب          | في 6 أعوام تقريب   |
| 2005-01-01T00:00:00.000Z | 5 أعوام تقريب | 5 أعوام تقريب          | في 5 أعوام تقريب   |
| 2004-01-01T00:00:00.000Z | 4 أعوام تقريب | 4 أعوام تقريب          | في 4 أعوام تقريب   |
| 2003-01-01T00:00:00.000Z | 3 أعوام تقريب | 3 أعوام تقريب          | في 3 أعوام تقريب   |
| 2002-01-01T00:00:00.000Z | عامين تقريب   | عامين تقريب            | في عامين تقريب     |
| 2001-06-01T00:00:00.000Z | أكثر من عام   | أكثر من عام            | في أكثر من عام     |
| 2001-02-01T00:00:00.000Z | عام تقريب     | عام تقريب              | في عام تقريب       |
| 2001-01-01T00:00:00.000Z | عام تقريب     | عام تقريب              | في عام تقريب       |
| 2000-06-01T00:00:00.000Z | 5 أشهرة       | 5 أشهرة                | في 5 أشهرة         |
| 2000-03-01T00:00:00.000Z | شهرين         | شهرين                  | في شهرين           |
| 2000-02-01T00:00:00.000Z | شهر تقريب     | شهر تقريب              | في شهر تقريب       |
| 2000-01-15T00:00:00.000Z | 14 يوم        | 14 يوم                 | في 14 يوم          |
| 2000-01-02T00:00:00.000Z | نهار          | نهار                   | في نهار            |
| 2000-01-01T06:00:00.000Z | 6 سوايع تقريب | 6 سوايع تقريب          | في 6 سوايع تقريب   |
| 2000-01-01T01:00:00.000Z | ساعة تقريب    | ساعة تقريب             | في ساعة تقريب      |
| 2000-01-01T00:45:00.000Z | ساعة تقريب    | ساعة تقريب             | في ساعة تقريب      |
| 2000-01-01T00:30:00.000Z | 30 دقيقة      | 30 دقيقة               | في 30 دقيقة        |
| 2000-01-01T00:15:00.000Z | 15 دقيقة      | 15 دقيقة               | في 15 دقيقة        |
| 2000-01-01T00:01:00.000Z | دقيقة         | دقيقة                  | في دقيقة           |
| 2000-01-01T00:00:25.000Z | أقل من دقيقة  | نص دقيقة               | في أقل من دقيقة    |
| 2000-01-01T00:00:15.000Z | أقل من دقيقة  | أقل من 20 ثانية        | في أقل من دقيقة    |
| 2000-01-01T00:00:05.000Z | أقل من دقيقة  | أقل من 10 ثواني        | في أقل من دقيقة    |
| 2000-01-01T00:00:00.000Z | أقل من دقيقة  | أقل من 5 ثواني         | عندو أقل من دقيقة  |
| 1999-12-31T23:59:55.000Z | أقل من دقيقة  | أقل من 10 ثواني        | عندو أقل من دقيقة  |
| 1999-12-31T23:59:45.000Z | أقل من دقيقة  | أقل من 20 ثانية        | عندو أقل من دقيقة  |
| 1999-12-31T23:59:35.000Z | أقل من دقيقة  | نص دقيقة               | عندو أقل من دقيقة  |
| 1999-12-31T23:59:00.000Z | دقيقة         | دقيقة                  | عندو دقيقة         |
| 1999-12-31T23:45:00.000Z | 15 دقيقة      | 15 دقيقة               | عندو 15 دقيقة      |
| 1999-12-31T23:30:00.000Z | 30 دقيقة      | 30 دقيقة               | عندو 30 دقيقة      |
| 1999-12-31T23:15:00.000Z | ساعة تقريب    | ساعة تقريب             | عندو ساعة تقريب    |
| 1999-12-31T23:00:00.000Z | ساعة تقريب    | ساعة تقريب             | عندو ساعة تقريب    |
| 1999-12-31T18:00:00.000Z | 6 سوايع تقريب | 6 سوايع تقريب          | عندو 6 سوايع تقريب |
| 1999-12-30T00:00:00.000Z | نهارين        | نهارين                 | عندو نهارين        |
| 1999-12-15T00:00:00.000Z | 17 يوم        | 17 يوم                 | عندو 17 يوم        |
| 1999-12-01T00:00:00.000Z | شهر تقريب     | شهر تقريب              | عندو شهر تقريب     |
| 1999-11-01T00:00:00.000Z | شهرين         | شهرين                  | عندو شهرين         |
| 1999-06-01T00:00:00.000Z | 7 أشهرة       | 7 أشهرة                | عندو 7 أشهرة       |
| 1999-01-01T00:00:00.000Z | عام تقريب     | عام تقريب              | عندو عام تقريب     |
| 1998-12-01T00:00:00.000Z | عام تقريب     | عام تقريب              | عندو عام تقريب     |
| 1998-06-01T00:00:00.000Z | أكثر من عام   | أكثر من عام            | عندو أكثر من عام   |
| 1998-01-01T00:00:00.000Z | عامين تقريب   | عامين تقريب            | عندو عامين تقريب   |
| 1997-01-01T00:00:00.000Z | 3 أعوام تقريب | 3 أعوام تقريب          | عندو 3 أعوام تقريب |
| 1996-01-01T00:00:00.000Z | 4 أعوام تقريب | 4 أعوام تقريب          | عندو 4 أعوام تقريب |
| 1995-01-01T00:00:00.000Z | 5 أعوام تقريب | 5 أعوام تقريب          | عندو 5 أعوام تقريب |
| 1994-01-01T00:00:00.000Z | 6 أعوام تقريب | 6 أعوام تقريب          | عندو 6 أعوام تقريب |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result   | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | -------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 أعوام  | في 6 أعوام        | 52608 ساعة                     |
| 2005-01-01T00:00:00.000Z | 5 أعوام  | في 5 أعوام        | 43848 ساعة                     |
| 2004-01-01T00:00:00.000Z | 4 أعوام  | في 4 أعوام        | 35064 ساعة                     |
| 2003-01-01T00:00:00.000Z | 3 أعوام  | في 3 أعوام        | 26304 ساعة                     |
| 2002-01-01T00:00:00.000Z | عامين    | في عامين          | 17544 ساعة                     |
| 2001-06-01T00:00:00.000Z | عام      | في عام            | 12408 ساعة                     |
| 2001-02-01T00:00:00.000Z | عام      | في عام            | 9528 ساعة                      |
| 2001-01-01T00:00:00.000Z | عام      | في عام            | 8784 ساعة                      |
| 2000-06-01T00:00:00.000Z | 5 أشهرة  | في 5 أشهرة        | 3648 ساعة                      |
| 2000-03-01T00:00:00.000Z | شهرين    | في شهرين          | 1440 ساعة                      |
| 2000-02-01T00:00:00.000Z | شهر      | في شهر            | 744 ساعة                       |
| 2000-01-15T00:00:00.000Z | 14 يوم   | في 14 يوم         | 336 ساعة                       |
| 2000-01-02T00:00:00.000Z | نهار     | في نهار           | 24 ساعة                        |
| 2000-01-01T06:00:00.000Z | 6 سوايع  | في 6 سوايع        | 6 سوايع                        |
| 2000-01-01T01:00:00.000Z | ساعة     | في ساعة           | ساعة                           |
| 2000-01-01T00:45:00.000Z | 45 دقيقة | في 45 دقيقة       | ساعة                           |
| 2000-01-01T00:30:00.000Z | 30 دقيقة | في 30 دقيقة       | ساعة                           |
| 2000-01-01T00:15:00.000Z | 15 دقيقة | في 15 دقيقة       | 0 سوايع                        |
| 2000-01-01T00:01:00.000Z | دقيقة    | في دقيقة          | 0 سوايع                        |
| 2000-01-01T00:00:25.000Z | 25 ثانية | في 25 ثانية       | 0 سوايع                        |
| 2000-01-01T00:00:15.000Z | 15 ثانية | في 15 ثانية       | 0 سوايع                        |
| 2000-01-01T00:00:05.000Z | 5 ثواني  | في 5 ثواني        | 0 سوايع                        |
| 2000-01-01T00:00:00.000Z | 0 ثواني  | عندو 0 ثواني      | 0 سوايع                        |
| 1999-12-31T23:59:55.000Z | 5 ثواني  | عندو 5 ثواني      | 0 سوايع                        |
| 1999-12-31T23:59:45.000Z | 15 ثانية | عندو 15 ثانية     | 0 سوايع                        |
| 1999-12-31T23:59:35.000Z | 25 ثانية | عندو 25 ثانية     | 0 سوايع                        |
| 1999-12-31T23:59:00.000Z | دقيقة    | عندو دقيقة        | 0 سوايع                        |
| 1999-12-31T23:45:00.000Z | 15 دقيقة | عندو 15 دقيقة     | 0 سوايع                        |
| 1999-12-31T23:30:00.000Z | 30 دقيقة | عندو 30 دقيقة     | ساعة                           |
| 1999-12-31T23:15:00.000Z | 45 دقيقة | عندو 45 دقيقة     | ساعة                           |
| 1999-12-31T23:00:00.000Z | ساعة     | عندو ساعة         | ساعة                           |
| 1999-12-31T18:00:00.000Z | 6 سوايع  | عندو 6 سوايع      | 6 سوايع                        |
| 1999-12-30T00:00:00.000Z | نهارين   | عندو نهارين       | 48 ساعة                        |
| 1999-12-15T00:00:00.000Z | 17 يوم   | عندو 17 يوم       | 408 ساعة                       |
| 1999-12-01T00:00:00.000Z | شهر      | عندو شهر          | 744 ساعة                       |
| 1999-11-01T00:00:00.000Z | شهرين    | عندو شهرين        | 1464 ساعة                      |
| 1999-06-01T00:00:00.000Z | 7 أشهرة  | عندو 7 أشهرة      | 5136 ساعة                      |
| 1999-01-01T00:00:00.000Z | عام      | عندو عام          | 8760 ساعة                      |
| 1998-12-01T00:00:00.000Z | عام      | عندو عام          | 9504 ساعة                      |
| 1998-06-01T00:00:00.000Z | عامين    | عندو عامين        | 13896 ساعة                     |
| 1998-01-01T00:00:00.000Z | عامين    | عندو عامين        | 17520 ساعة                     |
| 1997-01-01T00:00:00.000Z | 3 أعوام  | عندو 3 أعوام      | 26280 ساعة                     |
| 1996-01-01T00:00:00.000Z | 4 أعوام  | عندو 4 أعوام      | 35064 ساعة                     |
| 1995-01-01T00:00:00.000Z | 5 أعوام  | عندو 5 أعوام      | 43824 ساعة                     |
| 1994-01-01T00:00:00.000Z | 6 أعوام  | عندو 6 أعوام      | 52584 ساعة                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                               |
| ------------------------ | ------------------------------------ |
| 2000-01-10T00:00:00.000Z | 10/01/2000                           |
| 2000-01-05T00:00:00.000Z | الأربعاء الجمعة الجاية مع 00:00 نهار |
| 2000-01-02T00:00:00.000Z | غدوة مع 00:00                        |
| 2000-01-01T00:00:00.000Z | اليوم مع 00:00                       |
| 1999-12-31T00:00:00.000Z | البارح مع 00:00                      |
| 1999-12-27T00:00:00.000Z | الاثنين إلي فات مع 00:00             |
| 1999-12-21T00:00:00.000Z | 21/12/1999                           |

## `formatDuration`

| Duration      | Result    |
| ------------- | --------- |
| {"years":0}   | 0 أعوام   |
| {"years":1}   | عام       |
| {"years":2}   | عامين     |
| {"months":0}  | 0 أشهرة   |
| {"months":1}  | شهر       |
| {"months":2}  | شهرين     |
| {"weeks":0}   | 0 جماع    |
| {"weeks":1}   | جمعة      |
| {"weeks":2}   | جمعتين    |
| {"days":0}    | 0 أيام    |
| {"days":1}    | نهار      |
| {"days":2}    | نهارين    |
| {"hours":0}   | 0 سوايع   |
| {"hours":1}   | ساعة      |
| {"hours":2}   | ساعتين    |
| {"minutes":0} | 0 دقايق   |
| {"minutes":1} | دقيقة     |
| {"minutes":2} | دقيقتين   |
| {"seconds":0} | 0 ثواني   |
| {"seconds":1} | ثانية     |
| {"seconds":2} | زوز ثواني |
