import { toDate } from "../toDate/index.js";
import type { ContextOptions, DateArg } from "../types.js";

/**
 * The {@link isFirstDayOfMonth} function options.
 */
export interface IsFirstDayOfMonthOptions extends ContextOptions<Date> {}

/**
 * @name isFirstDayOfMonth
 * @category Month Helpers
 * @summary Is the given date the first day of a month?
 *
 * @description
 * Is the given date the first day of a month?
 *
 * @param date - The date to check
 * @param options - An object with options
 *
 * @returns The date is the first day of a month
 *
 * @example
 * // Is 1 September 2014 the first day of a month?
 * const result = isFirstDayOfMonth(new Date(2014, 8, 1))
 * //=> true
 */
export function isFirstDayOfMonth(
  date: DateArg<Date> & {},
  options?: IsFirstDayOfMonthOptions | undefined,
): boolean {
  return toDate(date, options?.in).getDate() === 1;
}
