import { toDate } from "../toDate/index.js";
import type { ContextOptions, DateArg } from "../types.js";

/**
 * The {@link getMonth} function options.
 */
export interface GetMonthOptions extends ContextOptions<Date> {}

/**
 * @name getMonth
 * @category Month Helpers
 * @summary Get the month of the given date.
 *
 * @description
 * Get the month of the given date.
 *
 * @param date - The given date
 * @param options - An object with options
 *
 * @returns The month index (0-11)
 *
 * @example
 * // Which month is 29 February 2012?
 * const result = getMonth(new Date(2012, 1, 29))
 * //=> 1
 */
export function getMonth(
  date: DateArg<Date> & {},
  options?: GetMonthOptions | undefined,
): number {
  return toDate(date, options?.in).getMonth();
}
