# coding: utf-8

"""
    OpenAI API

    The OpenAI REST API. Please see https://platform.openai.com/docs/api-reference for more details.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_server_v2.models.vector_store_expiration_after import VectorStoreExpirationAfter
from openapi_server_v2.models.vector_store_object_file_counts import VectorStoreObjectFileCounts
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class VectorStoreObject(BaseModel):
    """
    A vector store is a collection of processed files can be used by the `file_search` tool.
    """ # noqa: E501
    id: StrictStr = Field(description="The identifier, which can be referenced in API endpoints.")
    object: StrictStr = Field(description="The object type, which is always `vector_store`.")
    created_at: StrictInt = Field(description="The Unix timestamp (in seconds) for when the vector store was created.")
    name: StrictStr = Field(description="The name of the vector store.")
    usage_bytes: StrictInt = Field(description="The total number of bytes used by the files in the vector store.")
    file_counts: VectorStoreObjectFileCounts
    status: StrictStr = Field(description="The status of the vector store, which can be either `expired`, `in_progress`, or `completed`. A status of `completed` indicates that the vector store is ready for use.")
    expires_after: Optional[VectorStoreExpirationAfter] = None
    expires_at: Optional[StrictInt] = Field(default=None, description="The Unix timestamp (in seconds) for when the vector store will expire.")
    last_active_at: Optional[StrictInt] = Field(description="The Unix timestamp (in seconds) for when the vector store was last active.")
    metadata: Optional[Dict[str, Any]] = Field(description="Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long. ")
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "name", "usage_bytes", "file_counts", "status", "expires_after", "expires_at", "last_active_at", "metadata"]

    @field_validator('object')
    def object_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('vector_store'):
            raise ValueError("must be one of enum values ('vector_store')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('expired', 'in_progress', 'completed'):
            raise ValueError("must be one of enum values ('expired', 'in_progress', 'completed')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of VectorStoreObject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of file_counts
        if self.file_counts:
            _dict['file_counts'] = self.file_counts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of expires_after
        if self.expires_after:
            _dict['expires_after'] = self.expires_after.to_dict()
        # set to None if expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.expires_at is None and "expires_at" in self.model_fields_set:
            _dict['expires_at'] = None

        # set to None if last_active_at (nullable) is None
        # and model_fields_set contains the field
        if self.last_active_at is None and "last_active_at" in self.model_fields_set:
            _dict['last_active_at'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of VectorStoreObject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "name": obj.get("name"),
            "usage_bytes": obj.get("usage_bytes"),
            "file_counts": VectorStoreObjectFileCounts.from_dict(obj.get("file_counts")) if obj.get("file_counts") is not None else None,
            "status": obj.get("status"),
            "expires_after": VectorStoreExpirationAfter.from_dict(obj.get("expires_after")) if obj.get("expires_after") is not None else None,
            "expires_at": obj.get("expires_at"),
            "last_active_at": obj.get("last_active_at"),
            "metadata": obj.get("metadata")
        })
        return _obj


