# coding: utf-8

"""
    OpenAI API

    The OpenAI REST API. Please see https://platform.openai.com/docs/api-reference for more details.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_server_v2.models.vector_store_file_object_last_error import VectorStoreFileObjectLastError
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class VectorStoreFileObject(BaseModel):
    """
    A list of files attached to a vector store.
    """ # noqa: E501
    id: StrictStr = Field(description="The identifier, which can be referenced in API endpoints.")
    object: StrictStr = Field(description="The object type, which is always `vector_store.file`.")
    usage_bytes: StrictInt = Field(description="The total vector store usage in bytes. Note that this may be different from the original file size.")
    created_at: StrictInt = Field(description="The Unix timestamp (in seconds) for when the vector store file was created.")
    vector_store_id: StrictStr = Field(description="The ID of the [vector store](/docs/api-reference/vector-stores/object) that the [File](/docs/api-reference/files) is attached to.")
    status: StrictStr = Field(description="The status of the vector store file, which can be either `in_progress`, `completed`, `cancelled`, or `failed`. The status `completed` indicates that the vector store file is ready for use.")
    last_error: Optional[VectorStoreFileObjectLastError]
    __properties: ClassVar[List[str]] = ["id", "object", "usage_bytes", "created_at", "vector_store_id", "status", "last_error"]

    @field_validator('object')
    def object_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('vector_store.file'):
            raise ValueError("must be one of enum values ('vector_store.file')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('in_progress', 'completed', 'cancelled', 'failed'):
            raise ValueError("must be one of enum values ('in_progress', 'completed', 'cancelled', 'failed')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of VectorStoreFileObject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of last_error
        if self.last_error:
            _dict['last_error'] = self.last_error.to_dict()
        # set to None if last_error (nullable) is None
        # and model_fields_set contains the field
        if self.last_error is None and "last_error" in self.model_fields_set:
            _dict['last_error'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of VectorStoreFileObject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "usage_bytes": obj.get("usage_bytes"),
            "created_at": obj.get("created_at"),
            "vector_store_id": obj.get("vector_store_id"),
            "status": obj.get("status"),
            "last_error": VectorStoreFileObjectLastError.from_dict(obj.get("last_error")) if obj.get("last_error") is not None else None
        })
        return _obj


