# coding: utf-8

"""
    OpenAI API

    The OpenAI REST API. Please see https://platform.openai.com/docs/api-reference for more details.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from openapi_server_v2.models.vector_store_file_batch_object_file_counts import VectorStoreFileBatchObjectFileCounts
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class VectorStoreFileBatchObject(BaseModel):
    """
    A batch of files attached to a vector store.
    """ # noqa: E501
    id: StrictStr = Field(description="The identifier, which can be referenced in API endpoints.")
    object: StrictStr = Field(description="The object type, which is always `vector_store.file_batch`.")
    created_at: StrictInt = Field(description="The Unix timestamp (in seconds) for when the vector store files batch was created.")
    vector_store_id: StrictStr = Field(description="The ID of the [vector store](/docs/api-reference/vector-stores/object) that the [File](/docs/api-reference/files) is attached to.")
    status: StrictStr = Field(description="The status of the vector store files batch, which can be either `in_progress`, `completed`, `cancelled` or `failed`.")
    file_counts: VectorStoreFileBatchObjectFileCounts
    __properties: ClassVar[List[str]] = ["id", "object", "created_at", "vector_store_id", "status", "file_counts"]

    @field_validator('object')
    def object_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('vector_store.files_batch'):
            raise ValueError("must be one of enum values ('vector_store.files_batch')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('in_progress', 'completed', 'cancelled', 'failed'):
            raise ValueError("must be one of enum values ('in_progress', 'completed', 'cancelled', 'failed')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of VectorStoreFileBatchObject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of file_counts
        if self.file_counts:
            _dict['file_counts'] = self.file_counts.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of VectorStoreFileBatchObject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "vector_store_id": obj.get("vector_store_id"),
            "status": obj.get("status"),
            "file_counts": VectorStoreFileBatchObjectFileCounts.from_dict(obj.get("file_counts")) if obj.get("file_counts") is not None else None
        })
        return _obj


