# coding: utf-8

"""
    OpenAI API

    The OpenAI REST API. Please see https://platform.openai.com/docs/api-reference for more details.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401



from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from openapi_server_v2.models.run_step_details_tool_calls_code_object import RunStepDetailsToolCallsCodeObject
from openapi_server_v2.models.run_step_details_tool_calls_file_search_object import RunStepDetailsToolCallsFileSearchObject
from openapi_server_v2.models.run_step_details_tool_calls_function_object import RunStepDetailsToolCallsFunctionObject
from typing import Union, Any, List, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal
from pydantic import StrictStr, Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

RUNSTEPDETAILSTOOLCALLSOBJECTTOOLCALLSINNER_ONE_OF_SCHEMAS = ["RunStepDetailsToolCallsCodeObject", "RunStepDetailsToolCallsFileSearchObject", "RunStepDetailsToolCallsFunctionObject"]

class RunStepDetailsToolCallsObjectToolCallsInner(BaseModel):
    """
    RunStepDetailsToolCallsObjectToolCallsInner
    """
    # data type: RunStepDetailsToolCallsCodeObject
    oneof_schema_1_validator: Optional[RunStepDetailsToolCallsCodeObject] = None
    # data type: RunStepDetailsToolCallsFileSearchObject
    oneof_schema_2_validator: Optional[RunStepDetailsToolCallsFileSearchObject] = None
    # data type: RunStepDetailsToolCallsFunctionObject
    oneof_schema_3_validator: Optional[RunStepDetailsToolCallsFunctionObject] = None
    actual_instance: Optional[Union[RunStepDetailsToolCallsCodeObject, RunStepDetailsToolCallsFileSearchObject, RunStepDetailsToolCallsFunctionObject]] = None
    one_of_schemas: List[str] = Literal["RunStepDetailsToolCallsCodeObject", "RunStepDetailsToolCallsFileSearchObject", "RunStepDetailsToolCallsFunctionObject"]

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = RunStepDetailsToolCallsObjectToolCallsInner.model_construct()
        error_messages = []
        match = 0
        # validate data type: RunStepDetailsToolCallsCodeObject
        if not isinstance(v, RunStepDetailsToolCallsCodeObject):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RunStepDetailsToolCallsCodeObject`")
        else:
            match += 1
        # validate data type: RunStepDetailsToolCallsFileSearchObject
        if not isinstance(v, RunStepDetailsToolCallsFileSearchObject):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RunStepDetailsToolCallsFileSearchObject`")
        else:
            match += 1
        # validate data type: RunStepDetailsToolCallsFunctionObject
        if not isinstance(v, RunStepDetailsToolCallsFunctionObject):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RunStepDetailsToolCallsFunctionObject`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in RunStepDetailsToolCallsObjectToolCallsInner with oneOf schemas: RunStepDetailsToolCallsCodeObject, RunStepDetailsToolCallsFileSearchObject, RunStepDetailsToolCallsFunctionObject. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in RunStepDetailsToolCallsObjectToolCallsInner with oneOf schemas: RunStepDetailsToolCallsCodeObject, RunStepDetailsToolCallsFileSearchObject, RunStepDetailsToolCallsFunctionObject. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into RunStepDetailsToolCallsCodeObject
        try:
            instance.actual_instance = RunStepDetailsToolCallsCodeObject.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RunStepDetailsToolCallsFileSearchObject
        try:
            instance.actual_instance = RunStepDetailsToolCallsFileSearchObject.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RunStepDetailsToolCallsFunctionObject
        try:
            instance.actual_instance = RunStepDetailsToolCallsFunctionObject.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into RunStepDetailsToolCallsObjectToolCallsInner with oneOf schemas: RunStepDetailsToolCallsCodeObject, RunStepDetailsToolCallsFileSearchObject, RunStepDetailsToolCallsFunctionObject. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into RunStepDetailsToolCallsObjectToolCallsInner with oneOf schemas: RunStepDetailsToolCallsCodeObject, RunStepDetailsToolCallsFileSearchObject, RunStepDetailsToolCallsFunctionObject. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


