# coding: utf-8

"""
    OpenAI API

    The OpenAI REST API. Please see https://platform.openai.com/docs/api-reference for more details.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401



from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from openapi_server_v2.models.message_stream_event_one_of import MessageStreamEventOneOf
from openapi_server_v2.models.message_stream_event_one_of1 import MessageStreamEventOneOf1
from openapi_server_v2.models.message_stream_event_one_of2 import MessageStreamEventOneOf2
from openapi_server_v2.models.message_stream_event_one_of3 import MessageStreamEventOneOf3
from openapi_server_v2.models.message_stream_event_one_of4 import MessageStreamEventOneOf4
from typing import Union, Any, List, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal
from pydantic import StrictStr, Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

MESSAGESTREAMEVENT_ONE_OF_SCHEMAS = ["MessageStreamEventOneOf", "MessageStreamEventOneOf1", "MessageStreamEventOneOf2", "MessageStreamEventOneOf3", "MessageStreamEventOneOf4"]

class MessageStreamEvent(BaseModel):
    """
    MessageStreamEvent
    """
    # data type: MessageStreamEventOneOf
    oneof_schema_1_validator: Optional[MessageStreamEventOneOf] = None
    # data type: MessageStreamEventOneOf1
    oneof_schema_2_validator: Optional[MessageStreamEventOneOf1] = None
    # data type: MessageStreamEventOneOf2
    oneof_schema_3_validator: Optional[MessageStreamEventOneOf2] = None
    # data type: MessageStreamEventOneOf3
    oneof_schema_4_validator: Optional[MessageStreamEventOneOf3] = None
    # data type: MessageStreamEventOneOf4
    oneof_schema_5_validator: Optional[MessageStreamEventOneOf4] = None
    actual_instance: Optional[Union[MessageStreamEventOneOf, MessageStreamEventOneOf1, MessageStreamEventOneOf2, MessageStreamEventOneOf3, MessageStreamEventOneOf4]] = None
    one_of_schemas: List[str] = Literal["MessageStreamEventOneOf", "MessageStreamEventOneOf1", "MessageStreamEventOneOf2", "MessageStreamEventOneOf3", "MessageStreamEventOneOf4"]

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = MessageStreamEvent.model_construct()
        error_messages = []
        match = 0
        # validate data type: MessageStreamEventOneOf
        if not isinstance(v, MessageStreamEventOneOf):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MessageStreamEventOneOf`")
        else:
            match += 1
        # validate data type: MessageStreamEventOneOf1
        if not isinstance(v, MessageStreamEventOneOf1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MessageStreamEventOneOf1`")
        else:
            match += 1
        # validate data type: MessageStreamEventOneOf2
        if not isinstance(v, MessageStreamEventOneOf2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MessageStreamEventOneOf2`")
        else:
            match += 1
        # validate data type: MessageStreamEventOneOf3
        if not isinstance(v, MessageStreamEventOneOf3):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MessageStreamEventOneOf3`")
        else:
            match += 1
        # validate data type: MessageStreamEventOneOf4
        if not isinstance(v, MessageStreamEventOneOf4):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MessageStreamEventOneOf4`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in MessageStreamEvent with oneOf schemas: MessageStreamEventOneOf, MessageStreamEventOneOf1, MessageStreamEventOneOf2, MessageStreamEventOneOf3, MessageStreamEventOneOf4. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in MessageStreamEvent with oneOf schemas: MessageStreamEventOneOf, MessageStreamEventOneOf1, MessageStreamEventOneOf2, MessageStreamEventOneOf3, MessageStreamEventOneOf4. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into MessageStreamEventOneOf
        try:
            instance.actual_instance = MessageStreamEventOneOf.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MessageStreamEventOneOf1
        try:
            instance.actual_instance = MessageStreamEventOneOf1.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MessageStreamEventOneOf2
        try:
            instance.actual_instance = MessageStreamEventOneOf2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MessageStreamEventOneOf3
        try:
            instance.actual_instance = MessageStreamEventOneOf3.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MessageStreamEventOneOf4
        try:
            instance.actual_instance = MessageStreamEventOneOf4.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into MessageStreamEvent with oneOf schemas: MessageStreamEventOneOf, MessageStreamEventOneOf1, MessageStreamEventOneOf2, MessageStreamEventOneOf3, MessageStreamEventOneOf4. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into MessageStreamEvent with oneOf schemas: MessageStreamEventOneOf, MessageStreamEventOneOf1, MessageStreamEventOneOf2, MessageStreamEventOneOf3, MessageStreamEventOneOf4. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


