# coding: utf-8

"""
    OpenAI API

    The OpenAI REST API. Please see https://platform.openai.com/docs/api-reference for more details.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class FineTuningJobCheckpointMetrics(BaseModel):
    """
    Metrics at the step number during the fine-tuning job.
    """ # noqa: E501
    step: Optional[Union[StrictFloat, StrictInt]] = None
    train_loss: Optional[Union[StrictFloat, StrictInt]] = None
    train_mean_token_accuracy: Optional[Union[StrictFloat, StrictInt]] = None
    valid_loss: Optional[Union[StrictFloat, StrictInt]] = None
    valid_mean_token_accuracy: Optional[Union[StrictFloat, StrictInt]] = None
    full_valid_loss: Optional[Union[StrictFloat, StrictInt]] = None
    full_valid_mean_token_accuracy: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["step", "train_loss", "train_mean_token_accuracy", "valid_loss", "valid_mean_token_accuracy", "full_valid_loss", "full_valid_mean_token_accuracy"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of FineTuningJobCheckpointMetrics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of FineTuningJobCheckpointMetrics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "step": obj.get("step"),
            "train_loss": obj.get("train_loss"),
            "train_mean_token_accuracy": obj.get("train_mean_token_accuracy"),
            "valid_loss": obj.get("valid_loss"),
            "valid_mean_token_accuracy": obj.get("valid_mean_token_accuracy"),
            "full_valid_loss": obj.get("full_valid_loss"),
            "full_valid_mean_token_accuracy": obj.get("full_valid_mean_token_accuracy")
        })
        return _obj


