# coding: utf-8

"""
    OpenAI API

    The OpenAI REST API. Please see https://platform.openai.com/docs/api-reference for more details.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from openapi_server_v2.models.fine_tuning_job_checkpoint_metrics import FineTuningJobCheckpointMetrics
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class FineTuningJobCheckpoint(BaseModel):
    """
    The `fine_tuning.job.checkpoint` object represents a model checkpoint for a fine-tuning job that is ready to use. 
    """ # noqa: E501
    id: StrictStr = Field(description="The checkpoint identifier, which can be referenced in the API endpoints.")
    created_at: StrictInt = Field(description="The Unix timestamp (in seconds) for when the checkpoint was created.")
    fine_tuned_model_checkpoint: StrictStr = Field(description="The name of the fine-tuned checkpoint model that is created.")
    step_number: StrictInt = Field(description="The step number that the checkpoint was created at.")
    metrics: FineTuningJobCheckpointMetrics
    fine_tuning_job_id: StrictStr = Field(description="The name of the fine-tuning job that this checkpoint was created from.")
    object: StrictStr = Field(description="The object type, which is always \"fine_tuning.job.checkpoint\".")
    __properties: ClassVar[List[str]] = ["id", "created_at", "fine_tuned_model_checkpoint", "step_number", "metrics", "fine_tuning_job_id", "object"]

    @field_validator('object')
    def object_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('fine_tuning.job.checkpoint'):
            raise ValueError("must be one of enum values ('fine_tuning.job.checkpoint')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of FineTuningJobCheckpoint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metrics
        if self.metrics:
            _dict['metrics'] = self.metrics.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of FineTuningJobCheckpoint from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "created_at": obj.get("created_at"),
            "fine_tuned_model_checkpoint": obj.get("fine_tuned_model_checkpoint"),
            "step_number": obj.get("step_number"),
            "metrics": FineTuningJobCheckpointMetrics.from_dict(obj.get("metrics")) if obj.get("metrics") is not None else None,
            "fine_tuning_job_id": obj.get("fine_tuning_job_id"),
            "object": obj.get("object")
        })
        return _obj


