# coding: utf-8

"""
    OpenAI API

    The OpenAI REST API. Please see https://platform.openai.com/docs/api-reference for more details.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from openapi_server_v2.models.transcription_segment import TranscriptionSegment
from openapi_server_v2.models.transcription_word import TranscriptionWord
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CreateTranscriptionResponseVerboseJson(BaseModel):
    """
    Represents a verbose json transcription response returned by model, based on the provided input.
    """ # noqa: E501
    language: StrictStr = Field(description="The language of the input audio.")
    duration: StrictStr = Field(description="The duration of the input audio.")
    text: StrictStr = Field(description="The transcribed text.")
    words: Optional[List[TranscriptionWord]] = Field(default=None, description="Extracted words and their corresponding timestamps.")
    segments: Optional[List[TranscriptionSegment]] = Field(default=None, description="Segments of the transcribed text and their corresponding details.")
    __properties: ClassVar[List[str]] = ["language", "duration", "text", "words", "segments"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CreateTranscriptionResponseVerboseJson from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in words (list)
        _items = []
        if self.words:
            for _item in self.words:
                if _item:
                    _items.append(_item.to_dict())
            _dict['words'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in segments (list)
        _items = []
        if self.segments:
            for _item in self.segments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['segments'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CreateTranscriptionResponseVerboseJson from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "language": obj.get("language"),
            "duration": obj.get("duration"),
            "text": obj.get("text"),
            "words": [TranscriptionWord.from_dict(_item) for _item in obj.get("words")] if obj.get("words") is not None else None,
            "segments": [TranscriptionSegment.from_dict(_item) for _item in obj.get("segments")] if obj.get("segments") is not None else None
        })
        return _obj


