# coding: utf-8

"""
    OpenAI API

    The OpenAI REST API. Please see https://platform.openai.com/docs/api-reference for more details.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_server_v2.models.create_speech_request_model import CreateSpeechRequestModel
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CreateSpeechRequest(BaseModel):
    """
    CreateSpeechRequest
    """ # noqa: E501
    model: CreateSpeechRequestModel
    input: Annotated[str, Field(strict=True, max_length=4096)] = Field(description="The text to generate audio for. The maximum length is 4096 characters.")
    voice: StrictStr = Field(description="The voice to use when generating the audio. Supported voices are `alloy`, `echo`, `fable`, `onyx`, `nova`, and `shimmer`. Previews of the voices are available in the [Text to speech guide](/docs/guides/text-to-speech/voice-options).")
    response_format: Optional[StrictStr] = Field(default='mp3', description="The format to audio in. Supported formats are `mp3`, `opus`, `aac`, `flac`, `wav`, and `pcm`.")
    speed: Optional[Union[Annotated[float, Field(le=4.0, strict=True, ge=0.25)], Annotated[int, Field(le=4, strict=True, ge=1)]]] = Field(default=1.0, description="The speed of the generated audio. Select a value from `0.25` to `4.0`. `1.0` is the default.")
    __properties: ClassVar[List[str]] = ["model", "input", "voice", "response_format", "speed"]

    @field_validator('voice')
    def voice_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('alloy', 'echo', 'fable', 'onyx', 'nova', 'shimmer'):
            raise ValueError("must be one of enum values ('alloy', 'echo', 'fable', 'onyx', 'nova', 'shimmer')")
        return value

    @field_validator('response_format')
    def response_format_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('mp3', 'opus', 'aac', 'flac', 'wav', 'pcm'):
            raise ValueError("must be one of enum values ('mp3', 'opus', 'aac', 'flac', 'wav', 'pcm')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CreateSpeechRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of model
        if self.model:
            _dict['model'] = self.model.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CreateSpeechRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "model": CreateSpeechRequestModel.from_dict(obj.get("model")) if obj.get("model") is not None else None,
            "input": obj.get("input"),
            "voice": obj.get("voice"),
            "response_format": obj.get("response_format") if obj.get("response_format") is not None else 'mp3',
            "speed": obj.get("speed") if obj.get("speed") is not None else 1.0
        })
        return _obj


