# coding: utf-8

"""
    OpenAI API

    The OpenAI REST API. Please see https://platform.openai.com/docs/api-reference for more details.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Union
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CreateModerationResponseResultsInnerCategoryScores(BaseModel):
    """
    A list of the categories along with their scores as predicted by model.
    """ # noqa: E501
    hate: Union[StrictFloat, StrictInt] = Field(description="The score for the category 'hate'.")
    hate_threatening: Union[StrictFloat, StrictInt] = Field(description="The score for the category 'hate/threatening'.", alias="hate/threatening")
    harassment: Union[StrictFloat, StrictInt] = Field(description="The score for the category 'harassment'.")
    harassment_threatening: Union[StrictFloat, StrictInt] = Field(description="The score for the category 'harassment/threatening'.", alias="harassment/threatening")
    self_harm: Union[StrictFloat, StrictInt] = Field(description="The score for the category 'self-harm'.", alias="self-harm")
    self_harm_intent: Union[StrictFloat, StrictInt] = Field(description="The score for the category 'self-harm/intent'.", alias="self-harm/intent")
    self_harm_instructions: Union[StrictFloat, StrictInt] = Field(description="The score for the category 'self-harm/instructions'.", alias="self-harm/instructions")
    sexual: Union[StrictFloat, StrictInt] = Field(description="The score for the category 'sexual'.")
    sexual_minors: Union[StrictFloat, StrictInt] = Field(description="The score for the category 'sexual/minors'.", alias="sexual/minors")
    violence: Union[StrictFloat, StrictInt] = Field(description="The score for the category 'violence'.")
    violence_graphic: Union[StrictFloat, StrictInt] = Field(description="The score for the category 'violence/graphic'.", alias="violence/graphic")
    __properties: ClassVar[List[str]] = ["hate", "hate/threatening", "harassment", "harassment/threatening", "self-harm", "self-harm/intent", "self-harm/instructions", "sexual", "sexual/minors", "violence", "violence/graphic"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CreateModerationResponseResultsInnerCategoryScores from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CreateModerationResponseResultsInnerCategoryScores from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "hate": obj.get("hate"),
            "hate/threatening": obj.get("hate/threatening"),
            "harassment": obj.get("harassment"),
            "harassment/threatening": obj.get("harassment/threatening"),
            "self-harm": obj.get("self-harm"),
            "self-harm/intent": obj.get("self-harm/intent"),
            "self-harm/instructions": obj.get("self-harm/instructions"),
            "sexual": obj.get("sexual"),
            "sexual/minors": obj.get("sexual/minors"),
            "violence": obj.get("violence"),
            "violence/graphic": obj.get("violence/graphic")
        })
        return _obj


