# coding: utf-8

"""
    OpenAI API

    The OpenAI REST API. Please see https://platform.openai.com/docs/api-reference for more details.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List
from openapi_server_v2.models.create_moderation_response_results_inner_categories import CreateModerationResponseResultsInnerCategories
from openapi_server_v2.models.create_moderation_response_results_inner_category_scores import CreateModerationResponseResultsInnerCategoryScores
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CreateModerationResponseResultsInner(BaseModel):
    """
    CreateModerationResponseResultsInner
    """ # noqa: E501
    flagged: StrictBool = Field(description="Whether any of the below categories are flagged.")
    categories: CreateModerationResponseResultsInnerCategories
    category_scores: CreateModerationResponseResultsInnerCategoryScores
    __properties: ClassVar[List[str]] = ["flagged", "categories", "category_scores"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CreateModerationResponseResultsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of categories
        if self.categories:
            _dict['categories'] = self.categories.to_dict()
        # override the default output from pydantic by calling `to_dict()` of category_scores
        if self.category_scores:
            _dict['category_scores'] = self.category_scores.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CreateModerationResponseResultsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "flagged": obj.get("flagged"),
            "categories": CreateModerationResponseResultsInnerCategories.from_dict(obj.get("categories")) if obj.get("categories") is not None else None,
            "category_scores": CreateModerationResponseResultsInnerCategoryScores.from_dict(obj.get("category_scores")) if obj.get("category_scores") is not None else None
        })
        return _obj


