# coding: utf-8

"""
    OpenAI API

    The OpenAI REST API. Please see https://platform.openai.com/docs/api-reference for more details.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from openapi_server_v2.models.chat_completion_response_message import ChatCompletionResponseMessage
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class CreateChatCompletionFunctionResponseChoicesInner(BaseModel):
    """
    CreateChatCompletionFunctionResponseChoicesInner
    """ # noqa: E501
    finish_reason: StrictStr = Field(description="The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence, `length` if the maximum number of tokens specified in the request was reached, `content_filter` if content was omitted due to a flag from our content filters, or `function_call` if the model called a function. ")
    index: StrictInt = Field(description="The index of the choice in the list of choices.")
    message: ChatCompletionResponseMessage
    __properties: ClassVar[List[str]] = ["finish_reason", "index", "message"]

    @field_validator('finish_reason')
    def finish_reason_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('stop', 'length', 'function_call', 'content_filter'):
            raise ValueError("must be one of enum values ('stop', 'length', 'function_call', 'content_filter')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CreateChatCompletionFunctionResponseChoicesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of message
        if self.message:
            _dict['message'] = self.message.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of CreateChatCompletionFunctionResponseChoicesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "finish_reason": obj.get("finish_reason"),
            "index": obj.get("index"),
            "message": ChatCompletionResponseMessage.from_dict(obj.get("message")) if obj.get("message") is not None else None
        })
        return _obj


