# coding: utf-8

"""
    OpenAI API

    The OpenAI REST API. Please see https://platform.openai.com/docs/api-reference for more details.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_server_v2.models.batch_errors import BatchErrors
from openapi_server_v2.models.batch_request_counts import BatchRequestCounts
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class Batch(BaseModel):
    """
    Batch
    """ # noqa: E501
    id: StrictStr
    object: StrictStr = Field(description="The object type, which is always `batch`.")
    endpoint: StrictStr = Field(description="The OpenAI API endpoint used by the batch.")
    errors: Optional[BatchErrors] = None
    input_file_id: StrictStr = Field(description="The ID of the input file for the batch.")
    completion_window: StrictStr = Field(description="The time frame within which the batch should be processed.")
    status: StrictStr = Field(description="The current status of the batch.")
    output_file_id: Optional[StrictStr] = Field(default=None, description="The ID of the file containing the outputs of successfully executed requests.")
    error_file_id: Optional[StrictStr] = Field(default=None, description="The ID of the file containing the outputs of requests with errors.")
    created_at: StrictInt = Field(description="The Unix timestamp (in seconds) for when the batch was created.")
    in_progress_at: Optional[StrictInt] = Field(default=None, description="The Unix timestamp (in seconds) for when the batch started processing.")
    expires_at: Optional[StrictInt] = Field(default=None, description="The Unix timestamp (in seconds) for when the batch will expire.")
    finalizing_at: Optional[StrictInt] = Field(default=None, description="The Unix timestamp (in seconds) for when the batch started finalizing.")
    completed_at: Optional[StrictInt] = Field(default=None, description="The Unix timestamp (in seconds) for when the batch was completed.")
    failed_at: Optional[StrictInt] = Field(default=None, description="The Unix timestamp (in seconds) for when the batch failed.")
    expired_at: Optional[StrictInt] = Field(default=None, description="The Unix timestamp (in seconds) for when the batch expired.")
    cancelling_at: Optional[StrictInt] = Field(default=None, description="The Unix timestamp (in seconds) for when the batch started cancelling.")
    cancelled_at: Optional[StrictInt] = Field(default=None, description="The Unix timestamp (in seconds) for when the batch was cancelled.")
    request_counts: Optional[BatchRequestCounts] = None
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long. ")
    __properties: ClassVar[List[str]] = ["id", "object", "endpoint", "errors", "input_file_id", "completion_window", "status", "output_file_id", "error_file_id", "created_at", "in_progress_at", "expires_at", "finalizing_at", "completed_at", "failed_at", "expired_at", "cancelling_at", "cancelled_at", "request_counts", "metadata"]

    @field_validator('object')
    def object_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('batch'):
            raise ValueError("must be one of enum values ('batch')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('validating', 'failed', 'in_progress', 'finalizing', 'completed', 'expired', 'cancelling', 'cancelled'):
            raise ValueError("must be one of enum values ('validating', 'failed', 'in_progress', 'finalizing', 'completed', 'expired', 'cancelling', 'cancelled')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Batch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of errors
        if self.errors:
            _dict['errors'] = self.errors.to_dict()
        # override the default output from pydantic by calling `to_dict()` of request_counts
        if self.request_counts:
            _dict['request_counts'] = self.request_counts.to_dict()
        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Batch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "object": obj.get("object"),
            "endpoint": obj.get("endpoint"),
            "errors": BatchErrors.from_dict(obj.get("errors")) if obj.get("errors") is not None else None,
            "input_file_id": obj.get("input_file_id"),
            "completion_window": obj.get("completion_window"),
            "status": obj.get("status"),
            "output_file_id": obj.get("output_file_id"),
            "error_file_id": obj.get("error_file_id"),
            "created_at": obj.get("created_at"),
            "in_progress_at": obj.get("in_progress_at"),
            "expires_at": obj.get("expires_at"),
            "finalizing_at": obj.get("finalizing_at"),
            "completed_at": obj.get("completed_at"),
            "failed_at": obj.get("failed_at"),
            "expired_at": obj.get("expired_at"),
            "cancelling_at": obj.get("cancelling_at"),
            "cancelled_at": obj.get("cancelled_at"),
            "request_counts": BatchRequestCounts.from_dict(obj.get("request_counts")) if obj.get("request_counts") is not None else None,
            "metadata": obj.get("metadata")
        })
        return _obj


