# coding: utf-8

"""
    OpenAI API

    The OpenAI REST API. Please see https://platform.openai.com/docs/api-reference for more details.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401



from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from openapi_server_v2.models.done_event import DoneEvent
from openapi_server_v2.models.error_event import ErrorEvent
from openapi_server_v2.models.message_stream_event import MessageStreamEvent
from openapi_server_v2.models.run_step_stream_event import RunStepStreamEvent
from openapi_server_v2.models.run_stream_event import RunStreamEvent
from openapi_server_v2.models.thread_stream_event import ThreadStreamEvent
from typing import Union, Any, List, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal
from pydantic import StrictStr, Field
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

ASSISTANTSTREAMEVENT_ONE_OF_SCHEMAS = ["DoneEvent", "ErrorEvent", "MessageStreamEvent", "RunStepStreamEvent", "RunStreamEvent", "ThreadStreamEvent"]

class AssistantStreamEvent(BaseModel):
    """
    Represents an event emitted when streaming a Run.  Each event in a server-sent events stream has an `event` and `data` property:  ``` event: thread.created data: {\"id\": \"thread_123\", \"object\": \"thread\", ...} ```  We emit events whenever a new object is created, transitions to a new state, or is being streamed in parts (deltas). For example, we emit `thread.run.created` when a new run is created, `thread.run.completed` when a run completes, and so on. When an Assistant chooses to create a message during a run, we emit a `thread.message.created event`, a `thread.message.in_progress` event, many `thread.message.delta` events, and finally a `thread.message.completed` event.  We may add additional events over time, so we recommend handling unknown events gracefully in your code. See the [Assistants API quickstart](/docs/assistants/overview) to learn how to integrate the Assistants API with streaming. 
    """
    # data type: ThreadStreamEvent
    oneof_schema_1_validator: Optional[ThreadStreamEvent] = None
    # data type: RunStreamEvent
    oneof_schema_2_validator: Optional[RunStreamEvent] = None
    # data type: RunStepStreamEvent
    oneof_schema_3_validator: Optional[RunStepStreamEvent] = None
    # data type: MessageStreamEvent
    oneof_schema_4_validator: Optional[MessageStreamEvent] = None
    # data type: ErrorEvent
    oneof_schema_5_validator: Optional[ErrorEvent] = None
    # data type: DoneEvent
    oneof_schema_6_validator: Optional[DoneEvent] = None
    actual_instance: Optional[Union[DoneEvent, ErrorEvent, MessageStreamEvent, RunStepStreamEvent, RunStreamEvent, ThreadStreamEvent]] = None
    one_of_schemas: List[str] = Literal["DoneEvent", "ErrorEvent", "MessageStreamEvent", "RunStepStreamEvent", "RunStreamEvent", "ThreadStreamEvent"]

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = AssistantStreamEvent.model_construct()
        error_messages = []
        match = 0
        # validate data type: ThreadStreamEvent
        if not isinstance(v, ThreadStreamEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ThreadStreamEvent`")
        else:
            match += 1
        # validate data type: RunStreamEvent
        if not isinstance(v, RunStreamEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RunStreamEvent`")
        else:
            match += 1
        # validate data type: RunStepStreamEvent
        if not isinstance(v, RunStepStreamEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RunStepStreamEvent`")
        else:
            match += 1
        # validate data type: MessageStreamEvent
        if not isinstance(v, MessageStreamEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MessageStreamEvent`")
        else:
            match += 1
        # validate data type: ErrorEvent
        if not isinstance(v, ErrorEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ErrorEvent`")
        else:
            match += 1
        # validate data type: DoneEvent
        if not isinstance(v, DoneEvent):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DoneEvent`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in AssistantStreamEvent with oneOf schemas: DoneEvent, ErrorEvent, MessageStreamEvent, RunStepStreamEvent, RunStreamEvent, ThreadStreamEvent. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in AssistantStreamEvent with oneOf schemas: DoneEvent, ErrorEvent, MessageStreamEvent, RunStepStreamEvent, RunStreamEvent, ThreadStreamEvent. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into ThreadStreamEvent
        try:
            instance.actual_instance = ThreadStreamEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RunStreamEvent
        try:
            instance.actual_instance = RunStreamEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RunStepStreamEvent
        try:
            instance.actual_instance = RunStepStreamEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MessageStreamEvent
        try:
            instance.actual_instance = MessageStreamEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into ErrorEvent
        try:
            instance.actual_instance = ErrorEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into DoneEvent
        try:
            instance.actual_instance = DoneEvent.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into AssistantStreamEvent with oneOf schemas: DoneEvent, ErrorEvent, MessageStreamEvent, RunStepStreamEvent, RunStreamEvent, ThreadStreamEvent. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into AssistantStreamEvent with oneOf schemas: DoneEvent, ErrorEvent, MessageStreamEvent, RunStepStreamEvent, RunStreamEvent, ThreadStreamEvent. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


